/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.BlueJTheme;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import greenfoot.gui.WrappingMultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class MessageDialog
extends EscapeDialog
implements ActionListener {
    private JButton[] buttons;
    private JButton pressedButton;

    public MessageDialog(Dialog owner, String message, String title, int width, JButton[] buttons) {
        super(owner, title);
        this.setDefaultCloseOperation(2);
        this.createDialog(message, buttons, width);
    }

    public MessageDialog(Frame owner, String message, String title, int width, JButton[] buttons) {
        super(owner, title);
        this.setDefaultCloseOperation(2);
        this.createDialog(message, buttons, width);
    }

    private void createDialog(String message, JButton[] buttons, int width) {
        this.buttons = buttons;
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.setBorder(BlueJTheme.dialogBorder);
        WrappingMultiLineLabel messageLabel = new WrappingMultiLineLabel(message, width);
        contentPane.add((Component)((Object)messageLabel), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
        for (int i = 0; i < buttons.length; ++i) {
            buttonPanel.add(buttons[i]);
            buttons[i].addActionListener(this);
        }
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
    }

    public JButton displayModal() {
        this.setModal(true);
        DialogManager.centreDialog((JDialog)((Object)this));
        this.setVisible(true);
        this.dispose();
        return this.pressedButton;
    }

    public void display() {
        this.setModal(false);
        DialogManager.centreDialog((JDialog)((Object)this));
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button;
        this.pressedButton = button = (JButton)e.getSource();
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].removeActionListener(this);
        }
        this.setVisible(false);
    }
}

