/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.Config;
import bluej.extensions.ProjectNotOpenException;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import greenfoot.core.GClass;
import greenfoot.core.GProject;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassButton;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.record.InteractionListener;
import greenfoot.util.GreenfootUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class ImportClassWindow
extends JFrame {
    private static final int INDENT_HIERARCHY = 20;
    private JComponent classList;
    private JEditorPane htmlPane;
    private File curSelection;
    private File curSelectionImage;
    private ButtonGroup buttonGroup;
    private JLabel classPicture;
    private JLabel classLabel;
    private GreenfootFrame gfFrame;
    private InteractionListener interactionListener;

    public ImportClassWindow(GreenfootFrame gfFrame, InteractionListener interactionListener) {
        this.gfFrame = gfFrame;
        this.interactionListener = interactionListener;
        this.buttonGroup = new ButtonGroup();
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(Config.getString((String)"import.dialogTitle"));
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(10, 0));
        p.setBorder(new EmptyBorder(0, 0, 10, 0));
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        main.add(p);
        main.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setContentPane(main);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportClassWindow.this.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        main.registerKeyboardAction(actionListener, stroke, 2);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton okButton = new JButton(new OkAction());
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(new AbstractAction(Config.getString((String)"greenfoot.cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportClassWindow.this.setVisible(false);
            }
        });
        DialogManager.addOKCancelButtons((JPanel)buttonPanel, (JButton)okButton, (JButton)cancelButton);
        main.add(buttonPanel);
        this.classList = new JPanel();
        this.classList.setLayout(new BoxLayout(this.classList, 1));
        this.classList.setBackground(Color.WHITE);
        this.classList.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.findAddImportableClasses(new File(Config.getGreenfootLibDir(), "common"), 0);
        JScrollPane classScrollPane = new JScrollPane(this.classList){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width += this.getVerticalScrollBar().getWidth();
                return size;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        classScrollPane.setOpaque(false);
        classScrollPane.getViewport().setOpaque(false);
        classScrollPane.setBorder(BorderFactory.createEtchedBorder());
        classScrollPane.setSize(classScrollPane.getPreferredSize());
        p.add((Component)classScrollPane, "West");
        this.htmlPane = new JEditorPane();
        this.htmlPane.setDocument(new HTMLDocument());
        this.htmlPane.setEditorKit(new HTMLEditorKit());
        this.htmlPane.setEditable(false);
        JPanel rightPane = new JPanel();
        rightPane.setLayout(new BorderLayout());
        JPanel classInfo = new JPanel();
        classInfo.setBorder(new EmptyBorder(10, 5, 10, 5));
        classInfo.setLayout(new GridLayout(1, 2));
        this.classLabel = new JLabel("", 0);
        this.classLabel.setFont(this.classLabel.getFont().deriveFont(24.0f));
        classInfo.add(this.classLabel);
        this.classPicture = new JLabel((String)null, 0);
        classInfo.add(this.classPicture);
        rightPane.add((Component)classInfo, "North");
        rightPane.add((Component)new JScrollPane(this.htmlPane), "Center");
        p.add((Component)rightPane, "Center");
        this.pack();
        this.setSize(700, 550);
        ((ImportableClassButton)this.buttonGroup.getElements().nextElement()).select();
        ((ImportableClassButton)this.buttonGroup.getElements().nextElement()).setSelected(true);
        this.setLocation(this.gfFrame.getX() + 40, this.gfFrame.getY() + 40);
    }

    private void showHTML(String stem) {
        if (stem == null) {
            this.htmlPane.setText("");
            return;
        }
        File htmlFile = new File(stem + ".html");
        if (!htmlFile.exists()) {
            Debug.message((String)("No HTML file found for class " + stem + "; looked for: " + htmlFile.getAbsolutePath()));
            this.htmlPane.setText("");
            return;
        }
        try {
            int n;
            BufferedReader br = new BufferedReader(new FileReader(htmlFile));
            char[] buffer = new char[1024];
            StringBuilder s = new StringBuilder();
            do {
                if ((n = br.read(buffer)) == -1) continue;
                s.append(buffer, 0, n);
            } while (n != -1);
            String processedContents = s.toString().replace("./resources/inherit.gif", new File(Config.getGreenfootLibDir(), "common/inherit.gif").toURI().toURL().toString()).replace("</B><DT>extends", "</B><DT> extends").replace("../images/", new File(Config.getGreenfootLibDir(), "common/").toURI().toURL().toString());
            this.htmlPane.setText(processedContents);
            this.htmlPane.setCaretPosition(0);
            br.close();
        }
        catch (IOException e) {
            Debug.reportError((String)("Problem showing HTML for importable class " + stem), (Throwable)e);
            this.htmlPane.setText("");
        }
    }

    private void findAddImportableClasses(File dir, int indent) {
        File[] folders;
        File[] files = dir.listFiles(new ImportableClassesFileFilter());
        if (files != null) {
            for (File file : files) {
                ImportableClassButton button = new ImportableClassButton(file);
                this.addWithIndent(indent, button);
                this.buttonGroup.add(button);
            }
            indent += 20;
        }
        if ((folders = dir.listFiles(new ImportableFoldersFileFilter())) != null) {
            for (File folder : folders) {
                if (this.hasImportableClasses(folder)) {
                    JLabel label = new JLabel(folder.getName());
                    label.setFont(label.getFont().deriveFont(16.0f));
                    this.addWithIndent(indent, label);
                }
                this.findAddImportableClasses(folder, indent);
            }
        }
    }

    private boolean hasImportableClasses(File dir) {
        File[] files = dir.listFiles(new ImportableClassesFileFilter());
        if (files != null && files.length > 0) {
            return true;
        }
        File[] folders = dir.listFiles(new ImportableFoldersFileFilter());
        if (folders != null) {
            for (File folder : folders) {
                if (!this.hasImportableClasses(folder)) continue;
                return true;
            }
        }
        return false;
    }

    private void addWithIndent(int indent, JComponent comp) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalStrut(indent));
        panel.add(comp);
        panel.add(Box.createHorizontalGlue());
        panel.setBackground(Color.WHITE);
        panel.setMaximumSize(new Dimension(panel.getMaximumSize().width, panel.getPreferredSize().height));
        this.classList.add(panel);
    }

    private static File findImage(File classFile) {
        String[] extensions = ImageIO.getReaderFileSuffixes();
        File directory = classFile.getAbsoluteFile().getParentFile();
        String stemName = GreenfootUtil.removeExtension(classFile.getAbsoluteFile().getName());
        File[] allFiles = directory.listFiles();
        if (allFiles == null) {
            return null;
        }
        for (File f : allFiles) {
            for (String ext : extensions) {
                if (!f.getName().equalsIgnoreCase(stemName + "." + ext)) continue;
                return f;
            }
        }
        return null;
    }

    private void importClass(File srcFile, File srcImage) {
        boolean librariesImportedFlag = false;
        if (srcFile != null) {
            int option;
            String className = GreenfootUtil.removeExtension(srcFile.getName());
            ClassBrowser classBrowser = this.gfFrame.getClassBrowser();
            GProject project = classBrowser.getProject();
            for (GClass preexist : project.getDefaultPackage().getClasses(false)) {
                if (!preexist.getQualifiedName().equals(className)) continue;
                JOptionPane.showMessageDialog(this.gfFrame, "The current project already contains a class named " + className);
                return;
            }
            File destImage = null;
            if (srcImage != null && (destImage = new File(project.getImageDir(), srcImage.getName())).exists()) {
                JOptionPane.showMessageDialog(this.gfFrame, "The current project already contains an image file named " + srcImage.getName() + "; this file will NOT be replaced.");
            }
            File destFile = new File(project.getDir(), srcFile.getName());
            GreenfootUtil.copyFile(srcFile, destFile);
            File libFolder = new File(srcFile.getParentFile(), className + "/lib");
            if (libFolder.exists() && libFolder.listFiles().length > 0) {
                for (File srcLibFile : libFolder.listFiles()) {
                    File destLibFile = new File(project.getDir(), "+libs/" + srcLibFile.getName());
                    GreenfootUtil.copyFile(srcLibFile, destLibFile);
                }
                librariesImportedFlag = true;
            }
            project.getDefaultPackage().reload();
            GClass gclass = project.getDefaultPackage().getClass(className);
            if (gclass == null) {
                return;
            }
            if (srcImage != null && destImage != null && !destImage.exists()) {
                GreenfootUtil.copyFile(srcImage, destImage);
                gclass.setClassProperty("image", destImage.getName());
            }
            classBrowser.addClass(new ClassView(classBrowser, gclass, this.interactionListener));
            classBrowser.updateLayout();
            if (librariesImportedFlag && (option = JOptionPane.showConfirmDialog(this.gfFrame, Config.getString((String)"import.restartMessage"), null, 2)) == 0) {
                try {
                    project.getRProject().restartVM();
                }
                catch (RemoteException ex) {
                    Debug.reportError((String)"RemoteException restarting VM in ImportClassWindow", (Throwable)ex);
                }
                catch (ProjectNotOpenException ex) {
                    Debug.reportError((String)"ProjectNotOpenException restarting VM in ImportClassWindow", (Throwable)ex);
                }
            }
        }
    }

    private class ImportableFoldersFileFilter
    implements FileFilter {
        private ImportableFoldersFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    private class ImportableClassesFileFilter
    implements FileFilter {
        private ImportableClassesFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(".class") || pathname.getAbsolutePath().endsWith(".java");
        }
    }

    private class ImportableClassButton
    extends ClassButton {
        private File file;
        private String name;

        public ImportableClassButton(File file) {
            this.file = file;
            this.name = GreenfootUtil.removeExtension(file.getName());
            this.setText(this.name);
            this.initUI();
        }

        @Override
        protected boolean isValidClass() {
            return true;
        }

        @Override
        protected boolean isUncompiled() {
            return false;
        }

        @Override
        protected void doubleClick() {
        }

        @Override
        public void select() {
            ImageIcon icon;
            ImportClassWindow.this.curSelection = this.file;
            ImportClassWindow.this.classLabel.setText(this.name);
            File img = ImportClassWindow.findImage(this.file);
            ImportClassWindow.this.curSelectionImage = img;
            if (img == null) {
                icon = null;
            } else {
                icon = new ImageIcon(img.getAbsolutePath());
                int maxDim = 60;
                if (Math.max(icon.getIconHeight(), icon.getIconWidth()) > 60) {
                    double scale = 60.0 / (double)Math.max(icon.getIconHeight(), icon.getIconWidth());
                    icon.setImage(icon.getImage().getScaledInstance((int)(scale * (double)icon.getIconWidth()), (int)(scale * (double)icon.getIconHeight()), 4));
                }
            }
            ImportClassWindow.this.classPicture.setIcon(icon);
            ImportClassWindow.this.showHTML(GreenfootUtil.removeExtension(this.file.getAbsolutePath()));
        }

        @Override
        public boolean deselect() {
            ImportClassWindow.this.curSelection = null;
            ImportClassWindow.this.curSelectionImage = null;
            ImportClassWindow.this.classLabel.setText("");
            ImportClassWindow.this.classPicture.setIcon(null);
            ImportClassWindow.this.showHTML(null);
            return false;
        }

        @Override
        protected void maybeShowPopup(MouseEvent e) {
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(Config.getString((String)"import.import"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportClassWindow.this.setVisible(false);
            ImportClassWindow.this.importClass(ImportClassWindow.this.curSelection, ImportClassWindow.this.curSelectionImage);
        }
    }
}

