/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.inspector.ClassInspector;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.debugmgr.inspector.ResultInspector;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.ClassInspectInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.DialogManager;
import greenfoot.gui.inspector.GreenfootClassInspector;
import greenfoot.gui.inspector.GreenfootObjectInspector;
import greenfoot.gui.inspector.GreenfootResultInspector;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;

public class GreenfootInspectorManager
implements InspectorManager {
    private Map<DebuggerObject, Inspector> objectInspectors = new HashMap<DebuggerObject, Inspector>();
    private Map<String, Inspector> classInspectors = new HashMap<String, Inspector>();

    public void removeInspector(DebuggerObject obj) {
        this.objectInspectors.remove(obj);
    }

    public void removeInspector(DebuggerClass cls) {
        this.classInspectors.remove(cls.getName());
    }

    public ObjectInspector getInspectorInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, JFrame parent) {
        ObjectInspector inspector = (ObjectInspector)this.objectInspectors.get(obj);
        if (inspector == null) {
            inspector = new GreenfootObjectInspector(obj, this, name, pkg, ir, parent);
            this.objectInspectors.put(obj, (Inspector)inspector);
            inspector.setVisible(true);
        } else {
            inspector.update();
            inspector.updateLayout();
            inspector.setVisible(true);
            inspector.bringToFront();
        }
        return inspector;
    }

    public ClassInspector getClassInspectorInstance(DebuggerClass clss, Package pkg, JFrame parent) {
        ClassInspector inspector = (ClassInspector)this.classInspectors.get(clss.getName());
        if (inspector == null) {
            ClassInspectInvokerRecord ir = new ClassInspectInvokerRecord(clss.getName());
            inspector = new GreenfootClassInspector(clss, this, pkg, (InvokerRecord)ir, parent);
            this.classInspectors.put(clss.getName(), (Inspector)inspector);
        } else {
            inspector.update();
            inspector.updateLayout();
        }
        inspector.setVisible(true);
        inspector.bringToFront();
        return inspector;
    }

    public ResultInspector getResultInspectorInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, ExpressionInformation info, JFrame parent) {
        ResultInspector inspector = (ResultInspector)this.objectInspectors.get(obj);
        if (inspector == null) {
            inspector = new GreenfootResultInspector(obj, this, name, pkg, ir, info);
            this.objectInspectors.put(obj, (Inspector)inspector);
            DialogManager.centreWindow((Window)inspector, (Window)parent);
            inspector.setVisible(true);
        } else {
            inspector.update();
            inspector.updateLayout();
            inspector.setVisible(true);
            inspector.bringToFront();
        }
        return inspector;
    }

    public boolean inTestMode() {
        return false;
    }

    public void removeAllInspectors() {
        for (Inspector inspector : this.objectInspectors.values()) {
            inspector.setVisible(false);
            inspector.dispose();
        }
        this.objectInspectors.clear();
        for (Inspector inspector : this.classInspectors.values()) {
            inspector.setVisible(false);
            inspector.dispose();
        }
        this.classInspectors.clear();
    }
}

