/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.Config;
import bluej.utility.JavaNames;
import greenfoot.core.GPackage;
import greenfoot.event.ValidityEvent;
import greenfoot.event.ValidityListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

public class ClassNameVerifier
extends InputVerifier
implements DocumentListener {
    private EventListenerList listenerList = new EventListenerList();
    private String classExists = Config.getString((String)"newclass.dialog.err.classExists");
    private String illegalClassName = Config.getString((String)"newclass.dialog.err.classNameIllegal");
    private boolean valid = false;
    private boolean firstCheck = true;
    private GPackage pkg;
    private JTextField textField;

    public ClassNameVerifier(JTextField textField, GPackage pkg) {
        this.pkg = pkg;
        this.textField = textField;
        textField.getDocument().addDocumentListener(this);
        textField.setInputVerifier(this);
        textField.setVerifyInputWhenFocusTarget(true);
    }

    @Override
    public boolean verify(JComponent textField) {
        if (this.textField != textField) {
            System.err.println("Illegal textfield verified.");
            return false;
        }
        String className = this.textField.getText();
        return JavaNames.isIdentifier((String)className) && !this.classNameExist(className) && !this.isGreenfootClassName(className);
    }

    @Override
    public boolean shouldYieldFocus(JComponent jTextField) {
        return this.checkValidity();
    }

    private boolean isGreenfootClassName(String className) {
        return className.equals("Actor") || className.equals("World");
    }

    private boolean classNameExist(String className) {
        return this.pkg.getClass(className) != null;
    }

    private boolean checkValidity() {
        boolean inputOK = this.verify(this.textField);
        if (inputOK != this.valid || this.firstCheck) {
            this.firstCheck = false;
            this.valid = inputOK;
            if (this.valid) {
                this.fireValidEvent(new ValidityEvent(this.textField, "All OK"));
            } else {
                String className = this.textField.getText();
                ValidityEvent validityEvent = null;
                validityEvent = this.classNameExist(className) || this.isGreenfootClassName(className) ? new ValidityEvent(this.textField, this.classExists) : new ValidityEvent(this.textField, this.illegalClassName);
                this.fireInvalidEvent(validityEvent);
            }
        }
        return inputOK;
    }

    public void addValidityListener(ValidityListener l) {
        this.listenerList.add(ValidityListener.class, l);
    }

    public void removeValidityListner(ValidityListener l) {
        this.listenerList.remove(ValidityListener.class, l);
    }

    private void fireValidEvent(ValidityEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ValidityListener.class) continue;
            ((ValidityListener)listeners[i + 1]).changedToValid(event);
        }
    }

    private void fireInvalidEvent(ValidityEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ValidityListener.class) continue;
            ((ValidityListener)listeners[i + 1]).changedToInvalid(event);
        }
    }

    private void change() {
        this.checkValidity();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.change();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.change();
    }
}

