/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export;

import bluej.Boot;
import bluej.Config;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.FileUtility;
import greenfoot.core.GProject;
import greenfoot.export.GreenfootScenarioMain;
import greenfoot.export.GreenfootScenarioViewer;
import greenfoot.util.GreenfootUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class JarCreator {
    private static final String SOURCE_SUFFIX = ".java";
    private boolean includeSource;
    private String mainClass;
    private File exportDir;
    private File projectDir;
    private String jarName;
    private List<File> extraJars = new LinkedList<File>();
    private List<File> extraJarsInJar = new LinkedList<File>();
    private List<String> extraExternalJars = new LinkedList<String>();
    private List<File> dirs = new LinkedList<File>();
    private List<PrefixedFile> prefixDirs = new LinkedList<PrefixedFile>();
    private List<String> skipDirs = new LinkedList<String>();
    private List<String> skipFiles = new LinkedList<String>();
    private Manifest manifest = new Manifest();
    private Properties properties;
    private boolean isZip = false;

    public JarCreator(File exportDir, String jarName) {
        File jarFile = new File(exportDir, jarName);
        if (!jarFile.canWrite() && jarFile.exists()) {
            throw new IllegalArgumentException("Cannot write file: " + jarFile);
        }
        this.exportDir = exportDir;
        this.jarName = jarName;
        this.properties = new Properties();
    }

    public JarCreator(GProject project, File exportDir, String jarName, String worldClass, boolean lockScenario, boolean applet) {
        this(exportDir, jarName);
        this.projectDir = project.getDir();
        String scenarioName = project.getName();
        this.addFile(this.projectDir);
        this.addSkipDir("CVS");
        this.addSkipFile(".cvsignore");
        this.addSkipDir(".svn");
        this.addSkipFile(".DS_Store");
        this.addSkipDir(this.projectDir.getPath() + System.getProperty("file.separator") + "doc");
        this.addSkipDir(exportDir.getAbsolutePath());
        this.addSkipFile(".ctxt");
        this.addSkipFile("bluej.pkg");
        this.addSkipFile("bluej.pkh");
        this.addSkipDir("+libs");
        String mainClass = (applet ? GreenfootScenarioViewer.class : GreenfootScenarioMain.class).getCanonicalName();
        this.setMainClass(mainClass);
        this.properties.put("project.name", scenarioName);
        this.properties.put("project.greenfootversion", Boot.GREENFOOT_VERSION);
        this.properties.put("project.javaspecversion", System.getProperty("java.specification.version"));
        this.properties.put("project.javaversion", System.getProperty("java.version"));
        this.properties.put("project.javaclassversion", System.getProperty("java.class.version"));
        this.properties.put("main.class", worldClass);
        this.properties.put("scenario.lock", "" + lockScenario);
        this.properties.put("scenario.viewer.appletInfo", Config.getString((String)"scenario.viewer.appletInfo"));
        this.properties.put("run.once", Config.getString((String)"run.once"));
        this.properties.put("run.simulation", Config.getString((String)"run.simulation"));
        this.properties.put("pause.simulation", Config.getString((String)"pause.simulation"));
        this.properties.put("reset.world", Config.getString((String)"reset.world"));
        this.properties.put("controls.speed.label", Config.getString((String)"controls.speed.label"));
        this.properties.put("controls.runonce.longDescription", Config.getString((String)"controls.runonce.longDescription"));
        this.properties.put("controls.runonce.shortDescription", Config.getString((String)"controls.runonce.shortDescription"));
        this.properties.put("controls.run.longDescription", Config.getString((String)"controls.run.longDescription"));
        this.properties.put("controls.run.shortDescription", Config.getString((String)"controls.run.shortDescription"));
        this.properties.put("controls.pause.longDescription", Config.getString((String)"controls.pause.longDescription"));
        this.properties.put("controls.pause.shortDescription", Config.getString((String)"controls.pause.shortDescription"));
        this.properties.put("controls.run.button", Config.getString((String)"controls.run.button"));
        this.properties.put("controls.pause.button", Config.getString((String)"controls.pause.button"));
        this.properties.put("controls.reset.longDescription", Config.getString((String)"controls.reset.longDescription"));
        this.properties.put("controls.reset.shortDescription", Config.getString((String)"controls.reset.shortDescription"));
        this.properties.put("controls.speedSlider.tooltip", Config.getString((String)"controls.speedSlider.tooltip"));
        this.properties.put("sound-line-unavailable", Config.getString((String)"sound-line-unavailable"));
    }

    public JarCreator(GProject project, File exportDir, String zipName) {
        this(exportDir, zipName);
        this.isZip = true;
        this.projectDir = project.getDir();
        this.addFile(this.projectDir);
        this.addSkipDir("CVS");
        this.addSkipFile(".cvsignore");
        this.addSkipDir(".svn");
        this.addSkipFile(".DS_Store");
        this.addSkipDir(this.projectDir.getPath() + System.getProperty("file.separator") + "doc");
        this.addSkipDir(exportDir.getAbsolutePath());
        this.addSkipDir(this.projectDir.getPath() + System.getProperty("file.separator") + "greenfoot");
        this.addSkipFile("bluej.pkg");
        this.addSkipFile("bluej.pkh");
        this.includeSource(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() {
        File jarFile = new File(this.exportDir, this.jarName);
        File propertiesFile = null;
        File soundFile = null;
        BufferedOutputStream oStream = null;
        ZipOutputStream jStream = null;
        try {
            oStream = new BufferedOutputStream(new FileOutputStream(jarFile));
            String pathPrefix = "";
            if (!this.isZip) {
                this.writeManifest();
                propertiesFile = new File(this.projectDir, "standalone.properties");
                this.writePropertiesFile(propertiesFile);
                soundFile = new File(this.projectDir, "soundindex.list");
                this.writeSoundFilesList(soundFile);
                jStream = new JarOutputStream((OutputStream)oStream, this.manifest);
            } else {
                pathPrefix = this.projectDir.getName() + "/";
                jStream = new ZipOutputStream(oStream);
            }
            for (File file : this.dirs) {
                this.writeFileToJar(file, pathPrefix, jStream, jarFile.getCanonicalFile(), true);
            }
            for (PrefixedFile prefixedFile : this.prefixDirs) {
                this.writeFileToJar(prefixedFile.getFile(), pathPrefix + prefixedFile.getPrefix(), jStream, jarFile.getCanonicalFile(), true);
            }
            for (File file : this.extraJarsInJar) {
                this.writeJarToJar(file, jStream);
            }
            this.copyLibsToDir(this.extraJars, this.exportDir);
        }
        catch (IOException exc) {
            Debug.reportError((String)("problem writing jar file: " + exc));
        }
        finally {
            try {
                if (jStream != null) {
                    jStream.close();
                }
            }
            catch (IOException e) {}
            if (propertiesFile != null) {
                propertiesFile.delete();
            }
        }
    }

    private void writeSoundFilesList(File file) {
        BufferedWriter os = null;
        try {
            file.createNewFile();
            os = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (String name : GreenfootUtil.getSoundFiles()) {
                os.write(name + "\n");
            }
            os.close();
        }
        catch (IOException e) {
            Debug.reportError((String)"Error writing list of sounds: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesFile(File file) {
        OutputStream os = null;
        try {
            file.createNewFile();
            os = new BufferedOutputStream(new FileOutputStream(file));
            this.properties.store(os, "Properties for running Greenfoot scenarios alone.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void putManifestEntry(String key, String value) {
        Attributes attr = this.manifest.getMainAttributes();
        value = this.fixNewlines(value);
        attr.put(new Attributes.Name(key), value);
    }

    private String fixNewlines(String value) {
        StringBuffer buffer = new StringBuffer(value.length());
        String newLineRegExp = "(?m)(?s)$.^";
        String trailingNewLineReqExp = "$.\\z";
        String[] lines = value.split(newLineRegExp + "|" + trailingNewLineReqExp);
        for (int i = 0; i < lines.length; ++i) {
            String string = lines[i];
            if (i != 0) {
                buffer.append("<br>");
            }
            buffer.append(string);
        }
        return buffer.toString();
    }

    private void writeManifest() {
        String classpath = "";
        Iterator<Object> it = this.extraJars.iterator();
        while (it.hasNext()) {
            classpath = classpath + " " + ((File)it.next()).getName();
        }
        it = this.extraExternalJars.iterator();
        while (it.hasNext()) {
            classpath = classpath + " " + (String)it.next();
        }
        Attributes attr = this.manifest.getMainAttributes();
        attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attr.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        attr.put(Attributes.Name.CLASS_PATH, classpath);
    }

    public void includeSource(boolean b) {
        this.includeSource = b;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void addJar(File jar) {
        this.extraJars.add(jar);
    }

    public void addJarToJar(File jar) {
        this.extraJarsInJar.add(jar);
    }

    public void addToClassPath(String path) {
        this.extraExternalJars.add(path);
    }

    public void addFile(File file) {
        this.dirs.add(file);
    }

    public void addFile(String prefix, File file) {
        this.prefixDirs.add(new PrefixedFile(prefix, file));
    }

    public void addSkipDir(String dir) {
        this.skipDirs.add(dir);
    }

    public void addSkipFile(String file) {
        this.skipFiles.add(file);
    }

    private void writeDirToJar(File sourceDir, String pathPrefix, ZipOutputStream stream, File outputFile) throws IOException {
        if (!this.skipDir(sourceDir)) {
            File[] dir = sourceDir.listFiles();
            for (int i = 0; i < dir.length; ++i) {
                this.writeFileToJar(dir[i], pathPrefix, stream, outputFile, false);
            }
        }
    }

    private void writeFileToJar(File sourceFile, String pathPrefix, ZipOutputStream stream, File outputFile, boolean onlyDirContents) throws IOException {
        if (!sourceFile.exists()) {
            return;
        }
        if (sourceFile.isDirectory()) {
            if (!onlyDirContents) {
                pathPrefix = pathPrefix + sourceFile.getName() + "/";
            }
            this.writeDirToJar(sourceFile, pathPrefix, stream, outputFile);
        } else if (!this.skipFile(sourceFile.getName(), !this.includeSource) && !outputFile.equals(sourceFile.getCanonicalFile())) {
            this.writeJarEntry(sourceFile, stream, pathPrefix + sourceFile.getName());
        }
    }

    private void writeJarToJar(File inputJar, ZipOutputStream outputStream) throws IOException {
        if (!inputJar.exists()) {
            return;
        }
        JarInputStream inputStream = new JarInputStream(new BufferedInputStream(new FileInputStream(inputJar)));
        JarEntry inputEntry = inputStream.getNextJarEntry();
        while (inputEntry != null) {
            outputStream.putNextEntry(inputEntry);
            FileUtility.copyStream((InputStream)inputStream, (OutputStream)outputStream);
            inputStream.closeEntry();
            inputEntry = inputStream.getNextJarEntry();
        }
        inputStream.close();
    }

    private void copyLibsToDir(List<File> userLibs, File destDir) {
        for (File lib : userLibs) {
            if (!lib.exists()) continue;
            File destFile = new File(destDir, lib.getName());
            try {
                FileUtility.copyFile((File)lib, (File)destFile);
            }
            catch (IOException e) {
                Debug.reportError((String)("Error when copying file: " + lib + " to: " + destFile), (Throwable)e);
            }
        }
    }

    private boolean skipDir(File dir) throws IOException {
        for (String skipDir : this.skipDirs) {
            if (!dir.getCanonicalFile().getPath().endsWith(skipDir)) continue;
            return true;
        }
        return false;
    }

    private boolean skipFile(String fileName, boolean skipSource) {
        for (String skipFile : this.skipFiles) {
            if (!fileName.endsWith(skipFile)) continue;
            return true;
        }
        if (fileName.endsWith(SOURCE_SUFFIX)) {
            return !this.includeSource;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJarEntry(File file, ZipOutputStream stream, String entryName) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            stream.putNextEntry(new ZipEntry(entryName));
            FileUtility.copyStream((InputStream)in, (OutputStream)stream);
        }
        catch (ZipException exc) {
            Debug.message((String)("warning: " + exc));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void generateHTMLSkeleton(File outputFile, String title, int width, int height) {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        translations.put("TITLE", title);
        translations.put("CLASSFILE", this.mainClass + ".class");
        translations.put("CODEBASE", "");
        translations.put("APPLETWIDTH", "" + width);
        translations.put("APPLETHEIGHT", "" + height);
        try {
            translations.put("ARCHIVE", URLEncoder.encode(this.jarName, "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        String baseName = "greenfoot/templates/html.tmpl";
        File template = Config.getLanguageFile((String)baseName);
        try {
            Charset utf8 = Charset.forName("UTF-8");
            BlueJFileReader.translateFile((File)template, (File)outputFile, translations, (Charset)utf8, (Charset)utf8);
        }
        catch (IOException e) {
            Debug.reportError((String)("Exception during file translation from " + template + " to " + outputFile));
            e.printStackTrace();
        }
    }

    static class PrefixedFile {
        private File file;
        private String prefix;

        public File getFile() {
            return this.file;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public PrefixedFile(String prefix, File file) {
            this.prefix = prefix;
            this.file = file;
        }
    }
}

