/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export;

import bluej.BlueJPropStringSource;
import bluej.Config;
import greenfoot.export.GreenfootScenarioViewer;
import greenfoot.util.StandalonePropStringManager;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class GreenfootScenarioMain {
    public static String scenarioName;
    public static String[] args;

    public static void main(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        if (args.length != 3 && args.length != 0) {
            System.err.println("Wrong number of arguments");
        }
        GreenfootScenarioMain.args = args;
        GreenfootScenarioMain.initProperties();
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", scenarioName);
        final GreenfootScenarioViewer[] gsv = new GreenfootScenarioViewer[1];
        final JFrame[] frame = new JFrame[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame[0] = new JFrame(scenarioName);
                    gsv[0] = new GreenfootScenarioViewer(frame[0]);
                    frame[0].setDefaultCloseOperation(3);
                    frame[0].setResizable(false);
                    URL resource = this.getClass().getClassLoader().getResource("greenfoot.png");
                    ImageIcon icon = new ImageIcon(resource);
                    frame[0].setIconImage(icon.getImage());
                }
            });
            gsv[0].init();
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame[0].pack();
                    frame[0].setVisible(true);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void initProperties() {
        if (scenarioName != null) {
            return;
        }
        Properties p = new Properties();
        try {
            ClassLoader loader = GreenfootScenarioMain.class.getClassLoader();
            InputStream is = loader.getResourceAsStream("standalone.properties");
            if (is == null && args.length == 3) {
                p.put("project.name", args[0]);
                p.put("main.class", args[1]);
                p.put("scenario.lock", "true");
                File f = new File(args[2]);
                is = new FileInputStream(f);
            }
            p.load(is);
            scenarioName = p.getProperty("project.name");
            Config.initializeStandalone((BlueJPropStringSource)new StandalonePropStringManager(p));
            if (is != null) {
                is.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

