/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.extensions.ProjectNotOpenException;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import greenfoot.core.GProject;
import greenfoot.gui.GreenfootFrame;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import rmiextension.wrappers.RBlueJ;

public class SaveAsAction
extends AbstractAction {
    private GreenfootFrame gfFrame;
    private RBlueJ rBlueJ;

    public SaveAsAction(GreenfootFrame gfFrame, RBlueJ rBlueJ) {
        super(Config.getString((String)"project.saveAs"));
        this.gfFrame = gfFrame;
        this.rBlueJ = rBlueJ;
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File newFile = FileUtility.getDirName((Component)this.gfFrame, (String)Config.getString((String)"project.saveAs.title"), (String)Config.getString((String)"pkgmgr.saveAs.buttonLabel"), (boolean)false, (boolean)true);
        if (newFile != null) {
            GProject project = this.gfFrame.getProject();
            int result = 3;
            try {
                project.save();
                result = FileUtility.copyDirectory((File)project.getDir(), (File)newFile);
                if (result == 0) {
                    this.rBlueJ.openProject(newFile);
                    project.close();
                }
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            catch (ProjectNotOpenException pnoe) {
                pnoe.printStackTrace();
            }
            switch (result) {
                case 0: {
                    break;
                }
                case 4: {
                    DialogManager.showError((Component)this.gfFrame, (String)"directory-exists-file");
                    return;
                }
                case 5: {
                    DialogManager.showError((Component)this.gfFrame, (String)"directory-exists-non-empty");
                    return;
                }
                case 2: 
                case 3: {
                    DialogManager.showError((Component)this.gfFrame, (String)"cannot-save-project");
                    return;
                }
            }
        }
    }
}

