/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.AllThreadsMergedCPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTClassContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.MethodIdMap;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeFree;

public class CPUResultsSnapshot
extends ResultsSnapshot {
    private static final String CPU_MSG = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle").getString("CPUResultsSnapshot_CpuMsg");
    public static final int METHOD_LEVEL_VIEW = 0;
    public static final int CLASS_LEVEL_VIEW = 1;
    public static final int PACKAGE_LEVEL_VIEW = 2;
    protected Map threadIdMap;
    protected CPUCCTContainer[] allThreadsMergedCCTContainers;
    protected String[][] instrMethodClassesViews;
    protected String[] instrMethodNames;
    protected String[] instrMethodSignatures;
    protected PrestimeCPUCCTNode[] rootNode;
    protected CPUCCTContainer[][] threadCCTContainers;
    protected boolean collectingTwoTimeStamps;
    protected int nInstrMethods;
    private final Map<CCTNode, FilterSortSupport.Configuration> sortInfos = new WeakHashMap<CCTNode, FilterSortSupport.Configuration>();

    public CPUResultsSnapshot() {
        this.threadIdMap = new HashMap();
    }

    public CPUResultsSnapshot(long l, long l2, CPUCCTProvider cPUCCTProvider, boolean bl, String[] stringArray, String[] stringArray2, String[] stringArray3, int n) throws NoDataAvailableException {
        super(l, l2);
        this.collectingTwoTimeStamps = bl;
        this.instrMethodClassesViews = new String[3][];
        this.instrMethodClassesViews[0] = stringArray;
        this.instrMethodNames = stringArray2;
        this.instrMethodSignatures = stringArray3;
        this.nInstrMethods = n;
        CPUCCTContainer[] cPUCCTContainerArray = cPUCCTProvider.createPresentationCCTs(this);
        if (cPUCCTContainerArray == null || cPUCCTContainerArray.length == 0) {
            throw new NoDataAvailableException();
        }
        this.threadIdMap = new HashMap(cPUCCTContainerArray.length);
        for (int i = 0; i < cPUCCTContainerArray.length; ++i) {
            this.threadIdMap.put(cPUCCTContainerArray[i].threadId, i);
        }
        this.threadCCTContainers = new CPUCCTContainer[3][];
        this.threadCCTContainers[0] = cPUCCTContainerArray;
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public CPUCCTContainer getContainerForThread(int n, int n2) {
        if (this.threadCCTContainers[n2] == null) {
            this.generateDataForView(n2);
        }
        return this.threadCCTContainers[n2][this.getContainerIdForThreadId(n)];
    }

    public FlatProfileContainer getFlatProfile(int n, int n2) {
        if (this.threadCCTContainers[n2] == null) {
            this.generateDataForView(n2);
        }
        if (n != -1) {
            return this.threadCCTContainers[n2][this.getContainerIdForThreadId(n)].getFlatProfile();
        }
        return this.allThreadsMergedCCTContainers[n2].getFlatProfile();
    }

    public String[] getInstrMethodClasses(int n) {
        return this.instrMethodClassesViews[n];
    }

    public String[] getInstrMethodNames() {
        return this.instrMethodNames;
    }

    public String[] getInstrMethodSignatures() {
        return this.instrMethodSignatures;
    }

    public String[] getMethodClassNameAndSig(int n, int n2) {
        if (n2 == 0) {
            return new String[]{this.instrMethodClassesViews[0][n], this.instrMethodNames[n], this.instrMethodSignatures[n]};
        }
        return new String[]{this.instrMethodClassesViews[n2][n], null, null};
    }

    public int getNInstrMethods() {
        return this.nInstrMethods;
    }

    public int getNThreads() {
        return this.threadCCTContainers[0].length;
    }

    public PrestimeCPUCCTNode getReverseCCT(int n, int n2, int n3) {
        if (this.threadCCTContainers[n3] == null) {
            this.generateDataForView(n3);
        }
        if (n >= 0) {
            return this.threadCCTContainers[n3][this.getContainerIdForThreadId(n)].getReverseCCT(n2);
        }
        if (n == -1) {
            return this.allThreadsMergedCCTContainers[n3].getReverseCCT(n2);
        }
        throw new IllegalArgumentException("!!! Cannot generate reverse CCT for threadId = " + n);
    }

    public PrestimeCPUCCTNode getRootNode(int n) {
        if (this.threadCCTContainers[n] == null) {
            this.generateDataForView(n);
        }
        return this.rootNode[n];
    }

    public FilterSortSupport.Configuration getFilterSortInfo(CCTNode cCTNode) {
        return this.sortInfo(cCTNode);
    }

    private FilterSortSupport.Configuration sortInfo(CCTNode cCTNode) {
        while (cCTNode.getParent() != null) {
            cCTNode = cCTNode.getParent();
        }
        FilterSortSupport.Configuration configuration = this.sortInfos.get(cCTNode);
        if (configuration == null) {
            configuration = new FilterSortSupport.Configuration();
            this.sortInfos.put(cCTNode, configuration);
        }
        return configuration;
    }

    public void filterForward(String string, int n, PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked) {
        FilterSortSupport.Configuration configuration = this.sortInfo(prestimeCPUCCTNodeBacked);
        configuration.setFilterInfo(string, n);
        if (!FilterSortSupport.passesFilter(configuration, prestimeCPUCCTNodeBacked.getNodeName())) {
            prestimeCPUCCTNodeBacked.setFilteredNode();
        } else {
            prestimeCPUCCTNodeBacked.resetFilteredNode();
        }
        prestimeCPUCCTNodeBacked.resetChildren();
    }

    public void filterReverse(String string, int n, PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree, int n2) {
        PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree2 = (PrestimeCPUCCTNodeFree)this.getReverseCCT(prestimeCPUCCTNodeFree.getContainer().getThreadId(), prestimeCPUCCTNodeFree.getMethodId(), n2);
        FilterSortSupport.Configuration configuration = this.sortInfo(prestimeCPUCCTNodeFree);
        configuration.setFilterInfo(string, n);
        this.filter(configuration, prestimeCPUCCTNodeFree2);
        prestimeCPUCCTNodeFree.children = prestimeCPUCCTNodeFree2.children;
        if (prestimeCPUCCTNodeFree.children != null) {
            for (PrestimeCPUCCTNode prestimeCPUCCTNode : prestimeCPUCCTNodeFree.children) {
                prestimeCPUCCTNode.parent = prestimeCPUCCTNodeFree;
            }
            prestimeCPUCCTNodeFree.sortChildren(configuration.getSortBy(), configuration.getSortOrder());
        }
        if (!FilterSortSupport.passesFilter(configuration, prestimeCPUCCTNodeFree.getNodeName())) {
            prestimeCPUCCTNodeFree.setFilteredNode();
        } else {
            prestimeCPUCCTNodeFree.resetFilteredNode();
        }
    }

    private void filter(FilterSortSupport.Configuration configuration, PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree) {
        if (prestimeCPUCCTNodeFree.children != null) {
            PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree2 = null;
            ArrayList<PrestimeCPUCCTNodeFree> arrayList = new ArrayList<PrestimeCPUCCTNodeFree>();
            for (PrestimeCPUCCTNode prestimeCPUCCTNode : prestimeCPUCCTNodeFree.children) {
                PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree3 = (PrestimeCPUCCTNodeFree)prestimeCPUCCTNode;
                if (FilterSortSupport.passesFilter(configuration, prestimeCPUCCTNodeFree3.getNodeName())) {
                    int n = arrayList.indexOf(prestimeCPUCCTNodeFree3);
                    if (n == -1) {
                        arrayList.add(prestimeCPUCCTNodeFree3);
                        continue;
                    }
                    ((PrestimeCPUCCTNodeFree)arrayList.get(n)).merge(prestimeCPUCCTNodeFree3);
                    continue;
                }
                if (prestimeCPUCCTNodeFree2 == null) {
                    prestimeCPUCCTNodeFree3.setFilteredNode();
                    prestimeCPUCCTNodeFree2 = prestimeCPUCCTNodeFree3;
                    arrayList.add(prestimeCPUCCTNodeFree3);
                    continue;
                }
                prestimeCPUCCTNodeFree2.merge(prestimeCPUCCTNodeFree3);
            }
            if (arrayList.isEmpty()) {
                prestimeCPUCCTNodeFree.children = null;
            } else if (prestimeCPUCCTNodeFree.isFilteredNode() && prestimeCPUCCTNodeFree2 != null && arrayList.size() == 1) {
                PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree4 = (PrestimeCPUCCTNodeFree)arrayList.get(0);
                this.filter(configuration, prestimeCPUCCTNodeFree4);
                prestimeCPUCCTNodeFree.children = prestimeCPUCCTNodeFree4.children;
            } else {
                prestimeCPUCCTNodeFree.children = arrayList.toArray(new PrestimeCPUCCTNodeFree[arrayList.size()]);
            }
            if (prestimeCPUCCTNodeFree.children != null) {
                for (PrestimeCPUCCTNode prestimeCPUCCTNode : prestimeCPUCCTNodeFree.children) {
                    this.filter(configuration, (PrestimeCPUCCTNodeFree)prestimeCPUCCTNode);
                }
            }
        }
    }

    public int[] getThreadIds() {
        int[] nArray = new int[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            nArray[i] = this.threadCCTContainers[0][i].threadId;
        }
        return nArray;
    }

    public String getThreadNameForId(int n) {
        return this.getThreadNames()[this.getContainerIdForThreadId(n)];
    }

    public String[] getThreadNames() {
        String[] stringArray = new String[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            stringArray[i] = this.threadCCTContainers[0][i].threadName;
        }
        return stringArray;
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        int n;
        super.readFromStream(dataInputStream);
        this.collectingTwoTimeStamps = dataInputStream.readBoolean();
        this.nInstrMethods = dataInputStream.readInt();
        this.instrMethodClassesViews = new String[3][];
        String[] stringArray = new String[this.nInstrMethods];
        this.instrMethodClassesViews[0] = stringArray;
        this.instrMethodNames = new String[this.nInstrMethods];
        this.instrMethodSignatures = new String[this.nInstrMethods];
        for (n = 0; n < this.nInstrMethods; ++n) {
            stringArray[n] = dataInputStream.readUTF();
            this.instrMethodNames[n] = dataInputStream.readUTF();
            this.instrMethodSignatures[n] = dataInputStream.readUTF();
        }
        n = dataInputStream.readInt();
        this.threadCCTContainers = new CPUCCTContainer[3][];
        CPUCCTContainer[] cPUCCTContainerArray = new CPUCCTContainer[n];
        this.threadCCTContainers[0] = cPUCCTContainerArray;
        for (int i = 0; i < n; ++i) {
            cPUCCTContainerArray[i] = new CPUCCTContainer(this);
            cPUCCTContainerArray[i].readFromStream(dataInputStream);
            this.threadIdMap.put(cPUCCTContainerArray[i].threadId, i);
        }
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public void saveSortParams(int n, boolean bl, CCTNode cCTNode) {
        FilterSortSupport.Configuration configuration = this.sortInfo(cCTNode);
        configuration.setSortInfo(n, bl);
    }

    @Override
    public String toString() {
        return MessageFormat.format(CPU_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeBoolean(this.collectingTwoTimeStamps);
        dataOutputStream.writeInt(this.nInstrMethods);
        String[] stringArray = this.instrMethodClassesViews[0];
        for (int i = 0; i < this.nInstrMethods; ++i) {
            dataOutputStream.writeUTF(stringArray[i]);
            dataOutputStream.writeUTF(this.instrMethodNames[i]);
            dataOutputStream.writeUTF(this.instrMethodSignatures[i]);
        }
        CPUCCTContainer[] cPUCCTContainerArray = this.threadCCTContainers[0];
        int n = cPUCCTContainerArray.length;
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            cPUCCTContainerArray[i].writeToStream(dataOutputStream);
        }
    }

    private int getContainerIdForThreadId(int n) {
        Integer n2 = n;
        Integer n3 = null;
        if (this.threadIdMap.containsKey(n2)) {
            n3 = (Integer)this.threadIdMap.get(n2);
        }
        return n3 != null ? n3 : 0;
    }

    protected PrestimeCPUCCTNode createRootNodeForAllThreads(int n) {
        CPUCCTContainer[] cPUCCTContainerArray = this.threadCCTContainers[n];
        int n2 = cPUCCTContainerArray.length;
        PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = new PrestimeCPUCCTNode[n2];
        for (int i = 0; i < n2; ++i) {
            PrestimeCPUCCTNode prestimeCPUCCTNode = cPUCCTContainerArray[i].getRootNode();
            prestimeCPUCCTNodeArray[i] = !prestimeCPUCCTNode.isThreadNode() ? new PrestimeCPUCCTNodeBacked(cPUCCTContainerArray[i], new PrestimeCPUCCTNode[]{prestimeCPUCCTNode}) : prestimeCPUCCTNode;
        }
        this.allThreadsMergedCCTContainers[n] = new AllThreadsMergedCPUCCTContainer(this, prestimeCPUCCTNodeArray, n);
        return this.allThreadsMergedCCTContainers[n].getRootNode();
    }

    private void debugValues() {
        LOGGER.log(Level.FINEST, "collectingTwoTimeStamps: {0}", this.collectingTwoTimeStamps);
        LOGGER.log(Level.FINEST, "threadCCTContainers.length: {0}", this.debugLength(this.threadCCTContainers));
        LOGGER.log(Level.FINEST, "allThreadsMergedCCTContainers.length: {0}", this.debugLength(this.allThreadsMergedCCTContainers));
        LOGGER.log(Level.FINEST, "rootNode.length: {0}", this.debugLength(this.rootNode));
        LOGGER.log(Level.FINEST, "instrMethodClassesViews.length: {0}", this.debugLength(this.instrMethodClassesViews));
        LOGGER.log(Level.FINEST, "instrMethodNames.length: {0}", this.debugLength(this.instrMethodNames));
        LOGGER.log(Level.FINEST, "instrMethodSignatures.length: {0}", this.debugLength(this.instrMethodSignatures));
        LOGGER.log(Level.FINEST, "nInstrMethods: {0}", this.nInstrMethods);
    }

    private void generateDataForView(int n) {
        if (this.threadCCTContainers[n] == null) {
            MethodIdMap methodIdMap = new MethodIdMap(this.instrMethodClassesViews[0], this.nInstrMethods, n);
            int n2 = this.threadCCTContainers[0].length;
            this.threadCCTContainers[n] = new CPUCCTContainer[n2];
            for (int i = 0; i < n2; ++i) {
                this.threadCCTContainers[n][i] = new CPUCCTClassContainer(this.threadCCTContainers[0][i], methodIdMap, n);
            }
            this.rootNode[n] = this.createRootNodeForAllThreads(n);
            this.instrMethodClassesViews[n] = methodIdMap.getInstrClassesOrPackages();
        }
    }

    public static class NoDataAvailableException
    extends Exception {
    }
}

