/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.ClassLoaderFieldValue;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofFieldValue;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LoadClass;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.PrimitiveArrayDump;
import org.netbeans.lib.profiler.heap.TagBounds;

class ClassDump
extends HprofObject
implements JavaClass {
    private static final boolean DEBUG = false;
    private static final Set CANNOT_CONTAIN_ITSELF = new HashSet<String>(Arrays.asList("java.lang.String", "java.lang.StringBuffer", "java.lang.StringBuilder", "java.io.File"));
    final ClassDumpSegment classDumpSegment;
    private int instances;
    private long loadClassOffset;
    private long retainedSizeByClass;

    ClassDump(ClassDumpSegment classDumpSegment, long l) {
        super(l);
        this.classDumpSegment = classDumpSegment;
        assert (this.getHprofBuffer().get(l) == 32);
    }

    @Override
    public long getAllInstancesSize() {
        if (this.isArray()) {
            return (Long)this.classDumpSegment.arrayMap.get(this);
        }
        return (long)this.getInstancesCount() * (long)this.getInstanceSize();
    }

    @Override
    public boolean isArray() {
        return this.classDumpSegment.arrayMap.get(this) != null;
    }

    @Override
    public Instance getClassLoader() {
        return this.getHprof().getInstanceByID(this.getClassLoaderId());
    }

    public Field getField(String string) {
        for (Field field : this.getFields()) {
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    @Override
    public List getFields() {
        List list = (List)this.classDumpSegment.fieldsCache.get(this);
        if (list == null) {
            list = this.computeFields();
            this.classDumpSegment.fieldsCache.put(this, list);
        }
        return list;
    }

    @Override
    public int getInstanceSize() {
        if (this.isArray()) {
            return -1;
        }
        return this.classDumpSegment.getMinimumInstanceSize() + this.getHprofBuffer().getInt(this.fileOffset + (long)this.classDumpSegment.instanceSizeOffset);
    }

    @Override
    public long getRetainedSizeByClass() {
        this.getHprof().computeRetainedSizeByClass();
        return this.retainedSizeByClass;
    }

    @Override
    public List getInstances() {
        int n = this.getInstancesCount();
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        long l = this.getJavaClassId();
        HprofHeap hprofHeap = this.getHprof();
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n2 = hprofByteBuffer.getIDSize();
        ArrayList<InstanceDump> arrayList = new ArrayList<InstanceDump>(n);
        TagBounds tagBounds = hprofHeap.getAllInstanceDumpBounds();
        long[] lArray = new long[]{tagBounds.startOffset};
        while (lArray[0] < tagBounds.endOffset) {
            InstanceDump instanceDump;
            long l2 = lArray[0];
            int n3 = 0;
            long l3 = 0L;
            int n4 = hprofHeap.readDumpTag(lArray);
            if (n4 == 33) {
                n3 = n2 + 4;
            } else if (n4 == 34) {
                n3 = n2 + 4 + 4;
            } else if (n4 == 35) {
                byte by = hprofByteBuffer.get(l2 + 1L + (long)n2 + 4L + 4L);
                l3 = this.classDumpSegment.getPrimitiveArrayClass(by).getJavaClassId();
            }
            if (n3 != 0) {
                l3 = hprofByteBuffer.getID(l2 + 1L + (long)n3);
            }
            if (l3 != l) continue;
            if (n4 == 33) {
                instanceDump = new InstanceDump(this, l2);
            } else if (n4 == 34) {
                instanceDump = new ObjectArrayDump(this, l2);
            } else if (n4 == 35) {
                instanceDump = new PrimitiveArrayDump(this, l2);
            } else {
                throw new IllegalArgumentException("Illegal tag " + n4);
            }
            arrayList.add(instanceDump);
            if (--n != 0) continue;
            return arrayList;
        }
        return arrayList;
    }

    @Override
    public int getInstancesCount() {
        if (this.instances == 0) {
            this.getHprof().computeInstances();
        }
        return this.instances;
    }

    @Override
    public long getJavaClassId() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classIDOffset);
    }

    @Override
    public String getName() {
        return this.getLoadClass().getName();
    }

    @Override
    public List getStaticFieldValues() {
        return this.getStaticFieldValues(true);
    }

    @Override
    public Collection getSubClasses() {
        List list = this.classDumpSegment.hprofHeap.getAllClasses();
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>(list.size() / 10);
        HashMap<ClassDump, Boolean> hashMap = new HashMap<ClassDump, Boolean>(list.size() * 4 / 3);
        hashMap.put(this, Boolean.TRUE);
        for (int i = 0; i < list.size(); ++i) {
            JavaClass javaClass = (JavaClass)list.get(i);
            Boolean bl = (Boolean)hashMap.get(javaClass);
            if (bl == null) {
                bl = ClassDump.isSubClass(javaClass, hashMap);
            }
            if (!bl.booleanValue() || javaClass == this) continue;
            arrayList.add(javaClass);
        }
        return arrayList;
    }

    @Override
    public JavaClass getSuperClass() {
        long l = this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.superClassIDOffset);
        return this.classDumpSegment.getClassDumpByID(l);
    }

    @Override
    public Object getValueOfStaticField(String string) {
        for (FieldValue fieldValue : this.getStaticFieldValues()) {
            if (!fieldValue.getField().getName().equals(string)) continue;
            if (fieldValue instanceof HprofFieldObjectValue) {
                return ((HprofFieldObjectValue)fieldValue).getInstance();
            }
            return ((HprofFieldValue)fieldValue).getTypeValue();
        }
        return null;
    }

    private List computeFields() {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        long l = this.fileOffset + (long)this.getInstanceFieldOffset();
        int n = hprofByteBuffer.getShort(l);
        ArrayList<HprofField> arrayList = new ArrayList<HprofField>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new HprofField(this, l + 2L + (long)(i * this.classDumpSegment.fieldSize)));
        }
        return arrayList;
    }

    List getStaticFieldValues(boolean bl) {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        long l = this.fileOffset + (long)this.getStaticFieldOffset();
        HprofHeap hprofHeap = this.getHprof();
        int n = hprofByteBuffer.getShort(l);
        l += 2L;
        ArrayList<HprofFieldObjectValue> arrayList = new ArrayList<HprofFieldObjectValue>(n + (bl ? (short)0 : 1));
        for (int i = 0; i < n; ++i) {
            byte by = hprofByteBuffer.get(l + (long)this.classDumpSegment.fieldTypeOffset);
            int n2 = this.classDumpSegment.fieldSize + hprofHeap.getValueSize(by);
            HprofFieldValue hprofFieldValue = by == 2 ? new HprofFieldObjectValue(this, l) : new HprofFieldValue(this, l);
            arrayList.add((HprofFieldObjectValue)hprofFieldValue);
            l += (long)n2;
        }
        if (bl) {
            long l2 = this.fileOffset + (long)this.classDumpSegment.classLoaderIDOffset;
            arrayList.add(new ClassLoaderFieldValue(this, l2));
        }
        return arrayList;
    }

    List getAllInstanceFields() {
        ArrayList arrayList = new ArrayList(50);
        for (JavaClass javaClass = this; javaClass != null; javaClass = javaClass.getSuperClass()) {
            arrayList.addAll(javaClass.getFields());
        }
        return arrayList;
    }

    void setClassLoadOffset(long l) {
        this.loadClassOffset = l;
    }

    int getConstantPoolSize() {
        long l = this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset;
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n = hprofByteBuffer.getShort(l);
        HprofHeap hprofHeap = this.getHprof();
        l += 2L;
        for (int i = 0; i < n; ++i) {
            byte by = hprofByteBuffer.get(l + 2L);
            int n2 = hprofHeap.getValueSize(by);
            l += (long)(3 + n2);
        }
        return (int)(l - (this.fileOffset + (long)this.classDumpSegment.constantPoolSizeOffset));
    }

    HprofHeap getHprof() {
        return this.classDumpSegment.hprofHeap;
    }

    HprofByteBuffer getHprofBuffer() {
        return this.classDumpSegment.hprofHeap.dumpBuffer;
    }

    int getInstanceFieldOffset() {
        int n = this.getStaticFieldOffset();
        return n + this.getStaticFiledSize(n);
    }

    LoadClass getLoadClass() {
        return new LoadClass(this.getHprof().getLoadClassSegment(), this.loadClassOffset);
    }

    long getClassLoaderId() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.classDumpSegment.classLoaderIDOffset);
    }

    List getReferences() {
        return this.getHprof().findReferencesFor(this.getJavaClassId());
    }

    int getStaticFieldOffset() {
        return this.classDumpSegment.constantPoolSizeOffset + this.getConstantPoolSize();
    }

    int getStaticFiledSize(int n) {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n2 = hprofByteBuffer.getIDSize();
        long l = this.fileOffset + (long)n;
        int n3 = this.getHprofBuffer().getShort(l);
        HprofHeap hprofHeap = this.getHprof();
        l += 2L;
        for (int i = 0; i < n3; ++i) {
            byte by = hprofByteBuffer.get(l + (long)n2);
            int n4 = hprofHeap.getValueSize(by);
            l += (long)(n2 + 1 + n4);
        }
        return (int)(l - (long)n - this.fileOffset);
    }

    void findStaticReferencesFor(long l, List list) {
        HprofByteBuffer hprofByteBuffer = this.getHprofBuffer();
        int n = hprofByteBuffer.getIDSize();
        long l2 = this.fileOffset + (long)this.getStaticFieldOffset();
        int n2 = this.getHprofBuffer().getShort(l2);
        List list2 = null;
        HprofHeap hprofHeap = this.getHprof();
        l2 += 2L;
        for (int i = 0; i < n2; ++i) {
            byte by = hprofByteBuffer.get(l2 + (long)n);
            int n3 = hprofHeap.getValueSize(by);
            if (by == 2 && l == hprofByteBuffer.getID(l2 + (long)n + 1L)) {
                if (list2 == null) {
                    list2 = this.getStaticFieldValues();
                }
                list.add(list2.get(i));
            }
            l2 += (long)(n + 1 + n3);
        }
        if (l == this.getClassLoaderId()) {
            if (list2 == null) {
                list2 = this.getStaticFieldValues();
            }
            list.add(list2.get(n2));
        }
    }

    void incrementInstance() {
        ++this.instances;
    }

    void addSizeForInstance(Instance instance) {
        this.retainedSizeByClass += (long)instance.getRetainedSize();
    }

    boolean canContainItself() {
        if (this.getInstancesCount() >= 2 && !CANNOT_CONTAIN_ITSELF.contains(this.getName())) {
            for (Field field : this.getAllInstanceFields()) {
                if (!field.getType().getName().equals("object")) continue;
                return true;
            }
        }
        return false;
    }

    private static Boolean isSubClass(JavaClass javaClass, Map map) {
        Boolean bl;
        JavaClass javaClass2 = javaClass.getSuperClass();
        if (javaClass2 == null) {
            bl = Boolean.FALSE;
        } else {
            bl = (Boolean)map.get(javaClass2);
            if (bl == null) {
                bl = ClassDump.isSubClass(javaClass2, map);
            }
        }
        map.put(javaClass, bl);
        return bl;
    }
}

