/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JVMParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.BASE64Decoder;

public final class ArgumentParsingUtil {
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static List parseCommandLine(String string) {
        if (string == null || ArgumentParsingUtil.isEmpty(string)) {
            return new ArrayList();
        }
        Pattern pattern = Pattern.compile("(?:(?:([\"'])(?:\\\\\\1|.)*?(?:\\1|$))|(?:\\\\[\"'\\s]|[^\\s]))+");
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            String string2 = string.substring(matcher.start(), matcher.end()).trim();
            if (ArgumentParsingUtil.isEmpty(string2)) continue;
            arrayList.add(ArgumentParsingUtil.unquoteIfNeeded(string2));
        }
        Trace.println(" --- parseCommandLine converted : " + string + "\ninto:\n" + arrayList, TraceLevel.SECURITY);
        return arrayList;
    }

    public static List getSecureLaunchArgs(JREInfo jREInfo, List list, JVMParameters jVMParameters, boolean bl) {
        List list2;
        List list3;
        Object object;
        ArrayList arrayList = new ArrayList();
        if (jREInfo == null) {
            throw new IllegalArgumentException("Invalid JRE info passed.");
        }
        String string = jREInfo.getJREPath();
        if (string == null || ArgumentParsingUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Invalid JRE path passed.");
        }
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Invalid argument list passed.");
        }
        String string2 = null;
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string3.charAt(0) == '-') {
                if (!string3.equals("-classpath") && !string3.equals("-cp") && !string3.equals("-jar") || !iterator.hasNext()) continue;
                iterator.next();
                continue;
            }
            string2 = string3;
            break;
        }
        Trace.println("Main class is: " + string2, TraceLevel.SECURITY);
        if (!string2.equals("com.sun.javaws.Main") && !string2.equals("sun.plugin2.main.client.PluginMain")) {
            Trace.println("Cannot use secure launcher with main class: " + string2);
            return null;
        }
        int n = list.indexOf(string2);
        List list4 = list.subList(1, n);
        List list5 = list.subList(n + 1, list.size());
        String string4 = ArgumentParsingUtil.encodeArgumentList(list4);
        String string5 = ArgumentParsingUtil.encodeArgumentList(list5);
        arrayList.add(list.get(0));
        arrayList.add("-secure");
        if (string2.equals("com.sun.javaws.Main")) {
            arrayList.add("-javaws");
        } else {
            arrayList.add("-plugin");
        }
        arrayList.add("-jre");
        arrayList.add(string);
        arrayList.add("-vma");
        arrayList.add(string4);
        arrayList.add("-ma");
        arrayList.add(string5);
        if (bl && (object = jREInfo.getVmArgs()) != null && !ArgumentParsingUtil.isEmpty((String)object) && !(list3 = ArgumentParsingUtil.getMergedList(list2 = ArgumentParsingUtil.parseCommandLine((String)object), list4)).isEmpty()) {
            Trace.println("Adding vm args from JCP: " + list3, TraceLevel.BASIC);
            arrayList.add("-ta");
            arrayList.add(ArgumentParsingUtil.encodeArgumentList(list3));
        }
        if (jVMParameters != null && !(list2 = ArgumentParsingUtil.getMergedList((List)(object = jVMParameters.getCommandLineArguments(false)), list4)).isEmpty()) {
            Trace.println("Adding vm args from HTML or JNLP: " + list2, TraceLevel.BASIC);
            arrayList.add("-ta");
            arrayList.add(ArgumentParsingUtil.encodeArgumentList(list2));
        }
        return arrayList;
    }

    private static List getMergedList(List list, List list2) {
        ArrayList arrayList = new ArrayList();
        if (list != null && list2 != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!Config.isSecureVmArg((String)list.get(i))) {
                    arrayList.add(list.get(i));
                    continue;
                }
                if (list2.contains(list.get(i))) continue;
                arrayList.add(list.get(i));
            }
        }
        return arrayList;
    }

    public static String encodeArgumentList(List list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                byte[] byArray = string.getBytes("UTF-8");
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                byteArrayOutputStream.write(0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Trace.println("Internal error while encoding argument list.", TraceLevel.DEFAULT);
                return "";
            }
        }
        return ArgumentParsingUtil.base64Encode(byteArrayOutputStream.toByteArray());
    }

    public static List decodeArgumentList(String string) {
        byte[] byArray;
        if (string == null || ArgumentParsingUtil.isEmpty(string)) {
            return new ArrayList();
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            byArray = bASE64Decoder.decodeBuffer(string);
        }
        catch (IOException iOException) {
            Trace.println("Internal error while decoding argument list.", TraceLevel.DEFAULT);
            return null;
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0 && i != byArray.length - 1) continue;
            if (i > n) {
                try {
                    String string2 = new String(byArray, n, i - n, "UTF-8");
                    arrayList.add(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Trace.println("Bad characters encountered while decoding command line argument.", TraceLevel.DEFAULT);
                    return null;
                }
            }
            n = i + 1;
        }
        return arrayList;
    }

    public static String serializeArgumentListForDebugging(List list) {
        if (list == null) {
            throw new NullPointerException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(" \"");
            stringBuilder.append((String)iterator.next());
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    private static String unquoteIfNeeded(String string) {
        if (string == null) {
            return null;
        }
        if (ArgumentParsingUtil.isEmpty(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.codePointCount(0, string.length());
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            int n3 = string.codePointAt(i);
            if (n3 == 34 || n3 == 39) {
                if (n2 != -1) {
                    if (n3 == n2) {
                        n2 = -1;
                        continue;
                    }
                    stringBuilder.appendCodePoint(n3);
                    continue;
                }
                n2 = n3;
                continue;
            }
            if (n3 == 92) {
                if (++i >= n) continue;
                stringBuilder.appendCodePoint(string.codePointAt(i));
                continue;
            }
            stringBuilder.appendCodePoint(n3);
        }
        return stringBuilder.toString();
    }

    private static String base64Encode(byte[] byArray) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = byArray.length;
        for (int i = 0; i < n2; i += n) {
            n = Math.min(n2 - i, 3);
            try {
                ArgumentParsingUtil.encodeAtom(byteArrayOutputStream, byArray, i, n);
                continue;
            }
            catch (IOException iOException) {
                System.err.println("caught error encoding argument list: " + iOException);
                return null;
            }
        }
        return byteArrayOutputStream.toString();
    }

    private static void encodeAtom(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 1) {
            byte by = byArray[n];
            int n3 = 0;
            boolean bl = false;
            outputStream.write(pem_array[by >>> 2 & 0x3F]);
            outputStream.write(pem_array[(by << 4 & 0x30) + (n3 >>> 4 & 0xF)]);
            outputStream.write(61);
            outputStream.write(61);
        } else if (n2 == 2) {
            byte by = byArray[n];
            byte by2 = byArray[n + 1];
            int n4 = 0;
            outputStream.write(pem_array[by >>> 2 & 0x3F]);
            outputStream.write(pem_array[(by << 4 & 0x30) + (by2 >>> 4 & 0xF)]);
            outputStream.write(pem_array[(by2 << 2 & 0x3C) + (n4 >>> 6 & 3)]);
            outputStream.write(61);
        } else {
            byte by = byArray[n];
            byte by3 = byArray[n + 1];
            byte by4 = byArray[n + 2];
            outputStream.write(pem_array[by >>> 2 & 0x3F]);
            outputStream.write(pem_array[(by << 4 & 0x30) + (by3 >>> 4 & 0xF)]);
            outputStream.write(pem_array[(by3 << 2 & 0x3C) + (by4 >>> 6 & 3)]);
            outputStream.write(pem_array[by4 & 0x3F]);
        }
    }

    private static boolean isEmpty(String string) {
        return string.length() == 0;
    }
}

