/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.wizard;

import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachSettingsPanel;
import org.netbeans.modules.profiler.attach.panels.ManualIntegrationPanel;
import org.netbeans.modules.profiler.attach.panels.PerformIntegrationPanel;
import org.netbeans.modules.profiler.attach.panels.RemoteAttachSettingsPanel;
import org.netbeans.modules.profiler.attach.panels.ReviewAdditionalStepsPanel;
import org.netbeans.modules.profiler.attach.panels.ReviewSettingsPanel;
import org.netbeans.modules.profiler.attach.panels.SelectIntegrationTypePanel;
import org.netbeans.modules.profiler.attach.wizard.AbstractWizard;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.netbeans.modules.profiler.attach.wizard.WizardContext;
import org.netbeans.modules.profiler.attach.wizard.functors.ConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.steps.CompositeWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.ProxyWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStep;
import org.openide.util.NbBundle;

public class AttachWizardImpl
extends AbstractWizard {
    private static final String ATTACH_WIZARD_CAPTION = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_AttachWizardCaption");
    private static final String STEP_INTEGRATION_TYPE = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_ChooseIntegrationTypeString");
    private static final String STEP_REVIEW_ATTACHSETTINGS = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_ReviewAttachSettingsString");
    private static final String STEP_SELECT_TARGETTYPE = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_SelectTargetTypeString");
    private static final String STEP_REMOTE_SETTINGS = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_RemoteSystemString");
    private static final String STEP_DYNAMIC_SETTINGS = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_DynamicAttachString");
    private static final String STEP_PERFORM_INTEGRATION = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_PerformIntegrationString");
    private static final String STEP_REVIEW_ADDITIONALSTEPS = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_ReviewAdditionalStepsString");
    private static final String STEP_MANUAL_INTEGRATION = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_ManualIntegrationStep");
    private static final String STEP_AUTOMATIC_INTEGRATION = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_AutomaticIntegrationStep");
    private static final String PROVIDER_SPECIFIC_SETTINGS = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_ProviderSpecificSettings");
    private static final String REFINE_ATTACHMENT_SETTINGS = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_RefineAttachmentSettings");
    private static final String INTEGRATE_PROFILER = NbBundle.getMessage(AttachWizardImpl.class, (String)"AttachWizard_IntegrateProfiler");
    private AttachWizardContext context = null;
    private ProxyWizardStep proxy = null;
    private WizardStep wizardModel = null;

    public AttachSettings getAttachSettings() {
        return ((AttachWizardContext)this.getContext()).getAttachSettings();
    }

    public void init(AttachSettings attachSettings) {
        ((AttachWizardContext)this.getContext()).setAttachSettings(attachSettings);
        super.init();
    }

    @Override
    protected boolean isAutoWizard() {
        return true;
    }

    @Override
    protected boolean isContentDisplayed() {
        return true;
    }

    @Override
    protected WizardContext getContext() {
        if (this.context == null) {
            this.context = new AttachWizardContext();
        }
        return this.context;
    }

    @Override
    protected boolean isHelpDisplayed() {
        return true;
    }

    @Override
    protected boolean isNumbered() {
        return true;
    }

    @Override
    protected WizardStep getRootStep() {
        if (this.wizardModel == null) {
            this.wizardModel = this.buildWizardModel();
        }
        return this.wizardModel;
    }

    @Override
    protected String getTitle() {
        return ATTACH_WIZARD_CAPTION;
    }

    @Override
    protected String getTitleFormat() {
        return "{0}";
    }

    @Override
    protected void onUpdateWizardSteps() {
        this.proxy.setWizardStep(((AttachWizardContext)this.getContext()).getIntegrationProvider().getAttachedWizard());
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.wizardModel = null;
    }

    private boolean isAutomationAllowed(AttachWizardContext attachWizardContext) {
        if (!attachWizardContext.getIntegrationProvider().supportsAutomation()) {
            return false;
        }
        return attachWizardContext.getIntegrationProvider().supportsManual() && !attachWizardContext.getAttachSettings().isRemote();
    }

    private WizardStep buildWizardModel() {
        this.proxy = this.prepareProviderProxyStep();
        CompositeWizardStep compositeWizardStep = new CompositeWizardStep(this.getContext(), ATTACH_WIZARD_CAPTION);
        compositeWizardStep.addStep(STEP_SELECT_TARGETTYPE, new AttachSettingsPanel());
        compositeWizardStep.addStep(this.prepareAdditionalSettingsStep());
        compositeWizardStep.addStep(STEP_REVIEW_ATTACHSETTINGS, new ReviewSettingsPanel());
        compositeWizardStep.addStep(this.prepareIntegrationStep());
        return compositeWizardStep;
    }

    private WizardStep prepareAdditionalSettingsStep() {
        CompositeWizardStep compositeWizardStep = new CompositeWizardStep(this.getContext(), REFINE_ATTACHMENT_SETTINGS, new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext wizardContext) {
                AttachSettings attachSettings = ((AttachWizardContext)wizardContext).getAttachSettings();
                return attachSettings.isRemote() || !attachSettings.isDirect() && !attachSettings.isDynamic16();
            }
        });
        SimpleWizardStep simpleWizardStep = new SimpleWizardStep(this.getContext(), STEP_REMOTE_SETTINGS, new RemoteAttachSettingsPanel(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext wizardContext) {
                AttachSettings attachSettings = ((AttachWizardContext)wizardContext).getAttachSettings();
                return attachSettings.isRemote();
            }
        });
        compositeWizardStep.addStep(simpleWizardStep);
        return compositeWizardStep;
    }

    private WizardStep prepareIntegrationStep() {
        CompositeWizardStep compositeWizardStep = new CompositeWizardStep(this.getContext(), INTEGRATE_PROFILER, new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext wizardContext) {
                AttachWizardContext attachWizardContext = (AttachWizardContext)wizardContext;
                AttachSettings attachSettings = attachWizardContext.getAttachSettings();
                return attachWizardContext.getIntegrationProvider().supportsManual() || attachWizardContext.getIntegrationProvider().supportsAutomation();
            }
        });
        compositeWizardStep.addStep(STEP_INTEGRATION_TYPE, new SelectIntegrationTypePanel(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext wizardContext) {
                AttachWizardContext attachWizardContext = (AttachWizardContext)wizardContext;
                return AttachWizardImpl.this.isAutomationAllowed(attachWizardContext);
            }
        });
        CompositeWizardStep compositeWizardStep2 = new CompositeWizardStep(this.getContext(), STEP_AUTOMATIC_INTEGRATION, new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext wizardContext) {
                AttachWizardContext attachWizardContext = (AttachWizardContext)wizardContext;
                return attachWizardContext.isAutomatic();
            }
        });
        compositeWizardStep2.addStep(this.proxy);
        compositeWizardStep2.addStep(STEP_PERFORM_INTEGRATION, new PerformIntegrationPanel(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext wizardContext) {
                return true;
            }
        });
        compositeWizardStep2.addStep(STEP_REVIEW_ADDITIONALSTEPS, new ReviewAdditionalStepsPanel());
        compositeWizardStep.addStep(compositeWizardStep2);
        compositeWizardStep.addStep(this.prepareManualIntegrationStep());
        return compositeWizardStep;
    }

    private WizardStep prepareManualIntegrationStep() {
        return new SimpleWizardStep(this.getContext(), STEP_MANUAL_INTEGRATION, new ManualIntegrationPanel(), new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext wizardContext) {
                AttachWizardContext attachWizardContext = (AttachWizardContext)wizardContext;
                return attachWizardContext.isManual();
            }
        });
    }

    private ProxyWizardStep prepareProviderProxyStep() {
        return new ProxyWizardStep(this.getContext(), PROVIDER_SPECIFIC_SETTINGS, new ConditionalFunctor(){

            @Override
            public boolean evaluate(WizardContext wizardContext) {
                AttachWizardContext attachWizardContext = (AttachWizardContext)wizardContext;
                return attachWizardContext.isAutomatic();
            }
        }){

            @Override
            public void setNext() {
                super.setNext();
                if (this.canHandle()) {
                    ((AttachWizardContext)AttachWizardImpl.this.getContext()).getIntegrationProvider().getSettingsPersistor().storeSettings();
                }
            }
        };
    }
}

