/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.profiler.attach.panels.components.ResizableHintPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DirectorySelector
extends JPanel {
    public static final String LAYOUT_CHANGED_PROPERTY = DirectorySelector.class.getName() + "#LAYOUT_CHANGED";
    public static final String PATH_PROPERTY = "path";
    private DocumentListener pathListener = new DocumentListener(){
        private String oldValue = "";

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.firePathChange(DirectorySelector.this.textPath.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.firePathChange(DirectorySelector.this.textPath.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.firePathChange(DirectorySelector.this.textPath.getText());
        }

        private void firePathChange(String string) {
            DirectorySelector.this.firePropertyChange(DirectorySelector.PATH_PROPERTY, this.oldValue, string);
            this.oldValue = string;
        }
    };
    private String label = NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.caption.text");
    private String initPath = "";
    private JPanel browsePanel;
    private JButton buttonBrowse;
    private ResizableHintPanel hintPanel;
    private JTextField textPath;

    public DirectorySelector() {
        this.initComponents();
    }

    private void initComponents() {
        this.browsePanel = new JPanel();
        this.textPath = new JTextField();
        this.buttonBrowse = new JButton();
        this.hintPanel = new ResizableHintPanel();
        this.textPath.setText(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.textPath.text"));
        this.textPath.getDocument().addDocumentListener(this.pathListener);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonBrowse, (String)NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.buttonBrowse.text"));
        this.buttonBrowse.setMaximumSize(new Dimension(43, 23));
        this.buttonBrowse.setMinimumSize(new Dimension(43, 23));
        this.buttonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectorySelector.this.buttonBrowseActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.browsePanel);
        this.browsePanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.textPath, -1, 283, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonBrowse, -2, 25, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonBrowse, -2, 18, -2).addComponent(this.textPath, -2, -1, -2)));
        this.textPath.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.textPath.AccessibleContext.accessibleName"));
        this.textPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.textPath.AccessibleContext.accessibleDescription"));
        this.buttonBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectorySelector.class, (String)"DirectorySelector.buttonBrowse.AccessibleContext.accessibleDescription"));
        this.hintPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.hintPanel.setMinimumSize(new Dimension(0, 0));
        this.hintPanel.setPreferredSize(new Dimension(0, 0));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browsePanel, -1, -1, Short.MAX_VALUE).addComponent(this.hintPanel, -1, 317, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.browsePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hintPanel, -1, 43, Short.MAX_VALUE)));
    }

    private void buttonBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        String string = this.getPath();
        if (string == null || string.length() == 0) {
            string = this.initPath;
        }
        File file = new File(string);
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(this.label);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.setPath(file2.getAbsolutePath());
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getPath() {
        return this.textPath.getText();
    }

    public void setPath(String string) {
        this.textPath.setText(string);
    }

    public void setInitialDir(String string) {
        this.initPath = string;
    }

    public String getInitialDir() {
        return this.initPath;
    }

    public String getHint() {
        return this.hintPanel.getHint();
    }

    public void setHint(String string) {
        this.hintPanel.setHint(string);
        if (string == null || string.length() == 0) {
            this.hintPanel.setVisible(false);
        } else {
            this.hintPanel.setVisible(true);
        }
        this.firePropertyChange(LAYOUT_CHANGED_PROPERTY, null, null);
    }

    public Color getHintForeground() {
        return this.hintPanel.getForeground();
    }

    public void setHintForeground(Color color) {
        this.hintPanel.setForeground(color);
    }

    public Color getHintBackground() {
        return this.hintPanel.getBackground();
    }

    public void setHintBackground(Color color) {
        this.hintPanel.setBackground(color);
    }
}

