/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.util.Arrays;

final class IntList {
    private int[] array;
    private int used = 0;
    private int lastAdded = Integer.MIN_VALUE;

    IntList(int n) {
        this.array = this.allocArray(n);
    }

    public synchronized void add(int n) {
        if (this.used > 0 && this.array[this.used - 1] == n) {
            return;
        }
        if (n < this.lastAdded) {
            throw new IllegalArgumentException("Contents must be presorted - added value " + n + " is less than preceding " + "value " + this.lastAdded);
        }
        if (this.used >= this.array.length) {
            this.growArray();
        }
        this.array[this.used++] = n;
        this.lastAdded = n;
    }

    private int[] allocArray(int n) {
        int[] nArray = new int[n];
        Arrays.fill(nArray, Integer.MAX_VALUE);
        return nArray;
    }

    public synchronized int get(int n) {
        if (n >= this.used) {
            throw new ArrayIndexOutOfBoundsException("List contains " + this.used + " items, but tried to fetch item " + n);
        }
        return this.array[n];
    }

    public boolean contains(int n) {
        return Arrays.binarySearch(this.array, n) >= 0;
    }

    public int findNearest(int n) {
        if (this.size() == 0) {
            return -1;
        }
        int n2 = Arrays.binarySearch(this.array, n);
        if (n2 < 0) {
            n2 = -n2 - 2;
        }
        return n2;
    }

    public int indexOf(int n) {
        int n2 = Arrays.binarySearch(this.array, n);
        if (n2 < 0) {
            n2 = -1;
        }
        if (n2 >= this.used) {
            n2 = -1;
        }
        return n2;
    }

    public synchronized int size() {
        return this.used;
    }

    private void growArray() {
        int[] nArray = this.array;
        this.array = this.allocArray(Math.round((float)this.array.length * 1.5f));
        System.arraycopy(nArray, 0, this.array, 0, nArray.length);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("IntList [");
        for (int i = 0; i < this.used; ++i) {
            stringBuffer.append(i);
            stringBuffer.append(':');
            stringBuffer.append(this.array[i]);
            if (i == this.used - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

