/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjLivenessCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class LivenessMemoryResultsSnapshot
extends MemoryResultsSnapshot {
    private static final String MEMORY_LIVENESS_MSG = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle").getString("LivenessMemoryResultsSnapshot_MemoryLivenessMsg");
    private float[] avgObjectAge;
    private int[] maxSurvGen;
    private int[] nTotalAllocObjects;
    private long[] nTrackedAllocObjects;
    private int[] nTrackedLiveObjects;
    private long[] trackedLiveObjectsSize;
    private int currentEpoch;
    private int nInstrClasses;
    private int nTotalTracked;
    private int nTrackedItems;
    private long maxValue;
    private long nTotalTrackedBytes;

    public LivenessMemoryResultsSnapshot() {
    }

    public LivenessMemoryResultsSnapshot(long l, long l2, MemoryCCTProvider memoryCCTProvider, ProfilerClient profilerClient) throws ClientUtils.TargetAppOrVMTerminated {
        super(l, l2, memoryCCTProvider, profilerClient);
    }

    public float[] getAvgObjectAge() {
        return this.avgObjectAge;
    }

    public int[] getMaxSurvGen() {
        return this.maxSurvGen;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public int getNAlloc() {
        return this.nInstrClasses;
    }

    public int getNInstrClasses() {
        return this.nInstrClasses;
    }

    public long getNTotalTracked() {
        return this.nTotalTracked;
    }

    public long getNTotalTrackedBytes() {
        return this.nTotalTrackedBytes;
    }

    public long[] getNTrackedAllocObjects() {
        return this.nTrackedAllocObjects;
    }

    public int getNTrackedItems() {
        return this.nTrackedItems;
    }

    public int[] getNTrackedLiveObjects() {
        return this.nTrackedLiveObjects;
    }

    public long[] getTrackedLiveObjectsSize() {
        return this.trackedLiveObjectsSize;
    }

    public int[] getnTotalAllocObjects() {
        return this.nTotalAllocObjects;
    }

    @Override
    public void performInit(ProfilerClient profilerClient, MemoryCCTProvider memoryCCTProvider) throws ClientUtils.TargetAppOrVMTerminated {
        int n;
        MemoryCCTProvider.ObjectNumbersContainer objectNumbersContainer = memoryCCTProvider.getLivenessObjectNumbers();
        int n2 = objectNumbersContainer.nTrackedAllocObjects.length;
        this.nTrackedAllocObjects = new long[n2];
        System.arraycopy(objectNumbersContainer.nTrackedAllocObjects, 0, this.nTrackedAllocObjects, 0, n2);
        n2 = objectNumbersContainer.nTrackedLiveObjects.length;
        this.nTrackedLiveObjects = new int[n2];
        System.arraycopy(objectNumbersContainer.nTrackedLiveObjects, 0, this.nTrackedLiveObjects, 0, n2);
        n2 = objectNumbersContainer.trackedLiveObjectsSize.length;
        this.trackedLiveObjectsSize = new long[n2];
        System.arraycopy(objectNumbersContainer.trackedLiveObjectsSize, 0, this.trackedLiveObjectsSize, 0, n2);
        n2 = objectNumbersContainer.avgObjectAge.length;
        this.avgObjectAge = new float[n2];
        System.arraycopy(objectNumbersContainer.avgObjectAge, 0, this.avgObjectAge, 0, n2);
        n2 = objectNumbersContainer.maxSurvGen.length;
        this.maxSurvGen = new int[n2];
        System.arraycopy(objectNumbersContainer.maxSurvGen, 0, this.maxSurvGen, 0, n2);
        this.nInstrClasses = objectNumbersContainer.nInstrClasses;
        int[] nArray = profilerClient.getAllocatedObjectsCountResults();
        n2 = nArray.length;
        this.nTotalAllocObjects = new int[n2];
        System.arraycopy(nArray, 0, this.nTotalAllocObjects, 0, n2);
        this.nTrackedItems = Math.min(this.nTrackedAllocObjects.length, this.nTrackedLiveObjects.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.trackedLiveObjectsSize.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.avgObjectAge.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.maxSurvGen.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nInstrClasses);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nTotalAllocObjects.length);
        for (n = 0; n < this.nTrackedItems; ++n) {
            if (this.nTrackedAllocObjects[n] != -1L) continue;
            this.nTotalAllocObjects[n] = 0;
        }
        this.maxValue = 0L;
        this.nTotalTrackedBytes = 0L;
        this.nTotalTracked = 0;
        for (n = 0; n < this.nTrackedItems; ++n) {
            if (this.maxValue < this.trackedLiveObjectsSize[n]) {
                this.maxValue = this.trackedLiveObjectsSize[n];
            }
            this.nTotalTrackedBytes += this.trackedLiveObjectsSize[n];
            this.nTotalTracked += this.nTrackedLiveObjects[n];
        }
        this.currentEpoch = memoryCCTProvider.getCurrentEpoch();
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        int n;
        super.readFromStream(dataInputStream);
        int n2 = dataInputStream.readInt();
        this.nTrackedAllocObjects = new long[n2];
        for (n = 0; n < n2; ++n) {
            this.nTrackedAllocObjects[n] = dataInputStream.readLong();
        }
        n2 = dataInputStream.readInt();
        this.nTrackedLiveObjects = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.nTrackedLiveObjects[n] = dataInputStream.readInt();
        }
        n2 = dataInputStream.readInt();
        this.maxSurvGen = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.maxSurvGen[n] = dataInputStream.readInt();
        }
        n2 = dataInputStream.readInt();
        this.trackedLiveObjectsSize = new long[n2];
        for (n = 0; n < n2; ++n) {
            this.trackedLiveObjectsSize[n] = dataInputStream.readLong();
        }
        n2 = dataInputStream.readInt();
        this.avgObjectAge = new float[n2];
        for (n = 0; n < n2; ++n) {
            this.avgObjectAge[n] = dataInputStream.readFloat();
        }
        this.nInstrClasses = dataInputStream.readInt();
        n2 = dataInputStream.readInt();
        this.nTotalAllocObjects = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.nTotalAllocObjects[n] = dataInputStream.readInt();
        }
        this.nTrackedItems = dataInputStream.readInt();
        this.maxValue = dataInputStream.readLong();
        this.nTotalTrackedBytes = dataInputStream.readLong();
        this.nTotalTracked = dataInputStream.readInt();
        this.currentEpoch = dataInputStream.readInt();
    }

    @Override
    public String toString() {
        return MessageFormat.format(MEMORY_LIVENESS_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        int n;
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeInt(this.nTrackedAllocObjects.length);
        for (n = 0; n < this.nTrackedAllocObjects.length; ++n) {
            dataOutputStream.writeLong(this.nTrackedAllocObjects[n]);
        }
        dataOutputStream.writeInt(this.nTrackedLiveObjects.length);
        for (n = 0; n < this.nTrackedLiveObjects.length; ++n) {
            dataOutputStream.writeInt(this.nTrackedLiveObjects[n]);
        }
        dataOutputStream.writeInt(this.maxSurvGen.length);
        for (n = 0; n < this.maxSurvGen.length; ++n) {
            dataOutputStream.writeInt(this.maxSurvGen[n]);
        }
        dataOutputStream.writeInt(this.trackedLiveObjectsSize.length);
        for (n = 0; n < this.trackedLiveObjectsSize.length; ++n) {
            dataOutputStream.writeLong(this.trackedLiveObjectsSize[n]);
        }
        dataOutputStream.writeInt(this.avgObjectAge.length);
        for (n = 0; n < this.avgObjectAge.length; ++n) {
            dataOutputStream.writeFloat(this.avgObjectAge[n]);
        }
        dataOutputStream.writeInt(this.nInstrClasses);
        dataOutputStream.writeInt(this.nTotalAllocObjects.length);
        for (n = 0; n < this.nTotalAllocObjects.length; ++n) {
            dataOutputStream.writeInt(this.nTotalAllocObjects[n]);
        }
        dataOutputStream.writeInt(this.nTrackedItems);
        dataOutputStream.writeLong(this.maxValue);
        dataOutputStream.writeLong(this.nTotalTrackedBytes);
        dataOutputStream.writeInt(this.nTotalTracked);
        dataOutputStream.writeInt(this.currentEpoch);
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode runtimeMemoryCCTNode, int n, boolean bl) {
        return PresoObjLivenessCCTNode.createPresentationCCTFromSnapshot(this, runtimeMemoryCCTNode, this.getClassName(n), this.currentEpoch, bl);
    }

    @Override
    void debugValues() {
        super.debugValues();
        LOGGER.log(Level.FINEST, "nTrackedAllocObjects.length: {0}", this.debugLength(this.nTrackedAllocObjects));
        LOGGER.log(Level.FINEST, "nTrackedLiveObjects.length: {0}", this.debugLength(this.nTrackedLiveObjects));
        LOGGER.log(Level.FINEST, "maxSurvGen.length: {0}", this.debugLength(this.maxSurvGen));
        LOGGER.log(Level.FINEST, "trackedLiveObjectsSize.length: {0}", this.debugLength(this.trackedLiveObjectsSize));
        LOGGER.log(Level.FINEST, "avgObjectAge.length: {0}", this.debugLength(this.avgObjectAge));
        LOGGER.log(Level.FINEST, "nInstrClasses: {0}", this.nInstrClasses);
        LOGGER.log(Level.FINEST, "nTotalAllocObjects.length: {0}", this.debugLength(this.nTotalAllocObjects));
        LOGGER.log(Level.FINEST, "nTrackedItems: {0}", this.nTrackedItems);
        LOGGER.log(Level.FINEST, "maxValue: {0}", this.maxValue);
        LOGGER.log(Level.FINEST, "nTotalTrackedBytes: {0}", this.nTotalTrackedBytes);
        LOGGER.log(Level.FINEST, "nTotalTracked: {0}", this.nTotalTracked);
        LOGGER.log(Level.FINEST, "currentEpoch: {0}", this.currentEpoch);
    }
}

