/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.extensions.BClass;
import bluej.extensions.BConstructor;
import bluej.extensions.BField;
import bluej.extensions.BObject;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.WeakHashMap;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RClassImpl;
import rmiextension.wrappers.RConstructor;
import rmiextension.wrappers.RConstructorImpl;
import rmiextension.wrappers.RField;
import rmiextension.wrappers.RFieldImpl;
import rmiextension.wrappers.RObject;
import rmiextension.wrappers.RObjectImpl;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RPackageImpl;
import rmiextension.wrappers.RProjectImpl;

public class WrapperPool {
    private static WrapperPool instance = new WrapperPool();
    private WeakHashMap<Object, Object> pool = new WeakHashMap();

    private WrapperPool() {
    }

    public static WrapperPool instance() {
        return instance;
    }

    public synchronized RProjectImpl getWrapper(BProject wrapped) throws RemoteException {
        RProjectImpl wrapper = null;
        WeakReference wrProj = (WeakReference)this.pool.get(wrapped);
        if (wrProj != null) {
            wrapper = (RProjectImpl)wrProj.get();
        }
        if (wrapper == null) {
            wrapper = new RProjectImpl(wrapped);
            this.pool.put(wrapped, new WeakReference<RProjectImpl>(wrapper));
        }
        return wrapper;
    }

    public synchronized RPackage getWrapper(BPackage wrapped) throws RemoteException {
        if (wrapped == null) {
            return null;
        }
        RPackage wrapper = null;
        WeakReference wrPkg = (WeakReference)this.pool.get(wrapped);
        if (wrPkg != null) {
            wrapper = (RPackage)wrPkg.get();
        }
        if (wrapper == null) {
            wrapper = new RPackageImpl(wrapped);
            this.pool.put(wrapped, new WeakReference<RPackage>(wrapper));
        }
        return wrapper;
    }

    public synchronized RClass getWrapper(BClass wrapped) throws RemoteException {
        if (wrapped == null) {
            return null;
        }
        RClass wrapper = null;
        WeakReference wrClass = (WeakReference)this.pool.get(wrapped);
        if (wrClass != null) {
            wrapper = (RClass)wrClass.get();
        }
        if (wrapper == null) {
            wrapper = new RClassImpl(wrapped);
            this.pool.put(wrapped, new WeakReference<RClass>(wrapper));
        }
        return wrapper;
    }

    public synchronized RConstructor getWrapper(BConstructor wrapped) throws RemoteException {
        if (wrapped == null) {
            return null;
        }
        RConstructor wrapper = null;
        WeakReference wrCons = (WeakReference)this.pool.get(wrapped);
        if (wrCons != null) {
            wrapper = (RConstructor)wrCons.get();
        }
        if (wrapper == null) {
            wrapper = new RConstructorImpl(wrapped);
            this.pool.put(wrapped, new WeakReference<RConstructor>(wrapper));
        }
        return wrapper;
    }

    public synchronized RObject getWrapper(BObject wrapped) throws RemoteException {
        if (wrapped == null) {
            return null;
        }
        RObject wrapper = null;
        WeakReference wrObj = (WeakReference)this.pool.get(wrapped);
        if (wrObj != null) {
            wrapper = (RObject)wrObj.get();
        }
        if (wrapper == null) {
            wrapper = new RObjectImpl(wrapped);
            this.pool.put(wrapped, new WeakReference<RObject>(wrapper));
        }
        return wrapper;
    }

    public synchronized RField getWrapper(BField wrapped) throws RemoteException {
        if (wrapped == null) {
            return null;
        }
        RField wrapper = null;
        WeakReference wrField = (WeakReference)this.pool.get(wrapped);
        if (wrField != null) {
            wrapper = (RField)wrField.get();
        }
        if (wrapper == null) {
            wrapper = new RFieldImpl(wrapped);
            this.pool.put(wrapped, new WeakReference<RField>(wrapper));
        }
        return wrapper;
    }

    public synchronized void remove(Object wrapped) {
        this.pool.remove(wrapped);
    }
}

