/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.Config;
import bluej.extensions.BProject;
import bluej.extensions.BlueJ;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.event.ClassListener;
import bluej.extensions.event.CompileEvent;
import bluej.extensions.event.CompileListener;
import bluej.extensions.event.InvocationListener;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgrDialog;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import rmiextension.ProjectManager;
import rmiextension.wrappers.RBlueJ;
import rmiextension.wrappers.RPrintStream;
import rmiextension.wrappers.RPrintStreamImpl;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.RProjectImpl;
import rmiextension.wrappers.WrapperPool;
import rmiextension.wrappers.event.RClassListener;
import rmiextension.wrappers.event.RClassListenerWrapper;
import rmiextension.wrappers.event.RCompileListener;
import rmiextension.wrappers.event.RCompileListenerWrapper;
import rmiextension.wrappers.event.RInvocationListener;
import rmiextension.wrappers.event.RInvocationListenerWrapper;

public class RBlueJImpl
extends UnicastRemoteObject
implements RBlueJ {
    BlueJ blueJ;
    private Map<RCompileListener, RCompileListenerWrapper> compileListeners = new Hashtable<RCompileListener, RCompileListenerWrapper>();
    private Map<RInvocationListener, RInvocationListenerWrapper> invocationListeners = new Hashtable<RInvocationListener, RInvocationListenerWrapper>();
    private Map<RClassListener, RClassListenerWrapper> classListeners = new Hashtable<RClassListener, RClassListenerWrapper>();

    public RBlueJImpl(BlueJ blueJ) throws RemoteException {
        this.blueJ = blueJ;
        blueJ.addCompileListener(new CompileListener(){

            public void compileWarning(CompileEvent event) {
            }

            public void compileSucceeded(CompileEvent event) {
                System.gc();
            }

            public void compileStarted(CompileEvent event) {
            }

            public void compileFailed(CompileEvent event) {
            }

            public void compileError(CompileEvent event) {
            }
        });
    }

    @Override
    public RPrintStream getDebugPrinter() throws RemoteException {
        return new RPrintStreamImpl();
    }

    @Override
    public void addCompileListener(RCompileListener listener, final File projectPath) {
        final BProjectRef bProjectRef = new BProjectRef();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BProject[] projects = RBlueJImpl.this.blueJ.getOpenProjects();
                    BProject project = null;
                    for (int i = 0; i < projects.length; ++i) {
                        BProject prj = projects[i];
                        try {
                            if (!prj.getDir().equals(projectPath)) continue;
                            project = prj;
                            continue;
                        }
                        catch (ProjectNotOpenException e) {
                            e.printStackTrace();
                        }
                    }
                    bProjectRef.bProject = project;
                }
            });
        }
        catch (InterruptedException e1) {
        }
        catch (InvocationTargetException e1) {
            throw new Error(e1);
        }
        RCompileListenerWrapper wrapper = new RCompileListenerWrapper(listener, bProjectRef.bProject, this);
        this.compileListeners.put(listener, wrapper);
        this.blueJ.addCompileListener((CompileListener)wrapper);
    }

    @Override
    public void addInvocationListener(RInvocationListener listener) {
        RInvocationListenerWrapper wrapper = new RInvocationListenerWrapper(listener);
        this.invocationListeners.put(listener, wrapper);
        this.blueJ.addInvocationListener((InvocationListener)wrapper);
    }

    @Override
    public void addClassListener(RClassListener listener) throws RemoteException {
        RClassListenerWrapper wrapper = new RClassListenerWrapper(this, listener);
        this.classListeners.put(listener, wrapper);
        this.blueJ.addClassListener((ClassListener)wrapper);
    }

    @Override
    public String getBlueJPropertyString(String property, String def) {
        return this.blueJ.getBlueJPropertyString(property, def);
    }

    @Override
    public String getExtensionPropertyString(String property, String def) {
        return this.blueJ.getExtensionPropertyString(property, def);
    }

    @Override
    public RProject[] getOpenProjects() throws RemoteException {
        final ArrayList rProjects = new ArrayList();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BProject[] bProjects;
                    for (BProject bProject : bProjects = RBlueJImpl.this.blueJ.getOpenProjects()) {
                        try {
                            rProjects.add(WrapperPool.instance().getWrapper(bProject));
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            Debug.reportError((String)"Problem getting open projects", (Throwable)e.getCause());
        }
        return rProjects.toArray(new RProject[rProjects.size()]);
    }

    @Override
    public File getSystemLibDir() {
        File f = this.blueJ.getSystemLibDir();
        return f.getAbsoluteFile();
    }

    @Override
    public RProject newProject(final File directory) throws RemoteException {
        final RProjectRef wrapper = new RProjectRef();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ProjectManager.instance().addNewProject(directory);
                    BProject wrapped = RBlueJImpl.this.blueJ.newProject(directory);
                    if (wrapped != null) {
                        try {
                            wrapper.rProject = WrapperPool.instance().getWrapper(wrapped);
                        }
                        catch (RemoteException e) {
                            Debug.reportError((String)"Error creating RMI project wrapper", (Throwable)e);
                        }
                    }
                    ProjectManager.instance().removeNewProject(directory);
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            Debug.reportError((String)"Error creating project via RMI", (Throwable)e.getCause());
        }
        return wrapper.rProject;
    }

    @Override
    public RProject openProject(final File directory) throws RemoteException {
        final RProjectRef projectRef = new RProjectRef();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BProject bProject = RBlueJImpl.this.blueJ.openProject(directory);
                    if (bProject != null) {
                        try {
                            projectRef.rProject = WrapperPool.instance().getWrapper(bProject);
                        }
                        catch (RemoteException re) {
                            Debug.reportError((String)"Error when opening project via RMI", (Throwable)re);
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            Debug.reportError((String)"Error opening project", (Throwable)e);
            Debug.reportError((String)"Error cause:", (Throwable)e.getCause());
        }
        return projectRef.rProject;
    }

    @Override
    public void removeCompileListener(RCompileListener listener) {
        RCompileListenerWrapper wrapper = this.compileListeners.remove(listener);
        this.blueJ.removeCompileListener((CompileListener)wrapper);
    }

    @Override
    public void removeInvocationListener(RInvocationListener listener) {
        RInvocationListenerWrapper wrapper = this.invocationListeners.remove(listener);
        this.blueJ.removeInvocationListener((InvocationListener)wrapper);
    }

    @Override
    public void removeClassListener(RClassListener listener) {
        ClassListener wrapper = this.classListeners.remove(listener);
        this.blueJ.removeClassListener(wrapper);
    }

    @Override
    public void setExtensionPropertyString(String property, String value) {
        this.blueJ.setExtensionPropertyString(property, value);
    }

    @Override
    public void exit() throws RemoteException {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BProject[] bProjects = RBlueJImpl.this.blueJ.getOpenProjects();
                    int length = bProjects.length;
                    for (int i = 0; i < length; ++i) {
                        try {
                            RProjectImpl rpImpl = WrapperPool.instance().getWrapper(bProjects[i]);
                            rpImpl.notifyClosing();
                            continue;
                        }
                        catch (RemoteException re) {
                            // empty catch block
                        }
                    }
                    PkgMgrFrame[] frames = PkgMgrFrame.getAllFrames();
                    for (int i = 0; i < frames.length; ++i) {
                        frames[i].doClose(false, true);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Properties getInitialCommandLineProperties() throws RemoteException {
        return Config.getInitialCommandLineProperties();
    }

    @Override
    public void showPreferences() throws RemoteException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PrefMgrDialog.showDialog();
                Utility.bringToFront((Window)PrefMgrDialog.getInstance());
            }
        });
    }

    private class RProjectRef {
        public RProject rProject;

        private RProjectRef() {
        }
    }

    private class BProjectRef {
        public BProject bProject;

        private BProjectRef() {
        }
    }
}

