/*
 * Decompiled with CFR 0.152.
 */
package rmiextension;

import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BPackage;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import java.awt.EventQueue;

public class ConstructorInvoker {
    private PkgMgrFrame pkgFrame;
    private String className;
    private DebuggerResult result;

    public ConstructorInvoker(BPackage bPackage, String className) throws ProjectNotOpenException, PackageNotFoundException {
        this.pkgFrame = (PkgMgrFrame)bPackage.getFrame();
        this.className = className;
    }

    public void invokeConstructor(final String instanceNameOnObjectBench, final String[] args, final ResultWatcher resultWatcher) {
        final ObjectBench objBench = this.pkgFrame.getObjectBench();
        final Package pkg = this.pkgFrame.getPackage();
        final Debugger debugger = this.pkgFrame.getProject().getDebugger();
        Thread t = new Thread(){

            @Override
            public void run() {
                String[] argTypes = new String[args.length];
                DebuggerObject[] argObjects = new DebuggerObject[args.length];
                for (int i = 0; i < args.length; ++i) {
                    argTypes[i] = "java.lang.String";
                    argObjects[i] = debugger.getMirror(args[i]);
                }
                ConstructorInvoker.this.result = debugger.instantiateClass(ConstructorInvoker.this.className, argTypes, argObjects);
                final DebuggerObject debugObject = ConstructorInvoker.this.result.getResultObject();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (debugObject != null) {
                            ObjectWrapper wrapper = ObjectWrapper.getWrapper((PkgMgrFrame)ConstructorInvoker.this.pkgFrame, (ObjectBench)objBench, (DebuggerObject)debugObject, (GenTypeClass)debugObject.getGenType(), (String)instanceNameOnObjectBench);
                            objBench.addObject(wrapper);
                            pkg.getDebugger().addObject(pkg.getQualifiedName(), wrapper.getName(), debugObject);
                        }
                        if (resultWatcher != null) {
                            int status = ConstructorInvoker.this.result.getExitStatus();
                            if (status == 0) {
                                resultWatcher.putResult(ConstructorInvoker.this.result.getResultObject(), instanceNameOnObjectBench, null);
                            } else if (status == 2) {
                                resultWatcher.putException(ConstructorInvoker.this.result.getException(), null);
                            } else if (status == 3) {
                                resultWatcher.putVMTerminated(null);
                            }
                        }
                    }
                });
            }
        };
        t.start();
    }

    public DebuggerResult getResult() {
        return this.result;
    }
}

