/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class MicLevelGrabber {
    private static final MicLevelGrabber INSTANCE = new MicLevelGrabber();
    private final AudioFormat format = new AudioFormat(22050.0f, 8, 1, true, true);
    private int level;
    private final Runnable updator = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TargetDataLine line = (TargetDataLine)AudioSystem.getLine(new DataLine.Info(TargetDataLine.class, MicLevelGrabber.this.format));
                line.open();
                line.start();
                int bufferSize = (int)(MicLevelGrabber.this.format.getSampleRate() / 20.0f) * MicLevelGrabber.this.format.getFrameSize();
                byte[] buffer = new byte[bufferSize];
                int bytesRead = line.read(buffer, 0, bufferSize);
                line.stop();
                MicLevelGrabber.this.level = (int)(MicLevelGrabber.getRMS(buffer, bytesRead) / 127.0 * 100.0);
                MicLevelGrabber.this.reportedFailure = false;
            }
            catch (LineUnavailableException ex) {
                if (!MicLevelGrabber.this.reportedFailure) {
                    System.err.println("Couldn't get mic level: line unavailable");
                    MicLevelGrabber.this.reportedFailure = true;
                }
            }
            catch (IllegalArgumentException iae) {
                if (!MicLevelGrabber.this.reportedFailure) {
                    System.err.println("Couldn't get mic level: can't match 22050,8,1 audio format");
                    MicLevelGrabber.this.reportedFailure = true;
                }
            }
            finally {
                MicLevelGrabber.this.running = false;
            }
        }
    };
    private volatile boolean running;
    private boolean reportedFailure;

    private MicLevelGrabber() {
    }

    public static MicLevelGrabber getInstance() {
        return INSTANCE;
    }

    public int getLevel() {
        this.updateLevel();
        return this.level;
    }

    private synchronized void updateLevel() {
        if (!this.running) {
            this.running = true;
            new Thread(this.updator).start();
        }
    }

    private static double getRMS(byte[] arr, int lim) {
        double average = 0.0;
        for (int i = 0; i < arr.length && i < lim; ++i) {
            average += (double)(arr[i] * arr[i]);
        }
        return Math.sqrt(average /= (double)arr.length);
    }
}

