/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.record;

import bluej.debugger.gentype.JavaType;
import bluej.utility.Debug;
import greenfoot.Actor;
import greenfoot.ObjectTracker;
import greenfoot.World;
import java.rmi.RemoteException;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import rmiextension.wrappers.RObject;

public class GreenfootRecorder {
    private IdentityHashMap<Object, String> objectNames = new IdentityHashMap();
    private LinkedList<String> code = new LinkedList();
    private World world;
    public static final String METHOD_NAME = "prepare";

    public synchronized void createActor(Object actor, String[] args, JavaType[] paramTypes) {
        Class<?> theClass = actor.getClass();
        String name = this.nameActor(actor);
        if (name != null) {
            this.code.add(theClass.getCanonicalName() + " " + name + " = new " + theClass.getCanonicalName() + "(" + GreenfootRecorder.withCommas(args, paramTypes) + ");");
        }
    }

    public synchronized String nameActor(Object actor) {
        try {
            RObject rObject = ObjectTracker.getRObject(actor);
            if (rObject != null) {
                String name = rObject.getInstanceName();
                this.objectNames.put(actor, name);
                return name;
            }
            return null;
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Error naming actor", (Throwable)e);
            return null;
        }
    }

    private static String withCommas(String[] args, JavaType[] paramTypes) {
        if (args == null) {
            return "";
        }
        StringBuffer commaArgs = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.startsWith("{") && arg.endsWith("}")) {
                arg = "new " + paramTypes[i] + " " + arg;
            }
            commaArgs.append(arg);
            if (i == args.length - 1) continue;
            commaArgs.append(", ");
        }
        return commaArgs.toString();
    }

    public synchronized void addActorToWorld(Actor actor, int x, int y) {
        String actorObjectName = this.objectNames.get(actor);
        if (null == actorObjectName) {
            return;
        }
        this.code.add("addObject(" + actorObjectName + ", " + x + ", " + y + ");");
    }

    public synchronized void callActorMethod(Object obj, String actorName, String methodName, String[] args, JavaType[] paramTypes) {
        if (obj != null && null == this.objectNames.get(obj) && obj != this.world) {
            return;
        }
        if (this.world != null && this.world == obj) {
            this.code.add(methodName + "(" + GreenfootRecorder.withCommas(args, paramTypes) + ");");
        } else {
            this.code.add(actorName + "." + methodName + "(" + GreenfootRecorder.withCommas(args, paramTypes) + ");");
        }
    }

    public void callStaticMethod(String className, String name, String[] args, JavaType[] argTypes) {
        this.callActorMethod(null, className, name, args, argTypes);
    }

    public synchronized void clearCode(boolean simulationStarted) {
        this.code.clear();
        if (simulationStarted) {
            this.objectNames.clear();
        }
    }

    public synchronized void reset() {
        this.objectNames.clear();
        this.clearCode(false);
    }

    public synchronized void setWorld(World newWorld) {
        this.world = newWorld;
    }

    public synchronized void moveActor(Actor actor, int xCell, int yCell) {
        String actorObjectName = this.objectNames.get(actor);
        if (null == actorObjectName) {
            return;
        }
        this.code.add(actorObjectName + ".setLocation(" + xCell + ", " + yCell + ");");
    }

    public void removeActor(Actor obj) {
        String actorObjectName = this.objectNames.get(obj);
        if (null == actorObjectName) {
            return;
        }
        this.code.add("removeObject(" + actorObjectName + ");");
        this.objectNames.remove(obj);
    }

    public synchronized List<String> getCode() {
        return new LinkedList<String>(this.code);
    }
}

