/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.soundrecorder;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.Utility;
import greenfoot.core.GProject;
import greenfoot.gui.soundrecorder.SaveState;
import greenfoot.sound.MemoryAudioInputStream;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundPlaybackListener;
import greenfoot.sound.SoundRecorder;
import greenfoot.sound.SoundStream;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;

public class SoundRecorderControls
extends JFrame
implements WindowListener {
    SoundRecorder recorder = new SoundRecorder();
    private boolean selectionActive = false;
    private boolean selectionDrawing = false;
    private float selectionBegin;
    private float selectionEnd;
    private JButton trim;
    private JButton playStop;
    private JButton recordStop;
    private boolean playing = false;
    private long playbackPosition;
    private boolean recording = false;
    private AtomicReference<List<byte[]>> currentRecording;
    private SoundPanel soundPanel;
    private SaveState saveState = new SaveState(this, this.recorder);
    private final String playLabel = Config.getString((String)"soundRecorder.play");
    private final String playSelectionLabel = Config.getString((String)"soundRecorder.playSelection");
    private final String stopPlayLabel = Config.getString((String)"soundRecorder.stopPlay");
    private final String recordLabel = Config.getString((String)"soundRecorder.record");
    private final String stopRecordLabel = Config.getString((String)"soundRecorder.stopRecord");

    public SoundRecorderControls(GProject project) {
        this.setTitle(Config.getString((String)"soundRecorder.title"));
        this.buildUI(project);
        Image icon = BlueJTheme.getApplicationIcon((String)"greenfoot");
        if (icon != null) {
            this.setIconImage(icon);
        }
    }

    private JPanel buildControlBox() {
        this.recordStop = new JButton(this.recordLabel);
        Utility.changeToMacButton((AbstractButton)this.recordStop);
        this.recordStop.setFocusable(false);
        this.recordStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SoundRecorderControls.this.recording) {
                    SoundRecorderControls.this.currentRecording = SoundRecorderControls.this.recorder.startRecording();
                    SoundRecorderControls.this.recordStop.setText(SoundRecorderControls.this.stopRecordLabel);
                    SoundRecorderControls.this.playStop.setEnabled(false);
                    SoundRecorderControls.this.recording = true;
                    new Timer().scheduleAtFixedRate(new TimerTask(){
                        List<byte[]> lastValue = null;

                        @Override
                        public void run() {
                            List curValue = (List)SoundRecorderControls.this.currentRecording.get();
                            if (curValue != this.lastValue) {
                                SoundRecorderControls.this.soundPanel.repaint();
                            }
                            if (this.lastValue != null && curValue == null) {
                                this.cancel();
                            }
                            this.lastValue = curValue;
                        }
                    }, 100L, 200L);
                } else {
                    SoundRecorderControls.this.stopRecording();
                }
            }
        });
        this.trim = new JButton(Config.getString((String)"soundRecorder.trim"));
        this.trim.setEnabled(false);
        this.trim.setFocusable(false);
        Utility.changeToMacButton((AbstractButton)this.trim);
        this.trim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundRecorderControls.this.recorder.trim(Math.min(SoundRecorderControls.this.selectionBegin, SoundRecorderControls.this.selectionEnd), Math.max(SoundRecorderControls.this.selectionBegin, SoundRecorderControls.this.selectionEnd));
                SoundRecorderControls.this.saveState.changed();
                SoundRecorderControls.this.selectionActive = false;
                SoundRecorderControls.this.updateButtons();
                SoundRecorderControls.this.repaint();
            }
        });
        this.playStop = new JButton(this.playLabel);
        Utility.changeToMacButton((AbstractButton)this.playStop);
        this.playStop.setFocusable(false);
        this.playStop.setEnabled(false);
        this.playStop.addActionListener(new Player());
        JPanel controls = new JPanel(new FlowLayout(1, 2, 0));
        controls.add(this.recordStop);
        controls.add(this.playStop);
        controls.add(this.trim);
        return controls;
    }

    private void buildUI(GProject project) {
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(this.getContentPane(), 1));
        contentPane.setBorder(BlueJTheme.dialogBorder);
        this.soundPanel = new SoundPanel();
        JLabel messageLabel = this.saveState.createLabel();
        JPanel soundAndControls = new JPanel(new BorderLayout(0, 0));
        soundAndControls.add((Component)this.soundPanel, "Center");
        JPanel controls = new JPanel(new BorderLayout(0, 0));
        controls.add((Component)this.buildControlBox(), "Center");
        controls.add((Component)messageLabel, "South");
        soundAndControls.add((Component)controls, "South");
        soundAndControls.setBorder(new SoftBevelBorder(1));
        contentPane.add(soundAndControls);
        contentPane.add(Box.createVerticalStrut(12));
        contentPane.add(this.saveState.buildSaveBox(SoundRecorderControls.getSoundDir(project)));
        contentPane.add(Box.createVerticalStrut(12));
        JButton done = new JButton(Config.getString((String)"soundRecorder.done"));
        done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundRecorderControls.this.closeAndStopRecording();
            }
        });
        done.setAlignmentX(0.5f);
        contentPane.add(done);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pack();
        this.setVisible(true);
    }

    private static String getSoundDir(GProject project) {
        return project.getDir() + File.separator + "sounds" + File.separator;
    }

    private void updateButtons() {
        this.trim.setEnabled(this.selectionActive);
        this.playStop.setText(this.selectionActive ? this.playSelectionLabel : this.playLabel);
    }

    private int getSelectionStartOffset() {
        float start = Math.min(this.selectionBegin, this.selectionEnd);
        float length = this.recorder.getRawSound().length;
        return (int)(start * length);
    }

    private int getSelectionFinishOffset() {
        float finish = Math.max(this.selectionBegin, this.selectionEnd);
        float length = this.recorder.getRawSound().length;
        return (int)(finish * length);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeAndStopRecording();
    }

    public void closeAndStopRecording() {
        this.stopRecording();
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void stopRecording() {
        if (this.recording) {
            this.recorder.stopRecording();
            this.playStop.setEnabled(true);
            this.saveState.changed();
            this.soundPanel.repaint();
            this.recordStop.setText(this.recordLabel);
            this.recording = false;
        }
    }

    private class SoundPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private SoundPanel() {
            this.setPreferredSize(new Dimension(400, 200));
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            int middle = height / 2;
            int halfHeight = height / 2;
            byte[] sound = SoundRecorderControls.this.recorder.getRawSound();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, width, height);
            if (SoundRecorderControls.this.recording || sound != null && sound.length > 0) {
                if (SoundRecorderControls.this.selectionActive) {
                    g.setColor(Color.GRAY);
                    g.fillRect((int)(Math.min(SoundRecorderControls.this.selectionBegin, SoundRecorderControls.this.selectionEnd) * (float)width), 0, (int)(Math.abs(SoundRecorderControls.this.selectionBegin - SoundRecorderControls.this.selectionEnd) * (float)width), height);
                }
                byte[][] rec = null;
                int recLength = 0;
                if (SoundRecorderControls.this.recording) {
                    List recList = (List)SoundRecorderControls.this.currentRecording.get();
                    if (recList != null) {
                        for (byte[] chunk : rec = (byte[][])recList.toArray((T[])new byte[0][])) {
                            int chunkLength = chunk == null ? 0 : chunk.length;
                            recLength += chunkLength;
                        }
                    }
                } else {
                    recLength = sound.length;
                }
                int curRecChunk = 0;
                int prevChunksLength = 0;
                for (int i = 0; i < width; ++i) {
                    float f;
                    int index;
                    float pos = (float)i / (float)width;
                    if (rec != null) {
                        index = (int)(pos * (float)recLength);
                        if (recLength == 0 || index >= recLength) {
                            f = 0.0f;
                        } else {
                            while (index >= prevChunksLength + rec[curRecChunk].length) {
                                prevChunksLength += rec[curRecChunk].length;
                                ++curRecChunk;
                            }
                            f = (float)rec[curRecChunk][index - prevChunksLength] / 128.0f;
                        }
                    } else {
                        index = (int)(pos * (float)sound.length);
                        f = (float)sound[index] / 128.0f;
                    }
                    int waveHeight = (int)((float)halfHeight * f * 0.9f);
                    if (this.inSelection(pos)) {
                        g.setColor(Color.YELLOW);
                    } else {
                        g.setColor(Color.GREEN);
                    }
                    g.drawLine(i, middle - waveHeight, i, middle + waveHeight);
                }
                if (SoundRecorderControls.this.playing) {
                    g.setColor(Color.RED);
                    float playPosRel = (float)SoundRecorderControls.this.playbackPosition / (float)recLength;
                    int pos = (int)(playPosRel * (float)width);
                    g.drawLine(pos, 0, pos, height);
                }
            }
        }

        private boolean inSelection(float f) {
            return SoundRecorderControls.this.selectionActive && f >= Math.min(SoundRecorderControls.this.selectionBegin, SoundRecorderControls.this.selectionEnd) && f <= Math.max(SoundRecorderControls.this.selectionBegin, SoundRecorderControls.this.selectionEnd);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SoundRecorderControls.this.recorder.getRawSound() != null) {
                SoundRecorderControls.this.selectionActive = false;
                SoundRecorderControls.this.selectionDrawing = true;
                SoundRecorderControls.this.selectionBegin = this.calculatePosition(e.getPoint());
                SoundRecorderControls.this.selectionEnd = SoundRecorderControls.this.selectionBegin;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SoundRecorderControls.this.selectionDrawing) {
                SoundRecorderControls.this.selectionDrawing = false;
                SoundRecorderControls.this.selectionEnd = this.calculatePosition(e.getPoint());
                if (SoundRecorderControls.this.selectionBegin == SoundRecorderControls.this.selectionEnd) {
                    SoundRecorderControls.this.selectionActive = false;
                }
                this.repaint();
            }
            SoundRecorderControls.this.updateButtons();
        }

        private float calculatePosition(Point p) {
            float pos = (float)p.x / (float)this.getWidth();
            pos = Math.max(0.0f, pos);
            pos = Math.min(1.0f, pos);
            return pos;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SoundRecorderControls.this.selectionDrawing) {
                SoundRecorderControls.this.selectionEnd = this.calculatePosition(e.getPoint());
                SoundRecorderControls.this.selectionActive = true;
                this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class Player
    implements ActionListener,
    SoundPlaybackListener {
        private final Timer tim = new Timer();
        private TimerTask repaintWhilePlaying;
        private SoundStream stream;

        private Player() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SoundRecorderControls.this.playing) {
                this.stream.stop();
            } else {
                MemoryAudioInputStream memoryStream;
                int start;
                if (SoundRecorderControls.this.selectionActive) {
                    start = SoundRecorderControls.this.getSelectionStartOffset();
                    int len = SoundRecorderControls.this.getSelectionFinishOffset() - start;
                    memoryStream = new MemoryAudioInputStream(SoundRecorderControls.this.recorder.getRawSound(), start, len, SoundRecorderControls.this.recorder.getFormat());
                } else {
                    start = 0;
                    memoryStream = new MemoryAudioInputStream(SoundRecorderControls.this.recorder.getRawSound(), SoundRecorderControls.this.recorder.getFormat());
                }
                this.stream = new SoundStream(memoryStream, this);
                SoundRecorderControls.this.playing = true;
                SoundRecorderControls.this.playbackPosition = start;
                this.stream.play();
                SoundRecorderControls.this.playStop.setText(SoundRecorderControls.this.stopPlayLabel);
                SoundRecorderControls.this.recordStop.setEnabled(false);
                this.repaintWhilePlaying = new TimerTask(){

                    @Override
                    public void run() {
                        SoundRecorderControls.this.playbackPosition = (long)start + Player.this.stream.getLongFramePosition();
                        SoundRecorderControls.this.soundPanel.repaint();
                    }
                };
                this.tim.scheduleAtFixedRate(this.repaintWhilePlaying, 50L, 100L);
            }
        }

        @Override
        public void playbackPaused(Sound sound) {
        }

        @Override
        public void playbackStarted(Sound sound) {
        }

        @Override
        public void playbackStopped(Sound sound) {
            SoundRecorderControls.this.updateButtons();
            SoundRecorderControls.this.recordStop.setEnabled(true);
            this.repaintWhilePlaying.cancel();
            SoundRecorderControls.this.playing = false;
            SoundRecorderControls.this.soundPanel.repaint();
        }

        @Override
        public void soundClosed(Sound sound) {
        }
    }
}

