/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input.mouse;

import bluej.Config;
import greenfoot.Actor;
import greenfoot.MouseInfo;
import greenfoot.event.TriggeredMouseListener;
import greenfoot.event.TriggeredMouseMotionListener;
import greenfoot.gui.input.mouse.MouseEventData;
import greenfoot.gui.input.mouse.PriorityManager;
import greenfoot.gui.input.mouse.WorldLocator;
import java.awt.event.MouseEvent;

public class MousePollingManager
implements TriggeredMouseListener,
TriggeredMouseMotionListener {
    private MouseEventData currentData = new MouseEventData();
    private MouseEventData futureData = new MouseEventData();
    private MouseEventData potentialNewDragData = new MouseEventData();
    private WorldLocator locator;
    private MouseEventData dragStartData = new MouseEventData();
    private boolean isDragging;
    private boolean gotNewEvent;

    public MousePollingManager(WorldLocator locator) {
        this.locator = locator;
    }

    public void setWorldLocator(WorldLocator locator) {
        this.locator = locator;
    }

    public synchronized void newActStarted() {
        if (this.gotNewEvent) {
            MouseEventData newData = new MouseEventData();
            this.currentData = this.futureData;
            this.futureData = newData;
            this.potentialNewDragData = new MouseEventData();
            this.gotNewEvent = false;
        } else {
            this.currentData.init();
        }
    }

    private void registerEventRecieved() {
        this.gotNewEvent = true;
    }

    public boolean isMousePressed(Object obj) {
        return this.currentData.isMousePressed(obj);
    }

    public boolean isMouseClicked(Object obj) {
        return this.currentData.isMouseClicked(obj);
    }

    public boolean isMouseDragged(Object obj) {
        return this.currentData.isMouseDragged(obj);
    }

    public boolean isMouseDragEnded(Object obj) {
        return this.currentData.isMouseDragEnded(obj);
    }

    public boolean isMouseMoved(Object obj) {
        return this.currentData.isMouseMoved(obj);
    }

    public MouseInfo getMouseInfo() {
        return this.currentData.getMouseInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        Actor actor = this.locator.getTopMostActorAt(e);
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            MouseEventData mouseData = this.futureData;
            if (this.futureData.isMouseDragEnded(null)) {
                mouseData = this.potentialNewDragData;
            }
            if (!PriorityManager.isHigherPriority(e, mouseData)) {
                return;
            }
            this.registerEventRecieved();
            int x = this.locator.getTranslatedX(e);
            int y = this.locator.getTranslatedY(e);
            int button = this.getButton(e);
            mouseData.mouseClicked(x, y, button, e.getClickCount(), actor);
            this.isDragging = false;
        }
    }

    private int getButton(MouseEvent e) {
        int button = e.getButton();
        if (Config.isMacOS() && button == 1 && (e.getModifiersEx() & 0x80) == 128) {
            button = 3;
        }
        return button;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseExited(MouseEvent e) {
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            this.futureData.mouseExited();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        Actor actor = this.locator.getTopMostActorAt(e);
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            MouseEventData mouseData = this.futureData;
            if (this.futureData.isMouseDragEnded(null)) {
                mouseData = this.potentialNewDragData;
            }
            this.dragStartData = new MouseEventData();
            int x = this.locator.getTranslatedX(e);
            int y = this.locator.getTranslatedY(e);
            int button = this.getButton(e);
            this.dragStartData.mousePressed(x, y, button, actor);
            if (!PriorityManager.isHigherPriority(e, mouseData)) {
                return;
            }
            this.registerEventRecieved();
            mouseData.mousePressed(x, y, button, actor);
            this.isDragging = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        Actor clickActor = this.locator.getTopMostActorAt(e);
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            if (this.isDragging) {
                if (this.futureData.isMouseDragEnded(null)) {
                    this.futureData = this.potentialNewDragData;
                }
                if (!PriorityManager.isHigherPriority(e, this.futureData)) {
                    return;
                }
                this.registerEventRecieved();
                int x = this.locator.getTranslatedX(e);
                int y = this.locator.getTranslatedY(e);
                int button = this.getButton(e);
                this.futureData.mouseClicked(x, y, button, 1, clickActor);
                Actor actor = this.dragStartData.getActor();
                this.futureData.mouseDragEnded(x, y, button, actor);
                this.isDragging = false;
                this.potentialNewDragData = new MouseEventData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            this.isDragging = true;
            if (!PriorityManager.isHigherPriority(e, this.futureData)) {
                return;
            }
            this.registerEventRecieved();
            int x = this.locator.getTranslatedX(e);
            int y = this.locator.getTranslatedY(e);
            this.futureData.mouseDragged(x, y, this.dragStartData.getButton(), this.dragStartData.getActor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent e) {
        Actor actor = this.locator.getTopMostActorAt(e);
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            if (!PriorityManager.isHigherPriority(e, this.futureData)) {
                return;
            }
            this.registerEventRecieved();
            int x = this.locator.getTranslatedX(e);
            int y = this.locator.getTranslatedY(e);
            int button = this.getButton(e);
            this.futureData.mouseMoved(x, y, button, actor);
            this.isDragging = false;
        }
    }

    @Override
    public void listeningEnded() {
    }

    @Override
    public void listeningStarted(Object obj) {
    }
}

