/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.export;

import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.MiksGridLayout;
import bluej.utility.SwingWorker;
import greenfoot.core.GProject;
import greenfoot.export.mygame.ExistingScenarioChecker;
import greenfoot.export.mygame.MyGameClient;
import greenfoot.export.mygame.ScenarioInfo;
import greenfoot.gui.export.ExportDialog;
import greenfoot.gui.export.ExportPane;
import greenfoot.gui.export.ImageEditPanel;
import greenfoot.util.GreenfootUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.httpclient.ConnectTimeoutException;

public class ExportPublishPane
extends ExportPane
implements ChangeListener {
    public static final int IMAGE_WIDTH = 120;
    public static final int IMAGE_HEIGHT = 70;
    public static final String FUNCTION = "PUBLISH";
    private static final Color background = new Color(166, 188, 202);
    private static final Color headingColor = new Color(40, 75, 125);
    private static final String serverURL = ExportPublishPane.ensureTrailingSlash(Config.getPropString((String)"greenfoot.gameserver.address", (String)"http://www.greenfoot.org/"));
    private static final String createAccountUrl = Config.getPropString((String)"greenfoot.gameserver.createAccount.address", (String)"http://www.greenfoot.org/users/new");
    private static final String serverName = Config.getPropString((String)"greenfoot.gameserver.name", (String)"Greenfoot Gallery");
    private static final String helpLine1 = Config.getString((String)"export.publish.help") + " " + serverName;
    private static final String WITH_SOURCE_TAG = "with-source";
    private JComponent leftPanel;
    private JPanel titleAndDescPanel;
    private JPanel infoPanel;
    private JTextField titleField;
    private JTextField shortDescriptionField;
    private JTextArea descriptionArea;
    private JTextArea updateArea;
    private JTextField urlField;
    private JTextField userNameField;
    private JPasswordField passwordField;
    private ImageEditPanel imagePanel;
    private JCheckBox includeSource;
    private JCheckBox keepScenarioScreenshot;
    private SwingWorker commonTagsLoader;
    private JCheckBox[] popTags = new JCheckBox[7];
    private JTextArea tagArea;
    private GProject project;
    private boolean firstActivation = true;
    private ScenarioInfo publishedScenarioInfo;
    private String publishedUserName;
    private ExistingScenarioChecker scenarioChecker;
    private Font font;
    private boolean isUpdate = false;
    private ExportDialog exportDialog;

    public ExportPublishPane(GProject project, ExportDialog exportDialog) {
        this.project = project;
        this.exportDialog = exportDialog;
        this.makePane();
    }

    public BufferedImage getImage() {
        return this.imagePanel.getImage();
    }

    public void setImage(BufferedImage snapShot) {
        this.imagePanel.setImage(snapShot);
        this.imagePanel.repaint();
    }

    public String getTitle() {
        if (this.titleField != null) {
            return this.titleField.getText();
        }
        return null;
    }

    public String getShortDescription() {
        return this.shortDescriptionField.getText();
    }

    public String getDescription() {
        return this.descriptionArea.getText();
    }

    public String getURL() {
        return this.urlField.getText();
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    public String getUpdateDescription() {
        if (this.updateArea != null) {
            return this.updateArea.getText();
        }
        return null;
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public boolean includeSourceCode() {
        return this.includeSource.isSelected();
    }

    private void setHasSource(boolean hasSource) {
        this.includeSource.setSelected(hasSource);
    }

    public boolean keepSavedScenarioScreenshot() {
        if (this.isUpdate && this.keepScenarioScreenshot != null) {
            return this.keepScenarioScreenshot.isSelected();
        }
        return false;
    }

    private void setLocked(boolean locked) {
        this.lockScenario.setSelected(locked);
    }

    private void setTags(List<String> tags) {
        StringBuilder newTags = new StringBuilder();
        boolean isFirstNewTag = true;
        for (String tag : tags) {
            if (WITH_SOURCE_TAG.equals(tag)) continue;
            boolean isPopTag = false;
            for (int i = 0; i < this.popTags.length; ++i) {
                JCheckBox popTag = this.popTags[i];
                if (!popTag.getText().equals(tag)) continue;
                popTag.setSelected(true);
                isPopTag = true;
                break;
            }
            if (isPopTag) continue;
            if (!isFirstNewTag) {
                newTags.append(System.getProperty("line.separator"));
            }
            isFirstNewTag = false;
            newTags.append(tag);
        }
        this.tagArea.setText(newTags.toString());
    }

    private void setUrl(String url) {
        this.urlField.setText(url);
    }

    private void setLongDescription(String longDescription) {
        this.descriptionArea.setText(longDescription);
    }

    private void setShortDescripton(String shortDescription) {
        this.shortDescriptionField.setText(shortDescription);
    }

    private void setTitle(String title) {
        this.titleField.setText(title);
    }

    private void setUserName(String name) {
        this.userNameField.setText(name);
    }

    private void makePane() {
        this.font = new JLabel().getFont().deriveFont(2, 11.0f);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
        this.setBackground(backgroundColor);
        this.add(this.getHelpBox());
        this.add(Box.createVerticalStrut(12));
        this.infoPanel = new JPanel(new BorderLayout(22, 18));
        this.infoPanel.setAlignmentX(0.0f);
        this.infoPanel.setBackground(background);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(12, 22, 12, 22));
        this.infoPanel.setBorder(border);
        JLabel text = new JLabel(Config.getString((String)"export.publish.info") + " " + serverName, 0);
        text.setForeground(headingColor);
        this.infoPanel.add((Component)text, "North");
        this.createScenarioDisplay();
        this.infoPanel.add((Component)this.leftPanel, "Center");
        this.infoPanel.add((Component)this.getTagDisplay(), "East");
        this.add(this.infoPanel);
        this.add(Box.createVerticalStrut(16));
        this.add(this.getLoginPanel());
        this.add(Box.createVerticalStrut(10));
    }

    private JComponent getLoginPanel() {
        JPanel loginPanel = new JPanel(new FlowLayout(1, 8, 4));
        loginPanel.setBackground(background);
        loginPanel.setAlignmentX(0.0f);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(12, 12, 12, 12));
        loginPanel.setBorder(border);
        JLabel text = new JLabel(Config.getString((String)"export.publish.login"));
        text.setForeground(headingColor);
        text.setVerticalAlignment(1);
        loginPanel.add(text);
        text = new JLabel(Config.getString((String)"export.publish.username"), 11);
        text.setFont(this.font);
        loginPanel.add(text);
        this.userNameField = new JTextField(10);
        this.userNameField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String text = ExportPublishPane.this.userNameField.getText();
                return text.length() > 0;
            }
        });
        this.userNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ExportPublishPane.this.checkForExistingScenario();
            }
        });
        loginPanel.add(this.userNameField);
        text = new JLabel(Config.getString((String)"export.publish.password"), 11);
        text.setFont(this.font);
        loginPanel.add(text);
        this.passwordField = new JPasswordField(10);
        loginPanel.add(this.passwordField);
        JLabel createAccountLabel = new JLabel(Config.getString((String)"export.publish.createAccount"));
        createAccountLabel.setBackground(background);
        createAccountLabel.setHorizontalAlignment(4);
        GreenfootUtil.makeLink(createAccountLabel, createAccountUrl);
        loginPanel.add(createAccountLabel);
        return loginPanel;
    }

    private Box getHelpBox() {
        Box helpBox = new Box(0);
        helpBox.setAlignmentX(0.0f);
        JLabel helpText1 = new JLabel(helpLine1 + " (");
        helpBox.add(helpText1);
        JLabel serverLink = new JLabel(serverURL);
        GreenfootUtil.makeLink(serverLink, serverURL);
        helpBox.add(serverLink);
        helpBox.add(new JLabel(")"));
        return helpBox;
    }

    private void setPopularTags(List<String> tags) {
        int i;
        if (tags == null) {
            this.popTags[0].setText("Unavailable");
            for (int i2 = 1; i2 < this.popTags.length; ++i2) {
                this.popTags[i2].setText("");
            }
            return;
        }
        int minLength = this.popTags.length < tags.size() ? this.popTags.length : tags.size();
        for (i = 0; i < minLength; ++i) {
            JCheckBox checkBox = this.popTags[i];
            checkBox.setText(tags.get(i));
            checkBox.setEnabled(true);
            this.setTags(this.getTags());
        }
        for (i = minLength; i < this.popTags.length; ++i) {
            this.popTags[i].setText("");
        }
    }

    public List<String> getTags() {
        LinkedList<String> tagList = new LinkedList<String>();
        for (int i = 0; i < this.popTags.length; ++i) {
            JCheckBox checkBox = this.popTags[i];
            if (!checkBox.isSelected()) continue;
            tagList.add(checkBox.getText());
        }
        String currentTags = this.tagArea.getText().trim();
        String[] tags = currentTags.split("\\s");
        for (int i = 0; i < tags.length; ++i) {
            String tag = tags[i].trim();
            if (tag.equals("")) continue;
            tagList.add(tag);
        }
        if (this.includeSourceCode() && !tagList.contains(WITH_SOURCE_TAG)) {
            tagList.add(WITH_SOURCE_TAG);
        } else if (!this.includeSourceCode()) {
            tagList.remove(WITH_SOURCE_TAG);
        }
        return tagList;
    }

    private void loadStoredScenarioInfo() {
        ScenarioInfo info = new ScenarioInfo();
        if (info.load(this.project.getProjectProperties())) {
            this.setTitle(info.getTitle());
            this.setShortDescripton(info.getShortDescription());
            this.setLongDescription(info.getLongDescription());
            this.setUrl(info.getUrl());
            this.setTags(info.getTags());
            this.setLocked(info.isLocked());
            this.setHasSource(info.getHasSource());
            this.setUpdate(true);
        }
    }

    private void updateScenarioDisplay() {
        this.removeLeftPanel();
        this.createScenarioDisplay();
        this.infoPanel.add((Component)this.leftPanel, "Center");
        boolean enableImageControl = !this.isUpdate || !this.keepScenarioScreenshot.isSelected();
        this.imagePanel.enableImageEditPanel(enableImageControl);
        this.revalidate();
    }

    private void updateInfoFromFields(ScenarioInfo scenarioInfo) {
        scenarioInfo.setTitle(this.getTitle());
        scenarioInfo.setShortDescription(this.getShortDescription());
        scenarioInfo.setLongDescription(this.getDescription());
        scenarioInfo.setUrl(this.getURL());
        scenarioInfo.setTags(this.getTags());
        scenarioInfo.setLocked(this.lockScenario());
        scenarioInfo.setHasSource(this.includeSourceCode());
        scenarioInfo.setUpdateDescription(this.getUpdateDescription());
    }

    private void checkForExistingScenario() {
        String userName = this.getUserName();
        String title = this.getTitle();
        if (userName == null || userName.equals("")) {
            return;
        }
        if (title == null || title.equals("")) {
            return;
        }
        if (this.scenarioChecker == null) {
            this.scenarioChecker = new ExistingScenarioChecker(){

                @Override
                public void scenarioExistenceCheckFailed(Exception reason) {
                }

                @Override
                public void scenarioExistenceChecked(ScenarioInfo info) {
                    if (info != null) {
                        ExportPublishPane.this.setUpdate(true);
                    } else {
                        ExportPublishPane.this.setUpdate(false);
                    }
                }
            };
        }
        this.scenarioChecker.startScenarioExistenceCheck(serverURL, userName, title);
    }

    @Override
    public void activated() {
        if (this.firstActivation) {
            this.firstActivation = false;
            this.setUserName(Config.getPropString((String)"publish.username", (String)""));
            this.loadStoredScenarioInfo();
            this.checkForExistingScenario();
            this.commonTagsLoader = new SwingWorker(){

                public void finished() {
                    List l = (List)this.getValue();
                    ExportPublishPane.this.setPopularTags(l);
                }

                public Object construct() {
                    MyGameClient client = new MyGameClient(null);
                    List<String> tags = null;
                    try {
                        String hostAddress = serverURL;
                        if (!hostAddress.endsWith("/")) {
                            hostAddress = hostAddress + "/";
                        }
                        if ((tags = client.getCommonTags(hostAddress, ExportPublishPane.this.popTags.length + 1)).contains(ExportPublishPane.WITH_SOURCE_TAG)) {
                            tags.remove(ExportPublishPane.WITH_SOURCE_TAG);
                        } else if (!tags.isEmpty()) {
                            tags.remove(tags.size() - 1);
                        }
                    }
                    catch (ConnectTimeoutException ctoe) {
                    }
                    catch (UnknownHostException e) {
                        Debug.reportError((String)"Error while publishing scenario", (Throwable)e);
                    }
                    catch (IOException e) {
                        Debug.reportError((String)"Error while publishing scenario", (Throwable)e);
                    }
                    return tags;
                }
            };
            this.commonTagsLoader.start();
        }
        String updateText = this.isUpdate ? Config.getString((String)"export.dialog.update") : Config.getString((String)"export.dialog.share");
        this.exportDialog.setExportButtonText(updateText);
    }

    @Override
    public boolean prePublish() {
        this.publishedScenarioInfo = new ScenarioInfo();
        this.updateInfoFromFields(this.publishedScenarioInfo);
        this.publishedUserName = this.userNameField.getText();
        return true;
    }

    @Override
    public void postPublish(boolean success) {
        if (success) {
            this.publishedScenarioInfo.store(this.project.getProjectProperties());
            Config.putPropString((String)"publish.username", (String)this.publishedUserName);
            this.setUpdate(true);
        }
    }

    public static String ensureTrailingSlash(String hostname) {
        if (hostname.endsWith("/")) {
            return hostname;
        }
        return hostname + "/";
    }

    private void createScenarioDisplay() {
        this.leftPanel = new Box(1);
        MiksGridLayout titleAndDescLayout = new MiksGridLayout(6, 2, 8, 8);
        titleAndDescLayout.setVerticallyExpandingRow(3);
        this.titleAndDescPanel = new JPanel((LayoutManager)titleAndDescLayout);
        this.titleAndDescPanel.setBackground(background);
        if (this.imagePanel == null) {
            this.imagePanel = new ImageEditPanel(120, 70);
            this.imagePanel.setBackground(background);
        }
        Box textPanel = new Box(1);
        JLabel text = new JLabel(Config.getString((String)"export.publish.image1"));
        text.setAlignmentX(1.0f);
        text.setFont(this.font);
        textPanel.add(text);
        text = new JLabel(Config.getString((String)"export.publish.image2"));
        text.setAlignmentX(1.0f);
        text.setFont(this.font);
        textPanel.add(text);
        this.titleAndDescPanel.add(textPanel);
        this.titleAndDescPanel.add(this.imagePanel);
        if (this.isUpdate) {
            text = new JLabel(Config.getString((String)"export.snapshot.label"), 11);
            text.setFont(this.font);
            this.titleAndDescPanel.add(text);
            this.keepScenarioScreenshot = new JCheckBox();
            this.keepScenarioScreenshot.setSelected(true);
            this.imagePanel.enableImageEditPanel(false);
            this.keepScenarioScreenshot.setName(Config.getString((String)"export.publish.keepScenario"));
            this.keepScenarioScreenshot.setOpaque(false);
            this.keepScenarioScreenshot.addChangeListener(this);
            this.titleAndDescPanel.add(this.keepScenarioScreenshot);
        }
        text = new JLabel(Config.getString((String)"export.publish.title"), 11);
        text.setFont(this.font);
        this.titleAndDescPanel.add(text);
        String title = this.project.getName();
        if (this.getTitle() != null) {
            title = this.getTitle();
        }
        this.titleField = new JTextField(title);
        this.titleField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String text = ExportPublishPane.this.titleField.getText();
                return text.length() > 0;
            }
        });
        this.titleField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ExportPublishPane.this.checkForExistingScenario();
            }
        });
        this.titleAndDescPanel.add(this.titleField);
        if (this.isUpdate) {
            JLabel updateLabel = new JLabel(Config.getString((String)"export.publish.update"), 11);
            updateLabel.setVerticalAlignment(1);
            updateLabel.setFont(this.font);
            this.updateArea = new JTextArea();
            this.updateArea.setRows(6);
            this.updateArea.setLineWrap(true);
            this.updateArea.setWrapStyleWord(true);
            JScrollPane updatePane = new JScrollPane(this.updateArea);
            this.titleAndDescPanel.add(updateLabel);
            this.titleAndDescPanel.add(updatePane);
            titleAndDescLayout.setVerticallyExpandingRow(4);
        } else {
            text = new JLabel(Config.getString((String)"export.publish.shortDescription"), 11);
            text.setFont(this.font);
            this.shortDescriptionField = new JTextField();
            this.titleAndDescPanel.add(text);
            this.titleAndDescPanel.add(this.shortDescriptionField);
            text = new JLabel(Config.getString((String)"export.publish.longDescription"), 11);
            text.setVerticalAlignment(1);
            text.setFont(this.font);
            this.descriptionArea = new JTextArea();
            this.descriptionArea.setRows(6);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setWrapStyleWord(true);
            JScrollPane description = new JScrollPane(this.descriptionArea);
            this.titleAndDescPanel.add(text);
            this.titleAndDescPanel.add(description);
        }
        text = new JLabel(Config.getString((String)"export.publish.url"), 11);
        text.setFont(this.font);
        this.titleAndDescPanel.add(text);
        this.urlField = new JTextField();
        this.titleAndDescPanel.add(this.urlField);
        this.leftPanel.add((Component)this.titleAndDescPanel, "South");
        JPanel sourceAndLockPanel = new JPanel(new FlowLayout(1, 8, 0));
        sourceAndLockPanel.setBackground(background);
        this.includeSource = new JCheckBox(Config.getString((String)"export.publish.includeSource"));
        this.includeSource.setOpaque(false);
        this.includeSource.setSelected(false);
        this.includeSource.setFont(this.font);
        sourceAndLockPanel.add(this.includeSource);
        this.lockScenario.setFont(this.font);
        sourceAndLockPanel.add(this.lockScenario);
        sourceAndLockPanel.setMaximumSize(sourceAndLockPanel.getPreferredSize());
        this.leftPanel.add((Component)sourceAndLockPanel, "South");
    }

    private void removeLeftPanel() {
        this.leftPanel.removeAll();
        this.infoPanel.remove(this.leftPanel);
    }

    private JComponent getTagDisplay() {
        JPanel tagPanel = new JPanel((LayoutManager)new MiksGridLayout(3, 1, 8, 8));
        tagPanel.setBackground(background);
        JPanel popPanel = new JPanel((LayoutManager)new MiksGridLayout(8, 1, 8, 0));
        popPanel.setBackground(background);
        JLabel popLabel = new JLabel(Config.getString((String)"export.publish.tags.popular"), 10);
        popLabel.setFont(this.font);
        popPanel.add(popLabel);
        for (int i = 0; i < this.popTags.length; ++i) {
            JCheckBox popTag = new JCheckBox(Config.getString((String)"export.publish.tags.loading"));
            popTag.setBackground(background);
            popTag.setFont(this.font);
            popTag.setEnabled(false);
            this.popTags[i] = popTag;
            popPanel.add(popTag);
        }
        tagPanel.add(popPanel);
        Box textPanel = new Box(1);
        JLabel additionalLabel = new JLabel(Config.getString((String)"export.publish.tags.additional1"), 10);
        additionalLabel.setFont(this.font);
        textPanel.add(additionalLabel);
        JLabel additionalLabel2 = new JLabel(Config.getString((String)"export.publish.tags.additional2"), 0);
        additionalLabel2.setFont(this.font);
        textPanel.add(additionalLabel2);
        tagPanel.add(textPanel);
        this.tagArea = new JTextArea();
        this.tagArea.setRows(3);
        JScrollPane tagScroller = new JScrollPane(this.tagArea);
        tagPanel.add(tagScroller);
        return tagPanel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.keepScenarioScreenshot)) {
            if (this.keepScenarioScreenshot.isSelected()) {
                this.imagePanel.enableImageEditPanel(false);
            } else {
                this.imagePanel.enableImageEditPanel(true);
            }
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    private void setUpdate(boolean isUpdate) {
        if (this.isUpdate != isUpdate) {
            this.isUpdate = isUpdate;
            if (isUpdate) {
                String updateText = Config.getString((String)"export.dialog.update");
                this.exportDialog.setExportButtonText(updateText);
            } else {
                String exportText = Config.getString((String)"export.dialog.share");
                this.exportDialog.setExportButtonText(exportText);
            }
            this.updateScenarioDisplay();
        }
    }
}

