/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser.role;

import greenfoot.GreenfootImage;
import greenfoot.actions.DragProxyAction;
import greenfoot.core.GClass;
import greenfoot.core.GProject;
import greenfoot.core.ObjectDragProxy;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.role.ClassRole;
import greenfoot.util.GreenfootUtil;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

public abstract class ImageClassRole
extends ClassRole {
    protected GClass gClass;
    protected ClassView classView;
    protected GProject project;
    private static Hashtable<GClass, ImageIcon> imageIcons = new Hashtable();

    public ImageClassRole(GProject project) {
        this.project = project;
    }

    @Override
    public void buildUI(ClassView classView, GClass gClass) {
        this.gClass = gClass;
        this.classView = classView;
        classView.setText(gClass.getName());
        this.changeImage();
    }

    @Override
    public String getTemplateFileName() {
        return null;
    }

    private static Image getImage(GClass gClass) {
        GreenfootImage gfImage = ImageClassRole.getGreenfootImage(gClass);
        if (gfImage != null) {
            return gfImage.getAwtImage();
        }
        return null;
    }

    private static GClass getClassThatHasImage(GClass gclass) {
        while (gclass != null) {
            String className = gclass.getQualifiedName();
            GreenfootImage gfImage = null;
            GProject project = gclass.getPackage().getProject();
            gfImage = project.getProjectProperties().getImage(className);
            if (gfImage != null) break;
            gclass = gclass.getSuperclass();
        }
        return gclass;
    }

    protected static GreenfootImage getGreenfootImage(GClass gclass) {
        if ((gclass = ImageClassRole.getClassThatHasImage(gclass)) == null) {
            return null;
        }
        String className = gclass.getQualifiedName();
        GProject project = gclass.getPackage().getProject();
        return project.getProjectProperties().getImage(className);
    }

    private ImageIcon getImageIcon() {
        GClass gCls = ImageClassRole.getClassThatHasImage(this.gClass);
        ImageIcon icon = imageIcons.get(gCls);
        if (icon == null) {
            Image image = ImageClassRole.getImage(gCls);
            Image scaledImage = GreenfootUtil.getScaledImage(image, ImageClassRole.iconSize.width, ImageClassRole.iconSize.height);
            icon = new ImageIcon(scaledImage);
            imageIcons.put(gCls, icon);
        }
        return icon;
    }

    public ObjectDragProxy createObjectDragProxy() {
        GreenfootImage greenfootImage = ImageClassRole.getGreenfootImage(this.gClass);
        AbstractAction dropAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImageClassRole.this.classView.createInstance();
            }
        };
        ObjectDragProxy object = new ObjectDragProxy(greenfootImage, dropAction);
        return object;
    }

    protected Action createDragProxyAction(Action realAction) {
        GreenfootImage greenfootImage = ImageClassRole.getGreenfootImage(this.gClass);
        return new DragProxyAction(greenfootImage, realAction);
    }

    public void changeImage() {
        this.project.getProjectProperties().removeCachedImage(this.classView.getClassName());
        Image image = ImageClassRole.getImage(this.gClass);
        if (image != null) {
            Image scaledImage = GreenfootUtil.getScaledImage(image, ImageClassRole.iconSize.width, ImageClassRole.iconSize.height);
            ImageIcon icon = this.getImageIcon();
            icon.setImage(scaledImage);
            this.classView.setIcon(icon);
        } else {
            this.classView.setIcon(null);
        }
        this.classView.setPopupMenu(null);
    }

    @Override
    public void remove() {
        imageIcons.remove(this.gClass);
    }
}

