/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.GreenfootImage;
import greenfoot.ImageVisitor;
import greenfoot.TreeActorSet;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.WorldHandler;
import greenfoot.gui.DropTarget;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class WorldCanvas
extends JPanel
implements DropTarget,
Scrollable {
    private World world;
    private DropTarget dropTargetListener;
    private Actor dragActor;
    private Point dragLocation;
    private BufferedImage dragImage;
    private Dimension size;

    public WorldCanvas(World world) {
        this.setWorld(world);
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
    }

    public void setWorld(World world) {
        this.world = world;
        if (world != null) {
            this.setSize(this.getPreferredSize());
            this.revalidate();
            this.repaint();
        }
    }

    public void setWorldSize(int xsize, int ysize) {
        if (this.world == null) {
            this.size = new Dimension(xsize, ysize);
        }
    }

    public void paintObjects(Graphics2D g) {
        TreeActorSet objects = WorldVisitor.getObjectsListInPaintOrder(this.world);
        int paintSeq = 0;
        for (Actor thing : objects) {
            int cellSize = WorldVisitor.getCellSize(this.world);
            GreenfootImage image = ActorVisitor.getDisplayImage(thing);
            if (image == null) continue;
            ActorVisitor.setLastPaintSeqNum(thing, paintSeq++);
            double halfWidth = (double)image.getWidth() / 2.0;
            double halfHeight = (double)image.getHeight() / 2.0;
            AffineTransform oldTx = null;
            try {
                int ax = ActorVisitor.getX(thing);
                int ay = ActorVisitor.getY(thing);
                double xCenter = (double)(ax * cellSize) + (double)cellSize / 2.0;
                int paintX = (int)Math.floor(xCenter - halfWidth);
                double yCenter = (double)(ay * cellSize) + (double)cellSize / 2.0;
                int paintY = (int)Math.floor(yCenter - halfHeight);
                int rotation = ActorVisitor.getRotation(thing);
                if (rotation != 0) {
                    oldTx = g.getTransform();
                    g.rotate(Math.toRadians(rotation), xCenter, yCenter);
                }
                ImageVisitor.drawImage(image, g, paintX, paintY, this, true);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (oldTx == null) continue;
            g.setTransform(oldTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        block7: {
            if (this.world == null) {
                Color c = g.getColor();
                g.setColor(this.getParent().getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(c);
                WorldHandler.getInstance().repainted();
                return;
            }
            try {
                ReentrantReadWriteLock lock = WorldHandler.getInstance().getWorldLock();
                int timeout = 500;
                if (lock.readLock().tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    try {
                        Insets insets = this.getInsets();
                        Graphics2D g2 = (Graphics2D)g;
                        g.translate(insets.left, insets.top);
                        this.paintBackground(g2);
                        this.paintObjects(g2);
                        this.paintDraggedObject(g2);
                        WorldVisitor.paintDebug(this.world, g2);
                        g.translate(-insets.left, -insets.top);
                        break block7;
                    }
                    finally {
                        lock.readLock().unlock();
                        WorldHandler.getInstance().repainted();
                    }
                }
                WorldHandler.getInstance().repainted();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void paintDraggedObject(Graphics g) {
        if (this.dragImage != null) {
            int x = (int)this.dragLocation.getX();
            int y = (int)this.dragLocation.getY();
            int xCell = WorldVisitor.toCellFloor(this.world, x);
            int yCell = WorldVisitor.toCellFloor(this.world, y);
            int cellSize = WorldVisitor.getCellSize(this.world);
            x = (int)(((double)xCell + 0.5) * (double)cellSize - (double)(this.dragImage.getWidth() / 2));
            y = (int)(((double)yCell + 0.5) * (double)cellSize - (double)(this.dragImage.getHeight() / 2));
            g.drawImage(this.dragImage, x, y, null);
        }
    }

    public void paintBackground(Graphics2D g) {
        if (this.world != null) {
            GreenfootImage backgroundImage = WorldVisitor.getBackgroundImage(this.world);
            if (backgroundImage != null) {
                ImageVisitor.drawImage(backgroundImage, g, 0, 0, this, true);
            } else {
                Color oldColor = g.getColor();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(oldColor);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.world != null) {
            this.size = new Dimension();
            this.size.width = WorldVisitor.getWidthInPixels(this.world);
            this.size.height = WorldVisitor.getHeightInPixels(this.world);
            Insets insets = this.getInsets();
            this.size.width += insets.left + insets.right;
            this.size.height += insets.top + insets.bottom;
            return this.size;
        }
        if (this.size != null) {
            return this.size;
        }
        return super.getPreferredSize();
    }

    public void setDropTargetListener(DropTarget dropTargetListener) {
        this.dropTargetListener = dropTargetListener;
    }

    @Override
    public boolean drop(Object o, Point p) {
        Insets insets = this.getInsets();
        Point p2 = new Point(p.x - insets.left, p.y - insets.top);
        this.clearDragInfo();
        if (this.dropTargetListener != null) {
            return this.dropTargetListener.drop(o, p2);
        }
        return false;
    }

    @Override
    public boolean drag(Object o, Point p) {
        Insets insets = this.getInsets();
        Point p2 = new Point(p.x - insets.left, p.y - insets.top);
        if (o instanceof Actor && ActorVisitor.getWorld((Actor)o) == null) {
            if (!this.getVisibleRect().contains(p)) {
                return false;
            }
            if (o != this.dragActor) {
                this.dragActor = (Actor)o;
                this.dragImage = GreenfootUtil.createDragShadow(ActorVisitor.getDragImage(this.dragActor).getAwtImage());
            }
            this.dragLocation = p2;
            this.repaint();
            return true;
        }
        if (this.dropTargetListener != null) {
            return this.dropTargetListener.drag(o, p2);
        }
        return false;
    }

    @Override
    public void dragEnded(Object o) {
        this.clearDragInfo();
        if (this.dropTargetListener != null) {
            this.dropTargetListener.dragEnded(o);
        }
    }

    private void clearDragInfo() {
        this.dragLocation = null;
        this.dragActor = null;
        this.dragImage = null;
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int cellSize = this.world.getCellSize();
        double scrollPos = 0.0;
        if (orientation == 0) {
            if (direction < 0) {
                scrollPos = visibleRect.getMinX();
            } else if (direction > 0) {
                scrollPos = visibleRect.getMaxX();
            }
        } else if (direction < 0) {
            scrollPos = visibleRect.getMinY();
        } else if (direction > 0) {
            scrollPos = visibleRect.getMaxY();
        }
        int increment = Math.abs((int)Math.IEEEremainder(scrollPos, cellSize));
        if (increment == 0) {
            increment = cellSize;
        }
        return increment;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

