/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.prefmgr.PrefMgr;
import bluej.utility.DBox;
import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import greenfoot.Actor;
import greenfoot.World;
import greenfoot.actions.AboutGreenfootAction;
import greenfoot.actions.CloseProjectAction;
import greenfoot.actions.CompileAllAction;
import greenfoot.actions.ExportProjectAction;
import greenfoot.actions.ImportClassAction;
import greenfoot.actions.NewClassAction;
import greenfoot.actions.NewProjectAction;
import greenfoot.actions.OpenProjectAction;
import greenfoot.actions.OpenRecentProjectAction;
import greenfoot.actions.PauseSimulationAction;
import greenfoot.actions.PreferencesAction;
import greenfoot.actions.QuitAction;
import greenfoot.actions.RemoveSelectedClassAction;
import greenfoot.actions.ResetWorldAction;
import greenfoot.actions.RunOnceSimulationAction;
import greenfoot.actions.RunSimulationAction;
import greenfoot.actions.SaveAsAction;
import greenfoot.actions.SaveProjectAction;
import greenfoot.actions.SaveWorldAction;
import greenfoot.actions.SetPlayerAction;
import greenfoot.actions.ShowApiDocAction;
import greenfoot.actions.ShowCopyrightAction;
import greenfoot.actions.ShowReadMeAction;
import greenfoot.actions.ShowWebsiteAction;
import greenfoot.actions.ToggleAction;
import greenfoot.actions.ToggleDebuggerAction;
import greenfoot.actions.ToggleSoundAction;
import greenfoot.core.ClassStateManager;
import greenfoot.core.GClass;
import greenfoot.core.GCoreClass;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.core.GreenfootMain;
import greenfoot.core.ProjectProperties;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.event.CompileListener;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.gui.CenterLayout;
import greenfoot.gui.ControlPanel;
import greenfoot.gui.DragGlassPane;
import greenfoot.gui.GreenfootInspectorManager;
import greenfoot.gui.WorldCanvas;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.Selectable;
import greenfoot.gui.classbrowser.SelectionListener;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.platforms.ide.SimulationDelegateIDE;
import greenfoot.platforms.ide.WorldHandlerDelegateIDE;
import greenfoot.sound.SoundFactory;
import greenfoot.util.GreenfootUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import rmiextension.wrappers.RBlueJ;
import rmiextension.wrappers.event.RCompileEvent;

public class GreenfootFrame
extends JFrame
implements WindowListener,
CompileListener,
WorldListener,
SelectionListener {
    private static final String shareIconFile = "export-publish-small.png";
    private static final String compileIconFile = "compile.png";
    private static final int WORLD_MARGIN = 40;
    private static final int accelModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final int shiftAccelModifier = accelModifier | 1;
    private RBlueJ rBlueJ;
    private GProject project;
    private GreenfootInspectorManager inspectorManager = new GreenfootInspectorManager();
    private WorldCanvas worldCanvas;
    private WorldHandler worldHandler;
    private WorldHandlerDelegateIDE worldHandlerDelegate;
    private Dimension worldDimensions;
    private ClassBrowser classBrowser;
    private ControlPanel controlPanel;
    private JScrollPane classScrollPane;
    private JComponent centrePanel;
    private NewClassAction newClassAction;
    private ImportClassAction importClassAction;
    private SaveProjectAction saveProjectAction;
    private SaveAsAction saveAsAction;
    private ShowReadMeAction showReadMeAction;
    private ExportProjectAction exportProjectAction;
    private ExportProjectAction shareAction;
    private CloseProjectAction closeProjectAction;
    private RemoveSelectedClassAction removeSelectedClassAction;
    private CompileAllAction compileAllAction;
    private SaveWorldAction saveWorldAction;
    private SetPlayerAction setPlayerAction;
    private ToggleDebuggerAction toggleDebuggerAction;
    private ToggleSoundAction toggleSoundAction;
    private JMenu recentProjectsMenu;
    private boolean isClosedProject = true;
    private boolean resizeWhenPossible = false;
    private static GreenfootFrame instance;

    public boolean isClosedProject() {
        return this.isClosedProject;
    }

    public static GreenfootFrame getGreenfootFrame(RBlueJ blueJ, ClassStateManager classStateManager) {
        instance = new GreenfootFrame(blueJ, classStateManager);
        return instance;
    }

    private GreenfootFrame(RBlueJ blueJ, ClassStateManager classStateManager) throws HeadlessException {
        super("Greenfoot");
        this.rBlueJ = blueJ;
        LocationTracker.instance();
        Image icon = BlueJTheme.getApplicationIcon((String)"greenfoot");
        if (icon != null) {
            this.setIconImage(icon);
        }
        this.makeFrame(classStateManager);
        this.addWindowListener(this);
        this.restoreFrameState();
        this.prepareMacOSApp();
    }

    private void restoreFrameState() {
        if (this.project == null) {
            this.setBounds(40, 40, 700, 500);
            this.setResizeWhenPossible(true);
            return;
        }
        ProjectProperties projectProperties = this.project.getProjectProperties();
        try {
            int x = projectProperties.getInt("mainWindow.x");
            int y = projectProperties.getInt("mainWindow.y");
            int width = projectProperties.getInt("mainWindow.width");
            int height = projectProperties.getInt("mainWindow.height");
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            if (x > d.width - 50) {
                x = d.width - 50;
            }
            if (y > d.height - 50) {
                y = d.height - 50;
            }
            this.setBounds(x, y, width, height);
            this.setResizeWhenPossible(false);
        }
        catch (NumberFormatException ecx) {
            this.setBounds(40, 40, 700, 500);
            this.setResizeWhenPossible(true);
        }
    }

    private Application prepareMacOSApp() {
        if (Config.isMacOS()) {
            Application macApp = Application.getApplication();
            macApp.setPreferencesHandler(new PreferencesHandler(){

                public void handlePreferences(AppEvent.PreferencesEvent e) {
                    PreferencesAction.getInstance().actionPerformed(null);
                }
            });
            macApp.setAboutHandler(new AboutHandler(){

                public void handleAbout(AppEvent.AboutEvent arg0) {
                    AboutGreenfootAction.getInstance(GreenfootFrame.this).actionPerformed(null);
                }
            });
            macApp.setQuitHandler(new QuitHandler(){

                public void handleQuitRequestWith(AppEvent.QuitEvent e, QuitResponse response) {
                    GreenfootFrame.this.exit();
                }
            });
            return macApp;
        }
        return null;
    }

    public void openProject(GProject project) {
        if (this.isClosedProject) {
            this.project = project;
            this.worldHandlerDelegate.attachProject(project);
            project.addCompileListener(this);
            this.setTitle("Greenfoot: " + project.getName());
            this.enableProjectActions();
            this.worldCanvas.setVisible(false);
            this.buildClassBrowser();
            this.populateClassBrowser(this.classBrowser, project);
            this.classBrowser.setVisible(true);
            this.classScrollPane.setViewportView(this.classBrowser);
            this.restoreFrameState();
            try {
                ProjectProperties props = project.getProjectProperties();
                int initialSpeed = props.getInt("simulation.speed");
                Simulation.getInstance().setSpeed(initialSpeed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.worldHandler.instantiateNewWorld();
            if (this.needsResize()) {
                this.pack();
            }
            this.toggleDebuggerAction.setProject(project);
            this.toggleSoundAction.setProject(project);
            this.isClosedProject = false;
        }
    }

    public void closeProject() {
        this.setTitle("Greenfoot: ");
        this.project.removeCompileListener(this);
        this.project.closeEditors();
        this.worldCanvas.setVisible(false);
        this.classBrowser.setVisible(false);
        this.project = null;
        this.enableProjectActions();
        this.repaint();
        this.isClosedProject = true;
    }

    public ClassBrowser getClassBrowser() {
        return this.classBrowser;
    }

    public GProject getProject() {
        return this.project;
    }

    private void makeFrame(ClassStateManager classStateManager) {
        String[] scrollLabels;
        this.setDefaultCloseOperation(3);
        this.worldCanvas = new WorldCanvas(null);
        this.worldCanvas.setWorldSize(200, 100);
        this.worldCanvas.setVisible(false);
        this.worldHandlerDelegate = new WorldHandlerDelegateIDE(this, this.inspectorManager, classStateManager);
        WorldHandler.initialise(this.worldCanvas, this.worldHandlerDelegate);
        this.worldHandler = WorldHandler.getInstance();
        this.worldHandler.addWorldListener(this);
        Simulation.initialize(new SimulationDelegateIDE());
        Simulation sim = Simulation.getInstance();
        sim.attachWorldHandler(this.worldHandler);
        this.buildClassBrowser();
        this.setupActions();
        this.setJMenuBar(this.buildMenu(classStateManager));
        this.setGlassPane(DragGlassPane.getInstance());
        this.centrePanel = new JPanel(new BorderLayout(4, 4)){

            @Override
            public boolean isValidateRoot() {
                return true;
            }
        };
        sim.addSimulationListener(new SimulationListener(){

            @Override
            public void simulationChanged(SimulationEvent e) {
                if (e.getType() == 0) {
                    GreenfootFrame.this.worldCanvas.requestFocusInWindow();
                }
            }
        });
        sim.addSimulationListener(SoundFactory.getInstance().getSoundCollection());
        this.worldCanvas.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JPanel canvasPanel = new JPanel(new CenterLayout());
        canvasPanel.setBorder(BorderFactory.createEtchedBorder());
        canvasPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GreenfootFrame.this.worldHandlerDelegate.showWorldPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GreenfootFrame.this.worldHandlerDelegate.showWorldPopupMenu(e);
                }
            }
        });
        JScrollPane worldScrollPane = new JScrollPane(this.worldCanvas);
        for (String scrollLabel : scrollLabels = new String[]{"unitScrollLeft", "unitScrollRight", "unitScrollUp", "unitScrollDown"}) {
            worldScrollPane.getActionMap().put(scrollLabel, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        DBox worldBox = new DBox(DBox.Y_AXIS, 0.5f);
        worldBox.addAligned((JComponent)worldScrollPane);
        canvasPanel.add((Component)worldBox);
        GreenfootFrame.setScrollIncrements(worldScrollPane);
        worldScrollPane.setOpaque(false);
        worldScrollPane.getViewport().setOpaque(false);
        worldScrollPane.setBorder(null);
        this.centrePanel.add((Component)canvasPanel, "Center");
        this.controlPanel = new ControlPanel(sim, true);
        this.controlPanel.setBorder(BorderFactory.createEtchedBorder());
        this.centrePanel.add((Component)this.controlPanel, "South");
        JPanel eastPanel = new JPanel(new BorderLayout(12, 12));
        JButton shareButton = GreenfootUtil.createButton(this.shareAction);
        shareButton.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(shareIconFile)));
        shareButton.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        eastPanel.add((Component)shareButton, "North");
        this.classScrollPane = new JScrollPane(this.classBrowser){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width += this.getVerticalScrollBar().getWidth();
                return size;
            }
        };
        GreenfootFrame.setScrollIncrements(this.classScrollPane);
        this.classScrollPane.setOpaque(false);
        this.classScrollPane.getViewport().setOpaque(false);
        this.classScrollPane.setBorder(BorderFactory.createEtchedBorder());
        eastPanel.add((Component)this.classScrollPane, "Center");
        JButton button = GreenfootUtil.createButton(this.compileAllAction);
        button.setFocusable(false);
        button.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(compileIconFile)));
        eastPanel.add((Component)button, "South");
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        contentPane.setLayout(new BorderLayout(12, 12));
        contentPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        contentPane.add((Component)this.centrePanel, "Center");
        contentPane.add((Component)eastPanel, "East");
        contentPane.getInputMap(2).put(Config.GREENFOOT_SET_PLAYER_NAME_SHORTCUT, "setPlayerAction");
        contentPane.getActionMap().put("setPlayerAction", this.setPlayerAction);
        this.pack();
    }

    private static void setScrollIncrements(JScrollPane scrollPane) {
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        scrollPane.getVerticalScrollBar().setBlockIncrement(30);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        scrollPane.getHorizontalScrollBar().setBlockIncrement(30);
    }

    @Override
    public void pack() {
        super.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        boolean change = false;
        if (width > this.getMaximumSize().width) {
            width = this.getMaximumSize().width;
            change = true;
        }
        if (height > this.getMaximumSize().height) {
            height = this.getMaximumSize().height;
            change = true;
        }
        if (change) {
            this.setSize(width, height);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.setSize(dim.width + 40, dim.height + 40);
        return dim;
    }

    private void buildClassBrowser() {
        this.classBrowser = new ClassBrowser(this.project, this);
        this.classBrowser.getSelectionManager().addSelectionChangeListener(this);
        DragGlassPane.getInstance().setSelectionManager(this.classBrowser.getSelectionManager());
    }

    private void populateClassBrowser(ClassBrowser classBrowser, GProject project) {
        if (project != null) {
            try {
                GPackage pkg = project.getDefaultPackage();
                GClass[] classes = pkg.getClasses(false);
                classBrowser.quickAddClass(new ClassView(classBrowser, new GCoreClass(World.class, project), this.worldHandlerDelegate));
                classBrowser.quickAddClass(new ClassView(classBrowser, new GCoreClass(Actor.class, project), this.worldHandlerDelegate));
                for (int i = 0; i < classes.length; ++i) {
                    GClass gClass = classes[i];
                    classBrowser.quickAddClass(new ClassView(classBrowser, gClass, this.worldHandlerDelegate));
                }
                classBrowser.updateLayout();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    private void setupActions() {
        this.newClassAction = new NewClassAction(this, this.worldHandlerDelegate);
        this.saveProjectAction = new SaveProjectAction(this);
        this.saveAsAction = new SaveAsAction(this, this.rBlueJ);
        this.showReadMeAction = new ShowReadMeAction(this);
        this.saveWorldAction = this.worldHandlerDelegate.getSaveWorldAction();
        this.setPlayerAction = new SetPlayerAction(this);
        this.exportProjectAction = new ExportProjectAction(this, false);
        this.shareAction = new ExportProjectAction(this, true);
        this.importClassAction = new ImportClassAction(this, this.worldHandlerDelegate);
        this.closeProjectAction = new CloseProjectAction(this);
        this.removeSelectedClassAction = new RemoveSelectedClassAction(this);
        this.removeSelectedClassAction.setEnabled(false);
        this.compileAllAction = new CompileAllAction(this.project);
    }

    private JMenuBar buildMenu(ClassStateManager classStateManager) {
        JMenuBar menuBar = new JMenuBar();
        JMenu projectMenu = this.addMenu(Config.getString((String)"menu.scenario"), menuBar, 's');
        this.addMenuItem(NewProjectAction.getInstance(), projectMenu, -1, false, 78);
        this.addMenuItem(OpenProjectAction.getInstance(), projectMenu, 79, false, 79);
        this.recentProjectsMenu = new JMenu(Config.getString((String)"menu.openRecent"));
        projectMenu.add(this.recentProjectsMenu);
        this.updateRecentProjects(classStateManager);
        this.addMenuItem(this.closeProjectAction, projectMenu, 87, false, 67);
        this.addMenuItem(this.saveProjectAction, projectMenu, 83, false, 83);
        this.addMenuItem(this.saveAsAction, projectMenu, -1, false, -1);
        projectMenu.addSeparator();
        this.addMenuItem(this.showReadMeAction, projectMenu, -1, false, -1);
        this.addMenuItem(this.exportProjectAction, projectMenu, 69, false, 69);
        if (!Config.isMacOS()) {
            projectMenu.addSeparator();
            this.addMenuItem(QuitAction.getInstance(), projectMenu, 81, false, 81);
        }
        JMenu editMenu = this.addMenu(Config.getString((String)"menu.edit"), menuBar, 'e');
        this.addMenuItem(this.newClassAction, editMenu, 78, false, 78);
        this.addMenuItem(this.importClassAction, editMenu, 73, false, 73);
        this.addMenuItem(this.removeSelectedClassAction, editMenu, 68, false, 82);
        if (!Config.usingMacScreenMenubar()) {
            editMenu.addSeparator();
            this.addMenuItem(PreferencesAction.getInstance(), editMenu, 44, false, 44);
        }
        JMenu ctrlMenu = this.addMenu(Config.getString((String)"menu.controls"), menuBar, 'c');
        this.addMenuItem(RunOnceSimulationAction.getInstance(), ctrlMenu, 65, false, 65);
        this.addMenuItem(RunSimulationAction.getInstance(), ctrlMenu, 82, false, 82);
        this.addMenuItem(PauseSimulationAction.getInstance(), ctrlMenu, 82, true, 80);
        this.addMenuItem(ResetWorldAction.getInstance(), ctrlMenu, 84, false, 84);
        RunOnceSimulationAction.getInstance().attachListener(this.worldHandlerDelegate);
        RunSimulationAction.getInstance().attachListener(this.worldHandlerDelegate);
        ctrlMenu.addSeparator();
        this.toggleDebuggerAction = new ToggleDebuggerAction(Config.getString((String)"menu.debugger"), this.project);
        this.createCheckboxMenuItem(this.toggleDebuggerAction, false, ctrlMenu, 66, false, 66);
        this.toggleSoundAction = new ToggleSoundAction(Config.getString((String)"menu.soundRecorder"), this.project);
        this.createCheckboxMenuItem(this.toggleSoundAction, false, ctrlMenu, 85, false, 85);
        this.addMenuItem(this.saveWorldAction, ctrlMenu, -1, false, 87);
        ctrlMenu.addSeparator();
        this.addMenuItem(this.compileAllAction, ctrlMenu, 75, false, -1);
        JMenu helpMenu = this.addMenu(Config.getString((String)"menu.help"), menuBar, 'h');
        if (!Config.isMacOS()) {
            this.addMenuItem(AboutGreenfootAction.getInstance(this), helpMenu, -1, false, 65);
        }
        this.addMenuItem(ShowCopyrightAction.getInstance(this), helpMenu, -1, false, -1);
        helpMenu.addSeparator();
        this.addMenuItem(new ShowApiDocAction(Config.getString((String)"menu.help.classDoc")), helpMenu, -1, false, -1);
        this.addMenuItem(new ShowWebsiteAction(Config.getString((String)"menu.help.javadoc"), Config.getPropString((String)"greenfoot.url.javaStdLib")), helpMenu, -1, false, -1);
        helpMenu.addSeparator();
        this.addMenuItem(new ShowWebsiteAction(Config.getString((String)"menu.help.tutorial"), Config.getPropString((String)"greenfoot.url.tutorial")), helpMenu, -1, false, -1);
        this.addMenuItem(new ShowWebsiteAction(Config.getString((String)"menu.help.website"), Config.getPropString((String)"greenfoot.url.greenfoot")), helpMenu, -1, false, -1);
        this.addMenuItem(new ShowWebsiteAction(Config.getString((String)"menu.help.moreScenarios"), Config.getPropString((String)"greenfoot.url.scenarios")), helpMenu, -1, false, -1);
        helpMenu.addSeparator();
        this.addMenuItem(new ShowWebsiteAction(Config.getPropString((String)"greenfoot.gameserver.name"), Config.getPropString((String)"greenfoot.gameserver.address")), helpMenu, -1, false, -1);
        this.addMenuItem(new ShowWebsiteAction(Config.getString((String)"menu.help.discuss"), Config.getPropString((String)"greenfoot.url.discuss")), helpMenu, -1, false, -1);
        return menuBar;
    }

    private JMenu addMenu(String name, JMenuBar menubar, char mnemonic) {
        JMenu menu = new JMenu(name);
        if (!Config.isMacOS()) {
            menu.setMnemonic(mnemonic);
        }
        menubar.add(menu);
        return menu;
    }

    private void addMenuItem(Action action, JMenu menu, int accelKey, boolean shift, int mnemonicKey) {
        if (accelKey != -1) {
            if (shift) {
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelKey, shiftAccelModifier));
            } else {
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelKey, accelModifier));
            }
        }
        if (!Config.isMacOS() && mnemonicKey != -1) {
            action.putValue("MnemonicKey", mnemonicKey);
        }
        menu.add(action);
    }

    private void createCheckboxMenuItem(ToggleAction action, boolean selected, JMenu menu, int accelKey, boolean shift, int mnemonicKey) {
        if (accelKey != -1) {
            if (shift) {
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelKey, shiftAccelModifier));
            } else {
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelKey, accelModifier));
            }
        }
        if (!Config.isMacOS() && mnemonicKey != -1) {
            action.putValue("MnemonicKey", mnemonicKey);
        }
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        ButtonModel bm = action.getToggleModel();
        if (bm == null) {
            item.setSelected(selected);
        } else {
            item.setModel(bm);
        }
        menu.add(item);
    }

    private void updateRecentProjects(ClassStateManager classStateManager) {
        JMenuItem item = null;
        if (classStateManager != null && classStateManager.getProject() != null) {
            String currentName = classStateManager.getProject().getDir().getPath();
            item = new JMenuItem(currentName);
            item.addActionListener(OpenRecentProjectAction.getInstance());
            this.recentProjectsMenu.add(item);
            this.recentProjectsMenu.addSeparator();
        }
        List projects = PrefMgr.getRecentProjects();
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            item = new JMenuItem((String)it.next());
            item.addActionListener(OpenRecentProjectAction.getInstance());
            this.recentProjectsMenu.add(item);
        }
    }

    private void enableProjectActions() {
        boolean state = this.project != null;
        this.closeProjectAction.setEnabled(state);
        this.saveProjectAction.setEnabled(state);
        this.saveAsAction.setEnabled(state);
        this.newClassAction.setEnabled(state);
        this.importClassAction.setEnabled(state);
        this.showReadMeAction.setEnabled(state);
        this.saveWorldAction.setEnabled(state);
        this.exportProjectAction.setEnabled(state);
        this.shareAction.setEnabled(state);
        if (!state) {
            WorldHandler.getInstance().discardWorld();
            this.removeSelectedClassAction.setEnabled(false);
        }
        this.compileAllAction.setProject(this.project);
    }

    private void exit() {
        super.dispose();
        GreenfootMain.closeAll();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Dimension getMaximumSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    private boolean needsResize() {
        Dimension dim = this.worldCanvas.getPreferredSize();
        if (this.resizeWhenPossible) {
            return true;
        }
        if (this.worldDimensions == null) {
            return false;
        }
        return this.worldDimensions.width < dim.width || this.worldDimensions.height < dim.height;
    }

    private void resize() {
        this.setResizeWhenPossible(false);
        this.pack();
    }

    public void setResizeWhenPossible(boolean b) {
        this.worldDimensions = null;
        this.resizeWhenPossible = b;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        GreenfootMain.closeProject(this, true);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void compileStarted(RCompileEvent event) {
        WorldHandler.getInstance().discardWorld();
    }

    @Override
    public void compileError(RCompileEvent event) {
    }

    @Override
    public void compileWarning(RCompileEvent event) {
    }

    @Override
    public void compileSucceeded(RCompileEvent event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorldHandler.getInstance().instantiateNewWorld();
                GreenfootFrame.this.classBrowser.repaint();
                GreenfootFrame.this.compileAllAction.setEnabled(GreenfootFrame.this.project != null);
            }
        });
    }

    @Override
    public void compileFailed(RCompileEvent event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GreenfootFrame.this.compileAllAction.setEnabled(GreenfootFrame.this.project != null);
            }
        });
    }

    @Override
    public void worldCreated(WorldEvent e) {
        int state;
        World newWorld = e.getWorld();
        if (this.needsResize() && newWorld != null && (state = this.getExtendedState()) != 6) {
            this.resize();
        }
        this.worldCanvas.setVisible(true);
        this.centrePanel.revalidate();
        this.worldDimensions = this.worldCanvas.getPreferredSize();
    }

    @Override
    public void worldRemoved(WorldEvent e) {
        this.inspectorManager.removeAllInspectors();
        this.worldCanvas.setVisible(false);
    }

    @Override
    public void selectionChange(Selectable source) {
        if (source instanceof ClassView) {
            ClassView classView = (ClassView)source;
            if (classView.getRealClass() == null) {
                this.removeSelectedClassAction.setEnabled(true);
            } else if (!classView.getRealClass().getName().equals("greenfoot.Actor") && !classView.getRealClass().getName().equals("greenfoot.World")) {
                this.removeSelectedClassAction.setEnabled(true);
            } else {
                this.removeSelectedClassAction.setEnabled(false);
            }
        } else {
            this.removeSelectedClassAction.setEnabled(false);
        }
    }

    public GreenfootInspectorManager getInspectorManager() {
        return this.inspectorManager;
    }
}

