/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class EditableList<T>
extends JTable {
    private DefaultTableModel tableModel;
    private ListSelectionListener selectionListener;

    public EditableList(final boolean editable) {
        this.tableModel = new DefaultTableModel(1, 1){

            @Override
            public boolean isCellEditable(int row, int col) {
                return editable;
            }
        };
        this.setModel(this.tableModel);
        this.setShowGrid(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setIntercellSpacing(new Dimension());
        this.setAutoResizeMode(4);
        this.getTableHeader().setVisible(false);
        this.getSelectionModel().addListSelectionListener(new ListSelectionHandler());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.removeHeader();
    }

    private void removeHeader() {
        this.unconfigureEnclosingScrollPane();
    }

    private void setPreferredWidthToFit(List<T> listData) {
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        int contentsMaxWidth = this.getMaxWidth(listData);
        int prefWidth = tableColumn.getPreferredWidth();
        if (prefWidth < contentsMaxWidth) {
            tableColumn.setPreferredWidth(contentsMaxWidth);
        }
    }

    private int getMaxWidth(List<T> listData) {
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        TableCellRenderer ltcr = tableColumn.getCellRenderer();
        int contentsMaxWidth = 0;
        int row = 0;
        for (T data : listData) {
            Component n = ltcr.getTableCellRendererComponent(this, data, false, false, row, 0);
            int labelWidth = n.getPreferredSize().width;
            if (labelWidth > contentsMaxWidth) {
                contentsMaxWidth = labelWidth;
            }
            ++row;
        }
        return contentsMaxWidth;
    }

    public void setListData(List<T> data) {
        this.tableModel.setRowCount(0);
        if (data == null) {
            return;
        }
        for (T object : data) {
            this.tableModel.addRow(new Object[]{object});
        }
        this.setPreferredWidthToFit(data);
        this.revalidate();
    }

    public int setSelectedValue(Object value) {
        if (value == null) {
            return -1;
        }
        int rowCount = this.tableModel.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            if (!value.equals(this.getValueAt(row, 0))) continue;
            this.setSelectedRow(row);
            return row;
        }
        return -1;
    }

    public void setSelectedRow(int row) {
        this.getSelectionModel().setSelectionInterval(row, row);
    }

    public void ensureIndexIsVisible(int index) {
        if (index < 0 || index >= this.tableModel.getRowCount()) {
            return;
        }
        Rectangle cellBounds = this.getCellRect(index, 0, false);
        if (cellBounds != null) {
            this.scrollRectToVisible(cellBounds);
        }
    }

    public T getSelectedValue() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return (T)this.tableModel.getValueAt(row, 0);
    }

    public Object[] getSelectedValues() {
        int[] rows = this.getSelectedRows();
        Object[] selected = new Object[rows.length];
        int count = 0;
        for (int row : rows) {
            selected[count] = this.tableModel.getValueAt(row, 0);
            ++count;
        }
        return selected;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension d = super.getPreferredScrollableViewportSize();
        d.width = Math.min(d.width, this.getPreferredSize().width);
        return d;
    }

    protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            if (e == null) {
                e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        if (this.selectionListener == null) {
            this.selectionListener = new ListSelectionHandler();
            this.getSelectionModel().addListSelectionListener(this.selectionListener);
        }
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    private class ListSelectionHandler
    implements ListSelectionListener,
    Serializable {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            EditableList.this.fireSelectionValueChanged(e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
        }
    }
}

