/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export;

import bluej.BlueJPropStringSource;
import bluej.Config;
import greenfoot.export.GreenfootScenarioViewer;
import greenfoot.util.StandalonePropStringManager;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class GreenfootScenarioMain {
    public static String scenarioName;
    public static String[] args;

    public static void main(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        if (args.length != 3 && args.length != 0) {
            System.err.println("Wrong number of arguments");
        }
        GreenfootScenarioMain.args = args;
        GreenfootScenarioMain.initProperties();
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", scenarioName);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame(scenarioName);
                new GreenfootScenarioViewer(frame);
                frame.setDefaultCloseOperation(3);
                frame.setResizable(false);
                URL resource = this.getClass().getClassLoader().getResource("greenfoot.png");
                ImageIcon icon = new ImageIcon(resource);
                frame.setIconImage(icon.getImage());
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public static void initProperties() {
        if (scenarioName != null) {
            return;
        }
        Properties p = new Properties();
        try {
            ClassLoader loader = GreenfootScenarioMain.class.getClassLoader();
            InputStream is = loader.getResourceAsStream("standalone.properties");
            if (is == null && args.length == 3) {
                p.put("project.name", args[0]);
                p.put("main.class", args[1]);
                p.put("scenario.lock", "true");
                File f = new File(args[2]);
                is = new FileInputStream(f);
            }
            p.load(is);
            scenarioName = p.getProperty("project.name");
            Config.initializeStandalone((BlueJPropStringSource)new StandalonePropStringManager(p));
            is.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

