/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export;

import bluej.Boot;
import bluej.Config;
import greenfoot.core.GProject;
import greenfoot.core.WorldHandler;
import greenfoot.event.PublishEvent;
import greenfoot.event.PublishListener;
import greenfoot.export.GreenfootScenarioViewer;
import greenfoot.export.JarCreator;
import greenfoot.export.mygame.MyGameClient;
import greenfoot.export.mygame.ScenarioInfo;
import greenfoot.gui.WorldCanvas;
import greenfoot.gui.export.ExportAppPane;
import greenfoot.gui.export.ExportDialog;
import greenfoot.gui.export.ExportPublishPane;
import greenfoot.gui.export.ExportWebPagePane;
import greenfoot.gui.export.ProxyAuthDialog;
import greenfoot.util.GreenfootUtil;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;

public class Exporter
implements PublishListener {
    private static final String GREENFOOT_CORE_JAR = Exporter.getGreenfootCoreJar();
    private static final String GALLERY_SHARED_JARS = "sharedjars/";
    private static Exporter instance;
    private File tmpJarFile;
    private File tmpImgFile;
    private File tmpZipFile;
    private MyGameClient webPublisher;
    private ExportDialog dlg;

    private static String getGreenfootCoreJar() {
        String coreJar = "Greenfoot-core-";
        int lastDot = Boot.GREENFOOT_API_VERSION.lastIndexOf(46);
        coreJar = coreJar + Boot.GREENFOOT_API_VERSION.substring(0, lastDot) + ".jar";
        return coreJar;
    }

    public static synchronized Exporter getInstance() {
        if (instance == null) {
            instance = new Exporter();
        }
        return instance;
    }

    public void publishToWebServer(GProject project, ExportPublishPane pane, ExportDialog dlg) {
        this.dlg = dlg;
        dlg.setProgress(true, Config.getString((String)"export.progress.bundling"));
        try {
            this.tmpJarFile = File.createTempFile("greenfoot", ".jar", null);
            this.tmpJarFile.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        File exportDir = this.tmpJarFile.getParentFile();
        String jarName = this.tmpJarFile.getName();
        String hostAddress = Config.getPropString((String)"greenfoot.gameserver.address", (String)"http://www.greenfoot.org/");
        if (!hostAddress.endsWith("/")) {
            hostAddress = hostAddress + "/";
        }
        String worldClass = project.getLastWorldClassName();
        boolean lockScenario = pane.lockScenario();
        JarCreator jarCreator = new JarCreator(project, exportDir, jarName, worldClass, lockScenario, true);
        jarCreator.includeSource(false);
        jarCreator.addToClassPath(hostAddress + GALLERY_SHARED_JARS + GREENFOOT_CORE_JAR);
        Set<File> thirdPartyLibs = GreenfootUtil.get3rdPartyLibs();
        for (File lib : thirdPartyLibs) {
            jarCreator.addToClassPath(hostAddress + GALLERY_SHARED_JARS + lib.getName());
        }
        jarCreator.putManifestEntry("title", pane.getTitle());
        jarCreator.putManifestEntry("short-description", pane.getShortDescription());
        jarCreator.putManifestEntry("description", pane.getDescription());
        jarCreator.putManifestEntry("url", pane.getURL());
        jarCreator.putManifestEntry("greenfoot-version", Boot.GREENFOOT_VERSION);
        jarCreator.putManifestEntry("java-version", System.getProperty("java.version"));
        jarCreator.putManifestEntry("java-vm-name", System.getProperty("java.vm.name"));
        jarCreator.putManifestEntry("java-vm-version", System.getProperty("java.vm.version"));
        jarCreator.putManifestEntry("java-vm-vendor", System.getProperty("java.vm.vendor"));
        jarCreator.putManifestEntry("os-name", System.getProperty("os.name"));
        jarCreator.putManifestEntry("os-version", System.getProperty("os.version"));
        jarCreator.putManifestEntry("os-arch", System.getProperty("os.arch"));
        jarCreator.putManifestEntry("java-home", System.getProperty("java.home"));
        Dimension size = this.getSize(!lockScenario);
        jarCreator.putManifestEntry("width", "" + size.width);
        jarCreator.putManifestEntry("height", "" + size.height);
        project.getProjectProperties().save();
        jarCreator.create();
        if (pane.includeSourceCode()) {
            try {
                this.tmpZipFile = File.createTempFile("greenfootSource", ".zip", null);
                this.tmpZipFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            String zipName = this.tmpZipFile.getName();
            JarCreator zipCreator = new JarCreator(project, exportDir, zipName);
            zipCreator.create();
        }
        if (!pane.keepSavedScenarioScreenshot()) {
            String formatName = "png";
            try {
                this.tmpImgFile = File.createTempFile("greenfoot", "." + formatName, null);
                BufferedImage img = pane.getImage();
                ImageIO.write((RenderedImage)img, formatName, this.tmpImgFile);
                this.tmpImgFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        String login = pane.getUserName();
        String password = pane.getPassword();
        String scenarioName = pane.getTitle();
        if (scenarioName != null && scenarioName.length() < 1) {
            scenarioName = "NO_NAME";
        }
        if (this.webPublisher == null) {
            this.webPublisher = new MyGameClient(this);
        }
        dlg.setProgress(true, Config.getString((String)"export.progress.publishing"));
        try {
            ScenarioInfo info = new ScenarioInfo();
            info.setTitle(scenarioName);
            info.setShortDescription(pane.getShortDescription());
            info.setUpdateDescription(pane.getUpdateDescription());
            info.setLongDescription(pane.getDescription());
            if (pane.isUpdate()) {
                info.setUpdate(true);
            }
            info.setTags(pane.getTags());
            info.setUrl(pane.getURL());
            int uploadSize = (int)this.tmpJarFile.length();
            if (this.tmpImgFile != null) {
                uploadSize += (int)this.tmpImgFile.length();
            }
            if (this.tmpZipFile != null) {
                uploadSize += (int)this.tmpZipFile.length();
            }
            this.gotUploadSize(uploadSize);
            this.webPublisher.submit(hostAddress, login, password, this.tmpJarFile.getAbsolutePath(), this.tmpZipFile, this.tmpImgFile, size.width, size.height, info);
        }
        catch (UnknownHostException e) {
            dlg.setProgress(false, Config.getString((String)"export.publish.unknownHost") + " (" + e.getMessage() + ")");
            return;
        }
        catch (IOException e) {
            dlg.setProgress(false, Config.getString((String)"export.publish.fail") + " " + e.getMessage());
            return;
        }
    }

    public void makeWebPage(GProject project, ExportWebPagePane pane, ExportDialog dlg) {
        this.dlg = dlg;
        dlg.setProgress(true, Config.getString((String)"export.progress.writingHTML"));
        File exportDir = new File(pane.getExportLocation());
        exportDir.mkdir();
        String worldClass = project.getLastWorldClassName();
        boolean includeControls = pane.lockScenario();
        String jarName = project.getName() + ".jar";
        JarCreator jarCreator = new JarCreator(project, exportDir, jarName, worldClass, includeControls, true);
        jarCreator.includeSource(false);
        File greenfootLibDir = Config.getGreenfootLibDir();
        File greenfootDir = new File(greenfootLibDir, "standalone");
        jarCreator.addFile(greenfootDir);
        Set<File> thirdPartyLibs = GreenfootUtil.get3rdPartyLibs();
        for (File lib : thirdPartyLibs) {
            jarCreator.addJar(lib);
        }
        File[] jarFiles = this.getJarsInPlusLib(project);
        if (jarFiles != null) {
            for (File file : jarFiles) {
                jarCreator.addJar(file);
            }
        }
        Dimension size = this.getSize(includeControls);
        project.getProjectProperties().save();
        jarCreator.create();
        String htmlName = project.getName() + ".html";
        String title = project.getName();
        File outputFile = new File(exportDir, htmlName);
        jarCreator.generateHTMLSkeleton(outputFile, title, size.width, size.height);
        dlg.setProgress(false, Config.getString((String)"export.progress.complete"));
    }

    private File[] getJarsInPlusLib(GProject project) {
        File[] jarFiles = null;
        File plusLibsDir = new File(project.getDir(), "+libs");
        jarFiles = plusLibsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        return jarFiles;
    }

    public void makeApplication(GProject project, ExportAppPane pane, ExportDialog dlg) {
        dlg.setProgress(true, Config.getString((String)"export.progress.writingJar"));
        File exportFile = new File(pane.getExportName());
        File exportDir = exportFile.getParentFile();
        String jarName = exportFile.getName();
        String worldClass = project.getLastWorldClassName();
        boolean includeControls = pane.lockScenario();
        JarCreator jarCreator = new JarCreator(project, exportDir, jarName, worldClass, includeControls, false);
        jarCreator.includeSource(false);
        File greenfootLibDir = Config.getGreenfootLibDir();
        File greenfootDir = new File(greenfootLibDir, "standalone");
        jarCreator.addFile(greenfootDir);
        Set<File> thirdPartyLibs = GreenfootUtil.get3rdPartyLibs();
        for (File lib : thirdPartyLibs) {
            jarCreator.addJarToJar(lib);
        }
        File[] jarFiles = this.getJarsInPlusLib(project);
        if (jarFiles != null) {
            for (File file : jarFiles) {
                jarCreator.addJarToJar(file);
            }
        }
        try {
            File license = new File(GreenfootUtil.getGreenfootDir(), "GREENFOOT_LICENSES.txt");
            if (license.exists()) {
                jarCreator.addFile(license);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        project.getProjectProperties().save();
        jarCreator.create();
        dlg.setProgress(false, Config.getString((String)"export.progress.complete"));
    }

    private Dimension getSize(boolean includeControls) {
        Dimension controlPanelSize = null;
        Dimension border = GreenfootScenarioViewer.getControlsBorderSize();
        controlPanelSize = includeControls ? new Dimension(560 + border.width, 48 + border.height) : new Dimension(410 + border.width, 48 + border.height);
        WorldCanvas canvas = WorldHandler.getInstance().getWorldCanvas();
        border = GreenfootScenarioViewer.getWorldBorderSize();
        Dimension size = new Dimension(canvas.getWidth() + border.width, (int)controlPanelSize.getHeight() + canvas.getHeight() + border.height);
        size.width += 2;
        size.height += 2;
        size.width = Math.max(size.width, controlPanelSize.width);
        return size;
    }

    @Override
    public void errorRecieved(final PublishEvent event) {
        this.deleteTmpFiles();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Exporter.this.dlg.publishFinished(false, Config.getString((String)"export.publish.fail") + " " + event.getMessage());
            }
        });
    }

    @Override
    public void uploadComplete(PublishEvent event) {
        this.deleteTmpFiles();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Exporter.this.dlg.publishFinished(true, Config.getString((String)"export.publish.complete"));
            }
        });
    }

    private void deleteTmpFiles() {
        if (this.tmpJarFile != null) {
            this.tmpJarFile.delete();
            this.tmpJarFile = null;
        }
        if (this.tmpImgFile != null) {
            this.tmpImgFile.delete();
            this.tmpImgFile = null;
        }
        if (this.tmpZipFile != null) {
            this.tmpZipFile.delete();
            this.tmpZipFile = null;
        }
    }

    public void gotUploadSize(final int size) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Exporter.this.dlg.gotUploadSize(size);
            }
        });
    }

    @Override
    public void progressMade(final PublishEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Exporter.this.dlg.progressMade(event.getBytes());
            }
        });
    }

    @Override
    public String[] needProxyAuth() {
        final String[] details = new String[2];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ProxyAuthDialog dialog = new ProxyAuthDialog((Window)((Object)Exporter.this.dlg));
                    dialog.setVisible(true);
                    if (dialog.getResult() == 0) {
                        details[0] = dialog.getUsername();
                        details[1] = dialog.getPassword();
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getCause());
        }
        catch (InterruptedException ie) {
            return null;
        }
        if (details[0] == null) {
            return null;
        }
        return details;
    }
}

