/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.Config;
import bluej.debugmgr.CallHistory;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.GreenfootProjectFile;
import bluej.pkgmgr.Project;
import bluej.runtime.ExecServer;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import bluej.views.View;
import greenfoot.ObjectTracker;
import greenfoot.core.ClassStateManager;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.core.InternalGreenfootError;
import greenfoot.core.ProjectProperties;
import greenfoot.core.WorldHandler;
import greenfoot.event.ActorInstantiationListener;
import greenfoot.event.CompileListener;
import greenfoot.event.CompileListenerForwarder;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.MessageDialog;
import greenfoot.importer.scratch.ScratchImport;
import greenfoot.platforms.ide.ActorDelegateIDE;
import greenfoot.util.FileChoosers;
import greenfoot.util.Version;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import rmiextension.wrappers.RBlueJ;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.event.RCompileEvent;
import rmiextension.wrappers.event.RInvocationListener;
import rmiextension.wrappers.event.RProjectListener;

public class GreenfootMain
extends Thread
implements CompileListener,
RProjectListener {
    public static final int VERSION_OK = 0;
    public static final int VERSION_UPDATED = 1;
    public static final int VERSION_BAD = 2;
    private static Version version = null;
    private static GreenfootMain instance;
    private RBlueJ rBlueJ;
    private GreenfootFrame frame;
    private GProject project;
    private GPackage pkg;
    private File startupProject;
    private CompileListenerForwarder compileListenerForwarder;
    private List<CompileListener> compileListeners = new LinkedList<CompileListener>();
    private ClassStateManager classStateManager;
    private ActorInstantiationListener instantiationListener;
    private List<RInvocationListener> invocationListeners = new ArrayList<RInvocationListener>();
    private CallHistory callHistory = new CallHistory();
    private static FilenameFilter classFilter;
    private ClassLoader currentLoader;

    public static void initialize(RBlueJ rBlueJ, RPackage pkg) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        if (instance == null) {
            try {
                instance = new GreenfootMain(rBlueJ, pkg.getProject());
            }
            catch (ProjectNotOpenException pnoe) {
                Debug.reportError((String)"Getting remote project", (Throwable)pnoe);
            }
            catch (RemoteException re) {
                Debug.reportError((String)"Getting remote project", (Throwable)re);
            }
        }
    }

    public static GreenfootMain getInstance() {
        return instance;
    }

    private GreenfootMain(final RBlueJ rBlueJ, RProject proj) {
        instance = this;
        this.rBlueJ = rBlueJ;
        this.currentLoader = ExecServer.getCurrentClassLoader();
        this.addCompileListener(this);
        try {
            File startupProj = rBlueJ.getSystemLibDir();
            startupProj = new File(startupProj, "greenfoot");
            this.startupProject = new File(startupProj, "startupProject");
            this.project = GProject.newGProject(proj);
            this.addCompileListener(this.project);
            this.pkg = this.project.getDefaultPackage();
            ActorDelegateIDE.setupAsActorDelegate(this.project);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!GreenfootMain.this.isStartupProject()) {
                        try {
                            GreenfootMain.this.classStateManager = new ClassStateManager(GreenfootMain.this.project);
                        }
                        catch (RemoteException exc) {
                            Debug.reportError((String)"Error when opening scenario", (Throwable)exc);
                        }
                    }
                    GreenfootMain.this.frame = GreenfootFrame.getGreenfootFrame(rBlueJ, GreenfootMain.this.classStateManager);
                    if (!GreenfootMain.this.isStartupProject()) {
                        try {
                            GreenfootMain.this.instantiationListener = new ActorInstantiationListener(WorldHandler.getInstance());
                            GreenfootMain.this.frame.openProject(GreenfootMain.this.project);
                            GreenfootMain.this.compileListenerForwarder = new CompileListenerForwarder(GreenfootMain.this.compileListeners);
                            GreenfootMain.this.rBlueJ.addCompileListener(GreenfootMain.this.compileListenerForwarder, GreenfootMain.this.pkg.getProject().getDir());
                            rBlueJ.addClassListener(GreenfootMain.this.classStateManager);
                        }
                        catch (Exception exc) {
                            Debug.reportError((String)"Error when opening scenario", (Throwable)exc);
                        }
                    }
                    GreenfootMain.this.frame.setVisible(true);
                    Utility.bringToFront((Window)GreenfootMain.this.frame);
                }
            });
        }
        catch (Exception exc) {
            Debug.reportError((String)"could not create greenfoot main", (Throwable)exc);
        }
    }

    private boolean isStartupProject() {
        return this.project.getDir().equals(this.startupProject);
    }

    public void openProject(String projectDir) throws RemoteException {
        int versionStatus;
        boolean doOpen;
        File projectDirFile = new File(projectDir);
        if (!projectDirFile.exists()) {
            JOptionPane.showMessageDialog(this.frame, Config.getString((String)"noproject.dialog.msg") + System.getProperty("line.separator") + projectDir, Config.getString((String)"noproject.dialog.title"), 2);
            return;
        }
        if (this.project.getDir().equals(projectDirFile)) {
            this.frame.openProject(this.project);
            return;
        }
        boolean autoIndentAllFiles = false;
        if (!projectDirFile.isDirectory() && !Project.isProject((String)projectDirFile.toString())) {
            if (projectDirFile.getName().endsWith(".sb")) {
                projectDirFile = ScratchImport.convert(projectDirFile);
                autoIndentAllFiles = true;
            } else {
                if ((projectDirFile = Utility.maybeExtractArchive((File)projectDirFile, (Component)this.frame)) == null) {
                    return;
                }
                if (!GreenfootProjectFile.exists((File)projectDirFile)) {
                    DialogManager.showError((Component)this.frame, (String)"archive-not-greenfoot-project");
                    FileUtility.deleteDir((File)projectDirFile);
                    return;
                }
            }
        }
        boolean bl = doOpen = (versionStatus = GreenfootMain.updateApi(projectDirFile, this.frame, GreenfootMain.getAPIVersion().toString())) != 2;
        if (doOpen) {
            RProject proj = this.rBlueJ.openProject(projectDirFile);
            if (autoIndentAllFiles) {
                try {
                    for (RPackage pkg : proj.getPackages()) {
                        for (RClass cls : pkg.getRClasses()) {
                            cls.autoIndent();
                        }
                    }
                }
                catch (ProjectNotOpenException e) {
                }
                catch (PackageNotFoundException e) {
                    // empty catch block
                }
            }
            if (proj != null && this.frame.getProject() == null) {
                this.project.close();
            }
        }
    }

    public void openProjectBrowser() {
        File dirName = FileChoosers.getScenario(this.frame);
        if (dirName != null) {
            try {
                this.openProject(dirName.getAbsolutePath());
            }
            catch (Exception exc) {
                Debug.reportError((String)"Could not open scenario", (Throwable)exc);
            }
        }
    }

    public GProject getProject() {
        return this.project;
    }

    private void closeThisInstance(boolean windowClosing) {
        try {
            if (this.rBlueJ.getOpenProjects().length <= 1) {
                if (windowClosing) {
                    this.rBlueJ.exit();
                } else {
                    this.frame.closeProject();
                }
            } else {
                this.project.close();
            }
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Error while closing", (Throwable)re);
        }
    }

    public static void closeProject(GreenfootFrame frame, boolean windowClosing) {
        instance.closeThisInstance(windowClosing);
    }

    @Override
    public void projectClosing() {
        try {
            if (!this.isStartupProject()) {
                this.rBlueJ.removeCompileListener(this.compileListenerForwarder);
                this.rBlueJ.removeClassListener(this.classStateManager);
                this.storeFrameState();
                for (RInvocationListener element : this.invocationListeners) {
                    this.rBlueJ.removeInvocationListener(element);
                }
            }
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Closing project", (Throwable)re);
        }
    }

    public static void closeAll() {
        try {
            GreenfootMain.getInstance().rBlueJ.exit();
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Closing all projects", (Throwable)re);
        }
    }

    private void storeFrameState() {
        ProjectProperties projectProperties = this.project.getProjectProperties();
        projectProperties.setInt("mainWindow.width", this.frame.getWidth());
        projectProperties.setInt("mainWindow.height", this.frame.getHeight());
        Point loc = this.frame.getLocation();
        projectProperties.setInt("mainWindow.x", loc.x);
        projectProperties.setInt("mainWindow.y", loc.y);
        projectProperties.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCompileListener(CompileListener listener) {
        List<CompileListener> list = this.compileListeners;
        synchronized (list) {
            this.compileListeners.add(0, listener);
        }
    }

    public void addInvocationListener(RInvocationListener listener) throws RemoteException {
        this.invocationListeners.add(listener);
        this.rBlueJ.addInvocationListener(listener);
    }

    public RProject newProject() {
        File newFile = FileUtility.getDirName((Component)this.frame, (String)Config.getString((String)"greenfoot.utilDelegate.newScenario"), (String)Config.getString((String)"pkgmgr.newPkg.buttonLabel"), (boolean)false, (boolean)true);
        if (newFile != null) {
            if (newFile.exists()) {
                DialogManager.showError((Component)this.frame, (String)"project-already-exists");
                return null;
            }
            try {
                RProject rproj = this.rBlueJ.newProject(newFile);
                if (rproj != null) {
                    if (this.isStartupProject() || this.frame.isClosedProject()) {
                        this.project.close();
                    }
                    return rproj;
                }
                DialogManager.showError((Component)this.frame, (String)"cannot-create-project");
            }
            catch (ServerError se) {
                Debug.reportError((String)"Problems when trying to create new scenario", (Throwable)se);
            }
            catch (ServerException se) {
                Debug.reportError((String)"Problems when trying to create new scenario", (Throwable)se);
            }
            catch (RemoteException re) {
                Debug.reportError((String)"Problems when trying to create new scenario", (Throwable)re);
            }
        }
        return null;
    }

    public CallHistory getCallHistory() {
        return this.callHistory;
    }

    public ActorInstantiationListener getInvocationListener() {
        return this.instantiationListener;
    }

    public GreenfootFrame getFrame() {
        return this.frame;
    }

    private static void prepareGreenfootProject(File greenfootLibDir, File projectDir, ProjectProperties p, boolean deleteClassFiles, String greenfootApiVersion) {
        if (GreenfootMain.isStartupProject(greenfootLibDir, projectDir)) {
            return;
        }
        File dst = projectDir;
        File greenfootDir = new File(dst, "greenfoot");
        GreenfootMain.deleteGreenfootDir(greenfootDir);
        if (deleteClassFiles) {
            GreenfootMain.deleteAllClassFiles(dst);
        }
        try {
            File pkhFile;
            File pkgFile = new File(dst, "bluej.pkg");
            if (pkgFile.exists()) {
                pkgFile.delete();
            }
            if ((pkhFile = new File(dst, "bluej.pkh")).exists()) {
                pkhFile.delete();
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            File images = new File(dst, "images");
            images.mkdir();
            File sounds = new File(dst, "sounds");
            sounds.mkdir();
        }
        catch (SecurityException e) {
            Debug.reportError((String)"SecurityException when trying to create images/sounds directories", (Throwable)e);
        }
        p.setApiVersion(greenfootApiVersion);
        p.save();
    }

    private static void deleteGreenfootDir(File greenfootDir) {
        if (greenfootDir.exists()) {
            File worldJava;
            File actorJava;
            try {
                actorJava = new File(greenfootDir, "Actor.java");
                if (actorJava.exists()) {
                    actorJava.delete();
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            try {
                worldJava = new File(greenfootDir, "World.java");
                if (worldJava.exists()) {
                    worldJava.delete();
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            try {
                actorJava = new File(greenfootDir, "Actor.class");
                if (actorJava.exists()) {
                    actorJava.delete();
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            try {
                worldJava = new File(greenfootDir, "World.class");
                if (worldJava.exists()) {
                    worldJava.delete();
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            try {
                worldJava = new File(greenfootDir, "project.greenfoot");
                if (worldJava.exists()) {
                    worldJava.delete();
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            try {
                greenfootDir.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static int updateApi(File projectDir, Frame parent, String greenfootApiVersion) {
        File greenfootLibDir = Config.getGreenfootLibDir();
        ProjectProperties newProperties = new ProjectProperties(projectDir);
        Version projectVersion = newProperties.getAPIVersion();
        Version apiVersion = GreenfootMain.getAPIVersion();
        if (projectVersion.isBad()) {
            String message = projectVersion.getBadMessage();
            JButton continueButton = new JButton(Config.getString((String)"greenfoot.continue"));
            MessageDialog dialog = new MessageDialog(parent, message, Config.getString((String)"project.version.mismatch"), 50, new JButton[]{continueButton});
            dialog.displayModal();
            Debug.message((String)("Bad version number in project: " + greenfootLibDir));
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, true, greenfootApiVersion);
            return 1;
        }
        if (projectVersion.isOlderAndBreaking(apiVersion)) {
            String message = projectVersion.getChangesMessage(apiVersion);
            JButton continueButton = new JButton(Config.getString((String)"greenfoot.continue"));
            MessageDialog dialog = new MessageDialog(parent, message, Config.getString((String)"project.version.mismatch"), 80, new JButton[]{continueButton});
            dialog.displayModal();
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, true, greenfootApiVersion);
            return 1;
        }
        if (apiVersion.isOlderAndBreaking(projectVersion)) {
            String message = projectVersion.getNewerMessage();
            JButton cancelButton = new JButton(Config.getString((String)"greenfoot.cancel"));
            JButton continueButton = new JButton(Config.getString((String)"greenfoot.continue"));
            MessageDialog dialog = new MessageDialog(parent, message, Config.getString((String)"project.version.mismatch"), 50, new JButton[]{continueButton, cancelButton});
            JButton pressed = dialog.displayModal();
            if (pressed == cancelButton) {
                return 2;
            }
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, true, greenfootApiVersion);
            return 1;
        }
        if (projectVersion.isNonBreaking(apiVersion)) {
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, true, greenfootApiVersion);
            return 1;
        }
        if (projectVersion.isInternal(apiVersion)) {
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, false, greenfootApiVersion);
            return 1;
        }
        GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, false, greenfootApiVersion);
        return 0;
    }

    public static void deleteAllClassFiles(File dir) {
        String[] classFiles = dir.list(classFilter);
        if (classFiles == null) {
            return;
        }
        for (int i = 0; i < classFiles.length; ++i) {
            String fileName = classFiles[i];
            int index = fileName.lastIndexOf(46);
            String javaFileName = fileName.substring(0, index) + ".java";
            File file = new File(dir, fileName);
            File javaFile = new File(dir, javaFileName);
            if (!javaFile.exists()) continue;
            file.delete();
        }
    }

    public static boolean isStartupProject(File blueJLibDir, File projectDir) {
        File startupProject = new File(blueJLibDir, "startupProject");
        return startupProject.equals(projectDir);
    }

    public static Version getAPIVersion() {
        if (version == null) {
            try {
                Class<?> bootCls = Class.forName("bluej.Boot");
                Field field = bootCls.getField("GREENFOOT_API_VERSION");
                String versionStr = (String)field.get(null);
                version = new Version(versionStr);
            }
            catch (ClassNotFoundException e) {
                Debug.reportError((String)"Could not get Greenfoot API version", (Throwable)e);
                throw new InternalGreenfootError(e);
            }
            catch (SecurityException e) {
                Debug.reportError((String)"Could not get Greenfoot API version", (Throwable)e);
                throw new InternalGreenfootError(e);
            }
            catch (NoSuchFieldException e) {
                Debug.reportError((String)"Could not get Greenfoot API version", (Throwable)e);
                throw new InternalGreenfootError(e);
            }
            catch (IllegalArgumentException e) {
                Debug.reportError((String)"Could not get Greenfoot API version", (Throwable)e);
                throw new InternalGreenfootError(e);
            }
            catch (IllegalAccessException e) {
                Debug.reportError((String)"Could not get Greenfoot API version", (Throwable)e);
                throw new InternalGreenfootError(e);
            }
        }
        return version;
    }

    private void checkClassLoader() {
        ClassLoader newLoader = ExecServer.getCurrentClassLoader();
        if (newLoader != this.currentLoader) {
            View.removeAll((ClassLoader)this.currentLoader);
            this.currentLoader = newLoader;
            ObjectTracker.clearRObjectCache();
        }
    }

    @Override
    public void compileStarted(RCompileEvent event) {
        this.checkClassLoader();
    }

    @Override
    public void compileSucceeded(RCompileEvent event) {
        this.checkClassLoader();
    }

    @Override
    public void compileFailed(RCompileEvent event) {
        this.checkClassLoader();
    }

    @Override
    public void compileError(RCompileEvent event) {
    }

    @Override
    public void compileWarning(RCompileEvent event) {
    }

    public void showPreferences() {
        try {
            this.rBlueJ.showPreferences();
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Problem showing preferences dialog", (Throwable)e);
        }
    }

    static {
        classFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".class");
            }
        };
    }
}

