/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.util.GraphicsUtilities;
import greenfoot.util.GreenfootUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class GreenfootImage {
    private static final Color DEFAULT_BACKGROUND = new Color(255, 255, 255, 0);
    private static final Color DEFAULT_FOREGROUND = Color.BLACK;
    private String imageFileName;
    private URL imageUrl;
    private BufferedImage image;
    private static MediaTracker tracker;
    private Color currentColor = DEFAULT_FOREGROUND;
    private Font currentFont;
    private boolean copyOnWrite = false;
    private int transparency = 255;

    public GreenfootImage(String filename) throws IllegalArgumentException {
        GreenfootImage gImage = GreenfootUtil.getCachedImage(filename);
        if (gImage != null) {
            this.createClone(gImage);
        } else {
            try {
                this.loadFile(filename);
            }
            catch (IllegalArgumentException ile) {
                GreenfootUtil.addCachedImage(filename, null);
                throw ile;
            }
        }
        boolean success = GreenfootUtil.addCachedImage(filename, new GreenfootImage(this));
        if (success) {
            this.copyOnWrite = true;
        }
    }

    public GreenfootImage(int width, int height) {
        this.setImage(GraphicsUtilities.createCompatibleTranslucentImage(width, height));
    }

    public GreenfootImage(GreenfootImage image) throws IllegalArgumentException {
        if (!image.copyOnWrite) {
            this.setImage(GraphicsUtilities.createCompatibleTranslucentImage(image.getWidth(), image.getHeight()));
            Graphics2D g = this.getGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)image.getAwtImage(), 0, 0, null);
            g.dispose();
        } else {
            this.image = image.image;
            this.copyOnWrite = true;
        }
        GreenfootImage.copyStates(image, this);
    }

    public GreenfootImage(String string, int size, Color foreground, Color background) {
        int i;
        String[] lines = string.replaceAll("\r", "").split("\n");
        this.image = GraphicsUtilities.createCompatibleTranslucentImage(1, 1);
        Graphics2D g = (Graphics2D)this.image.getGraphics();
        Font font = g.getFont().deriveFont((float)size);
        g.setFont(font);
        if (g.getFontMetrics().getHeight() != size) {
            font = g.getFont().deriveFont((float)size * (float)size / (float)g.getFontMetrics().getHeight());
            g.setFont(font);
        }
        Rectangle2D[] bounds = new Rectangle2D[lines.length];
        int maxX = 1;
        int y = 0;
        for (i = 0; i < lines.length; ++i) {
            bounds[i] = g.getFontMetrics().getStringBounds(lines[i], g);
            maxX = Math.max(maxX, (int)Math.ceil(bounds[i].getWidth()));
            y = (int)((double)y + Math.ceil(bounds[i].getHeight()));
        }
        y = Math.max(y, 1);
        g.dispose();
        this.image = GraphicsUtilities.createCompatibleTranslucentImage(maxX, y);
        g = (Graphics2D)this.image.getGraphics();
        g.setFont(font);
        g.setColor(background == null ? new Color(0, 0, 0, 0) : background);
        g.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        g.setColor(foreground == null ? Color.BLACK : foreground);
        y = 0;
        for (i = 0; i < lines.length; ++i) {
            g.drawString(lines[i], (maxX - (int)bounds[i].getWidth()) / 2 - (int)bounds[i].getX(), y - (int)bounds[i].getY());
            y = (int)((double)y + Math.ceil(bounds[i].getHeight()));
        }
        g.dispose();
    }

    GreenfootImage(byte[] imageData) {
        try {
            this.image = GraphicsUtilities.loadCompatibleTranslucentImage(imageData);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not load image from: " + this.imageFileName);
        }
    }

    private GreenfootImage() {
    }

    GreenfootImage getCopyOnWriteClone() {
        GreenfootImage clone = new GreenfootImage();
        clone.copyOnWrite = true;
        clone.image = this.image;
        GreenfootImage.copyStates(this, clone);
        return clone;
    }

    void createClone(GreenfootImage cachedImage) {
        this.copyOnWrite = true;
        this.image = cachedImage.image;
        GreenfootImage.copyStates(cachedImage, this);
    }

    private static void copyStates(GreenfootImage src, GreenfootImage dst) {
        dst.imageFileName = src.imageFileName;
        dst.imageUrl = src.imageUrl;
        dst.currentColor = src.currentColor;
        dst.currentFont = src.currentFont;
        dst.transparency = src.transparency;
    }

    private void loadURL(URL imageURL) throws IllegalArgumentException {
        if (imageURL == null) {
            throw new NullPointerException("Image URL must not be null.");
        }
        try {
            this.image = GraphicsUtilities.loadCompatibleTranslucentImage(imageURL);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not load image from: " + this.imageFileName);
        }
    }

    private void loadFile(String filename) throws IllegalArgumentException {
        if (filename == null) {
            throw new NullPointerException("Filename must not be null.");
        }
        this.imageFileName = filename;
        try {
            this.imageUrl = GreenfootUtil.getURL(filename, "images");
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        this.loadURL(this.imageUrl);
    }

    private void setImage(Image image) throws IllegalArgumentException {
        if (image == null) {
            throw new IllegalArgumentException("Image must not be null.");
        }
        this.image = GreenfootImage.getBufferedImage(image);
        this.copyOnWrite = false;
    }

    public BufferedImage getAwtImage() {
        this.ensureWritableImage();
        return this.image;
    }

    private Graphics2D getGraphics() {
        if (this.copyOnWrite) {
            this.ensureWritableImage();
        }
        Graphics2D graphics = this.image.createGraphics();
        this.initGraphics(graphics);
        return graphics;
    }

    private void initGraphics(Graphics2D graphics) {
        if (graphics != null) {
            graphics.setBackground(DEFAULT_BACKGROUND);
            graphics.setColor(this.currentColor);
            if (this.currentFont != null) {
                graphics.setFont(this.currentFont);
            }
        }
    }

    public int getWidth() {
        return this.image.getWidth(null);
    }

    public int getHeight() {
        return this.image.getHeight(null);
    }

    public void rotate(int degrees) {
        AffineTransform tx = AffineTransform.getRotateInstance(Math.toRadians(degrees), (double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        BufferedImage newImage = GraphicsUtilities.createCompatibleTranslucentImage(this.getWidth(), this.getHeight());
        this.setImage(op.filter(this.image, newImage));
    }

    public void scale(int width, int height) {
        if (width == this.image.getWidth() && height == this.image.getHeight()) {
            return;
        }
        BufferedImage scaled = GraphicsUtilities.createCompatibleTranslucentImage(width, height);
        Graphics2D g = scaled.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.drawImage(this.image, 0, 0, width, height, null);
        g.dispose();
        this.setImage(scaled);
    }

    public void mirrorVertically() {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -this.image.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        this.setImage(op.filter(this.image, null));
    }

    public void mirrorHorizontally() {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-this.image.getWidth(null), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        this.setImage(op.filter(this.image, null));
    }

    public void fill() {
        Graphics2D g = this.getGraphics();
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.dispose();
    }

    public void drawImage(GreenfootImage image, int x, int y) {
        Graphics2D g = this.getGraphics();
        image.drawImage(g, x, y, null, true);
        g.dispose();
    }

    void drawImage(Graphics2D g, int x, int y, ImageObserver observer, boolean useTransparency) {
        float opacity;
        Composite oldComposite = null;
        if (useTransparency && (opacity = (float)this.getTransparency() / 255.0f) < 1.0f) {
            if (opacity < 0.0f) {
                opacity = 0.0f;
            }
            oldComposite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, opacity));
        }
        g.drawImage((Image)this.image, x, y, observer);
        if (oldComposite != null) {
            g.setComposite(oldComposite);
        }
    }

    public void setFont(Font f) {
        this.currentFont = f;
    }

    public Font getFont() {
        if (this.currentFont == null) {
            this.currentFont = this.getGraphics().getFont();
        }
        return this.currentFont;
    }

    public void setColor(Color color) {
        this.currentColor = color;
    }

    public Color getColor() {
        return this.currentColor;
    }

    public Color getColorAt(int x, int y) {
        return new Color(this.getRGBAt(x, y), true);
    }

    public void setColorAt(int x, int y, Color color) {
        this.setRGBAt(x, y, color.getRGB());
    }

    public void setTransparency(int t) {
        if (t < 0 || t > 255) {
            throw new IllegalArgumentException("The transparency value has to be in the range 0 to 255. It was: " + t);
        }
        this.transparency = t;
    }

    public int getTransparency() {
        return this.transparency;
    }

    private int getRGBAt(int x, int y) {
        if (x >= this.getWidth()) {
            throw new IndexOutOfBoundsException("X is out of bounds. It was: " + x + " and it should have been smaller than: " + this.getWidth());
        }
        if (y >= this.getHeight()) {
            throw new IndexOutOfBoundsException("Y is out of bounds. It was: " + y + " and it should have been smaller than: " + this.getHeight());
        }
        if (x < 0) {
            throw new IndexOutOfBoundsException("X is out of bounds. It was: " + x + " and it should have been at least: 0");
        }
        if (y < 0) {
            throw new IndexOutOfBoundsException("Y is out of bounds. It was: " + y + " and it should have been at least: 0");
        }
        return this.image.getRGB(x, y);
    }

    private void setRGBAt(int x, int y, int rgb) {
        if (x >= this.getWidth()) {
            throw new IndexOutOfBoundsException("X is out of bounds. It was: " + x + " and it should have been smaller than: " + this.getWidth());
        }
        if (y >= this.getHeight()) {
            throw new IndexOutOfBoundsException("Y is out of bounds. It was: " + y + " and it should have been smaller than: " + this.getHeight());
        }
        if (x < 0) {
            throw new IndexOutOfBoundsException("X is out of bounds. It was: " + x + " and it should have been at least: 0");
        }
        if (y < 0) {
            throw new IndexOutOfBoundsException("Y is out of bounds. It was: " + y + " and it should have been at least: 0");
        }
        this.ensureWritableImage();
        this.image.setRGB(x, y, rgb);
    }

    public void fillRect(int x, int y, int width, int height) {
        Graphics2D g = this.getGraphics();
        g.fillRect(x, y, width, height);
        g.dispose();
    }

    public void clear() {
        Graphics2D g = this.getGraphics();
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.dispose();
    }

    public void drawRect(int x, int y, int width, int height) {
        Graphics2D g = this.getGraphics();
        g.drawRect(x, y, width, height);
        g.dispose();
    }

    public void drawString(String string, int x, int y) {
        Graphics2D g = this.getGraphics();
        g.drawString(string, x, y);
        g.dispose();
    }

    public void drawShape(Shape shape) {
        Graphics2D g = this.getGraphics();
        g.draw(shape);
        g.dispose();
    }

    public void fillShape(Shape shape) {
        Graphics2D g = this.getGraphics();
        g.fill(shape);
        g.dispose();
    }

    public void fillOval(int x, int y, int width, int height) {
        Graphics2D g = this.getGraphics();
        g.fillOval(x, y, width, height);
        g.dispose();
    }

    public void drawOval(int x, int y, int width, int height) {
        Graphics2D g = this.getGraphics();
        g.drawOval(x, y, width, height);
        g.dispose();
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Graphics2D g = this.getGraphics();
        g.fillPolygon(xPoints, yPoints, nPoints);
        g.dispose();
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Graphics2D g = this.getGraphics();
        g.drawPolygon(xPoints, yPoints, nPoints);
        g.dispose();
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Graphics2D g = this.getGraphics();
        g.drawLine(x1, y1, x2, y2);
        g.dispose();
    }

    public String toString() {
        String superString = super.toString();
        if (this.imageFileName == null) {
            return superString;
        }
        return "Image file name: " + this.imageFileName + "   Image url: " + this.imageUrl + "  " + superString;
    }

    static boolean equal(GreenfootImage image1, GreenfootImage image2) {
        if (image1 == null || image2 == null) {
            return image1 == image2;
        }
        return image1.image == image2.image || image1.equals(image2);
    }

    private void ensureWritableImage() {
        if (this.copyOnWrite) {
            BufferedImage bImage = GraphicsUtilities.createCompatibleTranslucentImage(this.image.getWidth(null), this.image.getHeight(null));
            Graphics2D graphics = bImage.createGraphics();
            this.initGraphics(graphics);
            graphics.drawImage((Image)this.image, 0, 0, null);
            this.image = bImage;
            this.copyOnWrite = false;
            graphics.dispose();
        }
    }

    private static BufferedImage getBufferedImage(Image image) {
        if (!(image instanceof BufferedImage)) {
            if (image instanceof VolatileImage) {
                image = ((VolatileImage)image).getSnapshot();
                GreenfootImage.waitForImageLoad(image);
            } else {
                GreenfootImage.waitForImageLoad(image);
                BufferedImage bImage = GraphicsUtilities.createCompatibleTranslucentImage(image.getWidth(null), image.getHeight(null));
                Graphics g = bImage.getGraphics();
                g.drawImage(image, 0, 0, null);
                image = bImage;
            }
        }
        return (BufferedImage)image;
    }

    private static void waitForImageLoad(Image image) {
        if (tracker == null) {
            tracker = new MediaTracker(new Component(){});
        }
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
            tracker.removeImage(image);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

