/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.ClientConfig;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.VersionID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;

public class SecurityBaseline {
    private static String baseline_131 = "1.3.1_21";
    private static String baseline_142 = "1.4.2_43";
    private static String baseline_150 = "1.5.0_45";
    private static String baseline_160 = "1.6.0_45";
    private static String baseline_170 = "1.7.0_21";
    private static String baseline_180 = "1.8.0";
    private static boolean baselines_initialized = false;
    private static final boolean DEBUG = Config.getBooleanProperty("deployment.baseline.debug");
    private static final long UPDATE_INTERVAL = DEBUG ? 10000 : 86400000;
    private static final long THREAD_SLEEP_INTERVAL = DEBUG ? 1000 : 30000;
    private static final String BASELINE_FILENAME = "baseline.versions";
    private static final String UPDATE_TIMESTAMP = "update.timestamp";
    private static final File securityDir = new File(Config.getUserHome(), "security");
    private static final File baselineFile = new File(securityDir, "baseline.versions");
    private static final File blacklistFile = new File(Config.getDynamicBlacklistFile());
    private static final File blacklistCertsFile = new File(Config.getDynamicBlacklistCertsFile());
    private static final File updateTimestampFile = new File(securityDir, "update.timestamp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initialize_baselines() {
        block20: {
            if (!baselines_initialized && baselineFile.exists()) {
                BufferedReader bufferedReader;
                block19: {
                    bufferedReader = null;
                    long l = System.currentTimeMillis();
                    bufferedReader = new BufferedReader(new FileReader(baselineFile));
                    boolean bl = false;
                    while (!bl) {
                        String string = bufferedReader.readLine();
                        if (string == null) {
                            bl = true;
                            continue;
                        }
                        if (string.startsWith("1.8")) {
                            baseline_180 = string;
                            Platform.get().cacheSecurityBaseline("1.8.0", baseline_180);
                            continue;
                        }
                        if (string.startsWith("1.7")) {
                            baseline_170 = string;
                            Platform.get().cacheSecurityBaseline("1.7.0", baseline_170);
                            continue;
                        }
                        if (string.startsWith("1.6")) {
                            baseline_160 = string;
                            Platform.get().cacheSecurityBaseline("1.6.0", baseline_160);
                            continue;
                        }
                        if (string.startsWith("1.5")) {
                            baseline_150 = string;
                            Platform.get().cacheSecurityBaseline("1.5.0", baseline_150);
                            continue;
                        }
                        if (string.startsWith("1.4.2")) {
                            baseline_142 = string;
                            Platform.get().cacheSecurityBaseline("1.4.2", baseline_142);
                            continue;
                        }
                        if (!string.startsWith("1.3.1")) continue;
                        baseline_131 = string;
                        Platform.get().cacheSecurityBaseline("1.3.1", baseline_131);
                    }
                    if (!DEBUG) break block19;
                    Trace.println("It took " + (System.currentTimeMillis() - l) + " Ms. to read baseline file", TraceLevel.BASIC);
                }
                Object var6_5 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block20;
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
                break block20;
                {
                    catch (Exception exception) {
                        Trace.ignored(exception);
                        Object var6_6 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            break block20;
                        }
                        catch (IOException iOException) {
                            Trace.ignored(iOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                    throw throwable;
                }
            }
        }
        baselines_initialized = true;
    }

    public static String getBaselineVersion(String string) {
        if (!baselines_initialized) {
            SecurityBaseline.initialize_baselines();
        }
        String string2 = string.startsWith("1.8") ? baseline_180 : (string.startsWith("1.7") ? baseline_170 : (string.startsWith("1.6") ? baseline_160 : (string.startsWith("1.5") ? baseline_150 : (string.startsWith("1.4.2") ? baseline_142 : (string.startsWith("1.3.1") ? baseline_131 : "1.7.0_21")))));
        if (DEBUG) {
            Trace.println("for requested version: " + string + "baseline version is: " + string2, TraceLevel.SECURITY);
        }
        return string2;
    }

    public static boolean satisfiesSecurityBaseline(String string) {
        VersionID versionID = new VersionID(string);
        VersionID versionID2 = new VersionID(SecurityBaseline.getBaselineVersion(string));
        if (versionID.isGreaterThanOrEqual(versionID2)) {
            return true;
        }
        return versionID.equals(JREInfo.getLatestVersion(true));
    }

    public static boolean satisfiesBaselineStrictly(String string) {
        int n = string.indexOf("-");
        String string2 = n > 0 ? string.substring(0, n) : string;
        VersionID versionID = new VersionID(string2);
        VersionID versionID2 = new VersionID(SecurityBaseline.getBaselineVersion(string));
        boolean bl = versionID.isGreaterThanOrEqual(versionID2);
        if (DEBUG) {
            Trace.println("strictly satisfied=" + bl + "  for version: " + string + "  baseline is: " + SecurityBaseline.getBaselineVersion(string));
        }
        return bl;
    }

    public static String getDeployVersion() {
        return "10.21.2.12";
    }

    public static String getDeployNoBuildVersion() {
        return "10.21.2";
    }

    public static String getDeployNoDotVersion() {
        return "10212";
    }

    public static String getCurrentVersion() {
        return "1.7.0_21";
    }

    public static String getCurrentNoDotVersion() {
        return "170";
    }

    private static synchronized void checkForUpdates(boolean bl) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (SecurityBaseline.checkForUpdate(Config.getStringProperty("deployment.baseline.url"), baselineFile)) {
                    Config config;
                    SecurityBaseline.initialize_baselines();
                    if (SecurityBaseline.isExpired() && (config = Config.get()) instanceof ClientConfig) {
                        ((ClientConfig)config).storeConfig();
                    }
                }
            }
        });
        thread.setDaemon(!bl);
        thread.start();
        thread = new Thread(new Runnable(){

            public void run() {
                SecurityBaseline.checkForUpdate(Config.getStringProperty("deployment.blacklist.url"), blacklistFile);
            }
        });
        thread.setDaemon(!bl);
        thread.start();
        thread = new Thread(new Runnable(){

            public void run() {
                SecurityBaseline.checkForUpdate(Config.getStringProperty("deployment.blacklisted.certs.url"), blacklistCertsFile);
            }
        });
        thread.setDaemon(!bl);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkForUpdate(String var0, File var1_1) {
        if (var0 == null) return false;
        if (var0.length() <= 0) return false;
        var2_2 = 0L;
        if (var1_1.exists()) {
            var2_2 = var1_1.lastModified();
        }
        var4_3 = null;
        var5_4 = null;
        try {
            Trace.println("Checking for update at: " + var0, TraceLevel.NETWORK);
            var6_5 = new URL(var0);
            var7_7 = var6_5.openConnection();
            var7_7.setUseCaches(false);
            if (var7_7.getLastModified() < var2_2) ** GOTO lbl75
            Trace.println("Updating file at: " + var1_1 + " from url: " + var0, TraceLevel.NETWORK);
            var4_3 = var7_7.getInputStream();
            var5_4 = new FileOutputStream(var1_1);
            var8_8 = new byte[8192];
            while ((var9_9 = var4_3.read(var8_8)) != -1) {
                var5_4.write(var8_8, 0, var9_9);
            }
            var10_10 = true;
            var12_11 = null;
            if (var5_4 == null) ** GOTO lbl67
            ** GOTO lbl62
        }
        catch (Exception var6_6) {
            Trace.ignored(var6_6);
            var12_13 = null;
            if (var5_4 != null) {
                try {
                    var5_4.close();
                }
                catch (Exception var13_17) {
                    Trace.ignored(var13_17);
                }
            }
            if (var4_3 == null) return false;
            try {
                var4_3.close();
                return false;
            }
            catch (Exception var13_17) {
                Trace.ignored(var13_17);
                return false;
            }
        }
        {
            block23: {
                block24: {
                    catch (Throwable var11_19) {
                        block22: {
                            var12_14 = null;
                            if (var5_4 != null) {
                                ** try [egrp 2[TRYBLOCK] [5 : 217->225)] { 
lbl50:
                                // 1 sources

                                var5_4.close();
                                break block22;
lbl52:
                                // 1 sources

                                catch (Exception var13_18) {
                                    Trace.ignored(var13_18);
                                }
                            }
                        }
                        if (var4_3 == null) throw var11_19;
                        ** try [egrp 3[TRYBLOCK] [6 : 237->245)] { 
lbl57:
                        // 1 sources

                        var4_3.close();
                        throw var11_19;
lbl59:
                        // 1 sources

                        catch (Exception var13_18) {
                            Trace.ignored(var13_18);
                        }
                        throw var11_19;
                    }
lbl62:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [5 : 217->225)] { 
lbl63:
                    // 1 sources

                    var5_4.close();
                    break block24;
lbl65:
                    // 1 sources

                    catch (Exception var13_15) {
                        Trace.ignored(var13_15);
                    }
                }
                if (var4_3 == null) return var10_10;
                try {}
                catch (Exception var13_15) {
                    Trace.ignored(var13_15);
                    return var10_10;
                }
                var4_3.close();
                return var10_10;
lbl75:
                // 1 sources

                var12_12 = null;
                if (var5_4 != null) {
                    ** try [egrp 2[TRYBLOCK] [5 : 217->225)] { 
lbl78:
                    // 1 sources

                    var5_4.close();
                    break block23;
lbl80:
                    // 1 sources

                    catch (Exception var13_16) {
                        Trace.ignored(var13_16);
                    }
                }
            }
            if (var4_3 == null) return false;
            try {}
            catch (Exception var13_16) {}
            Trace.ignored(var13_16);
            return false;
            var4_3.close();
            return false;
        }
    }

    private static long getLastChecked() {
        if (updateTimestampFile.exists()) {
            return updateTimestampFile.lastModified();
        }
        return 0L;
    }

    private static void setLastChecked(long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(updateTimestampFile);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void backgroundUpdate() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                long l = new Date().getTime();
                if (l > SecurityBaseline.getLastChecked() + UPDATE_INTERVAL) {
                    try {
                        Thread.sleep(THREAD_SLEEP_INTERVAL);
                        SecurityBaseline.checkForUpdates(false);
                        SecurityBaseline.setLastChecked(l);
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                    }
                }
                if (DEBUG) {
                    Trace.println("Baseline/Blacklist thread exiting time: " + (new Date().getTime() - l), TraceLevel.BASIC);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void forceBaselineUpdate() {
        SecurityBaseline.checkForUpdates(true);
        SecurityBaseline.initialize_baselines();
        SecurityBaseline.setLastChecked(new Date().getTime());
    }

    public static boolean isExpired() {
        Date date;
        if (Config.isJavaVersionAtLeast15()) {
            if (System.getenv("JRE_NOTEXPIRED") != null) {
                return false;
            }
            if (System.getenv("JRE_EXPIRED") != null) {
                return true;
            }
        }
        if ((date = new Date(BuiltInProperties.expirationTime)).before(new Date())) {
            return true;
        }
        return !SecurityBaseline.satisfiesBaselineStrictly(JREInfo.getLatest());
    }

    static {
        securityDir.mkdirs();
        SecurityBaseline.backgroundUpdate();
    }
}

