/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeSuper;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.JavaType;
import bluej.utility.Debug;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import bluej.utility.JavaUtils14;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaUtils15
extends JavaUtils {
    public String getDescription(Method method, String[] paramnames, Map<String, ? extends GenTypeParameter> tparams, boolean longDesc) throws ClassNotFoundException {
        if (tparams == null) {
            String name = JavaUtils14.getTypeName(method.getReturnType()) + " " + method.getName();
            Class<?>[] params = method.getParameterTypes();
            String[] paramTypes = JavaUtils14.getParameterTypes(params);
            return JavaUtils15.makeDescription(name, paramTypes, paramnames, longDesc, false);
        }
        HashMap<String, ? extends GenTypeParameter> newMap = new HashMap<String, GenTypeParameter>(tparams);
        List<GenTypeDeclTpar> myParams = this.getTypeParams(method);
        for (GenTypeDeclTpar tpar : myParams) {
            newMap.put(tpar.getTparName(), tpar);
        }
        String name = JavaUtils15.getTypeParameters(method);
        JavaType rtype = this.getReturnType(method);
        name = name + rtype.mapTparsToTypes(newMap).toString(true) + " " + method.getName();
        JavaType[] paramTypes = this.getParamGenTypes(method, false);
        String[] paramTypeNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypeNames[i] = paramTypes[i].mapTparsToTypes(newMap).toString(true);
        }
        return JavaUtils15.makeDescription(name, paramTypeNames, paramnames, longDesc, method.isVarArgs());
    }

    @Override
    public String getShortDesc(Method method, String[] paramnames, Map<String, GenTypeParameter> tparams) throws ClassNotFoundException {
        return this.getDescription(method, paramnames, tparams, false);
    }

    @Override
    public String getLongDesc(Method method, String[] paramnames, Map<String, GenTypeParameter> tparams) throws ClassNotFoundException {
        return this.getDescription(method, paramnames, tparams, true);
    }

    @Override
    public String getShortDesc(Method method, String[] paramnames) throws ClassNotFoundException {
        try {
            String name = JavaUtils15.getTypeParameters(method);
            name = name + JavaUtils15.getTypeName(method.getGenericReturnType()) + " " + method.getName();
            Type[] paramTypes = method.getGenericParameterTypes();
            String[] paramTypeNames = this.getParameterTypes(paramTypes, false);
            return JavaUtils15.makeDescription(name, paramTypeNames, paramnames, false, method.isVarArgs());
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    @Override
    public String getLongDesc(Method method, String[] paramnames) throws ClassNotFoundException {
        try {
            String name = JavaUtils15.getTypeParameters(method);
            name = name + JavaUtils15.getTypeName(method.getGenericReturnType()) + " " + method.getName();
            Type[] paramTypes = method.getGenericParameterTypes();
            String[] paramTypeNames = this.getParameterTypes(paramTypes, false);
            return JavaUtils15.makeDescription(name, paramTypeNames, paramnames, true, method.isVarArgs());
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    public String getDescription(Constructor<?> constructor, String[] paramnames, boolean longDesc) throws ClassNotFoundException {
        String name = JavaUtils15.getTypeParameters(constructor);
        name = name + constructor.getName();
        name = name + JavaUtils15.typeParamsToString(constructor.getDeclaringClass().getTypeParameters(), false);
        Type[] paramTypes = constructor.getGenericParameterTypes();
        String[] paramTypeNames = this.getParameterTypes(paramTypes, false);
        return JavaUtils15.makeDescription(name, paramTypeNames, paramnames, longDesc, constructor.isVarArgs());
    }

    @Override
    public String getShortDesc(Constructor<?> constructor, String[] paramnames) throws ClassNotFoundException {
        return this.getDescription(constructor, paramnames, false);
    }

    @Override
    public String getLongDesc(Constructor<?> constructor, String[] paramnames) throws ClassNotFoundException {
        return this.getDescription(constructor, paramnames, true);
    }

    @Override
    public boolean isVarArgs(Constructor<?> cons) {
        return cons.isVarArgs();
    }

    @Override
    public boolean isVarArgs(Method method) {
        return method.isVarArgs();
    }

    @Override
    public boolean isSynthetic(Method method) {
        return method.isSynthetic();
    }

    @Override
    public boolean isEnum(Class<?> cl) {
        return cl.isEnum();
    }

    @Override
    public JavaType getReturnType(Method method) throws ClassNotFoundException {
        try {
            Type rt = method.getGenericReturnType();
            return JavaUtils15.genTypeFromType(rt);
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    @Override
    public JavaType getRawReturnType(Method method) {
        Class<?> c = method.getReturnType();
        return JavaUtils.genTypeFromClass(c);
    }

    @Override
    public JavaType getFieldType(Field field) throws ClassNotFoundException {
        try {
            return JavaUtils15.genTypeFromType(field.getGenericType());
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    @Override
    public JavaType getRawFieldType(Field field) {
        Class<?> c = field.getType();
        return JavaUtils.genTypeFromClass(c);
    }

    @Override
    public List<GenTypeDeclTpar> getTypeParams(Method method) {
        return this.getTypeParams((GenericDeclaration)method);
    }

    @Override
    public List<GenTypeDeclTpar> getTypeParams(Constructor<?> cons) {
        return this.getTypeParams((GenericDeclaration)cons);
    }

    @Override
    public List<GenTypeDeclTpar> getTypeParams(Class<?> cl) {
        return this.getTypeParams((GenericDeclaration)cl);
    }

    @Override
    public GenTypeClass getSuperclass(Class<?> cl) throws ClassNotFoundException {
        try {
            Type sc = cl.getGenericSuperclass();
            if (sc == null) {
                return null;
            }
            return (GenTypeClass)JavaUtils15.genTypeFromType(sc);
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    @Override
    public GenTypeClass[] getInterfaces(Class<?> cl) throws ClassNotFoundException {
        try {
            Type[] classes = cl.getGenericInterfaces();
            GenTypeClass[] gentypes = new GenTypeClass[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                gentypes[i] = (GenTypeClass)JavaUtils15.genTypeFromType(classes[i]);
            }
            return gentypes;
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    @Override
    public String[] getParameterTypes(Method method) throws ClassNotFoundException {
        try {
            Type[] params = method.getGenericParameterTypes();
            boolean isVarArgs = this.isVarArgs(method);
            return this.getParameterTypes(params, isVarArgs);
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    @Override
    public JavaType[] getParamGenTypes(Method method, boolean raw) throws ClassNotFoundException {
        try {
            Type[] params = raw ? method.getParameterTypes() : method.getGenericParameterTypes();
            JavaType[] gentypes = new JavaType[params.length];
            for (int i = 0; i < params.length; ++i) {
                gentypes[i] = JavaUtils15.genTypeFromType(params[i]);
            }
            return gentypes;
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    @Override
    public String[] getParameterTypes(Constructor<?> constructor) throws ClassNotFoundException {
        try {
            Type[] params = constructor.getGenericParameterTypes();
            boolean isVarArgs = this.isVarArgs(constructor);
            return this.getParameterTypes(params, isVarArgs);
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    @Override
    public JavaType[] getParamGenTypes(Constructor<?> constructor) throws ClassNotFoundException {
        try {
            Type[] params = constructor.getGenericParameterTypes();
            JavaType[] gentypes = new JavaType[params.length];
            for (int i = 0; i < params.length; ++i) {
                gentypes[i] = JavaUtils15.genTypeFromType(params[i]);
            }
            return gentypes;
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    private List<GenTypeDeclTpar> getTypeParams(GenericDeclaration decl) {
        ArrayList<GenTypeDeclTpar> rlist = new ArrayList<GenTypeDeclTpar>();
        TypeVariable<?>[] tvars = decl.getTypeParameters();
        HashMap<String, GenTypeDeclTpar> tvarMap = new HashMap<String, GenTypeDeclTpar>();
        for (TypeVariable<?> tvar : tvars) {
            tvarMap.put(tvar.getName(), new GenTypeDeclTpar(tvar.getName()));
        }
        for (int i = 0; i < tvars.length; ++i) {
            Type[] bounds = tvars[i].getBounds();
            GenTypeSolid[] upperBounds = new GenTypeSolid[bounds.length];
            for (int j = 0; j < bounds.length; ++j) {
                upperBounds[j] = (GenTypeSolid)JavaUtils15.genTypeFromType(bounds[j], tvarMap);
            }
            GenTypeDeclTpar tpar = (GenTypeDeclTpar)tvarMap.get(tvars[i].getName());
            tpar.setBounds(upperBounds);
            rlist.add(tpar);
        }
        return rlist;
    }

    private String[] getParameterTypes(Type[] params, boolean isVarArgs) throws ClassNotFoundException {
        String[] parameterTypes = new String[params.length];
        for (int j = 0; j < params.length; ++j) {
            String typeName = JavaUtils15.getTypeName(params[j]);
            if (isVarArgs && j == params.length - 1) {
                typeName = JavaUtils15.createVarArg(typeName);
            }
            parameterTypes[j] = typeName;
        }
        return parameterTypes;
    }

    private static String getTypeName(Type type) throws ClassNotFoundException {
        try {
            StringBuffer sb = new StringBuffer();
            Type primtype = type;
            int dimensions = 0;
            while (primtype instanceof GenericArrayType) {
                ++dimensions;
                primtype = ((GenericArrayType)primtype).getGenericComponentType();
            }
            if (primtype instanceof Class) {
                sb.append(JavaUtils14.getTypeName((Class)primtype));
            } else if (primtype instanceof ParameterizedType) {
                sb.append(JavaUtils15.getTypeName((ParameterizedType)primtype));
            } else if (primtype instanceof TypeVariable) {
                sb.append(((TypeVariable)primtype).getName());
            } else if (primtype instanceof WildcardType) {
                sb.append(JavaUtils15.getTypeName((WildcardType)primtype));
            } else {
                Debug.message("getTypeName(): Unknown type: " + primtype.getClass().getName());
            }
            while (dimensions > 0) {
                sb.append("[]");
                --dimensions;
            }
            return sb.toString();
        }
        catch (TypeNotPresentException tnpe) {
            throw new ClassNotFoundException(tnpe.typeName(), tnpe.getCause());
        }
    }

    private static String getTypeName(ParameterizedType type) throws ClassNotFoundException {
        StringBuffer sb = new StringBuffer();
        sb.append(JavaUtils15.getTypeName(type.getRawType()));
        sb.append('<');
        Type[] argTypes = type.getActualTypeArguments();
        for (int i = 0; i < argTypes.length; ++i) {
            sb.append(JavaUtils15.getTypeName(argTypes[i]));
            if (i == argTypes.length - 1) continue;
            sb.append(',');
        }
        sb.append('>');
        return sb.toString();
    }

    private static String getTypeName(WildcardType type) throws ClassNotFoundException {
        StringBuffer sb = new StringBuffer();
        Type[] upperBounds = type.getUpperBounds();
        Type[] lowerBounds = type.getLowerBounds();
        if (lowerBounds.length == 0 || lowerBounds[0] == null) {
            if (upperBounds.length == 0 || upperBounds[0] == null || upperBounds[0].equals(Object.class)) {
                sb.append("?");
            } else {
                sb.append("? extends ");
                sb.append(JavaUtils15.getTypeName(upperBounds[0]));
                if (upperBounds.length != 1) {
                    Debug.message("getTypeName: multiple upper bounds for wildcard type?");
                }
            }
        } else {
            sb.append("? super ");
            if (lowerBounds[0] == null) {
                Debug.message("lower bound[0] is null??");
                sb.append("[null type]");
            } else {
                sb.append(JavaUtils15.getTypeName(lowerBounds[0]));
            }
            if (upperBounds.length != 0 && upperBounds[0] != null && upperBounds[0] != Object.class) {
                Debug.message("getTypeName: upper and lower bound?");
                Debug.message("upper bound is: " + upperBounds[0]);
            }
            if (lowerBounds.length != 1) {
                Debug.message("getTypeName: multiple lower bounds for wildcard type?");
            }
        }
        return sb.toString();
    }

    private static String createVarArg(String typeName) {
        String lastArrayStripped = typeName.substring(0, typeName.length() - 2);
        return lastArrayStripped + " ...";
    }

    private static String getTypeParameters(Method method) throws ClassNotFoundException {
        return JavaUtils15.typeParamsToString(method.getTypeParameters(), true);
    }

    private static String getTypeParameters(Constructor<?> cons) throws ClassNotFoundException {
        return JavaUtils15.typeParamsToString(cons.getTypeParameters(), true);
    }

    private static String typeParamsToString(TypeVariable<?>[] tparams, boolean extraSpace) throws ClassNotFoundException {
        if (tparams.length != 0) {
            String name = "<";
            for (int i = 0; i < tparams.length; ++i) {
                TypeVariable<?> type = tparams[i];
                name = name + type.getName();
                Type[] upperBounds = type.getBounds();
                if (upperBounds.length != 0 && upperBounds[0] != null && !upperBounds[0].equals(Object.class)) {
                    name = name + " extends " + JavaUtils15.getTypeName(upperBounds[0]);
                    for (int j = 1; j < upperBounds.length; ++j) {
                        name = name + " & " + JavaUtils15.getTypeName(upperBounds[j]);
                    }
                }
                if (i == tparams.length - 1) continue;
                name = name + ',';
            }
            name = name + ">";
            if (extraSpace) {
                name = name + " ";
            }
            return name;
        }
        return "";
    }

    private static JavaType genTypeFromType(Type t) {
        return (JavaType)JavaUtils15.genTypeFromType(t, new HashMap());
    }

    private static GenTypeParameter genTypeFromType(Type t, Map<String, ? extends GenTypeParameter> tvars) {
        if (t instanceof Class) {
            return JavaUtils.genTypeFromClass((Class)t);
        }
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            GenTypeParameter existingTpar = tvars.get(tv.getName());
            if (existingTpar != null) {
                return existingTpar;
            }
            return new GenTypeTpar(tv.getName());
        }
        if (t instanceof WildcardType) {
            WildcardType wtype = (WildcardType)t;
            Type[] upperBounds = wtype.getUpperBounds();
            Type[] lowerBounds = wtype.getLowerBounds();
            if (lowerBounds.length == 0 || lowerBounds[0] == null) {
                if (upperBounds.length == 0 || upperBounds[0] == null) {
                    return new GenTypeUnbounded();
                }
                GenTypeSolid gtp = (GenTypeSolid)JavaUtils15.genTypeFromType(upperBounds[0], tvars);
                if (upperBounds.length != 1) {
                    Debug.message("GenTypeFromType: multiple upper bounds for wildcard type?");
                }
                return new GenTypeExtends(gtp);
            }
            if (upperBounds.length != 0 && upperBounds[0] != null && upperBounds[0] != Object.class) {
                Debug.message("getTypeName: upper and lower bound?");
            }
            if (lowerBounds.length != 1) {
                Debug.message("getTypeName: multiple lower bounds for wildcard type?");
            }
            GenTypeParameter lbound = JavaUtils15.genTypeFromType(lowerBounds[0], tvars);
            return new GenTypeSuper((GenTypeSolid)lbound);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            Class rawtype = (Class)pt.getRawType();
            Type[] argtypes = pt.getActualTypeArguments();
            ArrayList<GenTypeParameter> arggentypes = new ArrayList<GenTypeParameter>();
            for (int i = 0; i < argtypes.length; ++i) {
                arggentypes.add(JavaUtils15.genTypeFromType(argtypes[i], tvars));
            }
            GenTypeClass outer = null;
            if (pt.getOwnerType() != null) {
                outer = (GenTypeClass)JavaUtils15.genTypeFromType(pt.getOwnerType());
            }
            return new GenTypeClass(new JavaReflective(rawtype), arggentypes, outer);
        }
        GenericArrayType gat = (GenericArrayType)t;
        JavaType componentType = (JavaType)JavaUtils15.genTypeFromType(gat.getGenericComponentType(), tvars);
        return componentType.getArray();
    }
}

