/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.Config;
import bluej.terminal.ExceptionSourceLocation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class TerminalView
extends PlainView {
    public static final String METHOD_RECORD = "method-record";
    public static final String FOREIGN_STACK_TRACE = "foreign-stack-trace";
    public static final String SOURCE_LOCATION = "source-location";
    private static final Color STDOUT_TEXT_COLOR = Color.BLACK;
    private static final Color STDERR_TEXT_COLOR = Color.RED;
    private static final Color STACK_LOCAL_TEXT_COLOR = new Color(255, 96, 96);
    private static final Color STACK_FOREIGN_TEXT_COLOR = Color.LIGHT_GRAY;
    private static final Color METHOD_RECORD_COLOR = Config.ENV_COLOUR;

    public TerminalView(Element el, boolean isStderr) {
        super(el);
    }

    public static Color getDefaultColor(boolean isStderr) {
        return isStderr ? STDERR_TEXT_COLOR : STDOUT_TEXT_COLOR;
    }

    @Override
    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Map hints = (Map)tk.getDesktopProperty("awt.font.desktophints");
            if (hints != null && g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.addRenderingHints(hints);
            }
            Document doc = this.getDocument();
            int elementIndex = doc.getDefaultRootElement().getElementIndex(p0);
            Element el = doc.getDefaultRootElement().getElement(elementIndex);
            AttributeSet attrs = el.getAttributes();
            if (attrs != null && (attrs.getAttribute(METHOD_RECORD) != null || attrs.getAttribute(FOREIGN_STACK_TRACE) != null)) {
                g.setColor(attrs.getAttribute(METHOD_RECORD) != null ? METHOD_RECORD_COLOR : STACK_FOREIGN_TEXT_COLOR);
                Segment s = new Segment();
                doc.getText(p0, p1 - p0, s);
                return Utilities.drawTabbedText(s, x, y, g, (TabExpander)this, p0);
            }
            if (attrs != null && attrs.getAttribute(SOURCE_LOCATION) != null) {
                ExceptionSourceLocation esl = (ExceptionSourceLocation)attrs.getAttribute(SOURCE_LOCATION);
                Segment s = new Segment();
                g.setColor(STACK_LOCAL_TEXT_COLOR);
                int startUnderline = Math.max(p0, Math.min(esl.getStart(), p1));
                int endUnderline = Math.max(p0, Math.min(esl.getEnd(), p1));
                if (p0 < esl.getStart()) {
                    doc.getText(p0, startUnderline - p0, s);
                    x = Utilities.drawTabbedText(s, x, y, g, (TabExpander)this, p0);
                }
                if (p0 < esl.getEnd() && p1 > esl.getStart()) {
                    int startX = x;
                    doc.getText(startUnderline, endUnderline - startUnderline, s);
                    x = Utilities.drawTabbedText(s, x, y, g, (TabExpander)this, startUnderline);
                    g.drawLine(startX, y + 1, x, y + 1);
                }
                if (p1 > esl.getEnd()) {
                    doc.getText(endUnderline, p1 - endUnderline, s);
                    x = Utilities.drawTabbedText(s, x, y, g, (TabExpander)this, endUnderline);
                }
                return x;
            }
            return super.drawUnselectedText(g, x, y, p0, p1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

