/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.terminal.ExceptionSourceLocation;
import bluej.utility.JavaNames;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public class TerminalDocument
extends AbstractDocument {
    Element root = this.createDefaultRoot();
    private boolean highlightSourceLinks;
    private Project project;

    public TerminalDocument(Project project, boolean highlightSourceLinks) {
        super(new GapContent());
        this.project = project;
        this.highlightSourceLinks = highlightSourceLinks;
    }

    public void markLineAsMethodOutput(int line) {
        this.writeLock();
        Element el = this.root.getElement(line);
        MutableAttributeSet attr = (MutableAttributeSet)el.getAttributes();
        attr.addAttribute("method-record", true);
        this.writeUnlock();
    }

    @Override
    public Element getDefaultRootElement() {
        return this.root;
    }

    @Override
    public Element getParagraphElement(int pos) {
        int index = this.root.getElementIndex(pos);
        return this.root.getElement(index);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.BranchElement map = (AbstractDocument.BranchElement)this.createBranchElement(null, null);
        Element[] lines = new Element[]{new LeafElement(map, null, 0, 1)};
        map.replace(0, 0, lines);
        return map;
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        AbstractDocument.BranchElement lineMap = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int offset = chng.getOffset();
        int length = chng.getLength();
        Segment s = new Segment();
        try {
            this.getText(offset, length, s);
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
        int index = lineMap.getElementIndex(offset);
        LeafElement firstAffected = (LeafElement)lineMap.getElement(index);
        int lindex = lineMap.getElementIndex(offset + length);
        LeafElement nextLine = (LeafElement)lineMap.getElement(lindex);
        if (offset > 0 && offset + length == nextLine.getStartOffset()) {
            firstAffected.setEndOffset(offset);
            nextLine.setStartOffset(offset);
            firstAffected = nextLine;
            nextLine = (LeafElement)lineMap.getElement(lindex + 1);
        }
        ArrayList<LeafElement> added = new ArrayList<LeafElement>();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            int origEnd = firstAffected.getEndOffset();
            firstAffected.setEndOffset(i + offset + 1);
            LeafElement newFirst = new LeafElement(this.root, attr, i + offset + 1, origEnd);
            added.add(newFirst);
            firstAffected = newFirst;
        }
        if (!added.isEmpty()) {
            Element[] removed = new Element[]{};
            Element[] addedArr = new Element[added.size()];
            added.toArray(addedArr);
            lineMap.replace(lindex + 1, 0, addedArr);
            AbstractDocument.ElementEdit ee = new AbstractDocument.ElementEdit(lineMap, lindex + 1, removed, addedArr);
            chng.addEdit(ee);
        }
        if (this.highlightSourceLinks) {
            this.scanForStackTrace();
        }
        super.insertUpdate(chng, attr);
    }

    private void scanForStackTrace() {
        try {
            MutableAttributeSet attr;
            Element el;
            int elementIndex;
            String content = this.getText(0, this.getLength());
            Pattern p = Pattern.compile("at (\\S+)\\((\\S+)\\.java:(\\d+)\\)");
            Matcher m = p.matcher(content);
            while (m.find()) {
                elementIndex = this.getDefaultRootElement().getElementIndex(m.start());
                el = this.getDefaultRootElement().getElement(elementIndex);
                attr = (MutableAttributeSet)el.getAttributes();
                String fullyQualifiedMethodName = m.group(1);
                String javaFile = m.group(2);
                int lineNumber = Integer.parseInt(m.group(3));
                String fullyQualifiedClassName = JavaNames.getPrefix(fullyQualifiedMethodName);
                String packageName = JavaNames.getPrefix(fullyQualifiedClassName);
                Package pkg = this.project.getPackage(packageName);
                if (pkg != null && pkg.getAllClassnames().contains(javaFile)) {
                    attr.addAttribute("source-location", new ExceptionSourceLocation(m.start(1), m.end(), pkg, javaFile, lineNumber));
                    continue;
                }
                attr.addAttribute("foreign-stack-trace", true);
            }
            p = Pattern.compile("at \\S+\\(Native Method|Unknown Source\\)");
            m = p.matcher(content);
            while (m.find()) {
                elementIndex = this.getDefaultRootElement().getElementIndex(m.start());
                el = this.getDefaultRootElement().getElement(elementIndex);
                attr = (MutableAttributeSet)el.getAttributes();
                attr.addAttribute("foreign-stack-trace", true);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        AbstractDocument.BranchElement lineMap = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int offset = chng.getOffset();
        int length = chng.getLength();
        int index = lineMap.getElementIndex(offset);
        LeafElement first = (LeafElement)lineMap.getElement(index);
        if (first.getEndOffset() > offset + length) {
            return;
        }
        ArrayList<LeafElement> removed = new ArrayList<LeafElement>();
        int lastIndex = index + 1;
        LeafElement last = (LeafElement)lineMap.getElement(lastIndex);
        removed.add(last);
        while (last.getEndOffset() <= offset + length) {
            last = (LeafElement)lineMap.getElement(++lastIndex);
            removed.add(last);
        }
        first.end = last.end;
        lineMap.replace(index, lastIndex - index, new Element[0]);
        Element[] removedArr = new Element[removed.size()];
        removed.toArray(removedArr);
        AbstractDocument.ElementEdit ee = new AbstractDocument.ElementEdit(lineMap, index + 1, removedArr, new Element[0]);
        chng.addEdit(ee);
        super.removeUpdate(chng);
    }

    public class LeafElement
    extends AbstractDocument.AbstractElement {
        Position start;
        Position end;

        public LeafElement(Element parent, AttributeSet attrs, int startOffs, int endOffs) {
            super(TerminalDocument.this, parent, attrs);
            try {
                this.start = TerminalDocument.this.createPosition(startOffs);
                this.end = TerminalDocument.this.createPosition(endOffs);
            }
            catch (BadLocationException ble) {
                throw new RuntimeException(ble);
            }
        }

        @Override
        public int getStartOffset() {
            return this.start.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.end.getOffset();
        }

        public void setStartOffset(int offset) {
            try {
                this.start = TerminalDocument.this.createPosition(offset);
            }
            catch (BadLocationException ble) {
                throw new RuntimeException();
            }
        }

        public void setEndOffset(int offset) {
            try {
                this.end = TerminalDocument.this.createPosition(offset);
            }
            catch (BadLocationException ble) {
                throw new RuntimeException();
            }
        }

        @Override
        public int getElementCount() {
            return 0;
        }

        @Override
        public Element getElement(int index) {
            return null;
        }

        @Override
        public int getElementIndex(int offset) {
            return 0;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            return new Vector().elements();
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }
    }
}

