/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.filefilter.DirectoryFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InterfacePanel
extends JPanel
implements PrefPanelListener,
ActionListener,
ItemListener {
    private static final String toolkitDir = "bluej.javame.toolkit.dir";
    private JCheckBox showTestBox;
    private JCheckBox showTeamBox;
    private JCheckBox showJavaMEBox;
    private JLabel toolkitDirLabel;
    private JTextField toolkitDirField;
    private JButton toolkitBrowseButton;
    private ArrayList<String> allLangsInternal;
    private JComboBox langDropdown;

    public InterfacePanel() {
        String langString;
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        this.add(box);
        this.setBorder(BlueJTheme.generalBorder);
        box.add(Box.createVerticalGlue());
        if (!Config.isGreenfoot()) {
            box.add(Box.createVerticalStrut(5));
            JPanel testPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            testPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("prefmgr.misc.tools.title")), BlueJTheme.generalBorder));
            testPanel.setAlignmentX(0.0f);
            this.showTestBox = new JCheckBox(Config.getString("prefmgr.misc.showTesting"));
            testPanel.add(this.showTestBox);
            this.showTeamBox = new JCheckBox(Config.getString("prefmgr.misc.showTeam"));
            testPanel.add(this.showTeamBox);
            this.showJavaMEBox = new JCheckBox(Config.getString("prefmgr.misc.showJavaME"));
            testPanel.add(this.showJavaMEBox);
            JPanel toolkitPanel = new JPanel(new BorderLayout(5, 0));
            this.toolkitDirLabel = new JLabel(Config.getString("prefmgr.misc.wtk.dir.label"));
            this.toolkitDirField = new JTextField(15);
            this.toolkitBrowseButton = new JButton(Config.getString("prefmgr.misc.wtk.button"));
            toolkitPanel.add((Component)this.toolkitDirLabel, "West");
            toolkitPanel.add((Component)this.toolkitDirField, "Center");
            toolkitPanel.add((Component)this.toolkitBrowseButton, "East");
            testPanel.add(toolkitPanel);
            box.add(testPanel);
            box.add(Box.createVerticalStrut(5));
            this.showJavaMEBox.addItemListener(this);
            this.toolkitBrowseButton.addActionListener(this);
        }
        JPanel langPanel = new JPanel();
        langPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("prefmgr.interface.language.title")), BlueJTheme.generalBorder));
        langPanel.setAlignmentX(0.0f);
        langPanel.setLayout(new BoxLayout(langPanel, 1));
        Box langSelBox = new Box(0);
        langSelBox.add(new JLabel(Config.getString("prefmgr.interface.language") + ":"));
        langSelBox.add(Box.createHorizontalStrut(5));
        this.allLangsInternal = new ArrayList();
        ArrayList<String> allLangsReadable = new ArrayList<String>();
        int i = 1;
        while ((langString = Config.getPropString("bluej.language" + i, null)) != null) {
            int colonIndex = langString.indexOf(58);
            if (colonIndex != -1) {
                this.allLangsInternal.add(langString.substring(0, colonIndex));
                allLangsReadable.add(langString.substring(colonIndex + 1));
            }
            ++i;
        }
        String[] langs = new String[allLangsReadable.size()];
        allLangsReadable.toArray(langs);
        this.langDropdown = new JComboBox<String>(langs);
        langSelBox.add(this.langDropdown);
        langSelBox.setAlignmentX(0.0f);
        langPanel.add(langSelBox);
        langPanel.add(Box.createVerticalStrut(5));
        JLabel t = new JLabel(Config.getString("prefmgr.interface.language.restart"));
        t.setAlignmentX(0.0f);
        langPanel.add(t);
        box.add(langPanel);
    }

    @Override
    public void beginEditing() {
        String currentLang;
        int curLangIndex;
        if (!Config.isGreenfoot()) {
            this.showTestBox.setSelected(PrefMgr.getFlag("bluej.testing.showtools"));
            this.showTeamBox.setSelected(PrefMgr.getFlag("bluej.teamwork.showtools"));
            this.showJavaMEBox.setSelected(PrefMgr.getFlag("bluej.javame.showtools"));
            if (this.showJavaMEBox.isSelected()) {
                this.toolkitDirField.setText(Config.getPropString(toolkitDir, ""));
                this.enableToolkitPanel(true);
            } else {
                this.toolkitDirField.setText("");
                this.enableToolkitPanel(false);
            }
        }
        if ((curLangIndex = this.allLangsInternal.indexOf(currentLang = Config.getPropString("bluej.language", "english"))) == -1) {
            curLangIndex = 0;
        }
        this.langDropdown.setSelectedIndex(curLangIndex);
    }

    private void enableToolkitPanel(boolean b) {
        this.toolkitDirLabel.setEnabled(b);
        this.toolkitDirField.setEnabled(b);
        this.toolkitBrowseButton.setEnabled(b);
    }

    @Override
    public void commitEditing() {
        if (!Config.isGreenfoot()) {
            PrefMgr.setFlag("bluej.testing.showtools", this.showTestBox.isSelected());
            PrefMgr.setFlag("bluej.teamwork.showtools", this.showTeamBox.isSelected());
            PrefMgr.setFlag("bluej.javame.showtools", this.showJavaMEBox.isSelected());
            PkgMgrFrame.updateTestingStatus();
            PkgMgrFrame.updateTeamStatus();
            PkgMgrFrame.updateJavaMEstatus();
            String tkDir = this.toolkitDirField.getText();
            if (!tkDir.equals("")) {
                Config.putPropString(toolkitDir, tkDir);
            }
        }
        Config.putPropString("bluej.language", this.allLangsInternal.get(this.langDropdown.getSelectedIndex()));
    }

    @Override
    public void revertEditing() {
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.enableToolkitPanel(true);
            String toolkitDirectory = this.tryToFindToolkit();
            if (toolkitDirectory.equals("")) {
                this.letUserChooseToolkitDir();
                toolkitDirectory = this.toolkitDirField.getText().trim();
            } else {
                this.toolkitDirField.setText(toolkitDirectory);
            }
            this.checkCoreLibraryJars(toolkitDirectory);
        } else {
            this.enableToolkitPanel(false);
            this.toolkitDirField.setText("");
        }
    }

    private String tryToFindToolkit() {
        File[] roots = new File[]{new File(System.getProperty("user.home")), new File("/usr/local"), new File("/usr/lib")};
        if (Config.isWinOS()) {
            roots = File.listRoots();
        }
        for (int i = 0; i < roots.length; ++i) {
            File[] dirs = roots[i].listFiles(new DirectoryFilter());
            if (dirs == null) continue;
            for (int j = 0; j < dirs.length; ++j) {
                if (!this.isToolkitDirectory(dirs[j])) continue;
                return dirs[j].toString();
            }
        }
        return "";
    }

    private boolean isToolkitDirectory(File dirToCheck) {
        File file = new File(dirToCheck, "bin");
        if (file.isDirectory()) {
            File emulatorInLinux = new File(file, "emulator");
            File emulatorInWindows = new File(file, "emulator.exe");
            if (!emulatorInWindows.exists() && !emulatorInLinux.exists()) {
                return false;
            }
        } else {
            return false;
        }
        file = new File(dirToCheck, "lib");
        File anotherFile = new File(dirToCheck, "docs");
        return file.isDirectory() && anotherFile.isDirectory();
    }

    private void checkCoreLibraryJars(String tkdir) {
        String libs = Config.getPropString("bluej.javame.corelibraries", null);
        String libDir = tkdir + File.separator + "lib" + File.separator;
        StringTokenizer st = new StringTokenizer(libs);
        boolean allFilesExist = true;
        while (st.hasMoreTokens() && allFilesExist) {
            allFilesExist = new File(libDir + st.nextToken()).exists();
        }
        if (allFilesExist) {
            return;
        }
        File[] list = new File(libDir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        });
        File theCLDCJar = null;
        File theMIDPJar = null;
        for (File f : list) {
            Attributes manifest;
            try {
                manifest = new JarFile(f).getManifest().getMainAttributes();
            }
            catch (IOException ex) {
                continue;
            }
            String API = manifest.getValue("API");
            String version = manifest.getValue("API-Specification-Version");
            if (API == null || version == null) continue;
            if (API.equals("CLDC") && version.equals("1.1")) {
                theCLDCJar = f;
                if (theMIDPJar == null) continue;
                break;
            }
            if (!API.equals("MIDP") || !version.equals("2.0")) continue;
            theMIDPJar = f;
            if (theCLDCJar != null) break;
        }
        if (theMIDPJar == null || theCLDCJar == null) {
            return;
        }
        String prop = theCLDCJar.getName() + " " + theMIDPJar.getName();
        Config.putPropString("bluej.javame.corelibraries", prop);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.letUserChooseToolkitDir();
    }

    private void letUserChooseToolkitDir() {
        String s;
        String toolkitDirectory = "";
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(Config.getString("prefmgr.misc.filechooser.title"));
        int returnVal = chooser.showOpenDialog(this.getParent());
        if (returnVal == 0) {
            toolkitDirectory = chooser.getSelectedFile().toString();
            this.toolkitDirField.setText(toolkitDirectory);
        } else if (returnVal == 1 && (s = this.toolkitDirField.getText().trim()).equals("")) {
            this.showJavaMEBox.setSelected(false);
            this.enableToolkitPanel(false);
        }
    }
}

