/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target.role;

import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.editor.Editor;
import bluej.parser.SourceLocation;
import bluej.parser.SourceSpan;
import bluej.parser.UnitTestAnalyzer;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.TestRunnerThread;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.ClassRole;
import bluej.prefmgr.PrefMgr;
import bluej.testmgr.TestDisplayFrame;
import bluej.testmgr.record.ExistingFixtureInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.JavaUtils;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.junit.Test;

public class UnitTestClassRole
extends ClassRole {
    public static final String UNITTEST_ROLE_NAME = "UnitTestTarget";
    public static final String UNITTEST_ROLE_NAME_JUNIT4 = "UnitTestTargetJunit4";
    private final Color unittestbg = Config.getOptionalItemColour("colour.class.bg.unittest");
    private static final String testAll = Config.getString("pkgmgr.test.popup.testAll");
    private static final String createTest = Config.getString("pkgmgr.test.popup.createTest");
    private static final String benchToFixture = Config.getString("pkgmgr.test.popup.benchToFixture");
    private static final String fixtureToBench = Config.getString("pkgmgr.test.popup.fixtureToBench");
    private boolean isJunit4;
    private static final String spaces = "                                 ";

    public UnitTestClassRole(boolean isJunit4) {
        this.isJunit4 = isJunit4;
    }

    @Override
    public String getRoleName() {
        if (this.isJunit4) {
            return UNITTEST_ROLE_NAME_JUNIT4;
        }
        return UNITTEST_ROLE_NAME;
    }

    @Override
    public String getStereotypeLabel() {
        return "unit test";
    }

    @Override
    public Paint getBackgroundPaint(int width, int height) {
        if (this.unittestbg != null) {
            return this.unittestbg;
        }
        return new GradientPaint(0.0f, 0.0f, new Color(197, 211, 165), 0.0f, height, new Color(170, 190, 140));
    }

    private boolean isJUnitTestMethod(Method m) {
        if (this.isJunit4) {
            Class<?> cl = m.getDeclaringClass();
            ClassLoader classLoader = cl.getClassLoader();
            try {
                Class testClass = classLoader == null ? Test.class : classLoader.loadClass("org.junit.Test");
                if (m.getAnnotation(testClass) != null) {
                    if (!Modifier.isPublic(m.getModifiers())) {
                        return false;
                    }
                    return m.getParameterTypes().length == 0;
                }
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (LinkageError le) {
                // empty catch block
            }
            return false;
        }
        if (!m.getName().startsWith("test")) {
            return false;
        }
        if (!Modifier.isPublic(m.getModifiers())) {
            return false;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return m.getReturnType().equals(Void.TYPE);
    }

    @Override
    public boolean createRoleMenu(JPopupMenu menu, ClassTarget ct, Class<?> cl, int state) {
        boolean enableTestAll = false;
        if (state == 0 && cl != null && !ct.isAbstract()) {
            Method[] allMethods = cl.getMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                Method m = allMethods[i];
                if (!this.isJUnitTestMethod(m)) continue;
                enableTestAll = true;
                break;
            }
        }
        this.addMenuItem(menu, new TestAction(testAll, ct.getPackage().getEditor(), ct), enableTestAll);
        menu.addSeparator();
        return false;
    }

    @Override
    public boolean createClassConstructorMenu(JPopupMenu menu, ClassTarget ct, Class<?> cl) {
        boolean hasEntries = false;
        Method[] allMethods = cl.getMethods();
        if (!ct.isAbstract()) {
            for (int i = 0; i < allMethods.length; ++i) {
                String rtype;
                Method m = allMethods[i];
                if (!this.isJUnitTestMethod(m)) continue;
                try {
                    rtype = JavaUtils.getJavaUtils().getReturnType(m).toString(true);
                }
                catch (ClassNotFoundException cnfe) {
                    rtype = m.getReturnType().getName();
                }
                TestAction testAction = new TestAction(rtype + " " + m.getName() + "()", ct.getPackage().getEditor(), ct, m.getName());
                JMenuItem item = new JMenuItem();
                item.setAction(testAction);
                item.setFont(PrefMgr.getPopupMenuFont());
                menu.add(item);
                hasEntries = true;
            }
            if (!hasEntries) {
                JMenuItem item = new JMenuItem(Config.getString("pkgmgr.test.popup.noTests"));
                item.setFont(PrefMgr.getPopupMenuFont());
                item.setEnabled(false);
                menu.add(item);
            }
        } else {
            JMenuItem item = new JMenuItem(Config.getString("pkgmgr.test.popup.abstract"));
            item.setFont(PrefMgr.getPopupMenuFont());
            item.setEnabled(false);
            menu.add(item);
        }
        return true;
    }

    @Override
    public boolean createClassStaticMenu(JPopupMenu menu, ClassTarget ct, Class<?> cl) {
        boolean enable = !ct.getPackage().getProject().inTestMode() && ct.hasSourceCode() && !ct.isAbstract();
        this.addMenuItem(menu, new MakeTestCaseAction(createTest, ct.getPackage().getEditor(), ct), enable);
        this.addMenuItem(menu, new BenchToFixtureAction(benchToFixture, ct.getPackage().getEditor(), ct), enable);
        this.addMenuItem(menu, new FixtureToBenchAction(fixtureToBench, ct.getPackage().getEditor(), ct), enable);
        return true;
    }

    @Override
    public void run(PkgMgrFrame pmf, ClassTarget ct, String param) {
        if (param != null) {
            TestDisplayFrame.getTestDisplay().startTest(pmf.getProject(), 1);
        }
        new TestRunnerThread(pmf, ct, param).start();
    }

    public void doRunTest(PkgMgrFrame pmf, ClassTarget ct, TestRunnerThread trt) {
        Class<?> cl = pmf.getPackage().loadClass(ct.getQualifiedName());
        if (cl == null) {
            return;
        }
        Method[] allMethods = cl.getMethods();
        ArrayList<String> testMethods = new ArrayList<String>();
        int testCount = 0;
        for (int i = 0; i < allMethods.length; ++i) {
            if (!this.isJUnitTestMethod(allMethods[i])) continue;
            ++testCount;
            testMethods.add(allMethods[i].getName());
        }
        String[] testMethodsArr = testMethods.toArray(new String[testCount]);
        trt.setMethods(testMethodsArr);
        TestDisplayFrame.getTestDisplay().startTest(pmf.getProject(), testCount);
    }

    public int getTestCount(ClassTarget ct) {
        if (!ct.isCompiled()) {
            return 0;
        }
        Class<?> cl = ct.getPackage().loadClass(ct.getQualifiedName());
        if (cl == null) {
            return 0;
        }
        Method[] allMethods = cl.getMethods();
        int testCount = 0;
        for (int i = 0; i < allMethods.length; ++i) {
            if (!this.isJUnitTestMethod(allMethods[i])) continue;
            ++testCount;
        }
        return testCount;
    }

    public void doMakeTestCase(PkgMgrFrame pmf, ClassTarget ct) {
        String newTestName = DialogManager.askString(pmf, "unittest-new-test-method");
        if (newTestName == null) {
            return;
        }
        if (newTestName.length() == 0) {
            pmf.setStatus(Config.getString("pkgmgr.test.noTestName"));
            return;
        }
        if (!this.isJunit4 && !newTestName.startsWith("test")) {
            newTestName = "test" + Character.toTitleCase(newTestName.charAt(0)) + newTestName.substring(1);
        }
        if (!JavaNames.isIdentifier(newTestName)) {
            pmf.setStatus(Config.getString("pkgmgr.test.invalidTestName"));
            return;
        }
        try {
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            SourceSpan existingSpan = uta.getMethodBlockSpan(newTestName);
            if (existingSpan != null && DialogManager.askQuestion(null, "unittest-method-present") == 1) {
                return;
            }
        }
        catch (IOException ioe) {
            DialogManager.showErrorWithText(null, "unittest-io-error", ioe.getLocalizedMessage());
            Debug.reportError("Error reading unit test source", ioe);
        }
        pmf.testRecordingStarted(Config.getString("pkgmgr.test.recording") + " " + ct.getBaseName() + "." + newTestName + "()");
        pmf.getProject().removeClassLoader();
        this.runTestSetup(pmf, ct, false);
        pmf.getObjectBench().resetRecordingInteractions();
        pmf.setTestInfo(newTestName, ct);
    }

    private UnitTestAnalyzer analyzeUnitTest(ClassTarget ct, Charset fileEncoding) throws IOException {
        ct.ensureSaved();
        UnitTestAnalyzer uta = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(ct.getSourceFile());
            InputStreamReader reader = new InputStreamReader((InputStream)fis, fileEncoding);
            uta = new UnitTestAnalyzer(reader);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    Debug.reportError(ioe);
                }
            }
        }
        return uta;
    }

    private void runTestSetup(final PkgMgrFrame pmf, final ClassTarget ct, boolean recordAsFixtureToBench) {
        new Thread(){

            @Override
            public void run() {
                final Map<String, DebuggerObject> dobs = pmf.getProject().getDebugger().runTestSetUp(ct.getQualifiedName());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (Map.Entry mapent : dobs.entrySet()) {
                            DebuggerObject objVal = (DebuggerObject)mapent.getValue();
                            if (objVal.isNullObject()) continue;
                            pmf.putObjectOnBench((String)mapent.getKey(), objVal, objVal.getGenType(), null);
                        }
                    }
                });
            }
        }.start();
    }

    private String getIndentString() {
        int ts = Math.min(Config.getPropInteger("bluej.editor.tabsize", 4), spaces.length());
        return spaces.substring(0, ts);
    }

    public void doEndMakeTestCase(PkgMgrFrame pmf, ClassTarget ct, String name) {
        Editor ed = ct.getEditor();
        String ts = this.getIndentString();
        try {
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            SourceSpan existingSpan = uta.getMethodBlockSpan(name);
            if (existingSpan != null) {
                ed.setSelection(existingSpan.getStartLine(), existingSpan.getStartColumn(), existingSpan.getEndLine(), existingSpan.getEndColumn());
                ed.insertText("{\n" + pmf.getObjectBench().getTestMethod(ts + ts) + ts + "}", false);
            } else {
                SourceLocation methodInsert = uta.getNewMethodInsertLocation();
                if (methodInsert != null) {
                    ed.setSelection(methodInsert.getLine(), methodInsert.getColumn(), 1);
                    if (this.isJunit4) {
                        ed.insertText("\n" + ts + "@Test\n" + ts + "public void " + name + "()\n" + ts + "{\n" + pmf.getObjectBench().getTestMethod(ts + ts) + ts + "}\n}\n", false);
                    } else {
                        ed.insertText("\n" + ts + "public void " + name + "()\n" + ts + "{\n" + pmf.getObjectBench().getTestMethod(ts + ts) + ts + "}\n}\n", false);
                    }
                }
            }
            ed.save();
        }
        catch (IOException ioe) {
            PkgMgrFrame.showMessageWithText(pmf.getPackage(), "generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void doFixtureToBench(PkgMgrFrame pmf, ClassTarget ct) {
        Editor ed = ct.getEditor();
        ExistingFixtureInvokerRecord existing = new ExistingFixtureInvokerRecord();
        try {
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            List<SourceSpan> fixtureSpans = uta.getFieldSpans();
            ListIterator<SourceSpan> it = fixtureSpans.listIterator();
            while (it.hasNext()) {
                SourceSpan variableSpan = it.next();
                String fieldDecl = ed.getText(variableSpan.getStartLocation(), variableSpan.getEndLocation());
                existing.addFieldDeclaration(fieldDecl);
            }
            SourceSpan setUpSpan = uta.getMethodBlockSpan("setUp");
            if (setUpSpan != null) {
                String setUpWithBrackets = ed.getText(setUpSpan.getStartLocation(), setUpSpan.getEndLocation());
                String setUpWithoutBrackets = setUpWithBrackets.substring(setUpWithBrackets.indexOf(123) + 1, setUpWithBrackets.lastIndexOf(125)).trim();
                existing.setSetupMethod(setUpWithoutBrackets);
            }
        }
        catch (IOException ioe) {
            PkgMgrFrame.showMessageWithText(pmf.getPackage(), "generic-file-save-error", ioe.getLocalizedMessage());
        }
        this.runTestSetup(pmf, ct, true);
        pmf.getObjectBench().addInteraction(existing);
    }

    public void doBenchToFixture(PkgMgrFrame pmf, ClassTarget ct) {
        if (pmf.getObjectBench().getObjectCount() == 0) {
            return;
        }
        Editor ed = ct.getEditor();
        try {
            SourceLocation fixtureInsertLocation;
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            List<SourceSpan> variables = uta.getFieldSpans();
            if (variables != null && variables.size() > 0 && DialogManager.askQuestion(null, "unittest-fixture-present") == 1) {
                return;
            }
            if (variables != null) {
                ListIterator<SourceSpan> it = variables.listIterator(variables.size());
                while (it.hasPrevious()) {
                    SourceSpan variableSpan = it.previous();
                    ed.setSelection(variableSpan.getStartLine(), variableSpan.getStartColumn(), variableSpan.getEndLine(), variableSpan.getEndColumn());
                    ed.insertText("", false);
                }
                uta = this.analyzeUnitTest(ct, charset);
            }
            if ((fixtureInsertLocation = uta.getFixtureInsertLocation()) == null) {
                return;
            }
            ArrayList<String> names = new ArrayList<String>();
            for (ObjectWrapper obj : pmf.getObjectBench().getObjects()) {
                names.add(obj.getName());
            }
            SourceSpan setupSpan = uta.getMethodBlockSpan("setUp");
            String ts = this.getIndentString();
            if (setupSpan != null) {
                ed.setSelection(setupSpan.getStartLine(), setupSpan.getStartColumn(), setupSpan.getEndLine(), setupSpan.getEndColumn());
            } else {
                ed.setSelection(fixtureInsertLocation.getLine(), fixtureInsertLocation.getColumn(), 1);
                if (this.isJunit4) {
                    ed.insertText("{\n" + ts + "@Before\n" + ts + "public void setUp()\n" + ts, false);
                } else {
                    ed.insertText("{\n" + ts + "public void setUp()\n" + ts, false);
                }
            }
            ed.insertText("{\n" + pmf.getObjectBench().getFixtureSetup(ts + ts) + ts + "}", false);
            ed.setSelection(fixtureInsertLocation.getLine(), fixtureInsertLocation.getColumn(), 1);
            ed.insertText("{\n" + pmf.getObjectBench().getFixtureDeclaration(ts), false);
            ed.save();
        }
        catch (IOException ioe) {
            PkgMgrFrame.showMessageWithText(pmf.getPackage(), "generic-file-save-error", ioe.getLocalizedMessage());
        }
        pmf.getPackage().compileQuiet(ct);
        pmf.getProject().removeClassLoader();
        pmf.getProject().newRemoteClassLoaderLeavingBreakpoints();
    }

    private class FixtureToBenchAction
    extends TargetAbstractAction {
        public FixtureToBenchAction(String name, PackageEditor ped, Target t) {
            super(name, ped, t);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.ped.raiseFixtureToBenchEvent(this.t);
        }
    }

    private class BenchToFixtureAction
    extends TargetAbstractAction {
        public BenchToFixtureAction(String name, PackageEditor ped, Target t) {
            super(name, ped, t);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.ped.raiseBenchToFixtureEvent(this.t);
        }
    }

    private class MakeTestCaseAction
    extends TargetAbstractAction {
        public MakeTestCaseAction(String name, PackageEditor ped, Target t) {
            super(name, ped, t);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.ped.raiseMakeTestCaseEvent(this.t);
        }
    }

    private class TestAction
    extends TargetAbstractAction {
        private String testName;

        public TestAction(String actionName, PackageEditor ped, Target t) {
            super(actionName, ped, t);
            this.testName = null;
        }

        public TestAction(String actionName, PackageEditor ped, Target t, String testName) {
            super(actionName, ped, t);
            this.testName = testName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.ped.raiseRunTargetEvent(this.t, this.testName);
        }
    }

    private abstract class TargetAbstractAction
    extends AbstractAction {
        protected Target t;
        protected PackageEditor ped;

        public TargetAbstractAction(String name, PackageEditor ped, Target t) {
            super(name);
            this.ped = ped;
            this.t = t;
        }
    }
}

