/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.graph.Vertex;
import bluej.pkgmgr.Package;
import bluej.prefmgr.PrefMgr;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Properties;

public abstract class Target
extends Vertex
implements Comparable<Target> {
    static final int DEF_WIDTH = 80;
    static final int DEF_HEIGHT = 50;
    static final int ARR_HORIZ_DIST = 5;
    static final int ARR_VERT_DIST = 10;
    static final int HANDLE_SIZE = 20;
    static final int TEXT_HEIGHT = 16;
    static final int TEXT_BORDER = 4;
    static final int SHAD_SIZE = 4;
    private String identifierName;
    private String displayName;
    private Package pkg;
    protected boolean disabled;
    protected boolean selected;
    protected boolean queued;
    static FontRenderContext FRC = new FontRenderContext(new AffineTransform(), false, false);

    public Target(Package pkg, String identifierName) {
        super(0, 0, Target.calculateWidth(identifierName), 50);
        if (pkg == null) {
            throw new NullPointerException();
        }
        this.pkg = pkg;
        this.identifierName = identifierName;
        this.displayName = identifierName;
    }

    protected static int calculateWidth(String name) {
        int width = 0;
        if (name != null) {
            width = (int)PrefMgr.getTargetFont().getStringBounds(name, FRC).getWidth();
        }
        if (width + 20 <= 80) {
            return 80;
        }
        return (width + 29) / 10 * 10;
    }

    public void setRemoved() {
        this.pkg = null;
    }

    public void load(Properties props, String prefix) throws NumberFormatException {
        int xpos = 0;
        int ypos = 0;
        int width = 20;
        int height = 10;
        try {
            xpos = Math.max(Integer.parseInt(props.getProperty(prefix + ".x")), 0);
            ypos = Math.max(Integer.parseInt(props.getProperty(prefix + ".y")), 0);
            width = Math.max(Integer.parseInt(props.getProperty(prefix + ".width")), 1);
            height = Math.max(Integer.parseInt(props.getProperty(prefix + ".height")), 1);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        this.setPos(xpos, ypos);
        this.setSize(width, height);
    }

    public void save(Properties props, String prefix) {
        props.put(prefix + ".x", String.valueOf(this.getX()));
        props.put(prefix + ".y", String.valueOf(this.getY()));
        props.put(prefix + ".width", String.valueOf(this.getWidth()));
        props.put(prefix + ".height", String.valueOf(this.getHeight()));
        props.put(prefix + ".name", this.getIdentifierName());
    }

    public Package getPackage() {
        return this.pkg;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public void setIdentifierName(String newName) {
        this.identifierName = newName;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public Rectangle getBoundingBox() {
        return this.getRectangle();
    }

    public void toggleSelected() {
        this.selected = !this.selected;
        this.repaint();
    }

    @Override
    public boolean isHandle(int x, int y) {
        return x - this.getX() + y - this.getY() >= this.getWidth() + this.getHeight() - 20;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public void setQueued(boolean queued) {
        this.queued = queued;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    public boolean isSaveable() {
        return true;
    }

    public boolean isSelectable() {
        return true;
    }

    public void repaint() {
        if (this.pkg != null && this.pkg.getEditor() != null) {
            this.pkg.getEditor().repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Target) {
            Target t = (Target)o;
            return this.identifierName.equals(t.identifierName);
        }
        return false;
    }

    public int hashCode() {
        return this.identifierName.hashCode();
    }

    @Override
    public int compareTo(Target t) {
        if (this.equals(t)) {
            return 0;
        }
        if (this.getY() < t.getY()) {
            return -1;
        }
        if (this.getY() > t.getY()) {
            return 1;
        }
        if (this.getX() < t.getX()) {
            return -1;
        }
        if (this.getX() > t.getX()) {
            return 1;
        }
        return this.identifierName.compareTo(t.getIdentifierName());
    }

    public String toString() {
        return this.getDisplayName();
    }
}

