/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.graph.Moveable;
import bluej.pkgmgr.LayoutComparer;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.EditableTarget;
import bluej.utility.MultiIterator;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public abstract class DependentTarget
extends EditableTarget {
    public static final int S_NORMAL = 0;
    public static final int S_INVALID = 1;
    public static final int S_COMPILING = 2;
    protected int state = 1;
    private List<UsesDependency> inUses = new ArrayList<UsesDependency>();
    private List<UsesDependency> outUses = new ArrayList<UsesDependency>();
    private List<Dependency> parents = new ArrayList<Dependency>();
    private List<Dependency> children = new ArrayList<Dependency>();
    protected DependentTarget assoc = null;

    public DependentTarget(Package pkg, String identifierName) {
        super(pkg, identifierName);
    }

    @Override
    public void setPos(int x, int y) {
        super.setPos(x, y);
        this.recalcDependentPositions();
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.recalcDependentPositions();
    }

    @Override
    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        if (this.getAssociation() != null) {
            String assocName = this.getAssociation().getIdentifierName();
            props.put(prefix + ".association", assocName);
        }
    }

    public void setAssociation(DependentTarget t) {
        this.assoc = t;
        if (this.assoc instanceof Moveable) {
            ((Moveable)((Object)this.assoc)).setIsMoveable(false);
        }
    }

    public DependentTarget getAssociation() {
        return this.assoc;
    }

    public void addDependencyOut(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.outUses.add((UsesDependency)d);
            if (recalc) {
                this.recalcOutUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            this.parents.add(d);
        }
        if (recalc) {
            this.setState(1);
        }
    }

    public void addDependencyIn(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.inUses.add((UsesDependency)d);
            if (recalc) {
                this.recalcInUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            this.children.add(d);
        }
    }

    public void removeDependencyOut(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.outUses.remove(d);
            if (recalc) {
                this.recalcOutUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            this.parents.remove(d);
        }
        if (recalc) {
            this.setState(1);
        }
    }

    public void removeDependencyIn(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.inUses.remove(d);
            if (recalc) {
                this.recalcInUses();
            }
        } else if (d instanceof ExtendsDependency || d instanceof ImplementsDependency) {
            this.children.remove(d);
        }
    }

    public Iterator<? extends Dependency> dependencies() {
        ArrayList v = new ArrayList(2);
        v.add(this.parents.iterator());
        v.add(this.outUses.iterator());
        return new MultiIterator(v);
    }

    public Iterator<? extends Dependency> dependents() {
        ArrayList v = new ArrayList(2);
        v.add(this.children.iterator());
        v.add(this.inUses.iterator());
        return new MultiIterator(v);
    }

    public List<Dependency> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public List<Dependency> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public List<Dependency> dependentsAsList() {
        LinkedList<Dependency> list = new LinkedList<Dependency>();
        list.addAll(this.inUses);
        list.addAll(this.outUses);
        list.addAll(this.children);
        list.addAll(this.parents);
        return list;
    }

    public Iterator<UsesDependency> usesDependencies() {
        return Collections.unmodifiableList(this.outUses).iterator();
    }

    protected void removeAllOutDependencies() {
        if (!this.outUses.isEmpty()) {
            Dependency[] outUsesArray = new Dependency[this.outUses.size()];
            this.outUses.toArray(outUsesArray);
            for (int i = 0; i < outUsesArray.length; ++i) {
                this.getPackage().removeDependency(outUsesArray[i], false);
            }
        }
        this.removeInheritDependencies();
    }

    protected void removeInheritDependencies() {
        if (!this.parents.isEmpty()) {
            Dependency[] parentsArray = new Dependency[this.parents.size()];
            this.parents.toArray(parentsArray);
            for (int i = 0; i < parentsArray.length; ++i) {
                this.getPackage().removeDependency(parentsArray[i], false);
            }
        }
    }

    protected void removeAllInDependencies() {
        int i;
        if (!this.inUses.isEmpty()) {
            Dependency[] inUsesArray = new Dependency[this.inUses.size()];
            this.inUses.toArray(inUsesArray);
            for (i = 0; i < inUsesArray.length; ++i) {
                this.getPackage().removeDependency(inUsesArray[i], false);
            }
        }
        if (!this.children.isEmpty()) {
            Dependency[] childrenArray = new Dependency[this.children.size()];
            this.children.toArray(childrenArray);
            for (i = 0; i < childrenArray.length; ++i) {
                this.getPackage().removeDependency(childrenArray[i], false);
            }
        }
    }

    public void recalcOutUses() {
        List<UsesDependency> visibleOutUses = this.getVisibleUsesDependencies(this.outUses);
        Collections.sort(visibleOutUses, new LayoutComparer(this, false));
        int cy = this.getY() + this.getHeight() / 2;
        int n_top = 0;
        int n_bottom = 0;
        for (int i = visibleOutUses.size() - 1; i >= 0; --i) {
            DependentTarget to = ((Dependency)visibleOutUses.get(i)).getTo();
            int to_cy = to.getY() + to.getHeight() / 2;
            if (to_cy < cy) {
                ++n_top;
                continue;
            }
            ++n_bottom;
        }
        int top_left = this.getX() + (this.getWidth() - (n_top - 1) * 5) / 2;
        int bottom_left = this.getX() + (this.getWidth() - (n_bottom - 1) * 5) / 2;
        for (int i = 0; i < n_top + n_bottom; ++i) {
            UsesDependency d = visibleOutUses.get(i);
            int to_cy = d.getTo().getY() + d.getTo().getHeight() / 2;
            if (to_cy < cy) {
                d.setSourceCoords(top_left, this.getY() - 4, true);
                top_left += 5;
                continue;
            }
            d.setSourceCoords(bottom_left, this.getY() + this.getHeight() + 4, false);
            bottom_left += 5;
        }
    }

    public void recalcInUses() {
        List<UsesDependency> visibleInUses = this.getVisibleUsesDependencies(this.inUses);
        Collections.sort(visibleInUses, new LayoutComparer(this, true));
        int cx = this.getX() + this.getWidth() / 2;
        int n_left = 0;
        int n_right = 0;
        for (int i = visibleInUses.size() - 1; i >= 0; --i) {
            DependentTarget from = ((Dependency)visibleInUses.get(i)).getFrom();
            int from_cx = from.getX() + from.getWidth() / 2;
            if (from_cx < cx) {
                ++n_left;
                continue;
            }
            ++n_right;
        }
        int left_top = this.getY() + (this.getHeight() - (n_left - 1) * 10) / 2;
        int right_top = this.getY() + (this.getHeight() - (n_right - 1) * 10) / 2;
        for (int i = 0; i < n_left + n_right; ++i) {
            UsesDependency d = visibleInUses.get(i);
            int from_cx = d.getFrom().getX() + d.getFrom().getWidth() / 2;
            if (from_cx < cx) {
                d.setDestCoords(this.getX() - 4, left_top, true);
                left_top += 10;
                continue;
            }
            d.setDestCoords(this.getX() + this.getWidth() + 4, right_top, false);
            right_top += 10;
        }
    }

    private List<UsesDependency> getVisibleUsesDependencies(List<UsesDependency> usesDependencies) {
        ArrayList<UsesDependency> result = new ArrayList<UsesDependency>();
        for (UsesDependency incomingUsesDependency : usesDependencies) {
            if (!incomingUsesDependency.isVisible()) continue;
            result.add(incomingUsesDependency);
        }
        return result;
    }

    protected void unflagAllOutDependencies() {
        for (int i = 0; i < this.outUses.size(); ++i) {
            this.outUses.get(i).setFlag(false);
        }
    }

    public Point getAttachment(double angle) {
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double tan = sin / cos;
        double m = (double)this.getHeight() / (double)this.getWidth();
        double radius = Math.abs(tan) < m ? 0.5 * (double)this.getWidth() / Math.abs(cos) : 0.5 * (double)this.getHeight() / Math.abs(sin);
        Point p = new Point(this.getX() + this.getWidth() / 2 + (int)(radius * cos), this.getY() + this.getHeight() / 2 - (int)(radius * sin));
        if (-m < tan && tan < m && cos > 0.0) {
            p.x += 4;
        }
        if (Math.abs(tan) > m && sin < 0.0 && p.x > this.getX() + 4) {
            p.y += 4;
        }
        return p;
    }

    public void recalcDependentPositions() {
        this.recalcInUses();
        this.recalcOutUses();
        for (Dependency dependency : this.inUses) {
            dependency.getFrom().recalcOutUses();
        }
        for (Dependency dependency : this.outUses) {
            dependency.getTo().recalcInUses();
        }
        this.updateAssociatePosition();
    }

    protected void updateAssociatePosition() {
        DependentTarget t = this.getAssociation();
        if (t != null) {
            t.setPos(this.getX() + 30, this.getY() - 30);
            t.recalcDependentPositions();
        }
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public int getState() {
        return this.state;
    }

    public boolean isInvalidState() {
        return this.getState() == 1;
    }

    public void setInvalidState() {
        this.setState(1);
    }

    public void setState(int newState) {
        this.state = newState;
        this.repaint();
    }
}

