/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.actions;

import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.actions.PkgMgrAction;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.io.File;

public final class SaveProjectAsAction
extends PkgMgrAction {
    public SaveProjectAsAction() {
        super("menu.package.saveAs");
    }

    @Override
    public void actionPerformed(PkgMgrFrame pmf) {
        pmf.menuCall();
        this.saveAs(pmf, pmf.getProject());
    }

    public void saveAs(PkgMgrFrame frame, Project project) {
        File newName = FileUtility.getDirName(frame, Config.getString("pkgmgr.saveAs.title"), Config.getString("pkgmgr.saveAs.buttonLabel"), false, true);
        if (newName != null) {
            project.saveAll();
            int result = FileUtility.copyDirectory(project.getProjectDir(), newName);
            switch (result) {
                case 0: {
                    break;
                }
                case 1: {
                    DialogManager.showError(frame, "directory-exists");
                    return;
                }
                case 2: 
                case 3: {
                    DialogManager.showError(frame, "cannot-save-project");
                    return;
                }
            }
            PkgMgrFrame.closeProject(project);
            Project openProj = Project.openProject(newName.getAbsolutePath(), null);
            if (openProj != null) {
                Package pkg = openProj.getPackage("");
                PkgMgrFrame pmf = PkgMgrFrame.createFrame(pkg);
                pmf.setVisible(true);
            } else {
                Debug.message("Save as: could not open package under new name");
            }
        }
    }
}

