/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.debugger.gentype.Reflective;
import bluej.parser.InfoParser;
import bluej.parser.entity.PackageResolver;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.CommentCache;
import bluej.pkgmgr.DocPathEntry;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.views.Comment;
import bluej.views.MethodView;
import bluej.views.View;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ProjectJavadocResolver
implements JavadocResolver {
    private Project project;
    private CommentCache commentCache = new CommentCache();

    public ProjectJavadocResolver(Project project) {
        this.project = project;
    }

    @Override
    public void getJavadoc(MethodReflective method) {
        String comtarget;
        Reflective declaring = method.getDeclaringType();
        String declName = declaring.getName();
        String methodSig = ProjectJavadocResolver.buildSig(method);
        try {
            Class<?> cl = this.project.getClassLoader().loadClass(declName);
            View clView = View.getView(cl);
            MethodView[] methods = clView.getAllMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methodSig.equals(methods[i].getSignature())) continue;
                Comment comment = methods[i].getComment();
                if (comment != null) {
                    method.setJavaDoc(comment.getText());
                    ArrayList<String> paramNames = new ArrayList<String>(comment.getParamCount());
                    for (int j = 0; j < comment.getParamCount(); ++j) {
                        paramNames.add(comment.getParamName(j));
                    }
                    method.setParamNames(paramNames);
                    return;
                }
                break;
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (LinkageError e) {
            // empty catch block
        }
        Properties comments = (Properties)this.commentCache.get(declName);
        if (comments == null) {
            comments = this.getCommentsFromSource(declName);
            if (comments == null) {
                return;
            }
            this.commentCache.put(declName, comments);
        }
        int i = 0;
        while ((comtarget = comments.getProperty("comment" + i + ".target")) != null) {
            if (comtarget.equals(methodSig)) {
                method.setJavaDoc(comments.getProperty("comment" + i + ".text"));
                String paramNames = comments.getProperty("comment" + i + ".params");
                StringTokenizer tokenizer = new StringTokenizer(paramNames);
                ArrayList<String> paramNamesList = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    paramNamesList.add(tokenizer.nextToken());
                }
                method.setParamNames(paramNamesList);
                break;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getCommentsFromSource(String target) {
        List<DocPathEntry> sourcePath = this.project.getSourcePath();
        String pkg = JavaNames.getPrefix(target);
        String entName = target.replace('.', '/') + ".java";
        String entNameFs = target.replace('.', File.separatorChar) + ".java";
        PackageResolver resolver = new PackageResolver(this.project.getEntityResolver(), pkg);
        for (DocPathEntry pathEntry : sourcePath) {
            ClassInfo info;
            File jarFile = pathEntry.getFile();
            if (jarFile.isFile()) {
                String fullEntryName = pathEntry.getPathPrefix();
                if (fullEntryName.length() != 0 && !fullEntryName.endsWith("/")) {
                    fullEntryName = fullEntryName + "/";
                }
                fullEntryName = fullEntryName + entName;
                Reader r = null;
                try {
                    ZipFile zipFile = new ZipFile(jarFile);
                    ZipEntry zipEnt = zipFile.getEntry(fullEntryName);
                    if (zipEnt == null) continue;
                    InputStream zeis = zipFile.getInputStream(zipEnt);
                    r = new InputStreamReader(zeis, this.project.getProjectCharset());
                    info = InfoParser.parse(r, resolver, null);
                    if (info == null) {
                        Properties properties = null;
                        return properties;
                    }
                    Properties properties = info.getComments();
                    return properties;
                }
                catch (IOException ioe) {}
                continue;
                finally {
                    if (r == null) continue;
                    try {
                        r.close();
                        continue;
                    }
                    catch (IOException e) {}
                }
            }
            if (!jarFile.isDirectory()) continue;
            File base = jarFile;
            String prefix = pathEntry.getPathPrefix();
            if (prefix != null && !prefix.isEmpty()) {
                base = new File(base, prefix);
            }
            File srcFile = new File(base, entNameFs);
            FileInputStream fis = null;
            try {
                if (!srcFile.canRead()) continue;
                fis = new FileInputStream(srcFile);
                InputStreamReader r = new InputStreamReader((InputStream)fis, this.project.getProjectCharset());
                info = InfoParser.parse(r, resolver, null);
                ((Reader)r).close();
                if (info == null) {
                    return null;
                }
                return info.getComments();
            }
            catch (IOException ioe) {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        String targetName = target.replace('.', '/') + ".java";
        URL srcUrl = this.project.getClassLoader().findResource(targetName);
        if (srcUrl != null) {
            try {
                InputStreamReader r = new InputStreamReader(srcUrl.openStream(), this.project.getProjectCharset());
                ClassInfo info = InfoParser.parse(r, resolver, null);
                if (info != null) {
                    return info.getComments();
                }
            }
            catch (IOException ioe) {
                Debug.message("I/O exception while trying to retrieve javadoc for " + target);
            }
        }
        return null;
    }

    private static String buildSig(MethodReflective method) {
        String sig = method.getReturnType().getErasedType().toString();
        sig = sig.replace('$', '.');
        sig = sig + ' ';
        sig = sig + method.getName() + '(';
        Iterator<JavaType> i = method.getParamTypes().iterator();
        while (i.hasNext()) {
            JavaType ptype = i.next();
            sig = sig + ptype.getErasedType().toString().replace('$', '.');
            if (!i.hasNext()) continue;
            sig = sig + ", ";
        }
        sig = sig + ')';
        return sig;
    }
}

