/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.extmgr.MenuManager;
import bluej.extmgr.PackageMenuObject;
import bluej.graph.GraphEditor;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditorEvent;
import bluej.pkgmgr.PackageEditorListener;
import bluej.pkgmgr.actions.NewClassAction;
import bluej.pkgmgr.actions.NewPackageAction;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.testmgr.record.InvokerRecord;
import bluej.views.CallableView;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class PackageEditor
extends GraphEditor {
    private PackageEditorListener listener;

    public PackageEditor(Package pkg, PackageEditorListener listener) {
        super(pkg);
        this.listener = listener;
    }

    protected void fireTargetEvent(PackageEditorEvent e) {
        if (this.listener != null) {
            this.listener.targetEvent(e);
        }
    }

    public void raiseMethodCallEvent(Object src, CallableView cv) {
        this.fireTargetEvent(new PackageEditorEvent(src, 1, cv));
    }

    public void raiseRemoveTargetEvent(Target t) {
        this.fireTargetEvent(new PackageEditorEvent(t, 2));
    }

    public void raiseBenchToFixtureEvent(Target t) {
        this.fireTargetEvent(new PackageEditorEvent(t, 5));
    }

    public void raiseFixtureToBenchEvent(Target t) {
        this.fireTargetEvent(new PackageEditorEvent(t, 6));
    }

    public void raiseMakeTestCaseEvent(Target t) {
        this.fireTargetEvent(new PackageEditorEvent(t, 7));
    }

    public void raiseRunTargetEvent(Target t, String name) {
        this.fireTargetEvent(new PackageEditorEvent((Object)t, 4, name));
    }

    public void raiseOpenPackageEvent(Target t, String packageName) {
        this.fireTargetEvent(new PackageEditorEvent((Object)t, 3, packageName));
    }

    public void raisePutOnBenchEvent(Component src, DebuggerObject obj, GenTypeClass iType, InvokerRecord ir) {
        this.fireTargetEvent(new PackageEditorEvent(src, 8, obj, iType, ir));
    }

    public void recordInteraction(InvokerRecord ir) {
        this.listener.recordInteraction(ir);
    }

    @Override
    public void popupMenu(int x, int y) {
        JPopupMenu menu = this.createMenu();
        menu.show(this, x, y);
    }

    private JPopupMenu createMenu() {
        JPopupMenu menu = new JPopupMenu();
        NewClassAction newClassAction = new NewClassAction();
        this.addMenuItem(menu, newClassAction);
        NewPackageAction newPackageAction = new NewPackageAction();
        this.addMenuItem(menu, newPackageAction);
        Package bluejPackage = (Package)this.getGraph();
        MenuManager menuManager = new MenuManager(menu);
        menuManager.setAttachedObject(new PackageMenuObject(bluejPackage));
        menuManager.addExtensionMenu(bluejPackage.getProject());
        return menu;
    }

    private void addMenuItem(JPopupMenu menu, Action action) {
        JMenuItem item = menu.add(action);
        item.setFont(PrefMgr.getPopupMenuFont());
        item.setForeground(this.envOpColour);
    }
}

