/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.compiler.CompileObserver;
import bluej.compiler.CompilerWarningDialog;
import bluej.compiler.Diagnostic;
import bluej.compiler.EventqueueCompileObserver;
import bluej.compiler.JobQueue;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerThread;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugmgr.CallHistory;
import bluej.editor.Editor;
import bluej.extensions.BDependency;
import bluej.extensions.BPackage;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.event.CompileEvent;
import bluej.extensions.event.DependencyEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ExtensionsManager;
import bluej.graph.Edge;
import bluej.graph.Graph;
import bluej.parser.AssistContent;
import bluej.parser.CodeSuggestions;
import bluej.parser.ParseUtils;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.GreenfootProjectFile;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageFile;
import bluej.pkgmgr.PackageFileFactory;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.EditableTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.ParentPackageTarget;
import bluej.pkgmgr.target.ReadmeTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.TargetCollection;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.MultiIterator;
import bluej.utility.SortedProperties;
import bluej.utility.filefilter.JavaClassFilter;
import bluej.utility.filefilter.JavaSourceFilter;
import bluej.utility.filefilter.SubPackageFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class Package
extends Graph {
    static final String compiling = Config.getString("pkgmgr.compiling");
    static final String compileDone = Config.getString("pkgmgr.compileDone");
    static final String chooseUsesTo = Config.getString("pkgmgr.chooseUsesTo");
    static final String chooseInhTo = Config.getString("pkgmgr.chooseInhTo");
    private PackageFile packageFile;
    public static final String readmeName = "README.TXT";
    public static final int NO_ERROR = 0;
    public static final int FILE_NOT_FOUND = 1;
    public static final int ILLEGAL_FORMAT = 2;
    public static final int COPY_ERROR = 3;
    public static final int CLASS_EXISTS = 4;
    public static final int CREATE_ERROR = 5;
    public static final int FIXED_TARGET_X = 10;
    public static final int FIXED_TARGET_Y = 10;
    private final Project project;
    private final Package parentPackage;
    private final String baseName;
    private SortedProperties lastSavedProps = new SortedProperties();
    private TargetCollection targets;
    private List<Dependency> usesArrows;
    private List<Dependency> extendsArrows;
    private DependentTarget fromChoice;
    private CallHistory callHistory;
    private boolean showExtends = true;
    private boolean showUses = true;
    private String lastSourceName = "";
    public static final int S_IDLE = 0;
    public static final int S_CHOOSE_USES_FROM = 1;
    public static final int S_CHOOSE_USES_TO = 2;
    public static final int S_CHOOSE_EXT_FROM = 3;
    public static final int S_CHOOSE_EXT_TO = 4;
    public static final int HISTORY_LENGTH = 6;
    private int state = 0;
    private PackageEditor editor;
    private File dir;
    private BPackage singleBPackage;

    public Package(Project project, String baseName, Package parent) throws IOException {
        if (parent == null) {
            throw new NullPointerException("Package must have a valid parent package");
        }
        if (baseName.length() == 0) {
            throw new IllegalArgumentException("unnamedPackage must be created using Package(project)");
        }
        if (!JavaNames.isIdentifier(baseName)) {
            throw new IllegalArgumentException(baseName + " is not a valid name for a Package");
        }
        this.project = project;
        this.baseName = baseName;
        this.parentPackage = parent;
        this.init();
    }

    public Package(Project project) throws IOException {
        this.project = project;
        this.baseName = "";
        this.parentPackage = null;
        this.init();
    }

    private void init() throws IOException {
        this.targets = new TargetCollection();
        this.usesArrows = new ArrayList<Dependency>();
        this.extendsArrows = new ArrayList<Dependency>();
        this.callHistory = new CallHistory(6);
        this.dir = new File(this.project.getProjectDir(), this.getRelativePath().getPath());
        this.load();
    }

    public boolean isUnnamedPackage() {
        return this.parentPackage == null;
    }

    public Project getProject() {
        return this.project;
    }

    public final synchronized BPackage getBPackage() {
        if (this.singleBPackage == null) {
            this.singleBPackage = ExtensionBridge.newBPackage((Package)this);
        }
        return this.singleBPackage;
    }

    public String getId() {
        return this.getPath().getPath();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getQualifiedName(String identifier) {
        if (this.isUnnamedPackage()) {
            return identifier;
        }
        return this.getQualifiedName() + "." + identifier;
    }

    public String getQualifiedName() {
        Package currentPkg = this;
        String retName = "";
        while (!currentPkg.isUnnamedPackage()) {
            retName = retName == "" ? currentPkg.getBaseName() : currentPkg.getBaseName() + "." + retName;
            currentPkg = currentPkg.getParent();
        }
        return retName;
    }

    public ReadmeTarget getReadmeTarget() {
        ReadmeTarget readme = (ReadmeTarget)this.targets.get("@README");
        return readme;
    }

    private File getRelativePath() {
        Package currentPkg = this;
        File retFile = new File(currentPkg.getBaseName());
        while (!currentPkg.isUnnamedPackage()) {
            currentPkg = currentPkg.getParent();
            retFile = new File(currentPkg.getBaseName(), retFile.getPath());
        }
        return retFile;
    }

    public File getPath() {
        return this.dir;
    }

    public Package getParent() {
        return this.parentPackage;
    }

    protected Package getBoringSubPackage() {
        PackageTarget pt = null;
        Iterator<Target> e = this.targets.iterator();
        while (e.hasNext()) {
            Target target = e.next();
            if (target instanceof ClassTarget) {
                return null;
            }
            if (!(target instanceof PackageTarget) || target instanceof ParentPackageTarget) continue;
            if (pt != null) {
                return null;
            }
            pt = (PackageTarget)target;
        }
        if (pt == null) {
            return null;
        }
        return this.getProject().getPackage(pt.getQualifiedName());
    }

    protected List<Package> getChildren(boolean getUncached) {
        ArrayList<Package> children = new ArrayList<Package>();
        Iterator<Target> e = this.targets.iterator();
        while (e.hasNext()) {
            Target target = e.next();
            if (!(target instanceof PackageTarget) || target instanceof ParentPackageTarget) continue;
            PackageTarget pt = (PackageTarget)target;
            Package child = getUncached ? this.getProject().getPackage(pt.getQualifiedName()) : this.getProject().getCachedPackage(pt.getQualifiedName());
            if (child == null) continue;
            children.add(child);
        }
        return children;
    }

    public void setStatus(String msg) {
        PkgMgrFrame.displayMessage(this, msg);
    }

    public void repaint() {
        if (this.editor != null) {
            this.editor.repaint();
        }
    }

    void setEditor(PackageEditor editor) {
        this.editor = editor;
    }

    public PackageEditor getEditor() {
        return this.editor;
    }

    public Properties getLastSavedProperties() {
        return this.lastSavedProps;
    }

    public Target[] getSelectedTargets() {
        Target[] targetArray = new Target[]{};
        LinkedList<Target> list = new LinkedList<Target>();
        Iterator<Target> it = this.getVertices();
        while (it.hasNext()) {
            Target target = it.next();
            if (!target.isSelected()) continue;
            list.add(target);
        }
        return list.toArray(targetArray);
    }

    public Dependency getSelectedDependency() {
        Iterator<? extends Edge> it = this.getEdges();
        while (it.hasNext()) {
            Edge edge = it.next();
            if (!(edge instanceof Dependency) || !edge.isSelected()) continue;
            return (Dependency)edge;
        }
        return null;
    }

    public Dependency getDependency(DependentTarget origin, DependentTarget target, BDependency.Type type) {
        List<Object> dependencies = new ArrayList();
        switch (type) {
            case USES: {
                dependencies = this.usesArrows;
                break;
            }
            case IMPLEMENTS: 
            case EXTENDS: {
                dependencies = this.extendsArrows;
                break;
            }
            case UNKNOWN: {
                return null;
            }
        }
        for (Dependency dependency : dependencies) {
            DependentTarget from = dependency.getFrom();
            DependentTarget to = dependency.getTo();
            if (!from.equals(origin) || !to.equals(target)) continue;
            return dependency;
        }
        return null;
    }

    private Set<String> findTargets(File path) {
        int i;
        File[] srcFiles = path.listFiles(new JavaSourceFilter());
        File[] classFiles = path.listFiles(new JavaClassFilter());
        HashSet<String> interestingSet = new HashSet<String>();
        for (i = 0; i < srcFiles.length; ++i) {
            if (srcFiles[i].getName().startsWith("__SHELL")) {
                srcFiles[i].delete();
                continue;
            }
            String javaFileName = JavaNames.stripSuffix(srcFiles[i].getName(), ".java");
            if (!JavaNames.isIdentifier(javaFileName) || javaFileName.indexOf(36) != -1) continue;
            interestingSet.add(javaFileName);
        }
        for (i = 0; i < classFiles.length; ++i) {
            if (classFiles[i].getName().startsWith("__SHELL")) {
                classFiles[i].delete();
                continue;
            }
            String classFileName = JavaNames.stripSuffix(classFiles[i].getName(), ".class");
            if (!JavaNames.isIdentifier(classFileName) || classFileName.indexOf(36) != -1 || interestingSet.contains(classFileName)) continue;
            try {
                Class<?> c = this.loadClass(this.getQualifiedName(classFileName));
                if (c == null || !Modifier.isPublic(c.getModifiers())) continue;
                interestingSet.add(classFileName);
                continue;
            }
            catch (LinkageError e) {
                Debug.message(e.toString());
            }
        }
        return interestingSet;
    }

    public void load() throws IOException {
        this.packageFile = this.getPkgFile();
        this.packageFile.load(this.lastSavedProps);
    }

    public void refreshPackage() {
        ClassTarget ct;
        Target target;
        ClassTarget ct2;
        Target target2;
        HashMap<String, Target> propTargets = new HashMap<String, Target>();
        int numTargets = 0;
        int numDependencies = 0;
        try {
            numTargets = Integer.parseInt(this.lastSavedProps.getProperty("package.numTargets", "0"));
            numDependencies = Integer.parseInt(this.lastSavedProps.getProperty("package.numDependencies", "0"));
        }
        catch (Exception e) {
            Debug.reportError("Error loading from package file " + this.packageFile + ": " + e);
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < numTargets; ++i) {
            String type = this.lastSavedProps.getProperty("target" + (i + 1) + ".type");
            String identifierName = this.lastSavedProps.getProperty("target" + (i + 1) + ".name");
            Target target3 = "PackageTarget".equals(type) ? new PackageTarget(this, identifierName) : new ClassTarget(this, identifierName);
            target3.load(this.lastSavedProps, "target" + (i + 1));
            propTargets.put(identifierName, target3);
        }
        this.addImmovableTargets();
        ArrayList<Target> targetsToPlace = new ArrayList<Target>();
        File[] subDirs = this.getPath().listFiles(new SubPackageFilter());
        for (int i = 0; i < subDirs.length; ++i) {
            if (!JavaNames.isIdentifier(subDirs[i].getName())) continue;
            Target target4 = (Target)propTargets.get(subDirs[i].getName());
            if (target4 == null || !(target4 instanceof PackageTarget)) {
                target4 = new PackageTarget(this, subDirs[i].getName());
                targetsToPlace.add(target4);
            }
            this.addTarget(target4);
        }
        Set<String> interestingSet = this.findTargets(this.getPath());
        for (String targetName : interestingSet) {
            target2 = (Target)propTargets.get(targetName);
            if (target2 == null || !(target2 instanceof ClassTarget)) {
                target2 = new ClassTarget(this, targetName);
                targetsToPlace.add(target2);
            }
            this.addTarget(target2);
        }
        for (Target t : targetsToPlace) {
            this.findSpaceForVertex(t);
        }
        Iterator<Target> targetIt = this.targets.iterator();
        while (targetIt.hasNext()) {
            target2 = targetIt.next();
            if (!(target2 instanceof ClassTarget)) continue;
            ct2 = (ClassTarget)target2;
            ct2.setState(0);
        }
        for (int i = 0; i < numDependencies; ++i) {
            UsesDependency dep = null;
            String type = this.lastSavedProps.getProperty("dependency" + (i + 1) + ".type");
            if ("UsesDependency".equals(type)) {
                dep = new UsesDependency(this);
            }
            if (dep == null) continue;
            ((Dependency)dep).load(this.lastSavedProps, "dependency" + (i + 1));
            this.addDependency(dep, false);
        }
        this.recalcArrows();
        LinkedList<ClassTarget> invalidated = new LinkedList<ClassTarget>();
        targetIt = this.targets.iterator();
        while (targetIt.hasNext()) {
            target = targetIt.next();
            if (!(target instanceof ClassTarget) || !(ct = (ClassTarget)target).isCompiled() || ct.upToDate()) continue;
            ct.setState(1);
            invalidated.add(ct);
        }
        while (!invalidated.isEmpty()) {
            ct2 = (ClassTarget)invalidated.removeFirst();
            for (Dependency dependent : ct2.dependentsAsList()) {
                ClassTarget dep;
                DependentTarget dt = dependent.getFrom();
                if (!(dt instanceof ClassTarget) || !(dep = (ClassTarget)dt).isCompiled()) continue;
                dep.setState(1);
                invalidated.add(dep);
            }
        }
        targetIt = this.targets.iterator();
        while (targetIt.hasNext()) {
            target = targetIt.next();
            if (!(target instanceof ClassTarget)) continue;
            ct = (ClassTarget)target;
            if (ct.isCompiled()) {
                Class<?> cl = this.loadClass(ct.getQualifiedName());
                ct.determineRole(cl);
                ct.analyseDependencies(cl);
                if (cl != null) continue;
                ct.setState(1);
                continue;
            }
            ct.analyseSource();
            try {
                ct.enforcePackage(this.getQualifiedName());
            }
            catch (IOException ioe) {
                Debug.message("Error enforcing class package: " + ioe.getLocalizedMessage());
            }
        }
        for (int i = 0; i < numTargets; ++i) {
            String assoc = this.lastSavedProps.getProperty("target" + (i + 1) + ".association");
            String identifierName = this.lastSavedProps.getProperty("target" + (i + 1) + ".name");
            if (assoc == null) continue;
            Target t1 = this.getTarget(identifierName);
            Target t2 = this.getTarget(assoc);
            if (t1 == null || t2 == null || !(t1 instanceof DependentTarget)) continue;
            DependentTarget dt = (DependentTarget)t1;
            dt.setAssociation((DependentTarget)t2);
        }
    }

    private PackageFile getPkgFile() {
        File dir = this.getPath();
        return PackageFileFactory.getPackageFile(dir);
    }

    public void positionNewTarget(Target t) {
        String targetName = t.getIdentifierName();
        try {
            int numTargets = Integer.parseInt(this.lastSavedProps.getProperty("package.numTargets", "0"));
            for (int i = 0; i < numTargets; ++i) {
                String identifierName = this.lastSavedProps.getProperty("target" + (i + 1) + ".name");
                if (!identifierName.equals(targetName)) continue;
                t.load(this.lastSavedProps, "target" + (i + 1));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.findSpaceForVertex(t);
    }

    private void addImmovableTargets() {
        Target t = new ReadmeTarget(this);
        ((Target)t).load(this.lastSavedProps, "readme");
        t.setPos(10, 10);
        this.addTarget(t);
        if (!this.isUnnamedPackage()) {
            t = new ParentPackageTarget(this);
            this.findSpaceForVertex(t);
            this.addTarget(t);
        }
    }

    public void reload() {
        ClassTarget ct;
        Target target;
        File[] subDirs = this.getPath().listFiles(new SubPackageFilter());
        for (int i = 0; i < subDirs.length; ++i) {
            Target target2;
            if (!JavaNames.isIdentifier(subDirs[i].getName()) || (target2 = this.targets.get(subDirs[i].getName())) != null) continue;
            PackageTarget newtarget = this.addPackage(subDirs[i].getName());
            this.findSpaceForVertex(newtarget);
        }
        Set<String> interestingSet = this.findTargets(this.getPath());
        for (String targetName : interestingSet) {
            Target target3 = this.targets.get(targetName);
            if (target3 != null) continue;
            ClassTarget newtarget = this.addClass(targetName);
            this.findSpaceForVertex(newtarget);
        }
        Iterator<Object> it = this.targets.iterator();
        while (it.hasNext()) {
            target = (Target)it.next();
            if (!(target instanceof ClassTarget)) continue;
            ct = (ClassTarget)target;
            ct.analyseSource();
        }
        it = this.targets.iterator();
        while (it.hasNext()) {
            Class<?> cl;
            target = (Target)it.next();
            if (!(target instanceof ClassTarget) || (cl = this.loadClass((ct = (ClassTarget)target).getQualifiedName())) == null) continue;
            ct.determineRole(cl);
            if (ct.upToDate()) {
                ct.setState(0);
                continue;
            }
            ct.setState(1);
        }
        this.graphChanged();
    }

    public void reReadGraphLayout() throws IOException {
        SortedProperties props = new SortedProperties();
        this.packageFile.load(props);
        int numTargets = 0;
        try {
            numTargets = Integer.parseInt(props.getProperty("package.numTargets", "0"));
        }
        catch (Exception e) {
            Debug.reportError("Error loading from bluej package file " + this.packageFile + ": " + e);
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < numTargets; ++i) {
            Target target = null;
            String identifierName = props.getProperty("target" + (i + 1) + ".name");
            int x = Integer.parseInt(props.getProperty("target" + (i + 1) + ".x"));
            int y = Integer.parseInt(props.getProperty("target" + (i + 1) + ".y"));
            int height = Integer.parseInt(props.getProperty("target" + (i + 1) + ".height"));
            int width = Integer.parseInt(props.getProperty("target" + (i + 1) + ".width"));
            target = this.getTarget(identifierName);
            if (target == null) continue;
            target.setPos(x, y);
            target.setSize(width, height);
        }
        this.repaint();
    }

    public void save(Properties frameProperties) {
        Target t;
        File dir = this.getPath();
        if (!dir.exists() && !dir.mkdir()) {
            Debug.reportError("Error creating directory " + dir);
            return;
        }
        SortedProperties props = new SortedProperties();
        props.putAll((Map<?, ?>)frameProperties);
        props.put("package.numDependencies", String.valueOf(this.usesArrows.size()));
        int t_count = 0;
        Iterator<Target> t_enum = this.targets.iterator();
        while (t_enum.hasNext()) {
            t = t_enum.next();
            if (!t.isSaveable()) continue;
            t.save(props, "target" + (t_count + 1));
            ++t_count;
        }
        props.put("package.numTargets", String.valueOf(t_count));
        t = this.getTarget("@README");
        t.save(props, "readme");
        for (int i = 0; i < this.usesArrows.size(); ++i) {
            Dependency d = this.usesArrows.get(i);
            d.save(props, "dependency" + (i + 1));
        }
        try {
            this.packageFile.save(props);
        }
        catch (IOException e) {
            Debug.reportError("Exception when saving package file : " + e);
            return;
        }
        this.lastSavedProps = props;
    }

    public int importFile(File aFile) {
        if (!aFile.exists()) {
            return 1;
        }
        String fileName = aFile.getName();
        if (!fileName.endsWith(".java")) {
            return 2;
        }
        String className = fileName.substring(0, fileName.length() - 5);
        if (this.getTarget(className) != null) {
            return 4;
        }
        File destFile = new File(this.getPath(), fileName);
        try {
            FileUtility.copyFile(aFile, destFile);
        }
        catch (IOException ioe) {
            return 3;
        }
        ClassTarget t = this.addClass(className);
        this.findSpaceForVertex(t);
        t.analyseSource();
        return 0;
    }

    public ClassTarget addClass(String className) {
        ClassTarget target = new ClassTarget(this, className);
        this.addTarget(target);
        try {
            target.enforcePackage(this.getQualifiedName());
        }
        catch (IOException ioe) {
            Debug.message(ioe.getLocalizedMessage());
        }
        return target;
    }

    public PackageTarget addPackage(String packageName) {
        PackageTarget target = new PackageTarget(this, packageName);
        this.addTarget(target);
        return target;
    }

    public Debugger getDebugger() {
        return this.getProject().getDebugger();
    }

    public Class<?> loadClass(String className) {
        return this.getProject().loadClass(className);
    }

    public Iterator<Target> getVertices() {
        return this.targets.sortediterator();
    }

    @Override
    public Iterator<? extends Edge> getEdges() {
        ArrayList iterations = new ArrayList();
        if (this.showUses) {
            iterations.add(this.usesArrows.iterator());
        }
        if (this.showExtends) {
            iterations.add(this.extendsArrows.iterator());
        }
        return new MultiIterator(iterations);
    }

    public List<ClassTarget> getTestTargets() {
        ArrayList<ClassTarget> l = new ArrayList<ClassTarget>();
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Target target = it.next();
            if (!(target instanceof ClassTarget) || !(ct = (ClassTarget)target).isUnitTest()) continue;
            l.add(ct);
        }
        return l;
    }

    public void compile() {
        if (!this.checkCompile()) {
            return;
        }
        HashSet<ClassTarget> toCompile = new HashSet<ClassTarget>();
        try {
            Iterator<Target> it = this.targets.iterator();
            while (it.hasNext()) {
                ClassTarget ct;
                Target target = it.next();
                if (!(target instanceof ClassTarget) || !(ct = (ClassTarget)target).isInvalidState() || ct.isQueued()) continue;
                ct.ensureSaved();
                toCompile.add(ct);
                ct.setQueued(true);
            }
            this.project.removeClassLoader();
            this.project.newRemoteClassLoaderLeavingBreakpoints();
            this.doCompile(toCompile, new PackageCompileObserver());
        }
        catch (IOException ioe) {
            Debug.log("Error saving class before compile: " + ioe.getLocalizedMessage());
            for (ClassTarget ct : toCompile) {
                ct.setQueued(false);
            }
        }
    }

    public void compile(ClassTarget ct) {
        this.compile(ct, false);
    }

    public void compile(ClassTarget ct, boolean forceQuiet) {
        if (!this.checkCompile()) {
            return;
        }
        ClassTarget assocTarget = (ClassTarget)ct.getAssociation();
        if (assocTarget != null && !assocTarget.hasSourceCode()) {
            assocTarget = null;
        }
        if (ct.hasSourceCode()) {
            ct.setInvalidState();
        } else {
            ct = null;
        }
        if (assocTarget != null) {
            assocTarget.setInvalidState();
        }
        if (ct != null || assocTarget != null) {
            this.project.removeClassLoader();
            this.project.newRemoteClassLoaderLeavingBreakpoints();
            CompilerWarningDialog.getDialog().reset();
            if (ct != null) {
                QuietPackageCompileObserver observer = forceQuiet ? new QuietPackageCompileObserver() : new PackageCompileObserver();
                this.searchCompile(ct, observer);
            }
            if (assocTarget != null) {
                this.searchCompile(assocTarget, new QuietPackageCompileObserver());
            }
        }
    }

    public void compileQuiet(ClassTarget ct) {
        if (!this.isDebuggerIdle()) {
            return;
        }
        ct.setInvalidState();
        this.searchCompile(ct, new QuietPackageCompileObserver());
    }

    public void rebuild() {
        if (!this.checkCompile()) {
            return;
        }
        ArrayList<ClassTarget> compileTargets = new ArrayList<ClassTarget>();
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = it.next();
            if (!(target instanceof ClassTarget)) continue;
            compileTargets.add((ClassTarget)target);
        }
        try {
            Iterator i = compileTargets.iterator();
            while (i.hasNext()) {
                ClassTarget ct = (ClassTarget)i.next();
                if (ct.hasSourceCode()) {
                    ct.ensureSaved();
                    ct.setState(1);
                    ct.setQueued(true);
                    continue;
                }
                i.remove();
            }
            this.project.removeClassLoader();
            this.project.newRemoteClassLoader();
            CompilerWarningDialog.getDialog().reset();
            this.doCompile(compileTargets, new PackageCompileObserver());
        }
        catch (IOException ioe) {
            this.showMessageWithText("file-save-error-before-compile", ioe.getLocalizedMessage());
        }
    }

    public void saveFilesInEditors() throws IOException {
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Editor ed;
            Target target = it.next();
            if (!(target instanceof ClassTarget) || (ed = (ct = (ClassTarget)target).getEditor()) == null) continue;
            ed.save();
        }
    }

    private void searchCompile(ClassTarget t, CompileObserver observer) {
        if (!t.isInvalidState() || t.isQueued()) {
            return;
        }
        HashSet<ClassTarget> toCompile = new HashSet<ClassTarget>();
        try {
            LinkedList<ClassTarget> queue = new LinkedList<ClassTarget>();
            toCompile.add(t);
            t.ensureSaved();
            queue.add(t);
            t.setQueued(true);
            while (!queue.isEmpty()) {
                ClassTarget head = (ClassTarget)queue.remove(0);
                Iterator<? extends Dependency> dependencies = head.dependencies();
                while (dependencies.hasNext()) {
                    ClassTarget to;
                    Dependency d = dependencies.next();
                    if (!(d.getTo() instanceof ClassTarget) || !(to = (ClassTarget)d.getTo()).isInvalidState() || to.isQueued() || !toCompile.add(to)) continue;
                    to.ensureSaved();
                    to.setQueued(true);
                    queue.add(to);
                }
            }
            this.doCompile(toCompile, observer);
        }
        catch (IOException ioe) {
            Debug.log("Failed to save source before compile; " + ioe.getLocalizedMessage());
            for (ClassTarget ct : toCompile) {
                ct.setQueued(false);
            }
        }
    }

    private void doCompile(Collection<ClassTarget> targetList, CompileObserver observer) {
        observer = new EventqueueCompileObserver(observer);
        if (targetList.isEmpty()) {
            return;
        }
        File[] srcFiles = new File[targetList.size()];
        int i = 0;
        for (ClassTarget ct : targetList) {
            srcFiles[i++] = ct.getSourceFile();
        }
        JobQueue.getJobQueue().addJob(srcFiles, observer, this.project.getClassLoader(), this.project.getProjectDir(), !PrefMgr.getFlag("bluej.compiler.showunchecked"), this.project.getProjectCharset());
    }

    public boolean isDebuggerIdle() {
        int status = this.getDebugger().getStatus();
        return status == 2 || status == 1;
    }

    private boolean checkCompile() {
        if (this.isDebuggerIdle()) {
            return true;
        }
        this.showMessage("compile-while-executing");
        return false;
    }

    public String generateDocumentation() {
        return this.project.generateDocumentation();
    }

    public void generateDocumentation(ClassTarget ct) {
        String filename = ct.getSourceFile().getPath();
        this.project.generateDocumentation(filename);
    }

    public void reInitBreakpoints() {
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = it.next();
            if (!(target instanceof ClassTarget)) continue;
            ((ClassTarget)target).reInitBreakpoints();
        }
    }

    public void removeStepMarks() {
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = it.next();
            if (!(target instanceof ClassTarget)) continue;
            ((ClassTarget)target).removeStepMark();
        }
    }

    public void addTarget(Target t) {
        if (t.getPackage() != this) {
            throw new IllegalArgumentException();
        }
        this.targets.add(t.getIdentifierName(), t);
        this.graphChanged();
    }

    public void removeTarget(Target t) {
        this.targets.remove(t.getIdentifierName());
        this.removedSelectableElement(t);
        t.setRemoved();
        this.graphChanged();
    }

    public void updateTargetIdentifier(Target t, String oldIdentifier, String newIdentifier) {
        if (t == null || newIdentifier == null) {
            Debug.reportError("cannot properly update target name...");
            return;
        }
        this.targets.remove(oldIdentifier);
        this.targets.add(newIdentifier, t);
    }

    public void removeArrow(Dependency d) {
        if (!(d instanceof UsesDependency)) {
            this.userRemoveDependency(d);
        }
        this.removeDependency(d, true);
        this.graphChanged();
    }

    public void addDependency(Dependency d, boolean recalc) {
        DependentTarget from = d.getFrom();
        DependentTarget to = d.getTo();
        if (from == null || to == null) {
            return;
        }
        if (d instanceof UsesDependency) {
            int index = this.usesArrows.indexOf(d);
            if (index != -1) {
                ((UsesDependency)this.usesArrows.get(index)).setFlag(true);
                return;
            }
            this.usesArrows.add(d);
        } else {
            if (this.extendsArrows.contains(d)) {
                return;
            }
            this.extendsArrows.add(d);
        }
        from.addDependencyOut(d, recalc);
        to.addDependencyIn(d, recalc);
        DependencyEvent event = new DependencyEvent(d, this, DependencyEvent.Type.DEPENDENCY_ADDED);
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
    }

    public void userAddImplementsClassDependency(Dependency d) {
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        Editor ed = from.getEditor();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                Selection s1 = info.getImplementsInsertSelection();
                ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                if (info.hasInterfaceSelections()) {
                    List<String> exists = this.getInterfaceTexts(ed, info.getInterfaceSelections());
                    if (!exists.contains(to.getBaseName())) {
                        ed.insertText(", " + to.getBaseName(), false);
                    }
                } else {
                    ed.insertText(" implements " + to.getBaseName(), false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void userAddImplementsInterfaceDependency(Dependency d) {
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        Editor ed = from.getEditor();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                Selection s1 = info.getExtendsInsertSelection();
                ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                if (info.hasInterfaceSelections()) {
                    List<String> exists = this.getInterfaceTexts(ed, info.getInterfaceSelections());
                    if (!exists.contains(to.getBaseName())) {
                        ed.insertText(", " + to.getBaseName(), false);
                    }
                } else {
                    ed.insertText(" extends " + to.getBaseName(), false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void userAddExtendsClassDependency(Dependency d) {
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        Editor ed = from.getEditor();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                if (info.getSuperclass() == null) {
                    Selection s1 = info.getExtendsInsertSelection();
                    ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    ed.insertText(" extends " + to.getBaseName(), false);
                } else {
                    Selection s1 = info.getSuperReplaceSelection();
                    ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    ed.insertText(to.getBaseName(), false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void userRemoveDependency(Dependency d) {
        if (!(d.getFrom() instanceof ClassTarget) || !(d.getTo() instanceof ClassTarget)) {
            return;
        }
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        Editor ed = from.getEditor();
        try {
            ed.save();
            ClassInfo info = from.getSourceInfo().getInfo(from.getSourceFile(), this);
            if (info != null) {
                Selection s1 = null;
                if (d instanceof ImplementsDependency) {
                    List<Selection> vsels = info.getInterfaceSelections();
                    List<String> vtexts = this.getInterfaceTexts(ed, vsels);
                    int where = vtexts.indexOf(to.getBaseName());
                    if (where == 1 && vsels.size() > 2) {
                        where = 2;
                    }
                    if (where > 0) {
                        s1 = vsels.get(where - 1);
                        s1.combineWith(vsels.get(where));
                    }
                } else if (d instanceof ExtendsDependency) {
                    s1 = info.getExtendsReplaceSelection();
                    s1.combineWith(info.getSuperReplaceSelection());
                }
                if (s1 != null) {
                    ed.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    ed.insertText("", false);
                }
                ed.save();
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    private List<String> getInterfaceTexts(Editor ed, List<Selection> selections) {
        ArrayList<String> r = new ArrayList<String>(selections.size());
        for (Selection sel : selections) {
            String text = ed.getText(new bluej.parser.SourceLocation(sel.getLine(), sel.getColumn()), new bluej.parser.SourceLocation(sel.getEndLine(), sel.getEndColumn()));
            int taIndex = text.indexOf(60);
            if (taIndex != -1) {
                text = text.substring(0, taIndex);
            }
            text = text.trim();
            r.add(text);
        }
        return r;
    }

    public void removeDependency(Dependency d, boolean recalc) {
        if (d instanceof UsesDependency) {
            this.usesArrows.remove(d);
        } else {
            this.extendsArrows.remove(d);
        }
        DependentTarget from = d.getFrom();
        from.removeDependencyOut(d, recalc);
        DependentTarget to = d.getTo();
        to.removeDependencyIn(d, recalc);
        this.removedSelectableElement(d);
        DependencyEvent event = new DependencyEvent(d, this, DependencyEvent.Type.DEPENDENCY_REMOVED);
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
    }

    private void recalcArrows() {
        Iterator<Target> it = this.getVertices();
        while (it.hasNext()) {
            Target t = it.next();
            if (!(t instanceof DependentTarget)) continue;
            DependentTarget dt = (DependentTarget)t;
            dt.recalcInUses();
            dt.recalcOutUses();
        }
    }

    public Target getTarget(String identifierName) {
        if (identifierName == null) {
            return null;
        }
        Target t = this.targets.get(identifierName);
        return t;
    }

    public DependentTarget getDependentTarget(String identifierName) {
        if (identifierName == null) {
            return null;
        }
        Target t = this.targets.get(identifierName);
        if (t instanceof DependentTarget) {
            return (DependentTarget)t;
        }
        return null;
    }

    public final ArrayList<ClassTarget> getClassTargets() {
        ArrayList<ClassTarget> risul = new ArrayList<ClassTarget>();
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = it.next();
            if (!(target instanceof ClassTarget)) continue;
            risul.add((ClassTarget)target);
        }
        return risul;
    }

    public List<String> getAllClassnames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target t = it.next();
            if (!(t instanceof ClassTarget)) continue;
            ClassTarget ct = (ClassTarget)t;
            names.add(ct.getBaseName());
        }
        return names;
    }

    public List<String> getAllClassnamesWithSource() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Target t = it.next();
            if (!(t instanceof ClassTarget) || !(ct = (ClassTarget)t).hasSourceCode()) continue;
            names.add(ct.getBaseName());
        }
        return names;
    }

    public ClassTarget getTargetFromFilename(String filename) {
        this.getProject().convertPathToPackageName(filename);
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            ClassTarget ct;
            Target t = it.next();
            if (!(t instanceof ClassTarget) || !filename.equals((ct = (ClassTarget)t).getSourceFile().getPath())) continue;
            return ct;
        }
        return null;
    }

    public void setShowUses(boolean state) {
        this.showUses = state;
    }

    public void setShowExtends(boolean state) {
        this.showExtends = state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public static boolean isPackage(File f) {
        if (Config.isGreenfoot()) {
            return GreenfootProjectFile.exists(f);
        }
        return BlueJPackageFile.exists(f);
    }

    public static boolean isPackageFileName(String name) {
        if (Config.isGreenfoot()) {
            return GreenfootProjectFile.isProjectFileName(name);
        }
        return BlueJPackageFile.isPackageFileName(name);
    }

    public void targetSelected(Target t) {
        if (t == null) {
            if (this.getState() != 0) {
                this.setState(0);
                this.setStatus(" ");
            }
            return;
        }
        switch (this.getState()) {
            case 1: {
                if (t instanceof DependentTarget) {
                    this.fromChoice = (DependentTarget)t;
                    this.setState(2);
                    this.setStatus(chooseUsesTo);
                    break;
                }
                this.setState(0);
                this.setStatus(" ");
                break;
            }
            case 2: {
                if (t == this.fromChoice || !(t instanceof DependentTarget)) break;
                this.setState(0);
                this.addDependency(new UsesDependency(this, this.fromChoice, (DependentTarget)t), true);
                this.setStatus(" ");
                break;
            }
            case 3: {
                if (t instanceof DependentTarget) {
                    this.fromChoice = (DependentTarget)t;
                    this.setState(4);
                    this.setStatus(chooseInhTo);
                    break;
                }
                this.setState(0);
                this.setStatus(" ");
                break;
            }
            case 4: {
                if (t == this.fromChoice) break;
                this.setState(0);
                if (t instanceof ClassTarget && this.fromChoice instanceof ClassTarget) {
                    ClassTarget from = (ClassTarget)this.fromChoice;
                    ClassTarget to = (ClassTarget)t;
                    if (to.isInterface()) {
                        ImplementsDependency d = new ImplementsDependency(this, from, to);
                        if (from.isInterface()) {
                            this.userAddImplementsInterfaceDependency(d);
                        } else {
                            this.userAddImplementsClassDependency(d);
                        }
                        this.addDependency(d, true);
                    } else if (!(from.isInterface() || to.isEnum() || from.isEnum())) {
                        ExtendsDependency d = new ExtendsDependency(this, from, to);
                        this.userAddExtendsClassDependency(d);
                        this.addDependency(d, true);
                    }
                }
                this.setStatus(" ");
                break;
            }
        }
    }

    public void showError(String msgId) {
        PkgMgrFrame.showError(this, msgId);
    }

    public void showMessage(String msgId) {
        PkgMgrFrame.showMessage(this, msgId);
    }

    public void showMessageWithText(String msgId, String text) {
        PkgMgrFrame.showMessageWithText(this, msgId, text);
    }

    public void forgetLastSource() {
        this.lastSourceName = "";
    }

    public boolean showSource(String sourcename, int lineNo, String threadName, boolean breakpoint) {
        String msg = " ";
        if (breakpoint) {
            msg = "Thread \"" + threadName + "\" stopped at breakpoint.";
        }
        boolean bringToFront = !sourcename.equals(this.lastSourceName);
        this.lastSourceName = sourcename;
        if (!this.showEditorMessage(new File(this.getPath(), sourcename).getPath(), lineNo, msg, false, bringToFront, true, null) && !breakpoint) {
            this.showMessageWithText("break-no-source", sourcename);
        }
        return bringToFront;
    }

    private boolean showEditorMessage(String filename, int lineNo, final String message, boolean beep, boolean bringToFront, boolean setStepMark, String help) {
        return this.showEditorMessage(filename, lineNo, new MessageCalculator(){

            @Override
            public String calculateMessage(Editor e) {
                return message;
            }
        }, beep, bringToFront, setStepMark, help);
    }

    private boolean showEditorMessage(String filename, int lineNo, MessageCalculator messageCalc, boolean beep, boolean bringToFront, boolean setStepMark, String help) {
        String fullName = this.getProject().convertPathToPackageName(filename);
        if (fullName == null) {
            return false;
        }
        String packageName = JavaNames.getPrefix(fullName);
        String className = JavaNames.getBase(fullName);
        ClassTarget t = null;
        if (packageName != this.getQualifiedName()) {
            Package pkg = this.getProject().getPackage(packageName);
            if (pkg != null) {
                PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
                pmf = PkgMgrFrame.findFrame(pkg);
                if (pmf == null) {
                    pmf = PkgMgrFrame.createFrame(pkg);
                }
                pmf.setVisible(true);
                t = (ClassTarget)pkg.getTarget(className);
            }
        } else {
            t = (ClassTarget)this.getTarget(className);
        }
        if (t == null) {
            return false;
        }
        Editor editor = t.getEditor();
        if (editor != null) {
            if (bringToFront || !editor.isShowing()) {
                t.open();
            }
            editor.displayMessage(messageCalc.calculateMessage(editor), lineNo, 0, beep, setStepMark, help);
        } else {
            Debug.message(t.getDisplayName() + ", line" + lineNo + ": " + messageCalc.calculateMessage(null));
        }
        return true;
    }

    private boolean showEditorDiagnostic(Diagnostic diagnostic, MessageCalculator messageCalc) {
        String fileName = diagnostic.getFileName();
        if (fileName == null) {
            return false;
        }
        String fullName = this.getProject().convertPathToPackageName(diagnostic.getFileName());
        if (fullName == null) {
            return false;
        }
        String packageName = JavaNames.getPrefix(fullName);
        String className = JavaNames.getBase(fullName);
        ClassTarget t = null;
        if (packageName != this.getQualifiedName()) {
            Package pkg = this.getProject().getPackage(packageName);
            if (pkg != null) {
                PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
                pmf = PkgMgrFrame.findFrame(pkg);
                if (pmf == null) {
                    pmf = PkgMgrFrame.createFrame(pkg);
                }
                pmf.setVisible(true);
                t = (ClassTarget)pkg.getTarget(className);
            }
        } else {
            t = (ClassTarget)this.getTarget(className);
        }
        if (t == null) {
            return false;
        }
        Editor editor = t.getEditor();
        if (editor != null) {
            editor.setVisible(true);
            if (messageCalc != null) {
                diagnostic.setMessage(messageCalc.calculateMessage(editor));
            }
            editor.displayDiagnostic(diagnostic);
        } else {
            Debug.message(t.getDisplayName() + ", line" + diagnostic.getStartLine() + ": " + diagnostic.getMessage());
        }
        return true;
    }

    public void hitBreakpoint(DebuggerThread thread) {
        this.showSource(thread.getClassSourceName(0), thread.getLineNumber(0), thread.getName(), true);
        this.getProject().getExecControls().showHide(true);
        this.getProject().getExecControls().makeSureThreadIsSelected(thread);
    }

    public void hitHalt(DebuggerThread thread) {
        this.showSourcePosition(thread);
        this.getProject().getExecControls().showHide(true);
        this.getProject().getExecControls().makeSureThreadIsSelected(thread);
    }

    public void showSourcePosition(DebuggerThread thread) {
        int frame = thread.getSelectedFrame();
        if (this.showSource(thread.getClassSourceName(frame), thread.getLineNumber(frame), thread.getName(), false)) {
            this.getProject().getExecControls().setVisible(true);
        }
    }

    public void exceptionMessage(ExceptionDescription exception) {
        SourceLocation loc;
        String text = exception.getClassName();
        if (text == null) {
            this.reportException(exception.getText());
            return;
        }
        String message = text + ":\n" + exception.getText();
        List<SourceLocation> stack = exception.getStack();
        if (stack == null || stack.size() == 0) {
            return;
        }
        boolean done = false;
        Iterator<SourceLocation> iter = stack.iterator();
        boolean firstTime = true;
        while (!done && iter.hasNext()) {
            loc = iter.next();
            String filename = new File(this.getPath(), loc.getFileName()).getPath();
            int lineNo = loc.getLineNumber();
            done = this.showEditorMessage(filename, lineNo, message, true, true, false, "exception");
            if (!firstTime || done) continue;
            message = message + " (in " + loc.getClassName() + ")";
            firstTime = false;
        }
        if (!done) {
            loc = stack.get(0);
            this.showMessageWithText("error-in-file", loc.getClassName() + ":" + loc.getLineNumber() + "\n" + message);
        }
    }

    public void exceptionMessage(String className, int lineNumber) {
        this.showEditorMessage(className, lineNumber, "", false, true, false, "exception");
    }

    public void reportException(String text) {
        this.showMessageWithText("exception-thrown", text);
    }

    protected static String getResourcePath(Class<?> c) {
        URL srcUrl = c.getResource(c.getSimpleName() + ".class");
        try {
            if (srcUrl != null) {
                if (srcUrl.getProtocol().equals("file")) {
                    File srcFile = new File(srcUrl.toURI());
                    return srcFile.toString();
                }
                if (srcUrl.getProtocol().equals("jar")) {
                    int classIndex = srcUrl.toString().indexOf("!");
                    String subUrl = srcUrl.toString().substring(4, classIndex);
                    if (subUrl.startsWith("file:")) {
                        return new File(new URI(subUrl)).toString();
                    }
                    if (classIndex != -1) {
                        return srcUrl.toString().substring(4, classIndex);
                    }
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return srcUrl.toString();
    }

    public static boolean checkClassMatchesFile(Class<?> c, File f) {
        block5: {
            try {
                URL srcUrl = c.getResource(c.getSimpleName() + ".class");
                if (srcUrl == null) {
                    return true;
                }
                if (srcUrl != null && srcUrl.getProtocol().equals("file")) {
                    File srcFile = new File(srcUrl.toURI());
                    if (!f.equals(srcFile)) {
                        return false;
                    }
                    break block5;
                }
                return false;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return true;
    }

    public void closeAllEditors() {
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            EditableTarget et;
            Target t = it.next();
            if (!(t instanceof EditableTarget) || !(et = (EditableTarget)t).editorOpen()) continue;
            et.getEditor().close();
        }
    }

    public CallHistory getCallHistory() {
        return this.callHistory;
    }

    public String toString() {
        return "Package:" + this.getQualifiedName();
    }

    private class PackageCompileObserver
    extends QuietPackageCompileObserver {
        private boolean hadError;

        private PackageCompileObserver() {
        }

        @Override
        public void startCompile(File[] sources) {
            this.hadError = false;
            super.startCompile(sources);
        }

        @Override
        public boolean compilerMessage(Diagnostic diagnostic) {
            super.compilerMessage(diagnostic);
            if (diagnostic.getType() == Diagnostic.ERROR) {
                return this.errorMessage(diagnostic);
            }
            return this.warningMessage(diagnostic.getFileName(), (int)diagnostic.getStartLine(), diagnostic.getMessage());
        }

        private boolean errorMessage(Diagnostic diagnostic) {
            if (!this.hadError) {
                this.hadError = true;
                if (diagnostic.getFileName() == null) {
                    Package.this.showMessageWithText("compiler-error", diagnostic.getMessage());
                    return true;
                }
                String message = diagnostic.getMessage();
                boolean messageShown = message.contains("cannot find symbol - method") ? Package.this.showEditorDiagnostic(diagnostic, new MisspeltMethodChecker(message, (int)diagnostic.getStartColumn(), (int)diagnostic.getStartLine(), Package.this.project)) : Package.this.showEditorDiagnostic(diagnostic, null);
                if (!messageShown) {
                    Package.this.showMessageWithText("error-in-file", diagnostic.getFileName() + ":" + diagnostic.getStartLine() + "\n" + message);
                }
                return true;
            }
            return false;
        }

        private boolean warningMessage(String filename, int lineNo, String message) {
            CompilerWarningDialog.getDialog().addWarningMessage(message);
            return true;
        }
    }

    private static class MisspeltMethodChecker
    implements MessageCalculator {
        private static final int MAX_EDIT_DISTANCE = 2;
        private final String message;
        private int lineNumber;
        private int column;
        private Project project;

        public MisspeltMethodChecker(String message, int column, int lineNumber, Project project) {
            this.message = message;
            this.column = column;
            this.lineNumber = lineNumber;
            this.project = project;
        }

        private static String chopAtOpeningBracket(String name) {
            int openingBracket = name.indexOf(40);
            if (openingBracket >= 0) {
                return name.substring(0, openingBracket);
            }
            return name;
        }

        private String getLine(Editor e) {
            return e.getText(new bluej.parser.SourceLocation(this.lineNumber, 1), new bluej.parser.SourceLocation(this.lineNumber, e.getLineLength(this.lineNumber - 1)));
        }

        private int getLineStart(Editor e) {
            return e.getOffsetFromLineColumn(new bluej.parser.SourceLocation(this.lineNumber, 1));
        }

        private static int editDistance(String s, String t) {
            int j;
            int i;
            int n = s.length();
            int m = t.length();
            if (n == 0) {
                return m;
            }
            if (m == 0) {
                return n;
            }
            int[][] d = new int[n + 1][m + 1];
            for (i = 0; i <= n; ++i) {
                d[i][0] = i;
            }
            for (j = 0; j <= m; ++j) {
                d[0][j] = j;
            }
            for (i = 1; i <= n; ++i) {
                char s_i = s.charAt(i - 1);
                for (j = 1; j <= m; ++j) {
                    char t_j = t.charAt(j - 1);
                    int cost = s_i == t_j ? 0 : 1;
                    d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
                }
            }
            return d[n][m];
        }

        @Override
        public String calculateMessage(Editor e) {
            if (e == null) {
                return this.message;
            }
            String missing = MisspeltMethodChecker.chopAtOpeningBracket(this.message.substring(this.message.lastIndexOf(32) + 1));
            String lineText = this.getLine(e);
            int pos = MisspeltMethodChecker.convertColumn(lineText, this.column) + this.getLineStart(e);
            LinkedList<String> maybeTheyMeant = new LinkedList<String>();
            CodeSuggestions suggests = e.getParsedNode().getExpressionType(pos, e.getSourceDocument());
            AssistContent[] values = ParseUtils.getPossibleCompletions(suggests, "", this.project.getJavadocResolver());
            if (values != null) {
                for (AssistContent a : values) {
                    String name = MisspeltMethodChecker.chopAtOpeningBracket(a.getDisplayName());
                    if (MisspeltMethodChecker.editDistance(name.toLowerCase(), missing.toLowerCase()) > 2) continue;
                    maybeTheyMeant.addLast(a.getDisplayName());
                }
            }
            if (maybeTheyMeant.isEmpty()) {
                return this.message;
            }
            String augmentedMessage = this.message + "; maybe you meant: " + (String)maybeTheyMeant.getFirst();
            maybeTheyMeant.removeFirst();
            for (String sugg : maybeTheyMeant) {
                augmentedMessage = augmentedMessage + " or " + sugg;
            }
            return augmentedMessage;
        }

        private static int convertColumn(String string, int column) {
            int ccount = 0;
            int lpos = 0;
            int tabIndex = string.indexOf(9);
            while (tabIndex != -1 && lpos < column - 1) {
                lpos += tabIndex - ccount;
                ccount = tabIndex;
                if (lpos >= column - 1) break;
                lpos = (lpos + 8) / 8 * 8;
                tabIndex = string.indexOf(9, ++ccount);
            }
            return ccount += column - lpos;
        }
    }

    private class QuietPackageCompileObserver
    implements CompileObserver {
        private QuietPackageCompileObserver() {
        }

        private void markAsCompiling(File[] sources) {
            for (int i = 0; i < sources.length; ++i) {
                Target t;
                String fileName = sources[i].getPath();
                String fullName = Package.this.getProject().convertPathToPackageName(fileName);
                if (fullName == null || !((t = Package.this.getTarget(JavaNames.getBase(fullName))) instanceof ClassTarget)) continue;
                ClassTarget ct = (ClassTarget)t;
                ct.setState(2);
            }
        }

        private void sendEventToExtensions(String filename, int[] errorPosition, String message, int eventType) {
            File[] sources = filename != null ? new File[]{new File(filename)} : new File[]{};
            CompileEvent aCompileEvent = new CompileEvent(eventType, sources);
            aCompileEvent.setErrorPosition(errorPosition);
            aCompileEvent.setErrorMessage(message);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
        }

        @Override
        public void startCompile(File[] sources) {
            CompileEvent aCompileEvent = new CompileEvent(1, sources);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
            Package.this.setStatus(compiling);
            this.markAsCompiling(sources);
        }

        @Override
        public boolean compilerMessage(Diagnostic diagnostic) {
            int[] errorPosition = new int[]{(int)diagnostic.getStartLine(), (int)diagnostic.getStartColumn(), (int)diagnostic.getEndLine(), (int)diagnostic.getEndColumn()};
            if (diagnostic.getType() == Diagnostic.ERROR) {
                this.errorMessage(diagnostic.getFileName(), errorPosition, diagnostic.getMessage());
            } else {
                this.warningMessage(diagnostic.getFileName(), errorPosition, diagnostic.getMessage());
            }
            return false;
        }

        private void errorMessage(String filename, int[] errorPosition, String message) {
            this.sendEventToExtensions(filename, errorPosition, message, 3);
        }

        private void warningMessage(String filename, int[] errorPosition, String message) {
            this.sendEventToExtensions(filename, errorPosition, message, 2);
        }

        @Override
        public void endCompile(File[] sources, boolean successful) {
            for (int i = 0; i < sources.length; ++i) {
                ClassTarget t;
                String filename = sources[i].getPath();
                String fullName = Package.this.getProject().convertPathToPackageName(filename);
                if (fullName == null || (t = (ClassTarget)Package.this.targets.get(JavaNames.getBase(fullName))) == null) continue;
                boolean newCompiledState = successful;
                if (successful) {
                    t.endCompile();
                    Class<?> c = Package.this.loadClass(Package.this.getQualifiedName(t.getIdentifierName()));
                    if (c != null && !Package.checkClassMatchesFile(c, t.getClassFile())) {
                        String conflict = Package.getResourcePath(c);
                        DialogManager.showMessageWithPrefixText(null, "compile-class-library-conflict", t.getIdentifierName() + ":", conflict);
                    }
                    try {
                        ClassInfo info = t.getSourceInfo().getInfo(t.getSourceFile(), t.getPackage());
                        if (info != null) {
                            FileOutputStream out = new FileOutputStream(t.getContextFile());
                            info.getComments().store(out, "BlueJ class context");
                            ((OutputStream)out).close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    newCompiledState &= t.upToDate();
                }
                t.setState(newCompiledState ? 0 : 1);
                t.setQueued(false);
                if (!successful || !t.editorOpen()) continue;
                t.getEditor().setCompiled(true);
            }
            Package.this.setStatus(compileDone);
            Package.this.graphChanged();
            int eventId = successful ? 4 : 5;
            CompileEvent aCompileEvent = new CompileEvent(eventId, sources);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
        }
    }

    public static interface MessageCalculator {
        public String calculateMessage(Editor var1);
    }
}

