/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import bluej.utility.MultiLineLabel;
import bluej.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class AboutBlue
extends EscapeDialog {
    private static final String BLUEJ_URL = "http://www.bluej.org";
    private static final Color linkColor = new Color(0, 76, 134);

    public AboutBlue(JFrame parent, String version) {
        super(parent, Config.getString("menu.help.about"), true);
        JPanel aboutPanel = new JPanel();
        aboutPanel.setBorder(BlueJTheme.dialogBorder);
        aboutPanel.setLayout(new BorderLayout(12, 0));
        aboutPanel.setBackground(Color.white);
        ImageIcon icon = Config.getFixedImageAsIcon("about-logo.jpg");
        JLabel logoLabel = new JLabel(icon);
        aboutPanel.add((Component)logoLabel, "West");
        MultiLineLabel text = new MultiLineLabel(0.0f, 6);
        text.setBackground(Color.white);
        text.addText(Config.getString("about.theTeam") + "\n ", false, true);
        text.addText("  Neil Brown\n");
        text.addText("  Michael K\u00f6lling\n");
        text.addText("  Davin McCall\n");
        text.addText("  Philip Stevens\n");
        text.addText("  John Rosenberg\n");
        text.addText("  Ian Utting\n");
        text.addText("  Marion Zalk");
        aboutPanel.add((Component)text, "Center");
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 3));
        bottom.setBackground(Color.white);
        MultiLineLabel bottomtext = new MultiLineLabel(0.0f);
        bottomtext.setBackground(Color.white);
        bottomtext.addText(" ");
        bottomtext.addText(Config.getString("about.bluej.version") + " " + version + "  (" + Config.getString("about.java.version") + " " + System.getProperty("java.version") + ")", true, false);
        bottomtext.addText(" ");
        bottomtext.addText(Config.getString("about.vm") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
        bottomtext.addText(Config.getString("about.runningOn") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        bottomtext.addText(Config.getString("about.javahome") + " " + System.getProperty("java.home"));
        bottomtext.addText(" ");
        bottomtext.addText(Config.getString("about.logfile") + " " + Config.getUserConfigFile(Config.debugLogName));
        bottomtext.addText(" ");
        bottom.add(bottomtext);
        try {
            final URL bluejURL = new URL(BLUEJ_URL);
            JLabel urlField = new JLabel(BLUEJ_URL);
            urlField.setCursor(new Cursor(12));
            urlField.setForeground(linkColor);
            urlField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Utility.openWebBrowser(bluejURL.toExternalForm());
                }
            });
            JPanel urlPanel = new JPanel();
            urlPanel.setBackground(Color.white);
            urlPanel.setAlignmentX(0.0f);
            urlPanel.add(new JLabel(Config.getString("about.moreInformation")));
            urlPanel.add(urlField);
            bottom.add(urlPanel);
        }
        catch (MalformedURLException exc) {
            // empty catch block
        }
        aboutPanel.add((Component)bottom, "South");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton ok = BlueJTheme.getOkButton();
        buttonPanel.add(ok);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)aboutPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AboutBlue.this.setVisible(false);
                AboutBlue.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Window win = (Window)event.getSource();
                win.setVisible(false);
                win.dispose();
            }
        });
        this.setResizable(false);
        this.pack();
        DialogManager.centreDialog(this);
    }
}

