/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.DocumentReader;
import bluej.parser.EditorParser;
import bluej.parser.EscapedUnicodeReader;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParseParams;
import bluej.parser.nodes.ParsedNode;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public abstract class IncrementalParsingNode
extends JavaParentNode {
    protected int[] stateMarkers = new int[0];
    protected boolean[] marksEnd = new boolean[0];
    protected LocatableToken last;
    protected static final int PP_OK = 0;
    protected static final int PP_INCOMPLETE = 1;
    protected static final int PP_ENDS_NODE = 2;
    protected static final int PP_ENDS_NODE_AFTER = 3;
    protected static final int PP_EPIC_FAIL = 4;
    protected static final int PP_ENDS_STATE = 5;
    protected static final int PP_BEGINS_NEXT_STATE = 6;
    protected static final int PP_REGRESS_STATE = 7;
    protected static final int PP_PULL_UP_CHILD = 8;
    protected static final int PP_ABORT = 9;

    public IncrementalParsingNode(JavaParentNode parent) {
        super(parent);
    }

    protected abstract boolean isDelimitingNode(NodeTree.NodeAndPosition<ParsedNode> var1);

    protected abstract int doPartialParse(ParseParams var1, int var2);

    protected boolean isNodeEndMarker(int tokenType) {
        return tokenType == 100;
    }

    @Override
    protected int reparseNode(Document document, int nodePos, int offset, int maxParse, NodeStructureListener listener) {
        int parseEnd = Math.min(offset + maxParse, nodePos + this.getSize());
        int state = this.getCurrentState(offset - nodePos);
        int originalOffset = offset;
        int stateBoundary = state != 0 ? this.stateMarkers[state - 1] + nodePos : nodePos;
        NodeTree.NodeAndPosition<ParsedNode> nap = null;
        if (offset > stateBoundary) {
            nap = this.getNodeTree().findNodeAtOrBefore(offset - 1, nodePos);
        }
        while (nap != null && !this.isDelimitingNode(nap)) {
            if (nap.getPosition() >= stateBoundary) {
                nap = this.getNodeTree().findNodeAtOrBefore(nap.getPosition() - 1, nodePos);
                continue;
            }
            nap = null;
        }
        NodeTree.NodeAndPosition<ParsedNode> nextNap = null;
        if (nap != null) {
            nextNap = nap.nextSibling();
            offset = nap.getEnd();
        } else {
            offset = stateBoundary;
        }
        NodeTree.NodeAndPosition<ParsedNode> boundaryNap = nap;
        LinkedList<NodeTree.NodeAndPosition<ParsedNode>> childQueue = new LinkedList<NodeTree.NodeAndPosition<ParsedNode>>();
        nap = nap == null ? this.findNodeAtOrAfter(offset + 1, nodePos) : nextNap;
        while (nap != null) {
            childQueue.add(nap);
            nextNap = nap.nextSibling();
            nap.getNode().remove();
            nap = nextNap;
        }
        NodeTree.NodeAndPosition<ParsedNode> nextChild = (NodeTree.NodeAndPosition<ParsedNode>)childQueue.peek();
        int pline = document.getDefaultRootElement().getElementIndex(offset) + 1;
        int pcol = offset - document.getDefaultRootElement().getElement(pline - 1).getStartOffset() + 1;
        DocumentReader r = new DocumentReader(document, offset, parseEnd);
        EditorParser parser = new EditorParser(document, r, pline, pcol, offset, this.buildScopeStack());
        LocatableToken laToken = parser.getTokenStream().LA(1);
        int ttype = laToken.getType();
        int tokpos = IncrementalParsingNode.lineColToPos(document, laToken.getLine(), laToken.getColumn());
        nap = boundaryNap;
        boolean extendPrev = false;
        if (nap != null && !nap.getNode().complete) {
            extendPrev = true;
        }
        if (extendPrev) {
            int tokend = IncrementalParsingNode.lineColToPos(document, laToken.getEndLine(), laToken.getEndColumn());
            if (ttype == 1) {
                boolean weCanGrow;
                boolean bl = weCanGrow = nodePos + this.getSize() < document.getLength();
                if (!weCanGrow && tokend == nap.getEnd()) {
                    ((MoeSyntaxDocument)document).markSectionParsed(offset, tokend - offset + 1);
                    return 0;
                }
                if (weCanGrow) {
                    boolean grew = this.getParentNode().growChild(document, new NodeTree.NodeAndPosition<ParsedNode>(this, nodePos, this.getSize()), listener);
                    if (!grew) {
                        return 3;
                    }
                    this.complete = false;
                    return 0;
                }
            }
            nextChild = this.removeOverwrittenChildren(childQueue, tokend, listener);
            int oldSize = nap.getSize();
            nap.setSize(tokend - nap.getPosition());
            listener.nodeChangedLength(nap, nap.getPosition(), oldSize);
            int pr = nap.getNode().reparseNode(document, nap.getPosition(), tokpos, parseEnd - tokpos, listener);
            if (pr == 3) {
                this.removeChild(nap, listener);
                ((MoeSyntaxDocument)document).scheduleReparse(originalOffset, tokend - originalOffset);
                return 0;
            }
            if (nap.getNode().getSize() != oldSize) {
                if (!nap.getNode().complete) {
                    return 0;
                }
                offset = nap.getPosition() + nap.getNode().getSize();
                pline = document.getDefaultRootElement().getElementIndex(offset) + 1;
                pcol = offset - document.getDefaultRootElement().getElement(pline - 1).getStartOffset() + 1;
                r = new DocumentReader(document, offset, parseEnd);
                parser = new EditorParser(document, r, pline, pcol, offset, this.buildScopeStack());
                laToken = parser.getTokenStream().LA(1);
                tokpos = IncrementalParsingNode.lineColToPos(document, laToken.getLine(), laToken.getColumn());
            }
        }
        int nextStatePos = state < this.stateMarkers.length ? this.stateMarkers[state] : -1;
        nextStatePos += nextStatePos == -1 ? 0 : nodePos;
        ParseParams pparams = new ParseParams();
        pparams.listener = listener;
        pparams.parser = parser;
        pparams.tokenStream = parser.getTokenStream();
        pparams.document = (MoeSyntaxDocument)document;
        pparams.nodePos = nodePos;
        pparams.childQueue = childQueue;
        while (!this.isNodeEndMarker(ttype)) {
            int ppr = this.doPartialParse(pparams, state);
            nextChild = childQueue.peek();
            if (ppr == 2 || ppr == 3 || ppr == 1 && this.last.getType() != 1) {
                int pos = ppr == 3 ? IncrementalParsingNode.lineColToPos(document, this.last.getEndLine(), this.last.getEndColumn()) : IncrementalParsingNode.lineColToPos(document, this.last.getLine(), this.last.getColumn());
                pparams.document.markSectionParsed(offset, pos - offset);
                int newsize = pos - nodePos;
                if (!this.complete) {
                    pparams.document.scheduleReparse(nodePos + newsize, 0);
                }
                this.complete = ppr != 1;
                int oldSize = this.getSize();
                this.endNodeCleanup(pparams, state, Integer.MAX_VALUE, nodePos + newsize);
                if (newsize != oldSize) {
                    this.setSize(newsize);
                    nap = new NodeTree.NodeAndPosition<IncrementalParsingNode>(this, nodePos, newsize);
                    listener.nodeChangedLength(nap, nodePos, oldSize);
                    return 2;
                }
                return 0;
            }
            if (ppr == 1) {
                if (parseEnd != nodePos + this.getSize()) {
                    pparams.document.scheduleReparse(parseEnd, 0);
                    pparams.document.markSectionParsed(offset, parseEnd - offset);
                    return 0;
                }
                this.complete = false;
            } else {
                if (ppr == 4) {
                    this.removeOverwrittenChildren(childQueue, Integer.MAX_VALUE, listener);
                    return 3;
                }
                if (ppr == 5 || ppr == 6) {
                    int pos = ppr == 5 ? IncrementalParsingNode.lineColToPos(document, this.last.getEndLine(), this.last.getEndColumn()) : IncrementalParsingNode.lineColToPos(document, this.last.getLine(), this.last.getColumn());
                    if (this.stateMarkers[state] == pos - nodePos) {
                        nextChild = this.removeOverwrittenChildren(childQueue, pos, listener);
                        this.processChildQueue(nodePos, childQueue, nextChild);
                        parser.completedNode(this, nodePos, pos - nodePos);
                        pparams.document.markSectionParsed(offset, pos - offset);
                        return 0;
                    }
                    this.stateMarkers[state] = pos - nodePos;
                    this.marksEnd[state] = ppr == 5;
                    nextStatePos = ++state < this.stateMarkers.length ? this.stateMarkers[state] : -1;
                } else {
                    if (ppr == 7) {
                        int rppos = this.stateMarkers[--state] + nodePos;
                        pparams.document.scheduleReparse(rppos, Math.max(offset - rppos, 0));
                        this.stateMarkers[state] = -1;
                        int epos = IncrementalParsingNode.lineColToPos(document, this.last.getLine(), this.last.getColumn());
                        this.removeOverwrittenChildren(childQueue, epos, listener);
                        this.processChildQueue(nodePos, childQueue, nextChild);
                        return 0;
                    }
                    if (ppr == 8) {
                        nextChild = childQueue.peek();
                        this.processChildQueue(nodePos, childQueue, nextChild);
                        parser.completedNode(this, nodePos, pparams.abortPos - nodePos);
                        tokpos = IncrementalParsingNode.lineColToPos(document, this.last.getLine(), this.last.getColumn());
                        int ncpos = nextChild.getPosition();
                        if (ncpos != pparams.abortPos) {
                            int slideAmount = nextChild.getPosition() - pparams.abortPos;
                            nextChild.slide(-slideAmount);
                            int rr = nextChild.getNode().textInserted((MoeSyntaxDocument)document, nextChild.getPosition(), nextChild.getPosition(), slideAmount, listener);
                            if (rr == 3) {
                                this.removeChild(nextChild, listener);
                            } else {
                                nextChild.setNapSize(nextChild.getNode().getSize());
                                this.childResized(pparams.document, nodePos, nextChild);
                            }
                            listener.nodeChangedLength(nextChild, ncpos, nextChild.getSize() - slideAmount);
                            pparams.document.scheduleReparse(nextChild.getPosition(), slideAmount);
                        }
                        pparams.document.markSectionParsed(offset, pparams.abortPos - offset);
                        return 0;
                    }
                    if (ppr == 9) {
                        nextChild = this.removeOverwrittenChildren(childQueue, pparams.abortPos, listener);
                        this.processChildQueue(nodePos, childQueue, nextChild);
                        parser.completedNode(this, nodePos, pparams.abortPos - nodePos);
                        pparams.document.markSectionParsed(offset, pparams.abortPos - offset);
                        return 0;
                    }
                }
            }
            LocatableToken nlaToken = parser.getTokenStream().LA(1);
            if (nlaToken == laToken) {
                parser.getTokenStream().nextToken();
                nlaToken = parser.getTokenStream().LA(1);
            }
            int nlaPos = IncrementalParsingNode.lineColToPos(document, nlaToken.getLine(), nlaToken.getColumn());
            for (int i = state; i < this.stateMarkers.length; ++i) {
                if (this.stateMarkers[i] + nodePos >= nlaPos) continue;
                this.stateMarkers[i] = -1;
            }
            if (nlaToken.getType() == 1) {
                this.endNodeCleanup(pparams, state, parseEnd, parseEnd);
                this.processChildQueue(nodePos, childQueue, childQueue.peek());
                if (parseEnd < nodePos + this.getSize()) {
                    parser.completedNode(this, nodePos, this.getSize());
                    pparams.document.markSectionParsed(offset, parseEnd - offset);
                    pparams.document.scheduleReparse(parseEnd, 0);
                    return 0;
                }
                if (!this.complete) {
                    JavaParentNode parentNode = this.getParentNode();
                    if (parentNode != null && ((ParsedNode)parentNode).growChild(document, new NodeTree.NodeAndPosition<ParsedNode>(this, nodePos, this.getSize()), listener)) {
                        pparams.document.markSectionParsed(offset, parseEnd - offset);
                        pparams.document.scheduleReparse(parseEnd, nodePos + this.getSize() - parseEnd);
                        return 1;
                    }
                    if (nodePos + this.getSize() < document.getLength()) {
                        return 3;
                    }
                }
                pparams.document.markSectionParsed(offset, parseEnd - offset);
                return this.checkEnd(document, nodePos, listener);
            }
            laToken = nlaToken;
            ttype = laToken.getType();
            tokpos = nlaPos;
        }
        this.removeOverwrittenChildren(childQueue, Integer.MAX_VALUE, listener);
        tokpos = IncrementalParsingNode.lineColToPos(document, laToken.getLine(), laToken.getColumn());
        pparams.document.markSectionParsed(offset, tokpos - offset);
        int newsize = tokpos - nodePos;
        parser.completedNode(this, nodePos, newsize);
        if (!this.complete) {
            pparams.document.scheduleReparse(nodePos + newsize, 0);
        }
        this.complete = true;
        int oldSize = this.getSize();
        if (newsize < oldSize) {
            this.setSize(newsize);
            nap = new NodeTree.NodeAndPosition<IncrementalParsingNode>(this, nodePos, newsize);
            listener.nodeChangedLength(nap, nodePos, oldSize);
            return 2;
        }
        return 0;
    }

    protected boolean checkBoundary(ParseParams params, LocatableToken token) {
        int lpos;
        int hpos = lpos = IncrementalParsingNode.lineColToPos((Document)params.document, token.getLine(), token.getColumn());
        LocatableToken hidden = token.getHiddenBefore();
        if (hidden != null) {
            hpos = IncrementalParsingNode.lineColToPos((Document)params.document, hidden.getLine(), hidden.getColumn());
        }
        NodeTree.NodeAndPosition<ParsedNode> nextChild = params.childQueue.peek();
        while (nextChild != null) {
            if (this.isDelimitingNode(nextChild)) {
                boolean hasComment = nextChild.getNode().isCommentAttached();
                if (hasComment && nextChild.getPosition() == hpos) {
                    params.abortPos = hpos;
                    return true;
                }
                if (!hasComment && nextChild.getPosition() == lpos) {
                    int nextType = nextChild.getNode().getNodeType();
                    boolean wantsComment = nextType == 1 || nextType == 2;
                    params.abortPos = wantsComment ? hpos : lpos;
                    return true;
                }
            }
            if (nextChild.getPosition() > lpos) break;
            this.childRemoved(nextChild, params.listener);
            params.childQueue.poll();
            nextChild = params.childQueue.peek();
        }
        return false;
    }

    private void endNodeCleanup(ParseParams params, int state, int rpos, int epos) {
        while (state < this.stateMarkers.length) {
            if (this.stateMarkers[state] < rpos || this.stateMarkers[state] == rpos && this.marksEnd[state]) {
                this.stateMarkers[state] = -1;
            }
            ++state;
        }
        this.removeOverwrittenChildren(params.childQueue, rpos, params.listener);
        params.parser.completedNode(this, params.nodePos, epos - params.nodePos);
    }

    private Stack<JavaParentNode> buildScopeStack() {
        Stack<JavaParentNode> r = new Stack<JavaParentNode>();
        JavaParentNode pn = this;
        do {
            r.add(0, pn);
        } while ((pn = pn.getParentNode()) != null);
        return r;
    }

    private NodeTree.NodeAndPosition<ParsedNode> removeOverwrittenChildren(LinkedList<NodeTree.NodeAndPosition<ParsedNode>> childQueue, int epos, NodeStructureListener listener) {
        NodeTree.NodeAndPosition<ParsedNode> nextChild = childQueue.peek();
        while (nextChild != null && (epos > nextChild.getPosition() || epos >= nextChild.getEnd())) {
            this.childRemoved(nextChild, listener);
            childQueue.removeFirst();
            nextChild = childQueue.peek();
        }
        return nextChild;
    }

    private void processChildQueue(int nodePos, LinkedList<NodeTree.NodeAndPosition<ParsedNode>> childQueue, NodeTree.NodeAndPosition<ParsedNode> nextChild) {
        while (nextChild != null) {
            this.insertNode(nextChild.getNode(), nextChild.getPosition() - nodePos, nextChild.getSize());
            childQueue.removeFirst();
            nextChild = childQueue.peek();
        }
    }

    protected static int lineColToPos(Document document, int line, int col) {
        return document.getDefaultRootElement().getElement(line - 1).getStartOffset() + col - 1;
    }

    private int getCurrentState(int pos) {
        for (int i = this.stateMarkers.length - 1; i >= 0; --i) {
            if (pos < this.stateMarkers[i] || this.stateMarkers[i] < 0) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public int textInserted(MoeSyntaxDocument document, int nodePos, int insPos, int length, NodeStructureListener listener) {
        for (int i = 0; i < this.stateMarkers.length; ++i) {
            if (this.stateMarkers[i] <= insPos - nodePos && (this.stateMarkers[i] != insPos - nodePos || this.marksEnd[i])) continue;
            int n = i;
            this.stateMarkers[n] = this.stateMarkers[n] + length;
            while (i < this.stateMarkers.length) {
                if (this.stateMarkers[i] >= 0) {
                    int n2 = i;
                    this.stateMarkers[n2] = this.stateMarkers[n2] + length;
                }
                ++i;
            }
            break;
        }
        int result = super.textInserted(document, nodePos, insPos, length, listener);
        return result;
    }

    @Override
    public int textRemoved(MoeSyntaxDocument document, int nodePos, int delPos, int length, NodeStructureListener listener) {
        for (int i = 0; i < this.stateMarkers.length; ++i) {
            if (this.stateMarkers[i] <= delPos - nodePos && (!this.marksEnd[i] || this.stateMarkers[i] != delPos - nodePos)) continue;
            int n = i;
            this.stateMarkers[n] = this.stateMarkers[n] - length;
            if (this.stateMarkers[i] < delPos - nodePos || this.stateMarkers[i] == delPos - nodePos && this.marksEnd[i]) {
                this.stateMarkers[i] = -1;
                continue;
            }
            if (this.stateMarkers[i] != delPos - nodePos) continue;
            int spos = i == 0 ? 0 : Math.max(this.stateMarkers[i - 1], 0);
            NodeTree.NodeAndPosition<ParsedNode> nap = this.getNodeTree().findNodeAtOrBefore(this.stateMarkers[i] - 1 + nodePos, nodePos);
            if (nap != null && this.isDelimitingNode(nap)) {
                spos = Math.max(spos, nap.getEnd() - nodePos);
            }
            if (this.stateMarkers[i] <= spos) continue;
            document.scheduleReparse(spos + nodePos, this.stateMarkers[i] - spos);
        }
        return super.textRemoved(document, nodePos, delPos, length, listener);
    }

    private int checkEnd(Document document, int nodePos, NodeStructureListener listener) {
        int end = nodePos + this.getSize();
        if (end >= document.getLength()) {
            return 0;
        }
        NodeTree.NodeAndPosition<ParsedNode> nap = this.findNodeAt(end - 1, nodePos);
        if (nap == null) {
            return 0;
        }
        int offset = nap.getPosition();
        if (offset + nap.getSize() < end || nap.getNode().getNodeType() != 7) {
            return 0;
        }
        DocumentReader r = new DocumentReader(document, offset, nodePos + this.getSize());
        EscapedUnicodeReader eur = new EscapedUnicodeReader(r);
        try {
            String str;
            if (eur.read() == 47 && eur.read() == 47 && (str = document.getText(end, 1)).charAt(0) != '\n') {
                JavaParentNode parentNode = this.getParentNode();
                if (parentNode != null && ((ParsedNode)parentNode).growChild(document, new NodeTree.NodeAndPosition<ParsedNode>(this, nodePos, this.getSize()), listener)) {
                    int pr = this.reparseNode(document, nodePos, offset, this.getSize(), listener);
                    return pr == 0 ? 1 : pr;
                }
                return 3;
            }
        }
        catch (IOException ioe) {
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return 0;
    }

    @Override
    protected int handleDeletion(Document document, int nodePos, int dpos, NodeStructureListener listener) {
        int offset = dpos;
        int state = this.getCurrentState(offset - nodePos);
        int stateBoundary = state != 0 ? this.stateMarkers[state - 1] + nodePos : nodePos;
        NodeTree.NodeAndPosition<ParsedNode> nap = null;
        if (offset > stateBoundary) {
            nap = this.getNodeTree().findNodeAtOrBefore(offset, nodePos);
            while (nap != null && nap.getSize() == 0) {
                NodeTree.NodeAndPosition<ParsedNode> pnap = nap.prevSibling();
                this.removeChild(nap, listener);
                nap = pnap;
            }
            while (nap != null && nap.getEnd() > dpos) {
                nap = nap.prevSibling();
            }
            while (nap != null && !this.isDelimitingNode(nap)) {
                boolean isLeadingComment;
                boolean bl = isLeadingComment = nap != null && nap.getNode().getNodeType() == 7 && nap.getPosition() == stateBoundary;
                if (isLeadingComment) break;
                if (nap.getPosition() >= stateBoundary) {
                    NodeTree.NodeAndPosition<ParsedNode> pnap = nap.prevSibling();
                    if (pnap != null && this.isDelimitingNode(pnap) && pnap.getEnd() == dpos && nap.getPosition() == dpos) {
                        this.removeChild(nap, listener);
                        return super.handleDeletion(document, nodePos, dpos, listener);
                    }
                    nap = pnap;
                    continue;
                }
                nap = null;
            }
        }
        int adjustedPos = nap != null ? nap.getEnd() : stateBoundary;
        return super.handleDeletion(document, nodePos, adjustedPos, listener);
    }

    @Override
    protected boolean growChild(Document document, NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        int mypos = child.getPosition() - child.getNode().getOffsetFromParent();
        int oldSize = child.getSize();
        NodeTree.NodeAndPosition<ParsedNode> nap = child.nextSibling();
        if (nap != null && nap.getPosition() > child.getEnd()) {
            int newSize = nap.getPosition() - child.getPosition();
            child.setSize(newSize);
            this.childResized((MoeSyntaxDocument)document, mypos, child);
            listener.nodeChangedLength(child, child.getPosition(), oldSize);
            return true;
        }
        int myEnd = mypos + this.getSize();
        if (nap != null) {
            this.removeChild(nap, listener);
            child.setSize(nap.getEnd() - child.getPosition());
            if (myEnd == nap.getEnd() && this.marksOwnEnd()) {
                this.complete = false;
            }
            this.childResized((MoeSyntaxDocument)document, mypos, child);
            listener.nodeChangedLength(child, child.getPosition(), oldSize);
            return true;
        }
        if (myEnd > child.getEnd()) {
            int newsize = myEnd - child.getPosition();
            child.resize(newsize);
            if (this.marksOwnEnd()) {
                this.complete = false;
            }
            this.childResized((MoeSyntaxDocument)document, mypos, child);
            listener.nodeChangedLength(child, child.getPosition(), oldSize);
            return true;
        }
        JavaParentNode parentNode = this.getParentNode();
        if (parentNode != null && ((ParsedNode)parentNode).growChild(document, new NodeTree.NodeAndPosition<ParsedNode>(this, mypos, this.getSize()), listener)) {
            myEnd = mypos + this.getSize();
            ((MoeSyntaxDocument)document).scheduleReparse(myEnd, 0);
            this.complete = false;
            int newsize = myEnd - child.getPosition();
            child.resize(newsize);
            this.childResized((MoeSyntaxDocument)document, mypos, child);
            listener.nodeChangedLength(child, child.getPosition(), oldSize);
            return true;
        }
        return false;
    }
}

