/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.entity;

import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.TypeArgumentEntity;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.ValueEntity;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ImportedEntity
extends JavaEntity {
    private EntityResolver resolver;
    private List<String> names;
    private Reflective querySource;

    public ImportedEntity(EntityResolver resolver, List<String> names, Reflective querySource) {
        this.resolver = resolver;
        this.names = names;
        this.querySource = querySource;
    }

    @Override
    public String getName() {
        return this.names.get(this.names.size() - 1);
    }

    @Override
    public JavaEntity getSubentity(String name, Reflective accessSource) {
        LinkedList<String> newNames = new LinkedList<String>();
        newNames.addAll(this.names);
        newNames.add(name);
        return new ImportedEntity(this.resolver, newNames, this.querySource);
    }

    @Override
    public JavaType getType() {
        return null;
    }

    @Override
    public JavaEntity setTypeArgs(List<TypeArgumentEntity> tparams) {
        return null;
    }

    @Override
    public ValueEntity resolveAsValue() {
        return null;
    }

    @Override
    public TypeEntity resolveAsType() {
        PackageOrClass poc = this.resolveAsPackageOrClass();
        if (poc != null) {
            return poc.resolveAsType();
        }
        return null;
    }

    @Override
    public PackageOrClass resolveAsPackageOrClass() {
        Iterator<String> i = this.names.iterator();
        if (!i.hasNext()) {
            return null;
        }
        String fqName = i.next();
        PackageOrClass poc = new PackageEntity(fqName, this.resolver);
        while (i.hasNext()) {
            if ((poc = ((PackageOrClass)poc).getPackageOrClassMember(i.next())) != null) continue;
            return null;
        }
        return poc;
    }
}

