/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.parser.AssistContent;
import bluej.pkgmgr.JavadocResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MethodCompletion
extends AssistContent {
    private MethodReflective method;
    private JavadocResolver javadocResolver;
    private Map<String, GenTypeParameter> typeArgs;

    public MethodCompletion(MethodReflective method, Map<String, GenTypeParameter> typeArgs, JavadocResolver javadocResolver) {
        this.method = method;
        if (typeArgs != null) {
            List<GenTypeDeclTpar> mtpars = method.getTparTypes();
            if (!mtpars.isEmpty()) {
                HashMap<String, GenTypeParameter> fullArgMap = new HashMap<String, GenTypeParameter>();
                fullArgMap.putAll(typeArgs);
                for (GenTypeDeclTpar mtpar : mtpars) {
                    fullArgMap.put(mtpar.getTparName(), mtpar);
                }
                this.typeArgs = fullArgMap;
            } else {
                this.typeArgs = typeArgs;
            }
        }
        this.javadocResolver = javadocResolver;
    }

    @Override
    public String getDeclaringClass() {
        return this.method.getDeclaringType().getSimpleName();
    }

    @Override
    public String getDisplayMethodName() {
        return this.method.getName();
    }

    @Override
    public String getDisplayMethodParams() {
        return this.getDisplayMethodParams(true);
    }

    public String getDisplayMethodParams(boolean includeNames) {
        List<String> paramNames = includeNames ? this.method.getParamNames() : null;
        Iterator<String> nameIterator = paramNames != null ? paramNames.iterator() : null;
        String displayName = "(";
        List<JavaType> paramTypes = this.method.getParamTypes();
        Iterator<JavaType> i = paramTypes.iterator();
        while (i.hasNext()) {
            JavaType paramType = this.convertToSolid(i.next());
            displayName = displayName + paramType.toString(true);
            if (nameIterator != null) {
                displayName = displayName + " " + nameIterator.next();
            }
            if (!i.hasNext()) continue;
            displayName = displayName + ", ";
        }
        displayName = displayName + ")";
        return displayName;
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayMethodName() + this.getDisplayMethodParams(false);
    }

    @Override
    public String getCompletionText() {
        return this.method.getName() + "(";
    }

    @Override
    public String getCompletionTextSel() {
        List<JavaType> paramTypes = this.method.getParamTypes();
        if (!paramTypes.isEmpty()) {
            List<String> paramNames = this.method.getParamNames();
            if (paramNames == null || paramNames.isEmpty()) {
                return MethodCompletion.buildParam(1, paramTypes.get(0), null);
            }
            return MethodCompletion.buildParam(1, paramTypes.get(0), paramNames.get(0));
        }
        return "";
    }

    @Override
    public String getCompletionTextPost() {
        String r = ")";
        List<JavaType> paramTypes = this.method.getParamTypes();
        if (paramTypes.size() > 1) {
            String paramStr = "";
            List<String> paramNames = this.method.getParamNames();
            paramNames = paramNames == null ? Collections.emptyList() : paramNames;
            Iterator<JavaType> ti = paramTypes.iterator();
            Iterator<String> ni = paramNames.iterator();
            ti.next();
            if (ni.hasNext()) {
                ni.next();
            }
            int i = 2;
            while (ti.hasNext()) {
                String name = ni.hasNext() ? ni.next() : null;
                paramStr = paramStr + ", " + MethodCompletion.buildParam(i++, ti.next(), name);
            }
            r = paramStr + r;
        }
        return r;
    }

    @Override
    public String getReturnType() {
        return this.convertToSolid(this.method.getReturnType()).toString(true);
    }

    @Override
    public String getJavadoc() {
        String jd = this.method.getJavaDoc();
        if (jd == null && this.javadocResolver != null) {
            this.javadocResolver.getJavadoc(this.method);
            jd = this.method.getJavaDoc();
        }
        return jd;
    }

    @Override
    public boolean hasParameters() {
        return !this.method.getParamTypes().isEmpty();
    }

    private JavaType convertToSolid(JavaType type) {
        if (!type.isPrimitive()) {
            type = this.typeArgs != null ? type.mapTparsToTypes(this.typeArgs).getUpperBound() : type.getErasedType();
        }
        return type;
    }

    private static String buildParam(int pnum, JavaType paramType, String paramName) {
        if (paramName != null) {
            return "_" + paramName + "_";
        }
        return "_" + paramType.toString(true) + "_";
    }
}

