/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.actions.ValidateConnectionAction;
import bluej.groupwork.ui.TeamPanelFocusPolicy;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.utility.MiksGridLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TeamSettingsPanel
extends JPanel {
    private static final int fieldsize = 20;
    private TeamSettingsController teamSettingsController;
    private TeamSettingsDialog teamSettingsDialog;
    private JTextField userField;
    private JPasswordField passwordField;
    private JTextField groupField;
    private JTextField prefixField;
    private JComboBox serverTypeComboBox;
    private JTextField serverField;
    private JComboBox protocolComboBox;
    private JButton validateButton;
    private JCheckBox useAsDefault;
    private JLabel serverTypeLabel;
    private JLabel groupLabel;
    private JLabel prefixLabel;
    private JLabel serverLabel;
    private JLabel protocolLabel;
    private int selectedServerType = -1;
    private boolean okEnabled = true;

    public TeamSettingsPanel(TeamSettingsController teamSettingsController, TeamSettingsDialog dialog) {
        this.teamSettingsController = teamSettingsController;
        this.teamSettingsDialog = dialog;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BlueJTheme.generalBorder);
        this.add(Box.createVerticalGlue());
        this.add(this.makePersonalPanel());
        this.add(Box.createVerticalStrut(5));
        this.add(this.makeLocationPanel());
        this.add(Box.createVerticalStrut(5));
        this.useAsDefault = new JCheckBox(Config.getString("team.settings.rememberSettings"));
        this.add(this.useAsDefault);
        this.add(Box.createVerticalStrut(5));
        this.validateButton = new JButton(new ValidateConnectionAction(Config.getString("team.settings.checkConnection"), this, dialog));
        this.add(this.validateButton);
        DocumentListener changeListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TeamSettingsPanel.this.checkOkEnabled();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TeamSettingsPanel.this.checkOkEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TeamSettingsPanel.this.checkOkEnabled();
            }
        };
        this.userField.getDocument().addDocumentListener(changeListener);
        this.serverField.getDocument().addDocumentListener(changeListener);
        this.add(Box.createVerticalGlue());
        this.setupContent();
        this.checkOkEnabled();
        if (!teamSettingsController.hasProject()) {
            this.useAsDefault.setSelected(true);
        }
    }

    public FocusTraversalPolicy getTraversalPolicy(FocusTraversalPolicy delegate) {
        if (this.getUser().length() != 0) {
            return new TeamPanelFocusPolicy(this.passwordField, delegate);
        }
        return delegate;
    }

    public void disableRepositorySettings() {
        this.serverTypeComboBox.setEnabled(false);
        this.groupField.setEnabled(false);
        this.prefixField.setEnabled(false);
        this.serverField.setEnabled(false);
        this.protocolComboBox.setEnabled(false);
        this.serverTypeLabel.setEnabled(false);
        this.groupLabel.setEnabled(false);
        this.prefixLabel.setEnabled(false);
        this.serverLabel.setEnabled(false);
        this.protocolLabel.setEnabled(false);
    }

    private JPanel makePersonalPanel() {
        JPanel authentificationPanel = new JPanel();
        authentificationPanel.setLayout(new MiksGridLayout(3, 2, 10, 5));
        String docTitle = Config.getString("team.settings.personal");
        authentificationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(docTitle), BlueJTheme.generalBorder));
        authentificationPanel.setAlignmentX(0.0f);
        JLabel userLabel = new JLabel(Config.getString("team.settings.user"));
        this.userField = new JTextField(20);
        JLabel passwordLabel = new JLabel(Config.getString("team.settings.password"));
        this.passwordField = new JPasswordField(20);
        this.groupLabel = new JLabel(Config.getString("team.settings.group"));
        this.groupField = new JTextField(20);
        userLabel.setMaximumSize(userLabel.getMinimumSize());
        this.userField.setMaximumSize(this.userField.getMinimumSize());
        passwordLabel.setMaximumSize(passwordLabel.getMinimumSize());
        this.passwordField.setMaximumSize(this.passwordField.getMinimumSize());
        this.groupLabel.setMaximumSize(this.groupLabel.getMinimumSize());
        this.groupField.setMaximumSize(this.groupField.getMinimumSize());
        authentificationPanel.add(userLabel);
        authentificationPanel.add(this.userField);
        authentificationPanel.add(passwordLabel);
        authentificationPanel.add(this.passwordField);
        authentificationPanel.add(this.groupLabel);
        authentificationPanel.add(this.groupField);
        return authentificationPanel;
    }

    private JPanel makeLocationPanel() {
        JPanel locationPanel = new JPanel(new MiksGridLayout(4, 2, 10, 5));
        String docTitle2 = Config.getString("team.settings.location");
        locationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(docTitle2), BlueJTheme.generalBorder));
        locationPanel.setAlignmentX(0.0f);
        this.serverTypeLabel = new JLabel(Config.getString("team.settings.serverType"));
        this.serverTypeComboBox = new JComboBox();
        List<TeamworkProvider> teamProviders = this.teamSettingsController.getTeamworkProviders();
        for (TeamworkProvider provider : teamProviders) {
            this.serverTypeComboBox.addItem(provider.getProviderName());
        }
        this.serverTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeamSettingsPanel.this.setProviderSettings();
            }
        });
        this.serverLabel = new JLabel(Config.getString("team.settings.server"));
        this.serverField = new JTextField(20);
        this.prefixLabel = new JLabel(Config.getString("team.settings.prefix"));
        this.prefixField = new JTextField(20);
        this.protocolLabel = new JLabel(Config.getString("team.settings.protocol"));
        this.protocolComboBox = new JComboBox();
        this.protocolComboBox.setEditable(false);
        this.prefixLabel.setMaximumSize(this.prefixLabel.getMinimumSize());
        this.prefixField.setMaximumSize(this.prefixField.getMinimumSize());
        this.serverLabel.setMaximumSize(this.serverLabel.getMinimumSize());
        this.serverField.setMaximumSize(this.serverField.getMinimumSize());
        this.serverTypeLabel.setMaximumSize(this.serverTypeLabel.getMinimumSize());
        this.serverTypeComboBox.setMaximumSize(this.serverTypeComboBox.getMinimumSize());
        locationPanel.add(this.serverTypeLabel);
        locationPanel.add(this.serverTypeComboBox);
        locationPanel.add(this.serverLabel);
        locationPanel.add(this.serverField);
        locationPanel.add(this.prefixLabel);
        locationPanel.add(this.prefixField);
        locationPanel.add(this.protocolLabel);
        locationPanel.add(this.protocolComboBox);
        return locationPanel;
    }

    private void fillProtocolSelections() {
        int selected = this.serverTypeComboBox.getSelectedIndex();
        if (selected != this.selectedServerType) {
            this.selectedServerType = selected;
            this.protocolComboBox.removeAllItems();
            List<TeamworkProvider> teamProviders = this.teamSettingsController.getTeamworkProviders();
            TeamworkProvider provider = teamProviders.get(selected);
            String[] protocols = provider.getProtocols();
            for (int i = 0; i < protocols.length; ++i) {
                this.protocolComboBox.addItem(protocols[i]);
            }
        }
    }

    private void setupContent() {
        String providerName;
        String useAsDefault;
        String group;
        String password;
        String user = this.teamSettingsController.getPropString("bluej.teamsettings.user");
        if (user != null) {
            this.setUser(user);
        }
        if ((password = this.teamSettingsController.getPasswordString()) != null) {
            this.setPassword(password);
        }
        if ((group = this.teamSettingsController.getPropString("bluej.teamsettings.groupname")) != null) {
            this.setGroup(group);
        }
        if ((useAsDefault = this.teamSettingsController.getPropString("bluej.teamsettings.useAsDefault")) != null) {
            this.setUseAsDefault(Boolean.getBoolean(useAsDefault));
        }
        if ((providerName = this.teamSettingsController.getPropString("bluej.teamsettings.vcs")) != null) {
            List<TeamworkProvider> teamProviders = this.teamSettingsController.getTeamworkProviders();
            for (int index = 0; index < teamProviders.size(); ++index) {
                TeamworkProvider provider = teamProviders.get(index);
                if (!provider.getProviderName().equalsIgnoreCase(providerName)) continue;
                this.serverTypeComboBox.setSelectedIndex(index);
                break;
            }
        }
        this.setProviderSettings();
    }

    private void setProviderSettings() {
        String server;
        String keyBase = "bluej.teamsettings." + this.getSelectedProvider().getProviderName().toLowerCase() + ".";
        String prefix = this.teamSettingsController.getPropString(keyBase + "repositoryPrefix");
        if (prefix != null) {
            this.setPrefix(prefix);
        }
        if ((server = this.teamSettingsController.getPropString(keyBase + "server")) != null) {
            this.setServer(server);
        }
        this.fillProtocolSelections();
        String protocol = this.teamSettingsController.getPropString(keyBase + "protocol");
        if (protocol != null) {
            this.setProtocol(protocol);
        }
    }

    private void checkOkEnabled() {
        boolean newOkEnabled = this.userField.getText().length() != 0;
        if ((newOkEnabled &= this.serverField.getText().length() != 0) != this.okEnabled) {
            this.okEnabled = newOkEnabled;
            this.teamSettingsDialog.setOkButtonEnabled(this.okEnabled);
        }
    }

    private void setUser(String user) {
        this.userField.setText(user);
    }

    private void setPassword(String password) {
        this.passwordField.setText(password);
    }

    private void setGroup(String group) {
        this.groupField.setText(group);
    }

    private void setPrefix(String prefix) {
        this.prefixField.setText(prefix);
    }

    private void setServer(String server) {
        this.serverField.setText(server);
    }

    private void setProtocol(String protocolKey) {
        String protocolLabel = this.getSelectedProvider().getProtocolLabel(protocolKey);
        this.protocolComboBox.setSelectedItem(protocolLabel);
    }

    private void setUseAsDefault(boolean use) {
        this.useAsDefault.setSelected(use);
    }

    public TeamworkProvider getSelectedProvider() {
        int selected = this.serverTypeComboBox.getSelectedIndex();
        return this.teamSettingsController.getTeamworkProviders().get(selected);
    }

    private String getUser() {
        return this.userField.getText();
    }

    private String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    private String getGroup() {
        return this.groupField.getText();
    }

    private String getPrefix() {
        return this.prefixField.getText();
    }

    private String getServer() {
        return this.serverField.getText();
    }

    private String getProtocolKey() {
        int protocol = this.protocolComboBox.getSelectedIndex();
        return this.getSelectedProvider().getProtocolKey(protocol);
    }

    public boolean getUseAsDefault() {
        return this.useAsDefault.isSelected();
    }

    public TeamSettings getSettings() {
        return new TeamSettings(this.getSelectedProvider(), this.getProtocolKey(), this.getServer(), this.getPrefix(), this.getGroup(), this.getUser(), this.getPassword());
    }
}

