/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.ui.CommitCommentsFrame;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.SwingWorker;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;

public class CommitAction
extends AbstractAction {
    private Set<File> newFiles;
    private Set<File> deletedFiles;
    private Set<File> files;
    private CommitCommentsFrame commitCommentsFrame;
    private StatusHandle statusHandle;
    private CommitWorker worker;

    public CommitAction(CommitCommentsFrame frame) {
        super(Config.getString("team.commit"));
        this.commitCommentsFrame = frame;
    }

    public void setNewFiles(Set<File> newFiles) {
        this.newFiles = newFiles;
    }

    public void setDeletedFiles(Set<File> deletedFiles) {
        this.deletedFiles = deletedFiles;
    }

    public void setFiles(Set<File> files) {
        this.files = files;
    }

    public void setStatusHandle(StatusHandle statusHandle) {
        this.statusHandle = statusHandle;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Project project = this.commitCommentsFrame.getProject();
        if (project != null) {
            this.commitCommentsFrame.startProgress();
            PkgMgrFrame.displayMessage(project, Config.getString("team.commit.statusMessage"));
            this.setEnabled(false);
            this.worker = new CommitWorker(project);
            this.worker.start();
        }
    }

    public void cancel() {
        this.setEnabled(true);
        if (this.worker != null) {
            this.worker.abort();
            this.worker = null;
        }
    }

    private class CommitWorker
    extends SwingWorker {
        private TeamworkCommand command;
        private TeamworkCommandResult result;
        private boolean aborted;

        public CommitWorker(Project project) {
            String comment = CommitAction.this.commitCommentsFrame.getComment();
            HashSet<TeamStatusInfo> forceFiles = new HashSet();
            if (CommitAction.this.commitCommentsFrame.includeLayout()) {
                forceFiles = CommitAction.this.commitCommentsFrame.getChangedLayoutInfo();
                CommitAction.this.files.addAll(CommitAction.this.commitCommentsFrame.getChangedLayoutFiles());
            }
            Set<File> binFiles = TeamUtils.extractBinaryFilesFromSet(CommitAction.this.newFiles);
            this.command = CommitAction.this.statusHandle.commitAll(CommitAction.this.newFiles, binFiles, CommitAction.this.deletedFiles, CommitAction.this.files, forceFiles, comment);
        }

        @Override
        public Object construct() {
            this.result = this.command.getResult();
            return this.result;
        }

        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            final Project project = CommitAction.this.commitCommentsFrame.getProject();
            if (!this.aborted) {
                CommitAction.this.commitCommentsFrame.stopProgress();
                if (!this.result.isError() && !this.result.wasAborted()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PkgMgrFrame.displayMessage(project, Config.getString("team.commit.statusDone"));
                        }
                    });
                }
            }
            TeamUtils.handleServerResponse(this.result, CommitAction.this.commitCommentsFrame);
            if (!this.aborted) {
                CommitAction.this.setEnabled(true);
                CommitAction.this.commitCommentsFrame.setVisible(false);
            }
        }
    }
}

