/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.graph.Graph;
import bluej.graph.TraverseStragegy;
import bluej.graph.Vertex;
import java.util.Iterator;

public class TraverseStragegyImpl
implements TraverseStragegy {
    private double calcDistance(Vertex vertex1, Vertex vertex2) {
        if (vertex1 == null || vertex2 == null) {
            return Double.POSITIVE_INFINITY;
        }
        int x1 = vertex1.getX() + vertex1.getWidth() / 2;
        int y1 = vertex1.getY() + vertex1.getHeight() / 2;
        int x2 = vertex2.getX() + vertex2.getWidth() / 2;
        int y2 = vertex2.getY() + vertex2.getHeight() / 2;
        double d = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        return d;
    }

    @Override
    public Vertex findNextVertex(Graph graph, Vertex currentVertex, int key) {
        int currentVertexCenterX = currentVertex.getX() + currentVertex.getWidth() / 2;
        int currentVertexCenterY = currentVertex.getY() + currentVertex.getHeight() / 2;
        Vertex v = null;
        double closest = Double.POSITIVE_INFINITY;
        Vertex closestVertex = null;
        Iterator<? extends Vertex> i = graph.getVertices();
        while (i.hasNext()) {
            double d;
            v = i.next();
            int x = v.getX() + v.getWidth() / 2 - currentVertexCenterX;
            int y = v.getY() + v.getHeight() / 2 - currentVertexCenterY;
            boolean left = key == 37 && y >= x && y <= -x;
            boolean right = key == 39 && y <= x && y >= -x;
            boolean up = key == 38 && y <= x && y <= -x;
            boolean down = key == 40 && y >= x && y >= -x;
            boolean notSelf = currentVertex != v;
            boolean inRightRegion = (left || right || up || down) && notSelf;
            if (!inRightRegion) continue;
            if (closestVertex == null) {
                closestVertex = v;
                closest = this.calcDistance(v, currentVertex);
            }
            double currentDistance = this.calcDistance(v, currentVertex);
            if (!(closest > d)) continue;
            closest = currentDistance;
            closestVertex = v;
        }
        if (closestVertex == null) {
            closestVertex = currentVertex;
        }
        return closestVertex;
    }
}

