/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.Config;
import bluej.extensions.BClassTarget;
import bluej.extensions.BlueJ;
import bluej.extensions.Extension;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.PreferenceGenerator;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ExtensionMenuObject;
import bluej.extmgr.ExtensionPrefManager;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.graphPainter.ClassTargetPainter;
import bluej.utility.Debug;
import java.awt.Graphics2D;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class ExtensionWrapper {
    private final ExtensionPrefManager prefManager;
    private File extensionJarFileName;
    private Class<?> extensionClass;
    private Extension extensionInstance;
    private BlueJ extensionBluej;
    private String extensionStatusString;
    private Project project;

    public ExtensionWrapper(ExtensionPrefManager prefManager, File jarFile) {
        this.prefManager = prefManager;
        this.extensionClass = this.getExtensionClass(jarFile);
        if (this.extensionClass == null) {
            return;
        }
        this.extensionJarFileName = jarFile;
    }

    private Class<?> getExtensionClass(File jarFileName) {
        Class<?> extensionClass = null;
        this.extensionStatusString = Config.getString("extmgr.status.loading");
        if (jarFileName == null) {
            return null;
        }
        if (!jarFileName.getName().endsWith(".jar")) {
            return null;
        }
        String errorPrefix = "getExtensionsClass: jarFile=" + jarFileName.getName() + " ";
        try {
            JarFile jarFile = new JarFile(jarFileName);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                Debug.message(errorPrefix + Config.getString("extmgr.error.nomanifest"));
                return null;
            }
            String className = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (className == null) {
                Debug.message(errorPrefix + Config.getString("extmgr.error.nomain"));
                return null;
            }
            URL url = jarFileName.toURI().toURL();
            URL[] urlList = new URL[]{url};
            FirewallLoader fireLoader = new FirewallLoader(this.getClass().getClassLoader());
            URLClassLoader ucl = new URLClassLoader(urlList, (ClassLoader)fireLoader);
            extensionClass = ucl.loadClass(className);
            if (!Extension.class.isAssignableFrom(extensionClass)) {
                Debug.message(errorPrefix + Config.getString("extmgr.error.notsubclass"));
                return null;
            }
        }
        catch (Throwable exc) {
            Debug.message(errorPrefix + "Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
        return extensionClass;
    }

    void newExtension(Project aProject) {
        if (this.extensionClass == null) {
            return;
        }
        this.project = aProject;
        this.extensionBluej = ExtensionBridge.newBluej((ExtensionWrapper)this, (ExtensionPrefManager)this.prefManager);
        try {
            this.extensionInstance = (Extension)this.extensionClass.newInstance();
        }
        catch (Throwable ex) {
            this.extensionInstance = null;
            this.extensionStatusString = "newExtension: Exception=" + ex.getMessage();
            return;
        }
        if (!this.safeIsCompatible()) {
            this.extensionStatusString = Config.getString("extmgr.status.badversion");
            this.extensionInstance = null;
            return;
        }
        this.safeStartup(this.extensionBluej);
        this.extensionStatusString = Config.getString("extmgr.status.loaded");
    }

    Project getProject() {
        return this.project;
    }

    public boolean isValid() {
        return this.extensionInstance != null;
    }

    boolean isJarValid() {
        return this.extensionClass != null;
    }

    void terminate() {
        this.safeTerminate();
        this.extensionInstance = null;
        this.prefManager.panelRevalidate();
    }

    public String getExtensionStatus() {
        return this.extensionStatusString;
    }

    public String getExtensionClassName() {
        if (this.extensionClass == null) {
            return null;
        }
        return this.extensionClass.getName();
    }

    public Properties getLabelProperties() {
        String localLanguage = Config.getPropString("bluej.language", "english");
        Properties extensionsProps = this.getLabelProperties(localLanguage);
        if (extensionsProps != null) {
            return extensionsProps;
        }
        extensionsProps = this.getLabelProperties("english");
        return extensionsProps;
    }

    private Properties getLabelProperties(String language) {
        if (this.extensionClass == null) {
            return null;
        }
        String languageFileName = "lib/" + language + "/labels";
        InputStream inStream = this.extensionClass.getClassLoader().getResourceAsStream(languageFileName);
        if (inStream == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(inStream);
        }
        catch (Exception ex) {
            Debug.message("ExtensionWrapper.getLabelProperties(): Exception=" + ex.getMessage());
        }
        ExtensionWrapper.closeInputStream(inStream);
        return props;
    }

    public static void closeInputStream(InputStream aStream) {
        try {
            aStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getExtensionFileName() {
        if (this.extensionJarFileName == null) {
            return null;
        }
        return this.extensionJarFileName.getPath();
    }

    public String getSettingsString(String key) {
        return "extensions." + this.getExtensionClassName() + ".settings." + key;
    }

    public String toString() {
        if (!this.isValid()) {
            return "ExtensionWrapper: invalid";
        }
        return "ExtensionWrapper: " + this.extensionClass.getName();
    }

    public void safeEventOccurred(ExtensionEvent event) {
        if (!this.isValid()) {
            return;
        }
        try {
            ExtensionBridge.delegateEvent((BlueJ)this.extensionBluej, (ExtensionEvent)event);
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safeEventOccurred: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return;
        }
    }

    public String safeGetExtensionDescription() {
        if (this.extensionInstance == null) {
            return null;
        }
        try {
            return this.extensionInstance.getDescription();
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safeGetExtensionDescription: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    public String safeGetExtensionName() {
        if (this.extensionInstance == null) {
            return "";
        }
        try {
            return this.extensionInstance.getName();
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safeGetExtensionName: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return "";
        }
    }

    public URL safeGetURL() {
        if (this.extensionInstance == null) {
            return null;
        }
        try {
            return this.extensionInstance.getURL();
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safeGetURL: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    public String safeGetExtensionVersion() {
        if (this.extensionInstance == null) {
            return null;
        }
        try {
            return this.extensionInstance.getVersion();
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safeGetExtensionVersion: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    private boolean safeIsCompatible() {
        if (this.extensionInstance == null) {
            return false;
        }
        try {
            return this.extensionInstance.isCompatible();
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safeIsCompatible: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return false;
        }
    }

    private void safeStartup(BlueJ bluejProxy) {
        if (this.extensionInstance == null) {
            return;
        }
        try {
            this.extensionInstance.startup(bluejProxy);
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safeStartup: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    private void safeTerminate() {
        if (this.extensionInstance == null) {
            return;
        }
        try {
            this.extensionInstance.terminate();
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safeTerminate: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    public void safePrefGenLoadValues() {
        if (this.extensionBluej == null) {
            return;
        }
        PreferenceGenerator aPrefGen = this.extensionBluej.getPreferenceGenerator();
        if (aPrefGen == null) {
            return;
        }
        try {
            aPrefGen.loadValues();
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safePrefGenLoadValues: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    public void safePrefGenSaveValues() {
        if (this.extensionBluej == null) {
            return;
        }
        PreferenceGenerator aPrefGen = this.extensionBluej.getPreferenceGenerator();
        if (aPrefGen == null) {
            return;
        }
        try {
            aPrefGen.saveValues();
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safePrefGenSaveValues: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    public JPanel safePrefGenGetPanel() {
        if (this.extensionBluej == null) {
            return null;
        }
        PreferenceGenerator aPrefGen = this.extensionBluej.getPreferenceGenerator();
        if (aPrefGen == null) {
            return null;
        }
        try {
            return aPrefGen.getPanel();
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safePrefGenGetPanel: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    public JMenuItem safeGetMenuItem(ExtensionMenuObject attachedObject) {
        if (this.extensionBluej == null) {
            return null;
        }
        try {
            return ExtensionBridge.getMenuItem((BlueJ)this.extensionBluej, (ExtensionMenuObject)attachedObject);
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safeMenuGenGetMenuItem: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    public void safePostMenuItem(ExtensionMenuObject attachedObject, JMenuItem onThisItem) {
        if (this.extensionBluej == null) {
            return;
        }
        try {
            ExtensionBridge.postMenuItem((BlueJ)this.extensionBluej, (ExtensionMenuObject)attachedObject, (JMenuItem)onThisItem);
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safePostGenGetMenuItem: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    public void safeDrawExtensionClassTarget(ClassTargetPainter.Layer layer, BClassTarget bClassTarget, Graphics2D graphics, int width, int height) {
        if (this.extensionBluej == null) {
            return;
        }
        try {
            ExtensionBridge.drawExtensionClassTarget((BlueJ)this.extensionBluej, (ClassTargetPainter.Layer)layer, (BClassTarget)bClassTarget, (Graphics2D)graphics, (int)width, (int)height);
        }
        catch (Exception exc) {
            Debug.message("ExtensionWrapper.safeDrawExtensionClassTarget: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    class FirewallLoader
    extends ClassLoader {
        ClassLoader myParent;

        FirewallLoader(ClassLoader parent) {
            this.myParent = parent;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("bluej.") || name.startsWith("rmiextension.") || name.startsWith("greenfoot.")) {
                return this.myParent.loadClass(name);
            }
            throw new ClassNotFoundException();
        }
    }
}

